/***************************************************************************
                            KJavaAppletContext.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KJAVAAPPLETCONTEXT_H
#define KJAVAAPPLETCONTEXT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>

/**


 @author Richard J. Moore, rich@kde.org
 
 @version $Id: KJavaAppletContext.h,v 1.3 2002/03/15 02:12:21 rdale Exp $

 @short Communicates with a KJAS server to display and control Java applets.

*/
@class KJavaApplet; 

@interface KJavaAppletContext : QObject 
- init;
- (void) dealloc;

/** 
 Returns the ID of this context.
     
*/
- (int) contextId;

/** 
 Sets the ID of this context.
     
*/
- setContextId: (int)identifier;

/** 
 Sends a message to create the applet.
     
*/
- create: (KJavaApplet*)arg1;

/** 
 Sends a message to destroy the applet.
     
*/
- destroy: (KJavaApplet*)arg1;

/** 
 Sends a message to initialize the applet.
     
*/
- init: (KJavaApplet*)arg1;

/** 
 Sends a message to start the applet.
     
*/
- start: (KJavaApplet*)arg1;

/** 
 Sends a message to stop the applet.
     
*/
- stop: (KJavaApplet*)arg1;

/** 
 use this for applet call backs, the AppletServer
 calls this directly.
     
*/
- processCmd: (NSString *)cmd args: (NSArray *)args;
- received: (NSString *)cmd arg: (NSArray *)arg;
@end

/** Override these methods in subclasses of KJavaAppletContext to customise event handling behaviour */
@protocol KJavaAppletContextEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
