/***************************************************************************
                            HTMLFormElement.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef HTMLFORMELEMENT_H
#define HTMLFORMELEMENT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/HTMLElement.h>

/**

 The <code> FORM </code> element encompasses behavior similar to a
 collection and an element. It provides direct access to the
 contained input elements as well as the attributes of the form
 element. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html edef]-FORM">
 FORM element definition </a> in HTML 4.0.

 
 @short 
 The <code> FORM </code> element encompasses behavior similar to a
 collection and an element.
*/
@class HTMLCollection; 

@interface HTMLFormElement : HTMLElement 
- init;
- copyWithZone: (NSZone *) zone;
- initWithDOMNode: (DOMNode*)other;
- (void) dealloc;

/** 
 Returns a collection of all control elements in the form.

     
*/
- (HTMLCollection*) elements;

/** 
 The number of form controls in the form.

     
*/
- (long) length;

/** 
 Names the form.

     
*/
- (NSString *) name;

/** 
 see @ref name
     
*/
- setName: (NSString *)arg1;

/** 
 List of character sets supported by the server. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-accept-charset">
 accept-charset attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) acceptCharset;

/** 
 see @ref acceptCharset
     
*/
- setAcceptCharset: (NSString *)arg1;

/** 
 Server-side form handler. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-action">
 action attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) action;

/** 
 see @ref action
     
*/
- setAction: (NSString *)arg1;

/** 
 The content type of the submitted form, generally
 "application/x-www-form-urlencoded". See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-enctype">
 enctype attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) enctype;

/** 
 see @ref enctype
     
*/
- setEnctype: (NSString *)arg1;

/** 
 HTTP method used to submit form. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-method">
 method attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) method;

/** 
 see @ref method
     
*/
- setMethod: (NSString *)arg1;

/** 
 Frame to render the resource in. See the <a
 href="http://www.w3.org/TR/REC-html40/present/frames.-[html adef]-target">
 target attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) target;

/** 
 see @ref target
     
*/
- setTarget: (NSString *)arg1;

/** 
 Submits the form. It performs the same action as a submit
 button.

     
*/
- submit;

/** 
 Restores a form element's default values. It performs the same
 action as a reset button.

     
*/
- reset;
@end

#endif
