/***************************************************************************
                            KPixmapEffect.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This class includes various pixmap-based graphical effects.

 Everything is
 static, so there is no need to create an instance of this class. You can
 just call the static methods. They are encapsulated here merely to provide
 a common namespace.
 
 @short *
 This class includes various pixmap-based graphical effects.
*/
public class  KPixmapEffect implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KPixmapEffect(Class dummy){}


/** 
 Creates a gradient from color a to color b of the specified type.

*/
	public static native KPixmap gradient( KPixmap pixmap, QColor ca, QColor cb, int type, int ncols);
	public static native KPixmap gradient( KPixmap pixmap, QColor ca, QColor cb, int type);

/** 
 Creates an unbalanced gradient.

 An unbalanced gradient is a gradient where the transition from
 color a to color b is not linear, but in this case, exponential.

*/
	public static native KPixmap unbalancedGradient( KPixmap pixmap, QColor ca, QColor cb, int type, int xfactor, int yfactor, int ncols);
	public static native KPixmap unbalancedGradient( KPixmap pixmap, QColor ca, QColor cb, int type);

/** 
 Creates a pixmap of a given size with the given pixmap.

 if the
 given size is bigger than the size of the pixmap, the pixmap is
 tiled.

*/
	public static native KPixmap createTiled( KPixmap pixmap, QSize size);

/** 
 Either brightens or dims a pixmap by a specified ratio.

*/
	public static native KPixmap intensity( KPixmap pixmap, float ratio);

/** 
 Modifies the intensity of a pixmap's RGB channel component.

*/
	public static native KPixmap channelIntensity( KPixmap pixmap, float ratio, int channel);

/** 
 Blends the provided pixmap into a background of the indicated color.

*/
	public static native KPixmap blend( KPixmap pixmap, float initial_intensity, QColor bgnd, int eff, boolean anti_dir, int ncols);
	public static native KPixmap blend( KPixmap pixmap, float initial_intensity, QColor bgnd, int eff);

/** 
 Builds a hash on any given pixmap.

*/
	public static native KPixmap hash( KPixmap pixmap, int lite, int spacing, int ncols);
	public static native KPixmap hash( KPixmap pixmap);

/** 
 Creates a pattern from a pixmap.

 The given pixmap is "flattened"
 between color a to color b.

*/
	public static native KPixmap pattern( KPixmap pixmap, QSize size, QColor ca, QColor cb, int ncols);
	public static native KPixmap pattern( KPixmap pixmap, QSize size, QColor ca, QColor cb);

/** 
 Recolors a pixmap.

 The most dark color will become color a,
 the most bright one color b, and in between.

*/
	public static native KPixmap fade( KPixmap pixmap, double val, QColor color);

/** 
 Converts a pixmap to grayscale.

*/
	public static native KPixmap toGray( KPixmap pixmap, boolean fast);
	public static native KPixmap toGray( KPixmap pixmap);

/** 
 Desaturates a pixmap.

*/
	public static native KPixmap desaturate( KPixmap pixmap, float desat);
	public static native KPixmap desaturate( KPixmap pixmap);

/** 
 Modifies the contrast of a pixmap.

*/
	public static native KPixmap contrast( KPixmap pixmap, int c);

/** 
 Dithers a pixmap using Floyd-Steinberg dithering for low-color
 situations.

*/
	public static native KPixmap dither( KPixmap pixmap, QColor palette, int size);

/** 
 Calculate a 'selected' pixmap, for instance a selected icon
 on the desktop.

*/
	public static native KPixmap selectedPixmap( KPixmap pixmap, QColor col);
	public static final int VerticalGradient = 0;
	public static final int HorizontalGradient = 1;
	public static final int DiagonalGradient = 2;
	public static final int CrossDiagonalGradient = 3;
	public static final int PyramidGradient = 4;
	public static final int RectangleGradient = 5;
	public static final int PipeCrossGradient = 6;
	public static final int EllipticGradient = 7;
	public static final int Red = 0;
	public static final int Green = 1;
	public static final int Blue = 2;
	public static final int NorthLite = 0;
	public static final int NWLite = 1;
	public static final int WestLite = 2;
	public static final int SWLite = 3;
	public static final int SouthLite = 4;
	public static final int SELite = 5;
	public static final int EastLite = 6;
	public static final int NELite = 7;
}
