//-*-C++-*-
/*
**************************************************************************
                                 description
                             -------------------
    and                  : (C) 2002 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#ifndef PMLOOKSLIKE_H
#define PMLOOKSLIKE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "pmnamedobject.h"

/**
 * Class for povray looks_like statements.
 */
class PMLooksLike : public PMNamedObject
{
   typedef PMNamedObject Base;

public:
   /** Constructor */
   PMLooksLike( );
   /** Deletes the PMLooksLike */
   virtual ~PMLooksLike( );

   /** */
   virtual PMObject* newObject( ) const { return new PMLooksLike( ); }
   /** */
   virtual QString className( ) const { return QString( "lookslike" ); }
   /** */
   virtual PMObjectType type( ) const { return PMTLooksLike; }
   /** */
   virtual QString description( ) const;
   /** */
   virtual bool isA( PMObjectType t ) const;
   
   /** */
   virtual bool canInsert( PMObjectType t, const PMObject* after,
                           const PMObjectList* objectsBetween = 0 ) const;
   /** */
   virtual int canInsert( const QValueList<PMObjectType>& list,
                          const PMObject* after ) const;
   /** */
   virtual int canInsert( const PMObjectList& list,
                          const PMObject* after ) const;

   /** */
   virtual void serialize( PMOutputDevice& dev ) const;
   /** */
   virtual void serialize( QDomElement& e, QDomDocument& doc ) const;
   /** */
   virtual void readAttributes( const PMXMLHelper& h );
   /** Returns a new @ref PMLooksLikeEdit */
   virtual PMDialogEditBase* editWidget( QWidget* parent ) const;
   /** Returns the name of the pixmap that is displayed in the tree view
    * and dialog view */
   virtual QString pixmap( ) const { return QString( "pmlookslike" ); }

   /** */
   virtual void restoreMemento( PMMemento* s );

private:
   bool canInsert( PMObjectType t ) const;
   bool containsObject( ) const;

};


#endif
