/***************************************************************************
                            KBugReport.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KBUGREPORT_H
#define KBUGREPORT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KDialogBase.h>

/**

 A dialog box for sending bug reports.
 All the information needed by the dialog box
 (program name, version, bug-report address, etc.)
 comes from the @ref KAboutData class.
 Make sure you create an instance of KAboutData and pass it
 to @ref KCmdLineArgs.

 @author David Faure <faure@kde.org>
 
 @short A dialog box for sending bug reports.

*/
@class KAboutData; 

@interface KBugReport : KDialogBase 

/** 
 Creates a bug-report dialog.
 Note that you shouldn't have to do this manually,
 since @ref KHelpMenu takes care of the menu item
 for "Report Bug..." and of creating a KBugReport dialog.
   
*/
- initWithWidget: (QWidget *)parent modal: (BOOL)modal aboutData: (KAboutData*)aboutData;
- init;

/** 
 Destructor
   
*/
- (void) dealloc;
- (NSString *) text;
- (BOOL) sendBugReport;

/** 
 "Configure email" has been clicked - this calls kcmshell System/email
   
*/
- slotConfigureEmail;

/** 
 Sets the "From" field from the e-mail configuration
 Called at creation time, but also after "Configure email" is closed.
   
*/
- slotSetFrom;

/** 
 The URL-Label "http://bugs.kde.org/" was clicked.
   
*/
- slotUrlClicked: (NSString *)arg1;

/** 
 OK has been clicked
   
*/
- slotOk;

/** 
 Cancel has been clicked
   
*/
- slotCancel;
- appChanged: (int)arg1;
- updateURL;
@end

/** Override these methods in subclasses of KBugReport to customise event handling behaviour */
@protocol KBugReportEventHandling

/** 
 Maps some keys to the actions buttons. F1 is mapped to the Help
 button if present and Escape to the Cancel or Close if present. The
 button action event is animated.
     
*/
- keyPressEvent:(QKeyEvent*) e;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;

/** 
 Emits the @ref hidden signal. You can connect to that signal to
 detect when a dialog has been closed.
     
*/
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;

/** 
 Detects when a dialog is being closed from the window manager
 controls. If the Cancel or Close button is present then the button
 is activated. Otherwise standard @ref QDialog behavior
 will take place.
     
*/
- closeEvent:(QCloseEvent*) e;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
