/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.ProtocolVersion;
import com.sun.net.ssl.internal.ssl.SSLProtocolAlertException;
import com.sun.net.ssl.internal.ssl.SunJSSE_a1;
import com.sun.net.ssl.internal.ssl.SunJSSE_av;
import com.sun.net.ssl.internal.ssl.SunJSSE_ay;
import com.sun.net.ssl.internal.ssl.SunJSSE_h;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.crypto.BadPaddingException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLProtocolException;
import sun.misc.HexDumpEncoder;

final class InputRecord
extends ByteArrayInputStream
implements SunJSSE_av {
    private SunJSSE_ay a;
    private int b;
    private boolean c;
    private boolean d;
    private boolean e;
    private ProtocolVersion f;
    private ProtocolVersion g;
    private static final Debug h = Debug.getInstance("ssl");
    private static final byte[] i = new byte[]{-128, 3, 0, 0, 1};

    InputRecord(ProtocolVersion protocolVersion) {
        this(ProtocolVersion.g, ProtocolVersion.h);
    }

    InputRecord(ProtocolVersion protocolVersion, ProtocolVersion protocolVersion2) {
        super(new byte[16665]);
        this.a(protocolVersion);
        this.b(protocolVersion2);
        this.pos = 5;
        this.b = this.count = 5;
    }

    void a(ProtocolVersion protocolVersion) {
        this.f = protocolVersion;
    }

    void b(ProtocolVersion protocolVersion) {
        this.g = protocolVersion;
    }

    void a() {
        this.c = true;
    }

    boolean b() {
        return this.e;
    }

    void a(boolean bl) {
        this.e = bl;
    }

    byte c() {
        return this.buf[0];
    }

    SunJSSE_ay d() {
        return this.a;
    }

    boolean a(SunJSSE_a1 sunJSSE_a1) {
        int n = sunJSSE_a1.a();
        if (n == 0) {
            return true;
        }
        int n2 = this.count - n;
        if (n2 < 5) {
            return false;
        }
        byte[] byArray = sunJSSE_a1.a(this.c(), this.buf, 5, n2 - 5);
        if (n != byArray.length) {
            throw new RuntimeException("Internal MAC error");
        }
        int n3 = 0;
        while (n3 < n) {
            if (this.buf[n2 + n3] != byArray[n3]) {
                return false;
            }
            ++n3;
        }
        this.count -= n;
        return true;
    }

    void a(SunJSSE_h sunJSSE_h) throws BadPaddingException {
        int n = this.count - 5;
        this.count = 5 + sunJSSE_h.b(this.buf, 5, n);
    }

    void a(SunJSSE_ay sunJSSE_ay) {
        this.a = sunJSSE_ay;
    }

    void a(int n) {
        if (n > 0) {
            this.pos += n;
            this.b = this.pos;
        }
    }

    void e() {
        int n = this.pos - this.b;
        if (n > 0) {
            this.a(this.buf, this.b, n);
            this.b = this.pos;
        }
    }

    private void a(byte[] byArray, int n, int n2) {
        if (h != null && Debug.isOn("data")) {
            try {
                HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                System.out.println("[read] MD5 and SHA1 hashes:  len = " + n2);
                hexDumpEncoder.encodeBuffer((InputStream)new ByteArrayInputStream(byArray, n, n2), (OutputStream)System.out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.a.a(byArray, n, n2);
    }

    public void queueHandshake(InputRecord inputRecord) throws IOException {
        int n;
        this.e();
        if (this.pos > 5) {
            n = this.count - this.pos;
            if (n != 0) {
                System.arraycopy(this.buf, this.pos, this.buf, 5, n);
            }
            this.b = this.pos = 5;
            this.count = 5 + n;
        }
        if (this.buf.length < (n = inputRecord.available() + this.count)) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.buf, 0, byArray, 0, this.count);
            this.buf = byArray;
        }
        System.arraycopy(inputRecord.buf, inputRecord.pos, this.buf, this.count, n - this.count);
        this.count = n;
        n = inputRecord.b - inputRecord.pos;
        if (this.pos == 5) {
            this.b += n;
        } else {
            throw new SSLProtocolException("?? confused buffer hashing ??");
        }
        inputRecord.pos = inputRecord.count;
    }

    public void close() {
        this.e = false;
        this.d = true;
        this.mark = 0;
        this.pos = 0;
        this.count = 0;
    }

    private static int a(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = inputStream.read(byArray, n + n3, n2 - n3);
            if (n4 < 0) {
                return n4;
            }
            n3 += n4;
        }
        return n3;
    }

    public void read(InputStream inputStream, OutputStream outputStream) throws IOException {
        if (this.d) {
            return;
        }
        int n = InputRecord.a(inputStream, this.buf, 0, 5);
        if (n == -1) {
            throw new EOFException("SSL peer shut down incorrectly");
        }
        if (n != 5) {
            throw new SSLProtocolException("bad header read; count = " + n);
        }
        this.b = this.pos = 5;
        if (!this.c) {
            this.c = true;
            if (this.buf[0] != 22 && this.buf[0] != 21) {
                this.b(inputStream, outputStream);
            } else {
                this.a(inputStream, outputStream);
            }
        } else {
            this.a(inputStream, outputStream);
        }
    }

    private void a(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        ProtocolVersion protocolVersion = ProtocolVersion.a(this.buf[1], this.buf[2]);
        if (protocolVersion.i < ProtocolVersion.e.i || protocolVersion.j > ProtocolVersion.f.j) {
            throw new SSLException("Unsupported record version " + protocolVersion);
        }
        this.count = ((this.buf[3] & 0xFF) << 8) + (this.buf[4] & 0xFF);
        if (this.count < 0 || this.count > Short.MAX_VALUE) {
            throw new SSLProtocolException("Bad InputRecord size, count = " + this.count + ", buf.length = " + this.buf.length);
        }
        if (this.count > this.buf.length - 5) {
            byte[] byArray = new byte[this.count + 5];
            System.arraycopy(this.buf, 0, byArray, 0, 5);
            this.buf = byArray;
        }
        if ((n = InputRecord.a(inputStream, this.buf, 5, this.count)) != this.count) {
            throw new SSLException("SSL peer shut down incorrectly");
        }
        this.count += 5;
        if (h != null && Debug.isOn("record")) {
            if (this.count < 0 || this.count > 16660) {
                System.out.println(Thread.currentThread().getName() + ", Bad InputRecord size" + ", count = " + this.count);
            }
            System.out.println(Thread.currentThread().getName() + ", READ: " + protocolVersion + " " + InputRecord.b(this.c()) + ", length = " + this.available());
        }
    }

    private void b(InputStream inputStream, OutputStream outputStream) throws IOException {
        if ((this.buf[0] & 0x80) != 0 && this.buf[2] == 1) {
            if (this.g != ProtocolVersion.b) {
                throw new SSLProtocolAlertException("SSLv2Hello is disabled", 40);
            }
            ProtocolVersion protocolVersion = ProtocolVersion.a(this.buf[3], this.buf[4]);
            if (protocolVersion == ProtocolVersion.b) {
                try {
                    outputStream.write(i);
                    outputStream.flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new SSLException("Unsupported SSL v2.0 ClientHello");
            }
            int n = ((this.buf[0] & 0x7F) << 8) + (this.buf[1] & 0xFF) - 3;
            byte[] byArray = new byte[n];
            int n2 = InputRecord.a(inputStream, byArray, 0, n);
            if (n2 == -1) {
                throw new EOFException("SSL peer shut down incorrectly");
            }
            if (n2 != n) {
                throw new SSLProtocolException("Bad SSL v2.0 ClientHello record");
            }
            this.a(this.buf, 2, 3);
            this.a(byArray, 0, n);
            this.a(byArray);
            this.b = this.count;
            if (h != null && Debug.isOn("record")) {
                System.out.println(Thread.currentThread().getName() + ", READ:  SSL v2, contentType = " + InputRecord.b(this.c()) + ", translated length = " + this.available());
            }
            return;
        }
        if ((this.buf[0] & 0x80) != 0 && this.buf[2] == 4) {
            throw new SSLException("SSL V2.0 servers are not supported.");
        }
        int n = 0;
        while (n < i.length) {
            if (this.buf[n] != i[n]) {
                throw new SSLException("Unrecognized SSL message, plaintext connection?");
            }
            ++n;
        }
        throw new SSLException("SSL V2.0 servers are not supported.");
    }

    private void a(byte[] byArray) throws SSLException {
        int n;
        this.buf[0] = 22;
        this.buf[1] = this.buf[3];
        this.buf[2] = this.buf[4];
        this.buf[5] = 1;
        this.buf[9] = this.buf[1];
        this.buf[10] = this.buf[2];
        this.count = 11;
        int n2 = ((byArray[0] & 0xFF) << 8) + (byArray[1] & 0xFF);
        int n3 = ((byArray[2] & 0xFF) << 8) + (byArray[3] & 0xFF);
        int n4 = ((byArray[4] & 0xFF) << 8) + (byArray[5] & 0xFF);
        int n5 = 6 + n2 + n3;
        if (n4 < 32) {
            n = 0;
            while (n < 32 - n4) {
                this.buf[this.count++] = 0;
                ++n;
            }
            System.arraycopy(byArray, n5, this.buf, this.count, n4);
            this.count += n4;
        } else {
            System.arraycopy(byArray, n5 + (n4 - 32), this.buf, this.count, 32);
            this.count += 32;
        }
        this.buf[this.count++] = (byte)n3;
        System.arraycopy(byArray, n5 -= n3, this.buf, this.count, n3);
        this.count += n3;
        n5 -= n2;
        int n6 = this.count + 2;
        n = 0;
        while (n < n2) {
            if (byArray[n5 + n] == 0) {
                this.buf[n6++] = byArray[n5 + n + 1];
                this.buf[n6++] = byArray[n5 + n + 2];
            }
            n += 3;
        }
        this.buf[this.count++] = (byte)((n6 -= this.count + 2) >>> 8);
        this.buf[this.count++] = (byte)n6;
        this.count += n6;
        this.buf[this.count++] = 1;
        this.buf[this.count++] = 0;
        this.buf[3] = (byte)(this.count - 5);
        this.buf[4] = (byte)(this.count - 5 >>> 8);
        this.buf[6] = 0;
        this.buf[7] = (byte)(this.count - 5 - 4 >>> 8);
        this.buf[8] = (byte)(this.count - 5 - 4);
        this.pos = 5;
    }

    static String b(int n) {
        switch (n) {
            case 20: {
                return "Change Cipher Spec";
            }
            case 21: {
                return "Alert";
            }
            case 22: {
                return "Handshake";
            }
            case 23: {
                return "Application Data";
            }
        }
        return "contentType = " + n;
    }
}

