/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.cache;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import java.util.Iterator;
import sun.plugin.cache.Cache;
import sun.plugin.cache.CachedJarFile;
import sun.plugin.cache.FileCache;
import sun.plugin.cache.JarCache;

public class CacheFile {
    private String name;
    private File indexFile = null;
    private File dataFile = null;
    private long size = 0L;
    private long date = 0L;
    private byte status = 1;
    private boolean usable = false;
    private boolean initialized = false;

    public CacheFile(String string) {
        this.name = string;
    }

    public void initialize() {
        if (this.dataFile != null && this.indexFile != null) {
            this.size = this.dataFile.length() + this.indexFile.length();
            this.date = this.indexFile.lastModified();
        } else if (this.dataFile != null) {
            this.size = this.dataFile.length();
        } else if (this.indexFile != null) {
            this.size = this.indexFile.length();
        }
        if (this.indexFile != null) {
            this.readStatus();
        }
        this.initialized = true;
    }

    public void addFile(File file, String string) {
        if (string != null) {
            if (string.equalsIgnoreCase(".idx")) {
                this.indexFile = file;
            } else {
                this.dataFile = file;
            }
        }
    }

    public long getSize() {
        return this.size;
    }

    public String getName() {
        return this.name;
    }

    public long getDate() {
        return this.date;
    }

    public int getFileType() {
        String string = Cache.getFileExtension(this.dataFile.getName());
        int n = string.equalsIgnoreCase(".zip") ? 1 : 3;
        return n;
    }

    public boolean isUsable() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.status != 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readStatus() {
        RandomAccessFile randomAccessFile = null;
        randomAccessFile = new RandomAccessFile(this.indexFile, "r");
        this.status = randomAccessFile.readByte();
        Object var5_2 = null;
        if (randomAccessFile == null) return;
        try {
            randomAccessFile.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (EOFException eOFException) {
                this.status = 0;
                Object var5_3 = null;
                if (randomAccessFile == null) return;
                try {
                    randomAccessFile.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            catch (IOException iOException) {
                this.status = 0;
                Object var5_4 = null;
                if (randomAccessFile == null) return;
                try {
                    randomAccessFile.close();
                    return;
                }
                catch (IOException iOException2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (randomAccessFile == null) throw throwable;
            try {
                randomAccessFile.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public boolean before(CacheFile cacheFile) {
        if (this.isUsable() && cacheFile.isUsable()) {
            if (this.getFileType() == cacheFile.getFileType()) {
                return this.getDate() < cacheFile.getDate();
            }
            return this.getFileType() == 3;
        }
        return !this.isUsable();
    }

    public long delete() {
        long l = 0L;
        if (this.status != 0) {
            long l2;
            if (this.dataFile != null) {
                l2 = this.dataFile.length();
                Cache.msgPrintln("cache.full", new Object[]{this.dataFile.getName()});
                if (this.isLoaded(this.dataFile)) {
                    Cache.msgPrintln("cache.inuse", new Object[]{this.dataFile.getName()});
                } else if (this.dataFile.delete()) {
                    this.dataFile = null;
                    l += l2;
                } else {
                    Cache.msgPrintln("cache.notdeleted", new Object[]{this.dataFile.getName()});
                }
            }
            if (this.dataFile == null && this.indexFile != null) {
                l2 = this.indexFile.length();
                Cache.msgPrintln("cache.full", new Object[]{this.indexFile.getName()});
                if (this.indexFile.delete()) {
                    this.indexFile = null;
                    l += l2;
                } else {
                    Cache.msgPrintln("cache.notdeleted", new Object[]{this.indexFile.getName()});
                }
            }
        }
        return l;
    }

    private boolean isLoaded(File file) {
        boolean bl = false;
        if (Cache.getFileExtension(file.getName()).equalsIgnoreCase(".jar")) {
            Hashtable hashtable = (Hashtable)JarCache.loadedJars.clone();
            Iterator iterator = hashtable.values().iterator();
            while (iterator.hasNext() && !bl) {
                JarCache.JarReference jarReference = (JarCache.JarReference)iterator.next();
                if (jarReference == null) continue;
                CachedJarFile cachedJarFile = null;
                cachedJarFile = (CachedJarFile)jarReference.get();
                if (cachedJarFile == null) continue;
                try {
                    if (!new File(cachedJarFile.getName()).getCanonicalPath().equals(file.getCanonicalPath())) continue;
                    bl = true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        } else {
            Hashtable hashtable = (Hashtable)FileCache.loadedFiles.clone();
            Iterator iterator = hashtable.values().iterator();
            while (iterator.hasNext() && !bl) {
                FileCache.FileReference fileReference = (FileCache.FileReference)iterator.next();
                if (fileReference == null) continue;
                File file2 = null;
                file2 = (File)fileReference.get();
                if (file2 == null) continue;
                try {
                    if (!new File(file2.getName()).getCanonicalPath().equals(file.getCanonicalPath())) continue;
                    bl = true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return bl;
    }
}

