/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PushbackInputStream;
import java.io.Serializable;
import java.security.Identity;
import java.security.Key;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.Collator;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import sun.misc.BASE64Encoder;
import sun.security.pkcs.PKCS10;
import sun.security.provider.IdentityDatabase;
import sun.security.provider.SystemIdentity;
import sun.security.provider.SystemSigner;
import sun.security.util.DerOutputStream;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertAndKeyGen;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateValidity;
import sun.security.x509.X500Name;
import sun.security.x509.X500Signer;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public final class KeyTool {
    private boolean debug = false;
    private String command = null;
    private String sigAlgName = null;
    private String keyAlgName = "DSA";
    private boolean verbose = false;
    private int keysize = 1024;
    private boolean rfc = false;
    private int validity = 90;
    private String alias = null;
    private String dname = null;
    private String keyAlias = "mykey";
    private String dest = null;
    private String filename = null;
    private Vector providers = null;
    private String storetype = null;
    private char[] storePass = null;
    private char[] storePassNew = null;
    private char[] keyPass = null;
    private char[] keyPassNew = null;
    private char[] oldPass = null;
    private char[] newPass = null;
    private String ksfname = null;
    private File ksfile = null;
    private InputStream ksStream = null;
    private InputStream inStream = null;
    private KeyStore keyStore = null;
    private boolean kssave = false;
    private boolean noprompt = false;
    private boolean trustcacerts = false;
    private CertificateFactory cf = null;
    private KeyStore caks = null;
    private static final ResourceBundle rb = ResourceBundle.getBundle("sun.security.util.Resources");
    private static final Collator collator = Collator.getInstance();

    private KeyTool() {
    }

    public static void main(String[] stringArray) {
        KeyTool keyTool = new KeyTool();
        keyTool.run(stringArray, System.out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String[] stringArray, PrintStream printStream) {
        try {
            this.parseArgs(stringArray);
            this.doCommands(printStream);
        }
        catch (Exception exception) {
            System.out.println(rb.getString("keytool error: ") + exception);
            if (this.debug) {
                exception.printStackTrace();
            }
            System.exit(1);
        }
        finally {
            if (this.storePass != null) {
                Arrays.fill(this.storePass, ' ');
                this.storePass = null;
            }
            if (this.storePassNew != null) {
                Arrays.fill(this.storePassNew, ' ');
                this.storePassNew = null;
            }
            if (this.keyPass != null) {
                Arrays.fill(this.keyPass, ' ');
                this.keyPass = null;
            }
            if (this.keyPassNew != null) {
                Arrays.fill(this.keyPassNew, ' ');
                this.keyPassNew = null;
            }
            if (this.oldPass != null) {
                Arrays.fill(this.oldPass, ' ');
                this.oldPass = null;
            }
            if (this.newPass != null) {
                Arrays.fill(this.newPass, ' ');
                this.newPass = null;
            }
        }
    }

    void parseArgs(String[] stringArray) {
        if (stringArray.length == 0) {
            this.usage();
        }
        int n2 = 0;
        n2 = 0;
        while (n2 < stringArray.length && stringArray[n2].startsWith("-")) {
            String string = stringArray[n2];
            if (collator.compare(string, "-certreq") == 0) {
                this.command = "certreq";
            } else if (collator.compare(string, "-delete") == 0) {
                this.command = "delete";
            } else if (collator.compare(string, "-export") == 0) {
                this.command = "export";
            } else if (collator.compare(string, "-genkey") == 0) {
                this.command = "genkey";
            } else {
                if (collator.compare(string, "-help") == 0) {
                    this.usage();
                    return;
                }
                if (collator.compare(string, "-identitydb") == 0) {
                    this.command = "identitydb";
                } else if (collator.compare(string, "-import") == 0) {
                    this.command = "import";
                } else if (collator.compare(string, "-keyclone") == 0) {
                    this.command = "keyclone";
                } else if (collator.compare(string, "-keypasswd") == 0) {
                    this.command = "keypasswd";
                } else if (collator.compare(string, "-list") == 0) {
                    this.command = "list";
                } else if (collator.compare(string, "-printcert") == 0) {
                    this.command = "printcert";
                } else if (collator.compare(string, "-selfcert") == 0) {
                    this.command = "selfcert";
                } else if (collator.compare(string, "-storepasswd") == 0) {
                    this.command = "storepasswd";
                } else if (collator.compare(string, "-keystore") == 0) {
                    if (++n2 == stringArray.length) {
                        this.usage();
                    }
                    this.ksfname = stringArray[n2];
                } else if (collator.compare(string, "-storepass") == 0) {
                    if (++n2 == stringArray.length) {
                        this.usage();
                    }
                    this.storePass = stringArray[n2].toCharArray();
                } else if (collator.compare(string, "-storetype") == 0) {
                    if (++n2 == stringArray.length) {
                        this.usage();
                    }
                    this.storetype = stringArray[n2];
                } else if (collator.compare(string, "-keypass") == 0) {
                    if (++n2 == stringArray.length) {
                        this.usage();
                    }
                    this.keyPass = stringArray[n2].toCharArray();
                } else if (collator.compare(string, "-new") == 0) {
                    if (++n2 == stringArray.length) {
                        this.usage();
                    }
                    this.newPass = stringArray[n2].toCharArray();
                } else if (collator.compare(string, "-alias") == 0) {
                    if (++n2 == stringArray.length) {
                        this.usage();
                    }
                    this.alias = stringArray[n2];
                } else if (collator.compare(string, "-dest") == 0) {
                    if (++n2 == stringArray.length) {
                        this.usage();
                    }
                    this.dest = stringArray[n2];
                } else if (collator.compare(string, "-dname") == 0) {
                    if (++n2 == stringArray.length) {
                        this.usage();
                    }
                    this.dname = stringArray[n2];
                } else if (collator.compare(string, "-keysize") == 0) {
                    if (++n2 == stringArray.length) {
                        this.usage();
                    }
                    this.keysize = Integer.parseInt(stringArray[n2]);
                } else if (collator.compare(string, "-keyalg") == 0) {
                    if (++n2 == stringArray.length) {
                        this.usage();
                    }
                    this.keyAlgName = stringArray[n2];
                } else if (collator.compare(string, "-sigalg") == 0) {
                    if (++n2 == stringArray.length) {
                        this.usage();
                    }
                    this.sigAlgName = stringArray[n2];
                } else if (collator.compare(string, "-validity") == 0) {
                    if (++n2 == stringArray.length) {
                        this.usage();
                    }
                    this.validity = Integer.parseInt(stringArray[n2]);
                } else if (collator.compare(string, "-file") == 0) {
                    if (++n2 == stringArray.length) {
                        this.usage();
                    }
                    this.filename = stringArray[n2];
                } else if (collator.compare(string, "-provider") == 0) {
                    if (++n2 == stringArray.length) {
                        this.usage();
                    }
                    if (this.providers == null) {
                        this.providers = new Vector(3);
                    }
                    this.providers.add(stringArray[n2]);
                } else if (collator.compare(string, "-v") == 0) {
                    this.verbose = true;
                } else if (collator.compare(string, "-debug") == 0) {
                    this.debug = true;
                } else if (collator.compare(string, "-rfc") == 0) {
                    this.rfc = true;
                } else if (collator.compare(string, "-noprompt") == 0) {
                    this.noprompt = true;
                } else if (collator.compare(string, "-trustcacerts") == 0) {
                    this.trustcacerts = true;
                } else {
                    System.err.println(rb.getString("Illegal option:  ") + string);
                    this.usage();
                }
            }
            ++n2;
        }
        if (n2 < stringArray.length || this.command == null) {
            this.usage();
        }
    }

    void doCommands(PrintStream printStream) throws Exception {
        Object object;
        block69: {
            if (this.validity <= 0) {
                throw new Exception(rb.getString("Validity must be greater than zero"));
            }
            if (this.providers != null) {
                ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                object = this.providers.elements();
                while (object.hasMoreElements()) {
                    String string = (String)object.nextElement();
                    Class clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
                    Object object2 = clazz.newInstance();
                    if (!(object2 instanceof Provider)) {
                        MessageFormat messageFormat = new MessageFormat(rb.getString("provName not a provider"));
                        Object[] objectArray = new Object[]{string};
                        throw new Exception(messageFormat.format(objectArray));
                    }
                    Security.addProvider((Provider)object2);
                }
            }
            if (this.command.equals("list") && this.verbose && this.rfc) {
                System.err.println(rb.getString("Must not specify both -v and -rfc with 'list' command"));
                this.usage();
            }
            if (this.command.equals("genkey") && this.keyPass != null && this.keyPass.length < 6) {
                throw new Exception(rb.getString("Key password must be at least 6 characters"));
            }
            if (this.newPass != null && this.newPass.length < 6) {
                throw new Exception(rb.getString("New password must be at least 6 characters"));
            }
            if (!this.command.equals("printcert")) {
                if (this.ksfname == null) {
                    this.ksfname = System.getProperty("user.home") + File.separator + ".keystore";
                }
                try {
                    this.ksfile = new File(this.ksfname);
                    if (this.ksfile.exists() && this.ksfile.length() == 0L) {
                        throw new Exception(rb.getString("Keystore file exists, but is empty: ") + this.ksfname);
                    }
                    this.ksStream = new FileInputStream(this.ksfile);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (this.command.equals("genkey") || this.command.equals("identitydb") || this.command.equals("import")) break block69;
                    throw new Exception(rb.getString("Keystore file does not exist: ") + this.ksfname);
                }
            }
        }
        if (this.command.equals("keyclone") && this.dest == null) {
            this.dest = this.getAlias("destination");
            if (this.dest.equals("")) {
                throw new Exception(rb.getString("Must specify destination alias"));
            }
        }
        if (this.command.equals("delete") && this.alias == null) {
            this.alias = this.getAlias(null);
            if (this.alias.equals("")) {
                throw new Exception(rb.getString("Must specify alias"));
            }
        }
        this.keyStore = this.storetype != null ? KeyStore.getInstance(this.storetype) : KeyStore.getInstance(KeyStore.getDefaultType());
        this.keyStore.load(this.ksStream, this.storePass);
        if (this.ksStream != null) {
            this.ksStream.close();
        }
        if (this.storePass != null) {
            if (this.ksStream == null && this.storePass.length < 6) {
                throw new Exception(rb.getString("Keystore password must be at least 6 characters"));
            }
        } else {
            if (this.command.equals("certreq") || this.command.equals("delete") || this.command.equals("genkey") || this.command.equals("import") || this.command.equals("keyclone") || this.command.equals("selfcert") || this.command.equals("storepasswd") || this.command.equals("keypasswd") || this.command.equals("identitydb")) {
                int n2 = 0;
                do {
                    System.err.print(rb.getString("Enter keystore password:  "));
                    System.err.flush();
                    this.storePass = this.readPasswd(System.in);
                    if (this.ksStream != null || this.storePass.length >= 6) continue;
                    System.err.println(rb.getString("Keystore password is too short - must be at least 6 characters"));
                    this.storePass = null;
                } while (this.storePass == null && ++n2 < 3);
                if (this.storePass == null) {
                    System.err.println(rb.getString("Too many failures - try later"));
                    return;
                }
            } else if (!this.command.equals("printcert")) {
                System.err.print(rb.getString("Enter keystore password:  "));
                System.err.flush();
                this.storePass = this.readPasswd(System.in);
            }
            if (this.ksStream != null) {
                this.ksStream = new FileInputStream(this.ksfile);
                this.keyStore.load(this.ksStream, this.storePass);
                this.ksStream.close();
            }
        }
        if (this.command.equals("printcert") || this.command.equals("import") || this.command.equals("identitydb")) {
            this.cf = CertificateFactory.getInstance("X509");
        }
        if (this.trustcacerts) {
            this.caks = this.getCacertsKeyStore();
        }
        if (this.command.equals("certreq")) {
            if (this.filename != null) {
                PrintStream printStream2;
                printStream = printStream2 = new PrintStream(new FileOutputStream(this.filename));
            }
            this.doCertReq(this.alias, this.sigAlgName, printStream);
            if (this.verbose && this.filename != null) {
                MessageFormat messageFormat = new MessageFormat(rb.getString("Certification request stored in file <filename>"));
                object = new Object[]{this.filename};
                System.err.println(messageFormat.format(object));
                System.err.println(rb.getString("Submit this to your CA"));
            }
        } else if (this.command.equals("delete")) {
            this.doDeleteEntry(this.alias);
            this.kssave = true;
        } else if (this.command.equals("export")) {
            if (this.filename != null) {
                PrintStream printStream3;
                printStream = printStream3 = new PrintStream(new FileOutputStream(this.filename));
            }
            this.doExportCert(this.alias, printStream);
            if (this.filename != null) {
                MessageFormat messageFormat = new MessageFormat(rb.getString("Certificate stored in file <filename>"));
                object = new Object[]{this.filename};
                System.err.println(messageFormat.format(object));
            }
        } else if (this.command.equals("genkey")) {
            this.doGenKeyPair(this.alias, this.dname, this.keyAlgName, this.keysize, this.sigAlgName);
            this.kssave = true;
        } else if (this.command.equals("identitydb")) {
            InputStream inputStream = System.in;
            if (this.filename != null) {
                inputStream = new FileInputStream(this.filename);
            }
            this.doImportIdentityDatabase(inputStream);
        } else if (this.command.equals("import")) {
            InputStream inputStream = System.in;
            if (this.filename != null) {
                inputStream = new FileInputStream(this.filename);
            }
            Object object3 = object = this.alias != null ? this.alias : this.keyAlias;
            if (this.keyStore.isKeyEntry((String)object)) {
                this.kssave = this.installReply((String)object, inputStream);
                if (this.kssave) {
                    System.err.println(rb.getString("Certificate reply was installed in keystore"));
                } else {
                    System.err.println(rb.getString("Certificate reply was not installed in keystore"));
                }
            } else {
                this.kssave = this.addTrustedCert((String)object, inputStream);
                if (this.kssave) {
                    System.err.println(rb.getString("Certificate was added to keystore"));
                } else {
                    System.err.println(rb.getString("Certificate was not added to keystore"));
                }
            }
        } else if (this.command.equals("keyclone")) {
            this.keyPassNew = this.newPass;
            this.doCloneKey(this.alias, this.dest);
            this.kssave = true;
        } else if (this.command.equals("keypasswd")) {
            this.keyPassNew = this.newPass;
            this.doChangeKeyPasswd(this.alias);
            this.kssave = true;
        } else if (this.command.equals("list")) {
            if (this.alias != null) {
                this.doPrintEntry(this.alias, printStream, true);
            } else {
                this.doPrintEntries(printStream);
            }
        } else if (this.command.equals("printcert")) {
            InputStream inputStream = System.in;
            if (this.filename != null) {
                inputStream = new FileInputStream(this.filename);
            }
            this.doPrintCert(inputStream, printStream);
        } else if (this.command.equals("selfcert")) {
            this.doSelfCert(this.alias, this.dname, this.sigAlgName);
            this.kssave = true;
        } else if (this.command.equals("storepasswd")) {
            this.storePassNew = this.newPass;
            if (this.storePassNew == null) {
                this.storePassNew = this.getNewPasswd("keystore password", this.storePass);
            }
            this.kssave = true;
        }
        if (this.kssave) {
            if (this.verbose) {
                MessageFormat messageFormat = new MessageFormat(rb.getString("[Saving ksfname]"));
                object = new Object[]{this.ksfname};
                System.err.println(messageFormat.format(object));
            }
            FileOutputStream fileOutputStream = new FileOutputStream(this.ksfname);
            this.keyStore.store(fileOutputStream, this.storePassNew != null ? this.storePassNew : this.storePass);
            fileOutputStream.close();
        }
    }

    private void doCertReq(String string, String string2, PrintStream printStream) throws Exception {
        Object object;
        Certificate certificate;
        if (string == null) {
            string = this.keyAlias;
        }
        Object[] objectArray = this.recoverPrivateKey(string, this.storePass, this.keyPass);
        PrivateKey privateKey = (PrivateKey)objectArray[0];
        if (this.keyPass == null) {
            this.keyPass = (char[])objectArray[1];
        }
        if ((certificate = this.keyStore.getCertificate(string)) == null) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("alias has no public key (certificate)"));
            Object[] objectArray2 = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray2));
        }
        PKCS10 pKCS10 = new PKCS10(certificate.getPublicKey());
        if (string2 == null) {
            object = privateKey.getAlgorithm();
            if (((String)object).equalsIgnoreCase("DSA") || ((String)object).equalsIgnoreCase("DSS")) {
                string2 = "SHA1WithDSA";
            } else if (((String)object).equalsIgnoreCase("RSA")) {
                string2 = "MD5WithRSA";
            } else {
                throw new Exception(rb.getString("Cannot derive signature algorithm"));
            }
        }
        object = Signature.getInstance(string2);
        ((Signature)object).initSign(privateKey);
        X500Name x500Name = new X500Name(((X509Certificate)certificate).getSubjectDN().toString());
        X500Signer x500Signer = new X500Signer((Signature)object, x500Name);
        pKCS10.encodeAndSign(x500Signer);
        pKCS10.print(printStream);
    }

    private void doDeleteEntry(String string) throws Exception {
        if (!this.keyStore.containsAlias(string)) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Alias <alias> does not exist"));
            Object[] objectArray = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray));
        }
        this.keyStore.deleteEntry(string);
    }

    private void doExportCert(String string, PrintStream printStream) throws Exception {
        if (this.storePass == null) {
            this.printWarning();
        }
        if (string == null) {
            string = this.keyAlias;
        }
        if (!this.keyStore.containsAlias(string)) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Alias <alias> does not exist"));
            Object[] objectArray = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray));
        }
        X509Certificate x509Certificate = (X509Certificate)this.keyStore.getCertificate(string);
        if (x509Certificate == null) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Alias <alias> has no certificate"));
            Object[] objectArray = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray));
        }
        this.dumpCert(x509Certificate, printStream);
    }

    private void doGenKeyPair(String string, String string2, String string3, int n2, String string4) throws Exception {
        Object[] objectArray;
        Serializable serializable;
        if (string == null) {
            string = this.keyAlias;
        }
        if (this.keyStore.containsAlias(string)) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Key pair not generated, alias <alias> already exists"));
            Object[] objectArray2 = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray2));
        }
        if (string4 == null) {
            if (string3.equalsIgnoreCase("DSA")) {
                string4 = "SHA1WithDSA";
            } else if (string3.equalsIgnoreCase("RSA")) {
                string4 = "MD5WithRSA";
            } else {
                throw new Exception(rb.getString("Cannot derive signature algorithm"));
            }
        }
        CertAndKeyGen certAndKeyGen = new CertAndKeyGen(string3, string4);
        X500Name x500Name = string2 == null ? this.getX500Name() : new X500Name(string2);
        if (this.verbose) {
            serializable = new MessageFormat(rb.getString("Generating keysize bit keyAlgName key pair and self-signed certificate (sigAlgName)\n\tfor: x500Name"));
            objectArray = new Object[]{new Integer(n2), string3, string4, x500Name};
            System.err.println(((Format)serializable).format(objectArray));
        }
        certAndKeyGen.generate(n2);
        serializable = certAndKeyGen.getPrivateKey();
        objectArray = new X509Certificate[]{certAndKeyGen.getSelfCertificate(x500Name, this.validity * 24 * 60 * 60)};
        if (this.keyPass == null) {
            int n3 = 0;
            while (n3 < 3 && this.keyPass == null) {
                MessageFormat messageFormat = new MessageFormat(rb.getString("Enter key password for <alias>"));
                Object[] objectArray3 = new Object[]{string};
                System.err.println(messageFormat.format(objectArray3));
                System.err.print(rb.getString("\t(RETURN if same as keystore password):  "));
                System.err.flush();
                this.keyPass = this.readPasswd(System.in);
                if (this.keyPass == null) {
                    this.keyPass = this.storePass;
                } else if (this.keyPass.length < 6) {
                    System.err.println(rb.getString("Key password is too short - must be at least 6 characters"));
                    this.keyPass = null;
                }
                ++n3;
            }
            if (n3 == 3) {
                throw new Exception(rb.getString("Too many failures - key not added to keystore"));
            }
        }
        this.keyStore.setKeyEntry(string, (Key)serializable, this.keyPass, (Certificate[])objectArray);
    }

    private void doCloneKey(String string, String string2) throws Exception {
        if (string == null) {
            string = this.keyAlias;
        }
        if (this.keyStore.containsAlias(string2)) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Destination alias <dest> already exists"));
            Object[] objectArray = new Object[]{string2};
            throw new Exception(messageFormat.format(objectArray));
        }
        Object[] objectArray = this.recoverPrivateKey(string, this.storePass, this.keyPass);
        PrivateKey privateKey = (PrivateKey)objectArray[0];
        if (this.keyPass == null) {
            this.keyPass = (char[])objectArray[1];
        }
        if (this.keyPassNew == null) {
            int n2 = 0;
            do {
                this.keyPassNew = this.getKeyPasswd(string2, string, this.keyPass);
                if (this.keyPassNew.length >= 6) continue;
                System.err.println(rb.getString("Password is too short - must be at least 6 characters"));
                this.keyPassNew = null;
            } while (this.keyPassNew == null && ++n2 < 3);
            if (this.keyPassNew == null) {
                throw new Exception(rb.getString("Too many failures. Key entry not cloned"));
            }
        }
        this.keyStore.setKeyEntry(string2, privateKey, this.keyPassNew, this.keyStore.getCertificateChain(string));
    }

    private void doChangeKeyPasswd(String string) throws Exception {
        if (string == null) {
            string = this.keyAlias;
        }
        Object[] objectArray = this.recoverPrivateKey(string, this.storePass, this.keyPass);
        PrivateKey privateKey = (PrivateKey)objectArray[0];
        if (this.keyPass == null) {
            this.keyPass = (char[])objectArray[1];
        }
        if (this.keyPassNew == null) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("key password for <alias>"));
            Object[] objectArray2 = new Object[]{string};
            this.keyPassNew = this.getNewPasswd(messageFormat.format(objectArray2), this.keyPass);
        }
        this.keyStore.setKeyEntry(string, privateKey, this.keyPassNew, this.keyStore.getCertificateChain(string));
    }

    private void doImportIdentityDatabase(InputStream inputStream) throws Exception {
        Certificate[] certificateArray = null;
        boolean bl2 = false;
        IdentityDatabase identityDatabase = IdentityDatabase.fromStream(inputStream);
        Enumeration enumeration = identityDatabase.identities();
        while (enumeration.hasMoreElements()) {
            Serializable serializable;
            Object[] objectArray;
            Object object;
            Identity identity = (Identity)enumeration.nextElement();
            X509Certificate x509Certificate = null;
            if ((!(identity instanceof SystemSigner) || !((SystemSigner)identity).isTrusted()) && (!(identity instanceof SystemIdentity) || !((SystemIdentity)identity).isTrusted())) continue;
            if (this.keyStore.containsAlias(identity.getName())) {
                object = new MessageFormat(rb.getString("Keystore entry for <id.getName()> already exists"));
                objectArray = new Object[]{identity.getName()};
                System.err.println(((Format)object).format(objectArray));
                continue;
            }
            object = identity.certificates();
            if (object == null || ((java.security.Certificate[])object).length <= 0) continue;
            objectArray = new DerOutputStream();
            object[0].encode((OutputStream)objectArray);
            byte[] byArray = objectArray.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            x509Certificate = (X509Certificate)this.cf.generateCertificate(byteArrayInputStream);
            byteArrayInputStream.close();
            if (this.isSelfSigned(x509Certificate)) {
                serializable = x509Certificate.getPublicKey();
                try {
                    x509Certificate.verify((PublicKey)serializable);
                }
                catch (Exception exception) {
                    continue;
                }
            }
            if (identity instanceof SystemSigner) {
                serializable = new MessageFormat(rb.getString("Creating keystore entry for <id.getName()> ..."));
                Object[] objectArray2 = new Object[]{identity.getName()};
                System.err.println(((Format)serializable).format(objectArray2));
                if (certificateArray == null) {
                    certificateArray = new Certificate[]{x509Certificate};
                }
                PrivateKey privateKey = ((SystemSigner)identity).getPrivateKey();
                this.keyStore.setKeyEntry(identity.getName(), privateKey, this.storePass, certificateArray);
            } else {
                this.keyStore.setCertificateEntry(identity.getName(), x509Certificate);
            }
            this.kssave = true;
        }
        if (!this.kssave) {
            System.err.println(rb.getString("No entries from identity database added"));
        }
    }

    private void doPrintEntry(String string, PrintStream printStream, boolean bl2) throws Exception {
        Object object;
        Object[] objectArray;
        Certificate[] certificateArray;
        if (this.storePass == null && bl2) {
            this.printWarning();
        }
        if (!this.keyStore.containsAlias(string)) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Alias <alias> does not exist"));
            Object[] objectArray2 = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray2));
        }
        if (this.verbose || this.rfc || this.debug) {
            certificateArray = new MessageFormat(rb.getString("Alias name: alias"));
            objectArray = new Object[]{string};
            printStream.println(certificateArray.format(objectArray));
            certificateArray = new MessageFormat(rb.getString("Creation date: keyStore.getCreationDate(alias)"));
            object = new Object[]{this.keyStore.getCreationDate(string)};
            printStream.println(certificateArray.format(object));
        } else {
            certificateArray = new MessageFormat(rb.getString("alias, keyStore.getCreationDate(alias), "));
            objectArray = new Object[]{string, this.keyStore.getCreationDate(string)};
            printStream.print(certificateArray.format(objectArray));
        }
        if (this.keyStore.isKeyEntry(string)) {
            if (this.verbose || this.rfc || this.debug) {
                printStream.println(rb.getString("Entry type: keyEntry"));
            } else {
                printStream.println(rb.getString("keyEntry,"));
            }
            certificateArray = this.keyStore.getCertificateChain(string);
            if (certificateArray != null) {
                if (this.verbose || this.rfc || this.debug) {
                    printStream.println(rb.getString("Certificate chain length: ") + certificateArray.length);
                    int n2 = 0;
                    while (n2 < certificateArray.length) {
                        object = new MessageFormat(rb.getString("Certificate[(i + 1)]:"));
                        Object[] objectArray3 = new Object[]{new Integer(n2 + 1)};
                        printStream.println(((Format)object).format(objectArray3));
                        if (this.verbose && certificateArray[n2] instanceof X509Certificate) {
                            this.printX509Cert((X509Certificate)certificateArray[n2], printStream);
                        } else if (this.debug) {
                            printStream.println(certificateArray[n2].toString());
                        } else {
                            this.dumpCert(certificateArray[n2], printStream);
                        }
                        ++n2;
                    }
                } else {
                    printStream.println(rb.getString("Certificate fingerprint (MD5): ") + this.getCertFingerPrint("MD5", certificateArray[0]));
                }
            }
        } else {
            certificateArray = this.keyStore.getCertificate(string);
            if (this.verbose && certificateArray instanceof X509Certificate) {
                printStream.println(rb.getString("Entry type: trustedCertEntry\n"));
                this.printX509Cert((X509Certificate)certificateArray, printStream);
            } else if (this.rfc) {
                printStream.println(rb.getString("Entry type: trustedCertEntry\n"));
                this.dumpCert((Certificate)certificateArray, printStream);
            } else if (this.debug) {
                printStream.println(certificateArray.toString());
            } else {
                printStream.println(rb.getString("trustedCertEntry,"));
                printStream.println(rb.getString("Certificate fingerprint (MD5): ") + this.getCertFingerPrint("MD5", (Certificate)certificateArray));
            }
        }
    }

    private void doPrintEntries(PrintStream printStream) throws Exception {
        if (this.storePass == null) {
            this.printWarning();
        } else {
            printStream.println();
        }
        printStream.println(rb.getString("Keystore type: ") + this.keyStore.getType());
        printStream.println(rb.getString("Keystore provider: ") + this.keyStore.getProvider().getName());
        printStream.println();
        MessageFormat messageFormat = this.keyStore.size() == 1 ? new MessageFormat(rb.getString("Your keystore contains keyStore.size() entry")) : new MessageFormat(rb.getString("Your keystore contains keyStore.size() entries"));
        Object[] objectArray = new Object[]{new Integer(this.keyStore.size())};
        printStream.println(messageFormat.format(objectArray));
        printStream.println();
        Enumeration enumeration = this.keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.doPrintEntry(string, printStream, false);
            if (!this.verbose && !this.rfc) continue;
            printStream.println(rb.getString("\n"));
            printStream.println(rb.getString("*******************************************"));
            printStream.println(rb.getString("*******************************************\n\n"));
        }
    }

    private void doPrintCert(InputStream inputStream, PrintStream printStream) throws Exception {
        Collection collection = null;
        try {
            collection = this.cf.generateCertificates(inputStream);
        }
        catch (CertificateException certificateException) {
            throw new Exception(rb.getString("Failed to parse input"), certificateException);
        }
        if (collection.isEmpty()) {
            throw new Exception(rb.getString("Empty input"));
        }
        Certificate[] certificateArray = (Certificate[])collection.toArray(new Certificate[collection.size()]);
        int n2 = 0;
        while (n2 < certificateArray.length) {
            X509Certificate x509Certificate = null;
            try {
                x509Certificate = (X509Certificate)certificateArray[n2];
            }
            catch (ClassCastException classCastException) {
                throw new Exception(rb.getString("Not X.509 certificate"));
            }
            if (certificateArray.length > 1) {
                MessageFormat messageFormat = new MessageFormat(rb.getString("Certificate[(i + 1)]:"));
                Object[] objectArray = new Object[]{new Integer(n2 + 1)};
                printStream.println(messageFormat.format(objectArray));
            }
            this.printX509Cert(x509Certificate, printStream);
            if (n2 < certificateArray.length - 1) {
                printStream.println();
            }
            ++n2;
        }
    }

    private void doSelfCert(String string, String string2, String string3) throws Exception {
        X500Name x500Name;
        Object object;
        if (string == null) {
            string = this.keyAlias;
        }
        Object[] objectArray = this.recoverPrivateKey(string, this.storePass, this.keyPass);
        PrivateKey privateKey = (PrivateKey)objectArray[0];
        if (this.keyPass == null) {
            this.keyPass = (char[])objectArray[1];
        }
        if (string3 == null) {
            object = privateKey.getAlgorithm();
            if (((String)object).equalsIgnoreCase("DSA") || ((String)object).equalsIgnoreCase("DSS")) {
                string3 = "SHA1WithDSA";
            } else if (((String)object).equalsIgnoreCase("RSA")) {
                string3 = "MD5WithRSA";
            } else {
                throw new Exception(rb.getString("Cannot derive signature algorithm"));
            }
        }
        if ((object = this.keyStore.getCertificate(string)) == null) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("alias has no public key"));
            Object[] objectArray2 = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray2));
        }
        if (!(object instanceof X509Certificate)) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("alias has no X.509 certificate"));
            Object[] objectArray3 = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray3));
        }
        byte[] byArray = ((Certificate)object).getEncoded();
        X509CertImpl x509CertImpl = new X509CertImpl(byArray);
        X509CertInfo x509CertInfo = (X509CertInfo)x509CertImpl.get("x509.info");
        Date date = new Date();
        Date date2 = new Date();
        date2.setTime(date2.getTime() + (long)this.validity * 1000L * 24L * 60L * 60L);
        CertificateValidity certificateValidity = new CertificateValidity(date, date2);
        x509CertInfo.set("validity", certificateValidity);
        x509CertInfo.set("serialNumber", new CertificateSerialNumber((int)(date.getTime() / 1000L)));
        if (string2 == null) {
            x500Name = (X500Name)x509CertInfo.get("subject.dname");
        } else {
            x500Name = new X500Name(string2);
            x509CertInfo.set("subject.dname", x500Name);
        }
        x509CertInfo.set("issuer.dname", x500Name);
        X509CertImpl x509CertImpl2 = new X509CertImpl(x509CertInfo);
        x509CertImpl2.sign(privateKey, string3);
        AlgorithmId algorithmId = (AlgorithmId)x509CertImpl2.get("x509.algorithm");
        x509CertInfo.set("algorithmID.algorithm", algorithmId);
        x509CertImpl2 = new X509CertImpl(x509CertInfo);
        x509CertImpl2.sign(privateKey, string3);
        this.keyStore.setKeyEntry(string, privateKey, this.keyPass != null ? this.keyPass : this.storePass, new Certificate[]{x509CertImpl2});
        if (this.verbose) {
            System.err.println(rb.getString("New certificate (self-signed):"));
            System.err.print(x509CertImpl2.toString());
            System.err.println();
        }
    }

    private boolean installReply(String string, InputStream inputStream) throws Exception {
        Certificate certificate;
        if (string == null) {
            string = this.keyAlias;
        }
        Object[] objectArray = this.recoverPrivateKey(string, this.storePass, this.keyPass);
        PrivateKey privateKey = (PrivateKey)objectArray[0];
        if (this.keyPass == null) {
            this.keyPass = (char[])objectArray[1];
        }
        if ((certificate = this.keyStore.getCertificate(string)) == null) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("alias has no public key (certificate)"));
            Object[] objectArray2 = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray2));
        }
        Collection collection = this.cf.generateCertificates(inputStream);
        if (collection.isEmpty()) {
            throw new Exception(rb.getString("Reply has no certificates"));
        }
        Certificate[] certificateArray = (Certificate[])collection.toArray(new Certificate[collection.size()]);
        Certificate[] certificateArray2 = certificateArray.length == 1 ? this.establishCertChain(certificate, certificateArray[0]) : this.validateReply(string, certificate, certificateArray);
        if (certificateArray2 != null) {
            this.keyStore.setKeyEntry(string, privateKey, this.keyPass != null ? this.keyPass : this.storePass, certificateArray2);
            return true;
        }
        return false;
    }

    private boolean addTrustedCert(String string, InputStream inputStream) throws Exception {
        Object object;
        if (string == null) {
            throw new Exception(rb.getString("Must specify alias"));
        }
        if (this.keyStore.containsAlias(string)) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Certificate not imported, alias <alias> already exists"));
            Object[] objectArray = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray));
        }
        X509Certificate x509Certificate = null;
        try {
            x509Certificate = (X509Certificate)this.cf.generateCertificate(inputStream);
        }
        catch (ClassCastException classCastException) {
            throw new Exception(rb.getString("Input not an X.509 certificate"));
        }
        catch (CertificateException certificateException) {
            throw new Exception(rb.getString("Input not an X.509 certificate"));
        }
        boolean bl2 = false;
        if (this.isSelfSigned(x509Certificate)) {
            x509Certificate.verify(x509Certificate.getPublicKey());
            bl2 = true;
        }
        if (this.noprompt) {
            this.keyStore.setCertificateEntry(string, x509Certificate);
            return true;
        }
        String string2 = null;
        String string3 = this.keyStore.getCertificateAlias(x509Certificate);
        if (string3 != null) {
            object = new MessageFormat(rb.getString("Certificate already exists in keystore under alias <trustalias>"));
            Object[] objectArray = new Object[]{string3};
            System.err.println(((Format)object).format(objectArray));
            string2 = this.getYesNoReply(rb.getString("Do you still want to add it? [no]:  "));
        } else if (bl2) {
            if (this.trustcacerts && this.caks != null && (string3 = this.caks.getCertificateAlias(x509Certificate)) != null) {
                object = new MessageFormat(rb.getString("Certificate already exists in system-wide CA keystore under alias <trustalias>"));
                Object[] objectArray = new Object[]{string3};
                System.err.println(((Format)object).format(objectArray));
                string2 = this.getYesNoReply(rb.getString("Do you still want to add it to your own keystore? [no]:  "));
            }
            if (string3 == null) {
                this.printX509Cert(x509Certificate, System.out);
                string2 = this.getYesNoReply(rb.getString("Trust this certificate? [no]:  "));
            }
        }
        if (string2 != null) {
            if (string2.equals("YES")) {
                this.keyStore.setCertificateEntry(string, x509Certificate);
                return true;
            }
            return false;
        }
        try {
            object = this.establishCertChain(null, x509Certificate);
            if (object != null) {
                this.keyStore.setCertificateEntry(string, x509Certificate);
                return true;
            }
        }
        catch (Exception exception) {
            this.printX509Cert(x509Certificate, System.out);
            string2 = this.getYesNoReply(rb.getString("Trust this certificate? [no]:  "));
            if (string2.equals("YES")) {
                this.keyStore.setCertificateEntry(string, x509Certificate);
                return true;
            }
            return false;
        }
        return false;
    }

    private char[] getNewPasswd(String string, char[] cArray) throws Exception {
        char[] cArray2 = null;
        char[] cArray3 = null;
        int n2 = 0;
        while (n2 < 3) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("New prompt: "));
            Object[] objectArray = new Object[]{string};
            System.err.print(messageFormat.format(objectArray));
            cArray2 = this.readPasswd(System.in);
            if (cArray2.length < 6) {
                System.err.println(rb.getString("Password is too short - must be at least 6 characters"));
            } else if (Arrays.equals(cArray2, cArray)) {
                System.err.println(rb.getString("Passwords must differ"));
            } else {
                messageFormat = new MessageFormat(rb.getString("Re-enter new prompt: "));
                Object[] objectArray2 = new Object[]{string};
                System.err.print(messageFormat.format(objectArray2));
                cArray3 = this.readPasswd(System.in);
                if (!Arrays.equals(cArray2, cArray3)) {
                    System.err.println(rb.getString("They don't match; try again"));
                } else {
                    Arrays.fill(cArray3, ' ');
                    return cArray2;
                }
            }
            if (cArray2 != null) {
                Arrays.fill(cArray2, ' ');
                cArray2 = null;
            }
            if (cArray3 != null) {
                Arrays.fill(cArray3, ' ');
                cArray3 = null;
            }
            ++n2;
        }
        throw new Exception(rb.getString("Too many failures - try later"));
    }

    private String getAlias(String string) throws Exception {
        if (string != null) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Enter prompt alias name:  "));
            Object[] objectArray = new Object[]{string};
            System.err.print(messageFormat.format(objectArray));
        } else {
            System.err.print(rb.getString("Enter alias name:  "));
        }
        return new BufferedReader(new InputStreamReader(System.in)).readLine();
    }

    private char[] getKeyPasswd(String string, String string2, char[] cArray) throws Exception {
        int n2 = 0;
        char[] cArray2 = null;
        do {
            Object[] objectArray;
            MessageFormat messageFormat;
            if (cArray != null) {
                messageFormat = new MessageFormat(rb.getString("Enter key password for <alias>"));
                objectArray = new Object[]{string};
                System.err.println(messageFormat.format(objectArray));
                messageFormat = new MessageFormat(rb.getString("\t(RETURN if same as for <otherAlias>)"));
                Object[] objectArray2 = new Object[]{string2};
                System.err.print(messageFormat.format(objectArray2));
            } else {
                messageFormat = new MessageFormat(rb.getString("Enter key password for <alias>"));
                objectArray = new Object[]{string};
                System.err.print(messageFormat.format(objectArray));
            }
            System.err.flush();
            cArray2 = this.readPasswd(System.in);
            if (cArray2 != null) continue;
            cArray2 = cArray;
        } while (cArray2 == null && ++n2 < 3);
        if (cArray2 == null) {
            throw new Exception(rb.getString("Too many failures - try later"));
        }
        return cArray2;
    }

    private char[] readPasswd(InputStream inputStream) throws IOException {
        char[] cArray;
        char[] cArray2 = cArray = new char[128];
        int n2 = cArray2.length;
        int n3 = 0;
        block4: while (true) {
            int n4 = inputStream.read();
            switch (n4) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    int n5 = inputStream.read();
                    if (n5 == 10 || n5 == -1) break block4;
                    if (!(inputStream instanceof PushbackInputStream)) {
                        inputStream = new PushbackInputStream(inputStream);
                    }
                    ((PushbackInputStream)inputStream).unread(n5);
                }
                default: {
                    if (--n2 < 0) {
                        cArray2 = new char[n3 + 128];
                        n2 = cArray2.length - n3 - 1;
                        System.arraycopy(cArray, 0, cArray2, 0, n3);
                        Arrays.fill(cArray, ' ');
                        cArray = cArray2;
                    }
                    cArray2[n3++] = (char)n4;
                    continue block4;
                }
            }
            break;
        }
        if (n3 == 0) {
            return null;
        }
        char[] cArray3 = new char[n3];
        System.arraycopy(cArray2, 0, cArray3, 0, n3);
        Arrays.fill(cArray2, ' ');
        return cArray3;
    }

    private void printX509Cert(X509Certificate x509Certificate, PrintStream printStream) throws Exception {
        MessageFormat messageFormat = new MessageFormat(rb.getString("*PATTERN* printX509Cert"));
        Object[] objectArray = new Object[]{x509Certificate.getSubjectDN().toString(), x509Certificate.getIssuerDN().toString(), x509Certificate.getSerialNumber().toString(16), x509Certificate.getNotBefore().toString(), x509Certificate.getNotAfter().toString(), this.getCertFingerPrint("MD5", x509Certificate), this.getCertFingerPrint("SHA1", x509Certificate)};
        printStream.println(messageFormat.format(objectArray));
    }

    private boolean isSelfSigned(X509Certificate x509Certificate) {
        return x509Certificate.getSubjectDN().equals(x509Certificate.getIssuerDN());
    }

    private boolean isTrusted(Certificate certificate) throws Exception {
        if (this.keyStore.getCertificateAlias(certificate) != null) {
            return true;
        }
        return this.trustcacerts && this.caks != null && this.caks.getCertificateAlias(certificate) != null;
    }

    private X500Name getX500Name() throws IOException {
        X500Name x500Name;
        Object[] objectArray;
        MessageFormat messageFormat;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        String string = "Unknown";
        String string2 = "Unknown";
        String string3 = "Unknown";
        String string4 = "Unknown";
        String string5 = "Unknown";
        String string6 = "Unknown";
        String string7 = null;
        do {
            string = this.inputString(bufferedReader, rb.getString("What is your first and last name?"), string);
            string2 = this.inputString(bufferedReader, rb.getString("What is the name of your organizational unit?"), string2);
            string3 = this.inputString(bufferedReader, rb.getString("What is the name of your organization?"), string3);
            string4 = this.inputString(bufferedReader, rb.getString("What is the name of your City or Locality?"), string4);
            string5 = this.inputString(bufferedReader, rb.getString("What is the name of your State or Province?"), string5);
            string6 = this.inputString(bufferedReader, rb.getString("What is the two-letter country code for this unit?"), string6);
            x500Name = new X500Name(string, string2, string3, string4, string5, string6);
        } while (collator.compare(string7 = this.inputString(bufferedReader, (messageFormat = new MessageFormat(rb.getString("Is <name> correct?"))).format(objectArray = new Object[]{x500Name}), rb.getString("no")), rb.getString("yes")) != 0 && collator.compare(string7, rb.getString("y")) != 0);
        System.err.println();
        return x500Name;
    }

    private String inputString(BufferedReader bufferedReader, String string, String string2) throws IOException {
        System.err.println(string);
        MessageFormat messageFormat = new MessageFormat(rb.getString("  [defaultValue]:  "));
        Object[] objectArray = new Object[]{string2};
        System.err.print(messageFormat.format(objectArray));
        System.err.flush();
        String string3 = bufferedReader.readLine();
        if (string3 == null || collator.compare(string3, "") == 0) {
            string3 = string2;
        }
        return string3;
    }

    private void dumpCert(Certificate certificate, PrintStream printStream) throws IOException, CertificateException {
        if (this.rfc) {
            BASE64Encoder bASE64Encoder = new BASE64Encoder();
            printStream.println("-----BEGIN CERTIFICATE-----");
            bASE64Encoder.encodeBuffer(certificate.getEncoded(), (OutputStream)printStream);
            printStream.println("-----END CERTIFICATE-----");
        } else {
            printStream.write(certificate.getEncoded());
        }
    }

    private void byte2hex(byte by, StringBuffer stringBuffer) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int n2 = (by & 0xF0) >> 4;
        int n3 = by & 0xF;
        stringBuffer.append(cArray[n2]);
        stringBuffer.append(cArray[n3]);
    }

    private String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = byArray.length;
        int n3 = 0;
        while (n3 < n2) {
            this.byte2hex(byArray[n3], stringBuffer);
            if (n3 < n2 - 1) {
                stringBuffer.append(":");
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    private Object[] recoverPrivateKey(String string, char[] cArray, char[] cArray2) throws Exception {
        Key key = null;
        if (!this.keyStore.containsAlias(string)) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Alias <alias> does not exist"));
            Object[] objectArray = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray));
        }
        if (!this.keyStore.isKeyEntry(string)) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Alias <alias> has no (private) key"));
            Object[] objectArray = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray));
        }
        if (cArray2 == null) {
            try {
                key = this.keyStore.getKey(string, cArray);
                cArray2 = cArray;
            }
            catch (UnrecoverableKeyException unrecoverableKeyException) {
                cArray2 = this.getKeyPasswd(string, null, null);
                key = this.keyStore.getKey(string, cArray2);
            }
        } else {
            key = this.keyStore.getKey(string, cArray2);
        }
        if (!(key instanceof PrivateKey)) {
            throw new Exception(rb.getString("Recovered key is not a private key"));
        }
        return new Object[]{(PrivateKey)key, cArray2};
    }

    private String getCertFingerPrint(String string, Certificate certificate) throws Exception {
        byte[] byArray = certificate.getEncoded();
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        byte[] byArray2 = messageDigest.digest(byArray);
        return this.toHexString(byArray2);
    }

    private void printWarning() {
        System.err.println();
        System.err.println(rb.getString("*****************  WARNING WARNING WARNING  *****************"));
        System.err.println(rb.getString("* The integrity of the information stored in your keystore  *"));
        System.err.println(rb.getString("* has NOT been verified!  In order to verify its integrity, *"));
        System.err.println(rb.getString("* you must provide your keystore password.                  *"));
        System.err.println(rb.getString("*****************  WARNING WARNING WARNING  *****************"));
        System.err.println();
    }

    private Certificate[] validateReply(String string, Certificate certificate, Certificate[] certificateArray) throws Exception {
        PublicKey publicKey = certificate.getPublicKey();
        int n2 = 0;
        while (n2 < certificateArray.length) {
            if (publicKey.equals(certificateArray[n2].getPublicKey())) break;
            ++n2;
        }
        if (n2 == certificateArray.length) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Certificate reply does not contain public key for <alias>"));
            Object[] objectArray = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray));
        }
        Certificate certificate2 = certificateArray[0];
        certificateArray[0] = certificateArray[n2];
        certificateArray[n2] = certificate2;
        Principal principal = ((X509Certificate)certificateArray[0]).getIssuerDN();
        n2 = 1;
        while (n2 < certificateArray.length - 1) {
            int n3 = n2;
            while (n3 < certificateArray.length) {
                Principal principal2 = ((X509Certificate)certificateArray[n3]).getSubjectDN();
                if (principal2.equals(principal)) {
                    certificate2 = certificateArray[n2];
                    certificateArray[n2] = certificateArray[n3];
                    certificateArray[n3] = certificate2;
                    principal = ((X509Certificate)certificateArray[n2]).getIssuerDN();
                    break;
                }
                ++n3;
            }
            if (n3 == certificateArray.length) {
                throw new Exception(rb.getString("Incomplete certificate chain in reply"));
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < certificateArray.length - 1) {
            PublicKey publicKey2 = certificateArray[n2 + 1].getPublicKey();
            try {
                certificateArray[n2].verify(publicKey2);
            }
            catch (Exception exception) {
                throw new Exception(rb.getString("Certificate chain in reply does not verify: ") + exception.getMessage());
            }
            ++n2;
        }
        if (this.noprompt) {
            return certificateArray;
        }
        Certificate certificate3 = certificateArray[certificateArray.length - 1];
        if (!this.isTrusted(certificate3)) {
            Object object;
            boolean bl2 = false;
            Certificate certificate4 = null;
            if (this.trustcacerts && this.caks != null) {
                object = this.caks.aliases();
                while (object.hasMoreElements()) {
                    String string2 = (String)object.nextElement();
                    certificate4 = this.caks.getCertificate(string2);
                    if (certificate4 == null) continue;
                    try {
                        certificate3.verify(certificate4.getPublicKey());
                        bl2 = true;
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (!bl2) {
                System.err.println();
                System.err.println(rb.getString("Top-level certificate in reply:\n"));
                this.printX509Cert((X509Certificate)certificate3, System.out);
                System.err.println();
                System.err.print(rb.getString("... is not trusted. "));
                object = this.getYesNoReply(rb.getString("Install reply anyway? [no]:  "));
                if (((String)object).equals("NO")) {
                    return null;
                }
            } else if (!this.isSelfSigned((X509Certificate)certificate3)) {
                object = new Certificate[certificateArray.length + 1];
                System.arraycopy(certificateArray, 0, object, 0, certificateArray.length);
                object[((Certificate[])object).length - 1] = certificate4;
                certificateArray = object;
            }
        }
        return certificateArray;
    }

    private Certificate[] establishCertChain(Certificate certificate, Certificate certificate2) throws Exception {
        Serializable serializable;
        Serializable serializable2;
        if (certificate != null) {
            serializable2 = certificate.getPublicKey();
            if (!serializable2.equals(serializable = certificate2.getPublicKey())) {
                throw new Exception(rb.getString("Public keys in reply and keystore don't match"));
            }
            if (certificate2.equals(certificate)) {
                throw new Exception(rb.getString("Certificate reply and certificate in keystore are identical"));
            }
        }
        serializable2 = null;
        if (this.keyStore.size() > 0) {
            serializable2 = new Hashtable(11);
            this.keystorecerts2Hashtable(this.keyStore, (Hashtable)serializable2);
        }
        if (this.trustcacerts && this.caks != null && this.caks.size() > 0) {
            if (serializable2 == null) {
                serializable2 = new Hashtable(11);
            }
            this.keystorecerts2Hashtable(this.caks, (Hashtable)serializable2);
        }
        if (this.buildChain((X509Certificate)certificate2, (Vector)(serializable = new Vector(2)), (Hashtable)serializable2)) {
            Certificate[] certificateArray = new Certificate[((Vector)serializable).size()];
            int n2 = 0;
            int n3 = ((Vector)serializable).size() - 1;
            while (n3 >= 0) {
                certificateArray[n2] = (Certificate)((Vector)serializable).elementAt(n3);
                ++n2;
                --n3;
            }
            return certificateArray;
        }
        throw new Exception(rb.getString("Failed to establish chain from reply"));
    }

    private boolean buildChain(X509Certificate x509Certificate, Vector vector, Hashtable hashtable) {
        Principal principal;
        Principal principal2 = x509Certificate.getSubjectDN();
        if (principal2.equals(principal = x509Certificate.getIssuerDN())) {
            vector.addElement(x509Certificate);
            return true;
        }
        Vector vector2 = (Vector)hashtable.get(principal);
        if (vector2 == null) {
            return false;
        }
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            X509Certificate x509Certificate2 = (X509Certificate)enumeration.nextElement();
            PublicKey publicKey = x509Certificate2.getPublicKey();
            try {
                x509Certificate.verify(publicKey);
            }
            catch (Exception exception) {
                continue;
            }
            if (!this.buildChain(x509Certificate2, vector, hashtable)) continue;
            vector.addElement(x509Certificate);
            return true;
        }
        return false;
    }

    private String getYesNoReply(String string) throws IOException {
        String string2 = null;
        do {
            System.err.print(string);
            System.err.flush();
            string2 = new BufferedReader(new InputStreamReader(System.in)).readLine();
            if (collator.compare(string2, "") == 0 || collator.compare(string2, rb.getString("n")) == 0 || collator.compare(string2, rb.getString("no")) == 0) {
                string2 = "NO";
                continue;
            }
            if (collator.compare(string2, rb.getString("y")) == 0 || collator.compare(string2, rb.getString("yes")) == 0) {
                string2 = "YES";
                continue;
            }
            System.err.println(rb.getString("Wrong answer, try again"));
            string2 = null;
        } while (string2 == null);
        return string2;
    }

    private KeyStore getCacertsKeyStore() throws Exception {
        String string = File.separator;
        File file = new File(System.getProperty("java.home") + string + "lib" + string + "security" + string + "cacerts");
        if (!file.exists()) {
            return null;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        KeyStore keyStore = KeyStore.getInstance("jks");
        keyStore.load(fileInputStream, null);
        fileInputStream.close();
        return keyStore;
    }

    private void keystorecerts2Hashtable(KeyStore keyStore, Hashtable hashtable) throws Exception {
        Enumeration enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Certificate certificate = keyStore.getCertificate(string);
            if (certificate == null) continue;
            Principal principal = ((X509Certificate)certificate).getSubjectDN();
            Vector vector = (Vector)hashtable.get(principal);
            if (vector == null) {
                vector = new Vector();
                vector.addElement(certificate);
            } else if (!vector.contains(certificate)) {
                vector.addElement(certificate);
            }
            hashtable.put(principal, vector);
        }
    }

    private void usage() {
        System.err.println(rb.getString("keytool usage:\n"));
        System.err.println(rb.getString("-certreq     [-v] [-alias <alias>] [-sigalg <sigalg>]"));
        System.err.println(rb.getString("\t     [-file <csr_file>] [-keypass <keypass>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-provider <provider_class_name>] ..."));
        System.err.println();
        System.err.println(rb.getString("-delete      [-v] -alias <alias>"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-provider <provider_class_name>] ..."));
        System.err.println();
        System.err.println(rb.getString("-export      [-v] [-rfc] [-alias <alias>] [-file <cert_file>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-provider <provider_class_name>] ..."));
        System.err.println();
        System.err.println(rb.getString("-genkey      [-v] [-alias <alias>] [-keyalg <keyalg>]"));
        System.err.println(rb.getString("\t     [-keysize <keysize>] [-sigalg <sigalg>]"));
        System.err.println(rb.getString("\t     [-dname <dname>] [-validity <valDays>]"));
        System.err.println(rb.getString("\t     [-keypass <keypass>] [-keystore <keystore>]"));
        System.err.println(rb.getString("\t     [-storepass <storepass>] [-storetype <storetype>]"));
        System.err.println(rb.getString("\t     [-provider <provider_class_name>] ..."));
        System.err.println();
        System.err.println(rb.getString("-help"));
        System.err.println();
        System.err.println(rb.getString("-identitydb  [-v] [-file <idb_file>] [-keystore <keystore>]"));
        System.err.println(rb.getString("\t     [-storepass <storepass>] [-storetype <storetype>]"));
        System.out.println(rb.getString("\t     [-provider <provider_class_name>] ..."));
        System.err.println();
        System.err.println(rb.getString("-import      [-v] [-noprompt] [-trustcacerts] [-alias <alias>]"));
        System.err.println(rb.getString("\t     [-file <cert_file>] [-keypass <keypass>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-provider <provider_class_name>] ..."));
        System.err.println();
        System.err.println(rb.getString("-keyclone    [-v] [-alias <alias>] -dest <dest_alias>"));
        System.err.println(rb.getString("\t     [-keypass <keypass>] [-new <new_keypass>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-provider <provider_class_name>] ..."));
        System.err.println();
        System.err.println(rb.getString("-keypasswd   [-v] [-alias <alias>]"));
        System.err.println(rb.getString("\t     [-keypass <old_keypass>] [-new <new_keypass>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-provider <provider_class_name>] ..."));
        System.err.println();
        System.err.println(rb.getString("-list        [-v | -rfc] [-alias <alias>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-provider <provider_class_name>] ..."));
        System.err.println();
        System.err.println(rb.getString("-printcert   [-v] [-file <cert_file>]"));
        System.err.println();
        System.err.println(rb.getString("-selfcert    [-v] [-alias <alias>] [-sigalg <sigalg>]"));
        System.err.println(rb.getString("\t     [-dname <dname>] [-validity <valDays>]"));
        System.err.println(rb.getString("\t     [-keypass <keypass>] [-keystore <keystore>]"));
        System.err.println(rb.getString("\t     [-storepass <storepass>] [-storetype <storetype>]"));
        System.err.println(rb.getString("\t     [-provider <provider_class_name>] ..."));
        System.err.println();
        System.err.println(rb.getString("-storepasswd [-v] [-new <new_storepass>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-provider <provider_class_name>] ..."));
        System.err.println();
        System.exit(1);
    }

    static {
        collator.setStrength(0);
    }
}

