/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc.ee;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.sql.ConnectionEvent;
import sun.jdbc.odbc.JdbcOdbcDriver;
import sun.jdbc.odbc.JdbcOdbcTracer;
import sun.jdbc.odbc.ee.ConnectionEventListener;
import sun.jdbc.odbc.ee.ConnectionHandler;
import sun.jdbc.odbc.ee.PooledObject;

public class PooledConnection
implements javax.sql.PooledConnection,
PooledObject {
    private String strUserId = null;
    private String strPassword = null;
    private String strUrl = null;
    private String strCharset;
    private int timeout;
    private Properties pr = null;
    private ConnectionHandler conHandler;
    private boolean isAvailableForUse = true;
    private Hashtable htListener;
    private long time = 0L;
    private JdbcOdbcTracer tracer = new JdbcOdbcTracer();
    private JdbcOdbcDriver driver = null;
    private int state;
    private ConnectionEventListener listener;

    public PooledConnection(Properties properties, JdbcOdbcTracer jdbcOdbcTracer) throws SQLException {
        try {
            this.tracer = jdbcOdbcTracer;
            this.strUserId = (String)properties.get("user");
            this.strPassword = (String)properties.get("password");
            this.strUrl = (String)properties.get("url");
            this.strCharset = (String)properties.get("charset");
            this.timeout = Integer.parseInt((String)properties.get("loginTimeout"));
            this.pr = properties;
            this.time = System.currentTimeMillis();
            this.htListener = new Hashtable();
            this.driver = new JdbcOdbcDriver();
            this.driver.setTimeOut(this.timeout);
            this.driver.setWriter(jdbcOdbcTracer.getWriter());
            jdbcOdbcTracer.trace(" PooledConnection Being created ...." + this.strUserId + ":" + this.strPassword + ":" + this.strUrl + ":" + this.driver);
            this.conHandler = (ConnectionHandler)this.driver.EEConnect(this.strUrl, properties);
            this.conHandler.setPooledObject(this);
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw new SQLException("Error in creating pooled connection" + exception.getMessage());
        }
    }

    public boolean isMatching(Properties properties) {
        return this.pr.equals(properties);
    }

    public boolean isUsable() {
        return this.isAvailableForUse;
    }

    public void markForSweep() {
        this.state = 3;
    }

    public boolean isMarkedForSweep() {
        return this.state == 3;
    }

    public void markUsable() {
        this.isAvailableForUse = true;
    }

    public long getCreatedTime() {
        return this.time;
    }

    public void addConnectionEventListener(javax.sql.ConnectionEventListener connectionEventListener) {
        this.htListener.put(connectionEventListener, "");
        if (connectionEventListener instanceof ConnectionEventListener) {
            this.listener = (ConnectionEventListener)connectionEventListener;
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.conHandler.getState() != this.conHandler.CLOSED && this.conHandler.getState() != this.conHandler.NOTOPEN) {
            throw new SQLException("Connection is not available now!");
        }
        if (this.state == 3) {
            throw new SQLException("PooledConnection is not usable");
        }
        if (this.state == 1) {
            this.listener.connectionCheckOut(new ConnectionEvent(this));
        }
        this.isAvailableForUse = false;
        this.conHandler.setState(this.conHandler.OPEN);
        return this.conHandler;
    }

    public void removeConnectionEventListener(javax.sql.ConnectionEventListener connectionEventListener) {
        this.htListener.remove(connectionEventListener);
    }

    public void close() throws SQLException {
        try {
            this.isAvailableForUse = false;
            this.state = 3;
            this.conHandler.actualClose();
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw new SQLException("Unexpected Exception : " + exception.getMessage());
        }
    }

    public void destroy() {
        try {
            this.isAvailableForUse = false;
            this.state = 3;
            this.conHandler.destroy();
        }
        catch (Exception exception) {}
    }

    public void connectionClosed() {
        Enumeration enumeration = this.htListener.keys();
        while (enumeration.hasMoreElements()) {
            javax.sql.ConnectionEventListener connectionEventListener = (javax.sql.ConnectionEventListener)enumeration.nextElement();
            ConnectionEvent connectionEvent = new ConnectionEvent(this);
            connectionEventListener.connectionClosed(connectionEvent);
        }
    }

    public void connectionErrorOccurred(SQLException sQLException) {
        Enumeration enumeration = this.htListener.keys();
        while (enumeration.hasMoreElements()) {
            javax.sql.ConnectionEventListener connectionEventListener = (javax.sql.ConnectionEventListener)enumeration.nextElement();
            ConnectionEvent connectionEvent = new ConnectionEvent(this, sQLException);
            connectionEventListener.connectionErrorOccurred(connectionEvent);
        }
    }

    public void checkedOut() {
        if (this.state != 3) {
            this.state = 2;
        }
    }

    public void checkedIn() {
        if (this.state != 3) {
            this.state = 1;
        }
    }
}

