/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.CellRendererPane;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalUtils;

public class MetalComboBoxButton
extends JButton {
    protected JComboBox comboBox;
    protected JList listBox;
    protected CellRendererPane rendererPane;
    protected Icon comboIcon;
    protected boolean iconOnly = false;

    public final JComboBox getComboBox() {
        return this.comboBox;
    }

    public final void setComboBox(JComboBox jComboBox) {
        this.comboBox = jComboBox;
    }

    public final Icon getComboIcon() {
        return this.comboIcon;
    }

    public final void setComboIcon(Icon icon) {
        this.comboIcon = icon;
    }

    public final boolean isIconOnly() {
        return this.iconOnly;
    }

    public final void setIconOnly(boolean bl2) {
        this.iconOnly = bl2;
    }

    MetalComboBoxButton() {
        super("");
        DefaultButtonModel defaultButtonModel = new DefaultButtonModel(){

            public void setArmed(boolean bl2) {
                super.setArmed(this.isPressed() ? true : bl2);
            }
        };
        this.setModel(defaultButtonModel);
    }

    public MetalComboBoxButton(JComboBox jComboBox, Icon icon, CellRendererPane cellRendererPane, JList jList) {
        this();
        this.comboBox = jComboBox;
        this.comboIcon = icon;
        this.rendererPane = cellRendererPane;
        this.listBox = jList;
        this.setEnabled(this.comboBox.isEnabled());
    }

    public MetalComboBoxButton(JComboBox jComboBox, Icon icon, boolean bl2, CellRendererPane cellRendererPane, JList jList) {
        this(jComboBox, icon, cellRendererPane, jList);
        this.iconOnly = bl2;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void setEnabled(boolean bl2) {
        super.setEnabled(bl2);
        if (bl2) {
            this.setBackground(this.comboBox.getBackground());
            this.setForeground(this.comboBox.getForeground());
        } else {
            this.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
            this.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
        }
    }

    public void paintComponent(Graphics graphics) {
        int n2;
        boolean bl2 = MetalUtils.isLeftToRight(this.comboBox);
        super.paintComponent(graphics);
        Insets insets = this.getInsets();
        int n3 = this.getWidth() - (insets.left + insets.right);
        int n4 = this.getHeight() - (insets.top + insets.bottom);
        if (n4 <= 0 || n3 <= 0) {
            return;
        }
        int n5 = insets.left;
        int n6 = insets.top;
        int n7 = n5 + (n3 - 1);
        int n8 = n6 + (n4 - 1);
        int n9 = 0;
        int n10 = n2 = bl2 ? n7 : n5;
        if (this.comboIcon != null) {
            n9 = this.comboIcon.getIconWidth();
            int n11 = this.comboIcon.getIconHeight();
            int n12 = 0;
            if (this.iconOnly) {
                n2 = this.getWidth() / 2 - n9 / 2;
                n12 = this.getHeight() / 2 - n11 / 2;
            } else {
                n2 = bl2 ? n5 + (n3 - 1) - n9 : n5;
                n12 = n6 + (n8 - n6) / 2 - n11 / 2;
            }
            this.comboIcon.paintIcon(this, graphics, n2, n12);
            if (this.comboBox.hasFocus()) {
                graphics.setColor(MetalLookAndFeel.getFocusColor());
                graphics.drawRect(n5 - 1, n6 - 1, n3 + 3, n4 + 1);
            }
        }
        if (!this.iconOnly && this.comboBox != null) {
            ListCellRenderer listCellRenderer = this.comboBox.getRenderer();
            boolean bl3 = this.getModel().isPressed();
            Component component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, bl3, false);
            component.setFont(this.rendererPane.getFont());
            if (this.model.isArmed() && this.model.isPressed()) {
                if (this.isOpaque()) {
                    component.setBackground(UIManager.getColor("Button.select"));
                }
                component.setForeground(this.comboBox.getForeground());
            } else if (!this.comboBox.isEnabled()) {
                if (this.isOpaque()) {
                    component.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
                }
                component.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
            } else {
                component.setForeground(this.comboBox.getForeground());
                component.setBackground(this.comboBox.getBackground());
            }
            int n13 = n3 - (insets.right + n9);
            boolean bl4 = false;
            if (component instanceof JPanel) {
                bl4 = true;
            }
            if (bl2) {
                this.rendererPane.paintComponent(graphics, component, this, n5, n6, n13, n4, bl4);
            } else {
                this.rendererPane.paintComponent(graphics, component, this, n5 + n9, n6, n13, n4, bl4);
            }
        }
    }
}

