/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.colorchooser.RecentSwatchPanel;

class SwatchPanel
extends JPanel {
    protected Color[] colors;
    protected Dimension swatchSize;
    protected Dimension numSwatches;
    protected Dimension gap;

    public SwatchPanel() {
        this.initValues();
        this.initColors();
        this.setToolTipText("");
        this.setOpaque(true);
        this.setBackground(Color.white);
        this.setRequestFocusEnabled(false);
    }

    public boolean isFocusTraversable() {
        return false;
    }

    protected void initValues() {
    }

    public void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        int n2 = 0;
        while (n2 < this.numSwatches.height) {
            int n3 = 0;
            while (n3 < this.numSwatches.width) {
                graphics.setColor(this.getColorForCell(n3, n2));
                int n4 = !this.getComponentOrientation().isLeftToRight() && this instanceof RecentSwatchPanel ? (this.numSwatches.width - n3 - 1) * (this.swatchSize.width + this.gap.width) : n3 * (this.swatchSize.width + this.gap.width);
                int n5 = n2 * (this.swatchSize.height + this.gap.height);
                graphics.fillRect(n4, n5, this.swatchSize.width, this.swatchSize.height);
                graphics.setColor(Color.black);
                graphics.drawLine(n4 + this.swatchSize.width - 1, n5, n4 + this.swatchSize.width - 1, n5 + this.swatchSize.height - 1);
                graphics.drawLine(n4, n5 + this.swatchSize.height - 1, n4 + this.swatchSize.width - 1, n5 + this.swatchSize.height - 1);
                ++n3;
            }
            ++n2;
        }
    }

    public Dimension getPreferredSize() {
        int n2 = this.numSwatches.width * (this.swatchSize.width + this.gap.width) - 1;
        int n3 = this.numSwatches.height * (this.swatchSize.height + this.gap.height) - 1;
        return new Dimension(n2, n3);
    }

    protected void initColors() {
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        Color color = this.getColorForLocation(mouseEvent.getX(), mouseEvent.getY());
        return color.getRed() + ", " + color.getGreen() + ", " + color.getBlue();
    }

    public Color getColorForLocation(int n2, int n3) {
        int n4 = !this.getComponentOrientation().isLeftToRight() && this instanceof RecentSwatchPanel ? this.numSwatches.width - n2 / (this.swatchSize.width + this.gap.width) - 1 : n2 / (this.swatchSize.width + this.gap.width);
        int n5 = n3 / (this.swatchSize.height + this.gap.height);
        return this.getColorForCell(n4, n5);
    }

    private Color getColorForCell(int n2, int n3) {
        return this.colors[n3 * this.numSwatches.width + n2];
    }
}

