/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import sun.security.action.LoadLibraryAction;

public final class NetworkInterface {
    private String name;
    private String displayName;
    private int index;
    private InetAddress[] addrs;

    NetworkInterface() {
    }

    NetworkInterface(String string, int n2, InetAddress[] inetAddressArray) {
        this.name = string;
        this.index = n2;
        this.addrs = inetAddressArray;
    }

    public String getName() {
        return this.name;
    }

    public Enumeration getInetAddresses() {
        class CheckedAddresses
        implements Enumeration {
            private int i;
            private int count;
            private Object[] local_addrs;
            private final /* synthetic */ NetworkInterface this$0;

            CheckedAddresses(NetworkInterface networkInterface) {
                this.this$0 = networkInterface;
                this.i = 0;
                this.count = 0;
                this.local_addrs = new Object[NetworkInterface.access$000(networkInterface).length];
                SecurityManager securityManager = System.getSecurityManager();
                int n2 = 0;
                while (n2 < NetworkInterface.access$000(networkInterface).length) {
                    try {
                        if (securityManager != null) {
                            securityManager.checkConnect(NetworkInterface.access$000(networkInterface)[n2].getHostAddress(), -1);
                        }
                        this.local_addrs[this.count++] = NetworkInterface.access$000(networkInterface)[n2];
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    ++n2;
                }
            }

            public Object nextElement() {
                if (this.i < this.count) {
                    return this.local_addrs[this.i++];
                }
                throw new NoSuchElementException();
            }

            public boolean hasMoreElements() {
                return this.i < this.count;
            }
        }
        return new CheckedAddresses(this);
    }

    int getIndex() {
        return this.index;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static NetworkInterface getByName(String string) throws SocketException {
        if (string == null) {
            throw new NullPointerException();
        }
        return NetworkInterface.getByName0(string);
    }

    static native NetworkInterface getByIndex(int var0) throws SocketException;

    public static NetworkInterface getByInetAddress(InetAddress inetAddress) throws SocketException {
        if (inetAddress == null) {
            throw new NullPointerException();
        }
        return NetworkInterface.getByInetAddress0(inetAddress);
    }

    public static Enumeration getNetworkInterfaces() throws SocketException {
        final NetworkInterface[] networkInterfaceArray = NetworkInterface.getAll();
        if (networkInterfaceArray == null) {
            return null;
        }
        return new Enumeration(){
            private int i = 0;

            public Object nextElement() {
                if (networkInterfaceArray != null && this.i < networkInterfaceArray.length) {
                    NetworkInterface networkInterface = networkInterfaceArray[this.i++];
                    return networkInterface;
                }
                throw new NoSuchElementException();
            }

            public boolean hasMoreElements() {
                return networkInterfaceArray != null && this.i < networkInterfaceArray.length;
            }
        };
    }

    private static native NetworkInterface[] getAll() throws SocketException;

    private static native NetworkInterface getByName0(String var0) throws SocketException;

    private static native NetworkInterface getByInetAddress0(InetAddress var0) throws SocketException;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        Enumeration enumeration;
        int n2;
        if (object == null || !(object instanceof NetworkInterface)) {
            return false;
        }
        NetworkInterface networkInterface = (NetworkInterface)object;
        if (this.name != null) {
            if (networkInterface.getName() == null) return false;
            if (!this.name.equals(networkInterface.getName())) {
                return false;
            }
        } else if (networkInterface.getName() != null) {
            return false;
        }
        Enumeration enumeration2 = networkInterface.getInetAddresses();
        int n3 = 0;
        n3 = 0;
        while (enumeration2.hasMoreElements()) {
            enumeration2.nextElement();
            ++n3;
        }
        if (this.addrs == null) {
            if (n3 != 0) {
                return false;
            }
        } else {
            n2 = 0;
            enumeration = this.getInetAddresses();
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement();
                ++n2;
            }
            if (n3 != n2) {
                return false;
            }
        }
        enumeration2 = networkInterface.getInetAddresses();
        while (enumeration2.hasMoreElements()) {
            n2 = 0;
            enumeration = this.getInetAddresses();
            InetAddress inetAddress = (InetAddress)enumeration2.nextElement();
            while (enumeration.hasMoreElements()) {
                InetAddress inetAddress2 = (InetAddress)enumeration.nextElement();
                if (!inetAddress2.equals(inetAddress)) continue;
                n2 = 1;
            }
            if (n2 != 0) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n2 = 0;
        if (this.addrs != null) {
            int n3 = 0;
            while (n3 < this.addrs.length) {
                n2 += this.addrs[n3].hashCode();
                ++n3;
            }
        }
        return n2;
    }

    public String toString() {
        String string = "name:";
        string = string + (this.name == null ? "null" : this.name);
        if (this.displayName != null) {
            string = string + " (" + this.displayName + ")";
        }
        string = string + " index: " + this.index + " addresses:\n";
        Enumeration enumeration = this.getInetAddresses();
        while (enumeration.hasMoreElements()) {
            InetAddress inetAddress = (InetAddress)enumeration.nextElement();
            string = string + inetAddress + ";\n";
        }
        return string;
    }

    private static native void init();

    static /* synthetic */ InetAddress[] access$000(NetworkInterface networkInterface) {
        return networkInterface.addrs;
    }

    static {
        AccessController.doPrivileged(new LoadLibraryAction("net"));
        NetworkInterface.init();
    }
}

