/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.awt.DebugHelper;
import sun.awt.dnd.SunDropTargetEvent;

class LightweightDispatcher
implements Serializable,
AWTEventListener {
    private static final long serialVersionUID = 5184291520170872969L;
    private static final int LWD_MOUSE_DRAGGED_OVER = 1500;
    private static final DebugHelper dbg = DebugHelper.create(class$java$awt$LightweightDispatcher == null ? (class$java$awt$LightweightDispatcher = LightweightDispatcher.class$("java.awt.LightweightDispatcher")) : class$java$awt$LightweightDispatcher);
    private Container nativeContainer;
    private Component focus;
    private transient Component mouseEventTarget;
    private transient Component targetLastEntered;
    private transient boolean isMouseInNativeContainer = false;
    private Cursor nativeCursor;
    private long eventMask;
    private static final long PROXY_EVENT_MASK = 131132L;
    private static final long MOUSE_MASK = 131120L;
    static /* synthetic */ Class class$java$awt$LightweightDispatcher;

    LightweightDispatcher(Container container) {
        this.nativeContainer = container;
        this.mouseEventTarget = null;
        this.eventMask = 0L;
    }

    void dispose() {
        this.stopListeningForOtherDrags();
    }

    void enableEvents(long l2) {
        this.eventMask |= l2;
    }

    boolean dispatchEvent(AWTEvent aWTEvent) {
        boolean bl2 = false;
        if (aWTEvent instanceof SunDropTargetEvent) {
            SunDropTargetEvent sunDropTargetEvent = (SunDropTargetEvent)aWTEvent;
            bl2 = this.processDropTargetEvent(sunDropTargetEvent);
        } else {
            if (aWTEvent instanceof MouseEvent && (this.eventMask & 0x20030L) != 0L) {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                bl2 = this.processMouseEvent(mouseEvent);
            }
            if (aWTEvent.getID() == 503) {
                this.nativeContainer.updateCursorImmediately();
            }
        }
        return bl2;
    }

    private boolean isMouseGrab(MouseEvent mouseEvent) {
        int n2 = mouseEvent.getModifiersEx();
        if (mouseEvent.getID() == 501 || mouseEvent.getID() == 502) {
            switch (mouseEvent.getButton()) {
                case 1: {
                    n2 ^= 0x400;
                    break;
                }
                case 2: {
                    n2 ^= 0x800;
                    break;
                }
                case 3: {
                    n2 ^= 0x1000;
                }
            }
        }
        return (n2 & 0x1C00) != 0;
    }

    private boolean processMouseEvent(MouseEvent mouseEvent) {
        int n2 = mouseEvent.getID();
        Component component = this.nativeContainer.getMouseEventTarget(mouseEvent.getX(), mouseEvent.getY(), true);
        this.trackMouseEnterExit(component, mouseEvent);
        if (!this.isMouseGrab(mouseEvent) && n2 != 500) {
            Component component2 = this.mouseEventTarget = component != this.nativeContainer ? component : null;
        }
        if (this.mouseEventTarget != null) {
            switch (n2) {
                case 504: 
                case 505: {
                    break;
                }
                case 501: {
                    this.retargetMouseEvent(this.mouseEventTarget, n2, mouseEvent);
                    break;
                }
                case 502: {
                    this.retargetMouseEvent(this.mouseEventTarget, n2, mouseEvent);
                    break;
                }
                case 500: {
                    if (component != this.mouseEventTarget) break;
                    this.retargetMouseEvent(component, n2, mouseEvent);
                    break;
                }
                case 503: {
                    this.retargetMouseEvent(this.mouseEventTarget, n2, mouseEvent);
                    break;
                }
                case 506: {
                    if (!this.isMouseGrab(mouseEvent)) break;
                    this.retargetMouseEvent(this.mouseEventTarget, n2, mouseEvent);
                    break;
                }
                case 507: {
                    this.retargetMouseEvent(component, n2, mouseEvent);
                }
            }
            mouseEvent.consume();
        }
        return mouseEvent.isConsumed();
    }

    private boolean processDropTargetEvent(SunDropTargetEvent sunDropTargetEvent) {
        Serializable serializable;
        int n2;
        int n3 = sunDropTargetEvent.getID();
        int n4 = sunDropTargetEvent.getX();
        if (!this.nativeContainer.contains(n4, n2 = sunDropTargetEvent.getY())) {
            serializable = this.nativeContainer.getSize();
            if (serializable.width <= n4) {
                n4 = serializable.width - 1;
            } else if (n4 < 0) {
                n4 = 0;
            }
            if (serializable.height <= n2) {
                n2 = serializable.height - 1;
            } else if (n2 < 0) {
                n2 = 0;
            }
        }
        serializable = this.nativeContainer.getDropTargetEventTarget(n4, n2, true);
        this.trackMouseEnterExit((Component)serializable, sunDropTargetEvent);
        if (serializable != this.nativeContainer && serializable != null) {
            switch (n3) {
                case 504: 
                case 505: {
                    break;
                }
                default: {
                    this.retargetMouseEvent((Component)serializable, n3, sunDropTargetEvent);
                    sunDropTargetEvent.consume();
                }
            }
        }
        return sunDropTargetEvent.isConsumed();
    }

    private void trackMouseEnterExit(Component component, MouseEvent mouseEvent) {
        Component component2 = null;
        int n2 = mouseEvent.getID();
        if (mouseEvent instanceof SunDropTargetEvent && n2 == 504 && this.isMouseInNativeContainer) {
            this.targetLastEntered = null;
        } else if (n2 != 505 && n2 != 506 && n2 != 1500 && !this.isMouseInNativeContainer) {
            this.isMouseInNativeContainer = true;
            this.startListeningForOtherDrags();
        } else if (n2 == 505) {
            this.isMouseInNativeContainer = false;
            this.stopListeningForOtherDrags();
        }
        if (this.isMouseInNativeContainer) {
            component2 = component;
        }
        if (this.targetLastEntered == component2) {
            return;
        }
        if (this.targetLastEntered != null) {
            this.retargetMouseEvent(this.targetLastEntered, 505, mouseEvent);
        }
        if (n2 == 505) {
            mouseEvent.consume();
        }
        if (component2 != null) {
            this.retargetMouseEvent(component2, 504, mouseEvent);
        }
        if (n2 == 504) {
            mouseEvent.consume();
        }
        this.targetLastEntered = component2;
    }

    private void startListeningForOtherDrags() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                LightweightDispatcher.this.nativeContainer.getToolkit().addAWTEventListener(LightweightDispatcher.this, 48L);
                return null;
            }
        });
    }

    private void stopListeningForOtherDrags() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                LightweightDispatcher.this.nativeContainer.getToolkit().removeAWTEventListener(LightweightDispatcher.this);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventDispatched(AWTEvent aWTEvent) {
        MouseEvent mouseEvent;
        Component component;
        boolean bl2;
        boolean bl3 = bl2 = aWTEvent instanceof MouseEvent && !(aWTEvent instanceof SunDropTargetEvent) && aWTEvent.id == 506 && aWTEvent.getSource() != this.nativeContainer;
        if (!bl2) {
            return;
        }
        MouseEvent mouseEvent2 = (MouseEvent)aWTEvent;
        Object object = this.nativeContainer.getTreeLock();
        synchronized (object) {
            component = mouseEvent2.getComponent();
            if (!component.isShowing() || !this.nativeContainer.isShowing()) {
                return;
            }
            mouseEvent = new MouseEvent(this.nativeContainer, 1500, mouseEvent2.getWhen(), mouseEvent2.getModifiersEx() | mouseEvent2.getModifiers(), mouseEvent2.getX(), mouseEvent2.getY(), mouseEvent2.getClickCount(), mouseEvent2.isPopupTrigger(), mouseEvent2.getButton());
            mouseEvent2.copyPrivateDataInto(mouseEvent);
            Point point = component.getLocationOnScreen();
            Point point2 = this.nativeContainer.getLocationOnScreen();
            mouseEvent.translatePoint(point.x - point2.x, point.y - point2.y);
        }
        component = this.nativeContainer.getMouseEventTarget(mouseEvent.getX(), mouseEvent.getY(), true);
        this.trackMouseEnterExit(component, mouseEvent);
    }

    void retargetMouseEvent(Component component, int n2, MouseEvent mouseEvent) {
        if (component == null) {
            return;
        }
        int n3 = mouseEvent.getX();
        int n4 = mouseEvent.getY();
        Component component2 = component;
        while (component2 != null && component2 != this.nativeContainer) {
            n3 -= component2.x;
            n4 -= component2.y;
            component2 = component2.getParent();
        }
        if (component2 != null) {
            MouseEvent mouseEvent2 = mouseEvent instanceof SunDropTargetEvent ? new SunDropTargetEvent(component, n2, n3, n4, ((SunDropTargetEvent)mouseEvent).getDispatcher()) : (n2 == 507 ? new MouseWheelEvent(component, n2, mouseEvent.getWhen(), mouseEvent.getModifiersEx() | mouseEvent.getModifiers(), n3, n4, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), ((MouseWheelEvent)mouseEvent).getScrollType(), ((MouseWheelEvent)mouseEvent).getScrollAmount(), ((MouseWheelEvent)mouseEvent).getWheelRotation()) : new MouseEvent(component, n2, mouseEvent.getWhen(), mouseEvent.getModifiersEx() | mouseEvent.getModifiers(), n3, n4, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton()));
            mouseEvent.copyPrivateDataInto(mouseEvent2);
            if (component == this.nativeContainer) {
                ((Container)component).dispatchEventToSelf(mouseEvent2);
            } else {
                component.dispatchEvent(mouseEvent2);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

