#include <stdio.h>
#include "file2.h"
#include "internal.h"

#include <trace.h>
/***************************************************************************
 *
 * Function:     freopen
 *
 * Description:
 *     Close a stream and assign it to a new file.
 *
 * Input:
 *      filename   - File to be opened
 *      mode       - input mode string
 *      fpStream   - Pointer to the stream to be re-assigned.
 *
 * Output:
 *      A pointer to the file table or NULL to indicate an error.
 */

FILE *freopen (const char *filename, const char *mode, FILE *stream)
    {
    FUNC_ENTRY ("freopen");
/*
 *  Close the file if the file is currently open. If the file could not
 *  be closed then return the failure condition. (If this is a string file
 *  then the fclose operation will fail.)
 */
    if (inuse (stream) && fclose (stream) == -1)
        {
	stream = NULL;
        }
/*
 *  Indicate that the file is closed and re-open the file for the new name.
 */
    else
        {
	stream->_ptr  =
	stream->_base = NULL;
	stream->_cnt  =
	stream->_flag = 0;
	stream        = _openfile (filename, mode, stream);
        }
/*
 *  Return the resulting stream pointer or NULL for an error.
 */
    FUNC_EXIT ("freopen");
    return (stream);
    }
