/* This file is automatically generated by sql_to_c.awk */

#include "sqlnode.h"
#include "sqlfn.h"
#include "sqltype.h"

/* javavm_xml.sql */

static const char *proc0 = 
"create procedure jvm_ref_print (in xx any, inout ses any)\n"
"{\n"
"http (xx, ses);\n"
"}\n"
"--src javavm_xml.sql:23\n";

static const char *proc1 = 
"create procedure jvm_type_to_pl_type (in java_type varchar, in is_primitive int, in is_array int, inout escape_it integer) returns varchar\n"
"{\n"
"escape_it := 0;\n"
"java_type := cast (java_type as varchar);\n"
"if (is_array)\n"
"return \'any\';\n"
"if (is_primitive)\n"
"{\n"
"if (java_type = \'byte\') return \'smallint\';\n"
"if (java_type = \'char\') return \'smallint\';\n"
"if (java_type = \'double\') return \'double precision\';\n"
"if (java_type = \'float\') return \'real\';\n"
"if (java_type = \'int\') return \'integer\';\n"
"if (java_type = \'long\') return \'integer\';\n"
"if (java_type = \'short\') return \'smallint\';\n"
"if (java_type = \'boolean\') return \'smallint\';\n"
"if (java_type = \'void\') return \'any\';\n"
"}\n"
"else\n"
"{\n"
"if (java_type = \'java.lang.String\') return \'nvarchar\';\n"
"if (java_type = \'java.lang.Date\') return \'datetime\';\n"
"escape_it := 1;\n"
"return replace (cast (java_type as varchar), \'.\', \'_\');\n"
"}\n"
"}\n"
"--src javavm_xml.sql:29\n";

static const char *proc2 = 
"create procedure jvm_type_to_signature (in java_type varchar, in is_primitive int, in is_array int) returns varchar\n"
"{\n"
"java_type := cast (java_type as varchar);\n"
"if (is_array)\n"
"return replace (java_type, \'.\', \'/\');\n"
"if (java_type = \'void\') return \'V\';\n"
"if (is_primitive)\n"
"{\n"
"if (java_type = \'byte\') return \'B\';\n"
"if (java_type = \'char\') return \'C\';\n"
"if (java_type = \'double\') return \'D\';\n"
"if (java_type = \'float\') return \'F\';\n"
"if (java_type = \'int\') return \'I\';\n"
"if (java_type = \'long\') return \'J\';\n"
"if (java_type = \'short\') return \'S\';\n"
"if (java_type = \'boolean\') return \'B\';\n"
"}\n"
"else\n"
"return concat (\'L\', replace (cast (java_type as varchar), \'.\', \'/\'), \';\');\n"
"}\n"
"--src javavm_xml.sql:58\n";

static const char *proc3 = 
"create procedure jvm_type_to_schema_type (in java_type varchar, in is_primitive int, in is_array int) returns varchar\n"
"{\n"
"java_type := cast (java_type as varchar);\n"
"if (is_array)\n"
"return \'\';\n"
"if (is_primitive)\n"
"{\n"
"if (java_type = \'byte\') return \'http://www.w3.org/2001/XMLSchema:byte\';\n"
"if (java_type = \'char\') return \'http://www.w3.org/2001/XMLSchema:unsignedShort\';\n"
"if (java_type = \'double\') return \'http://www.w3.org/2001/XMLSchema:double\';\n"
"if (java_type = \'float\') return \'http://www.w3.org/2001/XMLSchema:float\';\n"
"if (java_type = \'int\') return \'http://www.w3.org/2001/XMLSchema:int\';\n"
"if (java_type = \'long\') return \'http://www.w3.org/2001/XMLSchema:long\';\n"
"if (java_type = \'short\') return \'http://www.w3.org/2001/XMLSchema:short\';\n"
"if (java_type = \'boolean\') return \'http://www.w3.org/2001/XMLSchema:boolelan\';\n"
"return \'\';\n"
"}\n"
"else\n"
"{\n"
"if (java_type = \'java.lang.String\') return \'http://www.w3.org/2001/XMLSchema:string\';\n"
"if (java_type = \'java.lang.Date\') return \'http://www.w3.org/2001/XMLSchema:timeInstant\';\n"
"return \'\';\n"
"}\n"
"}\n"
"--src javavm_xml.sql:80\n";

static const char *proc4 = 
"create procedure jvm_ref_describe_method (inout jvm_method any, inout ses any,\n"
"in method_type varchar,\n"
"in entity_name varchar,\n"
"inout under_class any)\n"
"{\n"
"declare method_name varchar;\n"
"declare overriding integer;\n"
"\n"
"overriding := 0;\n"
"\n"
"declare modifiers, static_mask, private_mask, protected_mask any;\n"
"modifiers := cast (java_call_method (method_type, jvm_method, \'getModifiers\', \'I\') as integer);\n"
"static_mask := cast (java_get_property (\'java.lang.reflect.Modifier\', NULL, \'STATIC\', \'I\') as integer);\n"
"private_mask := cast (java_get_property (\'java.lang.reflect.Modifier\', NULL, \'PRIVATE\', \'I\') as integer);\n"
"protected_mask := cast (java_get_property (\'java.lang.reflect.Modifier\', NULL, \'PROTECTED\', \'I\') as integer);\n"
"\n"
"if (bit_and (modifiers, private_mask)	> 0 or bit_and (modifiers, protected_mask) > 0)\n"
"return;\n"
"\n"
"method_name := java_call_method (method_type, jvm_method, \'getName\', \'Ljava/lang/String;\');\n"
"if (under_class is not null)\n"
"{\n"
"declare method_params any;\n"
"method_params := java_call_method (method_type, jvm_method, \'getParameterTypes\', \'[Ljava/lang/Class;\');\n"
"{\n"
"declare exit handler for sqlstate \'*\';\n"
"java_call_method (\'java.lang.Class\', under_class, \'getMethod\', \'Ljava/lang/reflect/Method;\',\n"
"method_name, vector (\'[Ljava/lang/Class;\', method_params));\n"
"overriding := 1;\n"
"}\n"
"}\n"
"\n"
"if (entity_name = \'method\')\n"
"{\n"
"jvm_ref_print (sprintf (\'\\n<%s name=\"%s\" static=\"%d\" overriding=\"%d\">\',\n"
"entity_name, method_name,\n"
"bit_and (modifiers, static_mask) / static_mask, overriding\n"
"), ses);\n"
"}\n"
"else\n"
"jvm_ref_print (sprintf (\'\\n<%s>\', entity_name), ses);\n"
"\n"
"\n"
"declare return_type, is_primitive, is_array any;\n"
"if (entity_name = \'method\')\n"
"{\n"
"declare return_type_cls, plescape any;\n"
"return_type_cls := java_call_method (method_type, jvm_method, \'getReturnType\', \'Ljava/lang/Class;\');\n"
"return_type := java_call_method (\'java.lang.Class\', return_type_cls, \'getName\', \'Ljava/lang/String;\');\n"
"is_primitive := java_call_method (\'java.lang.Class\', return_type_cls, \'isPrimitive\', \'Z\');\n"
"is_array := java_call_method (\'java.lang.Class\', return_type_cls, \'isArray\', \'Z\');\n"
"return_type_cls := null;\n"
"jvm_ref_print (sprintf (\'\\n<returnType type=\"%s\" is_primitive=\"%d\" is_array=\"%d\" pltype=\"%s\" signature=\"%s\" soaptype=\"%s\" plescape=\"%d\"/>\',\n"
"return_type, is_primitive, is_array,\n"
"jvm_type_to_pl_type (return_type, is_primitive, is_array, plescape),\n"
"jvm_type_to_signature (return_type, is_primitive, is_array),\n"
"jvm_type_to_schema_type (return_type, is_primitive, is_array),\n"
"plescape\n"
"), ses);\n"
"}\n"
"else\n"
"{\n"
"return_type := \'void\';\n"
"}\n"
"\n"
"\n"
"declare param_types any;\n"
"declare param_inx integer;\n"
"param_types := java_call_method (method_type, jvm_method, \'getParameterTypes\', \'[Ljava/lang/Class;\');\n"
"param_inx := 0;\n"
"jvm_ref_print (\'\\n<parameters>\', ses);\n"
"while (param_inx < length (param_types))\n"
"{\n"
"declare param_type, ref_type,plescape any;\n"
"declare param_type_obj any;\n"
"\n"
"param_type_obj := param_types[param_inx];\n"
"param_type := java_call_method (\'java.lang.Class\', param_type_obj, \'getName\', \'Ljava/lang/String;\');\n"
"is_primitive := java_call_method (\'java.lang.Class\', param_type_obj, \'isPrimitive\', \'Z\');\n"
"is_array := java_call_method (\'java.lang.Class\', param_type_obj, \'isArray\', \'Z\');\n"
"if (is_primitive = 1 and is_array = 0)\n"
"ref_type := \'in\';\n"
"else\n"
"ref_type := \'inout\';\n"
"jvm_ref_print (\n"
"sprintf (\n"
"\'\\n<param name=\"p%d\" type=\"%s\" is_primitive=\"%d\" is_array=\"%d\" pltype=\"%s\" signature=\"%s\" soaptype=\"%s\" reftype=\"%s\" plescape=\"%d\"/>\',\n"
"param_inx + 1, param_type, is_primitive, is_array,\n"
"jvm_type_to_pl_type (param_type, is_primitive, is_array, plescape),\n"
"jvm_type_to_signature (param_type, is_primitive, is_array),\n"
"jvm_type_to_schema_type (param_type, is_primitive, is_array),\n"
"ref_type,\n"
"plescape\n"
"), ses);\n"
"param_inx := param_inx + 1;\n"
"param_type_obj := null;\n"
"}\n"
"param_types := null;\n"
"jvm_ref_print (\'\\n</parameters>\', ses);\n"
"jvm_ref_print (sprintf (\'\\n</%s>\', entity_name), ses);\n"
"}\n"
"--src javavm_xml.sql:107\n";

static const char *proc5 = 
"create procedure jvm_ref_describe_class (in jvm varchar, inout classes any, in unrestricted integer)\n"
"{\n"
"declare inx integer;\n"
"declare inherited integer;\n"
"declare str_unrestricted varchar;\n"
"\n"
"inherited := 1;\n"
"\n"
"declare ses any;\n"
"ses := string_output ();\n"
"\n"
"declare jvm_class, under_class any;\n"
"jvm_class := jvm_load_class (cast (jvm as varchar));\n"
"\n"
"declare jvm_super_class any;\n"
"jvm_super_class := java_call_method (\'java.lang.Class\', jvm_class, \'getSuperclass\', \'Ljava/lang/Class;\');\n"
"declare jvm_super_class_name, under_name  varchar;\n"
"under_name := \'\';\n"
"under_class := null;\n"
"\n"
"str_unrestricted := \'\';\n"
"if (unrestricted)\n"
"str_unrestricted := \' restiction=\"unrestricted\"\';\n"
"\n"
"if (jvm_super_class is not null)\n"
"{\n"
"jvm_super_class_name := cast (java_call_method (\'java.lang.Class\', jvm_super_class, \'getName\', \'Ljava/lang/String;\') as varchar);\n"
"declare class_inx integer;\n"
"class_inx := 0;\n"
"while (class_inx < length (classes))\n"
"{\n"
"if (classes[class_inx] = jvm_super_class_name)\n"
"{\n"
"under_class := jvm_load_class (cast (jvm_super_class_name as varchar));\n"
"under_name := replace (cast (jvm_super_class_name as varchar), \'.\', \'_\');\n"
"class_inx := length (classes);\n"
"inherited := 0;\n"
"}\n"
"else\n"
"class_inx := class_inx + 1;\n"
"}\n"
"}\n"
"\n"
"jvm_ref_print (\n"
"sprintf (\n"
"\'\\n<class type=\"%s\" pl_lang=\"JAVA\" pl_type=\"%s\" pl_under=\"%s\"%s>\',\n"
"jvm,\n"
"replace (cast (jvm as varchar), \'.\', \'_\'),\n"
"under_name, str_unrestricted),\n"
"ses);\n"
"\n"
"\n"
"declare jvm_fields any;\n"
"if (inherited <> 0)\n"
"jvm_fields := java_call_method (\'java.lang.Class\', jvm_class,\n"
"\'getFields\', \'[Ljava/lang/reflect/Field;\');\n"
"else\n"
"jvm_fields := java_call_method (\'java.lang.Class\', jvm_class,\n"
"\'getDeclaredFields\', \'[Ljava/lang/reflect/Field;\');\n"
"inx := 0;\n"
"while (inx < length (jvm_fields))\n"
"{\n"
"declare fld_name, fld_type, fld_type_obj, is_primitive, is_array, plescape varchar;\n"
"declare modifiers, static_mask, final_mask, private_mask, protected_mask any;\n"
"declare jvm_field any;\n"
"\n"
"jvm_field := jvm_fields[inx];\n"
"fld_name := java_call_method (\'java.lang.reflect.Field\', jvm_field,\n"
"\'getName\', \'Ljava/lang/String;\');\n"
"fld_type_obj := java_call_method (\'java.lang.reflect.Field\', jvm_field,\n"
"\'getType\', \'Ljava/lang/Class;\');\n"
"fld_type := java_call_method (\'java.lang.Class\', fld_type_obj,\n"
"\'getName\', \'Ljava/lang/String;\');\n"
"is_primitive := java_call_method (\'java.lang.Class\', fld_type_obj, \'isPrimitive\', \'Z\');\n"
"is_array := java_call_method (\'java.lang.Class\', fld_type_obj, \'isArray\', \'Z\');\n"
"modifiers := cast (java_call_method (\'java.lang.reflect.Field\', jvm_field,\n"
"\'getModifiers\', \'I\') as integer);\n"
"static_mask := cast (java_get_property (\'java.lang.reflect.Modifier\', NULL,\n"
"\'STATIC\', \'I\') as integer);\n"
"final_mask := cast (java_get_property (\'java.lang.reflect.Modifier\', NULL,\n"
"\'FINAL\', \'I\') as integer);\n"
"private_mask := cast (java_get_property (\'java.lang.reflect.Modifier\', NULL, \'PRIVATE\', \'I\') as integer);\n"
"protected_mask := cast (java_get_property (\'java.lang.reflect.Modifier\', NULL, \'PROTECTED\', \'I\') as integer);\n"
"if (bit_and (modifiers, private_mask) = 0 and bit_and (modifiers, protected_mask) = 0)\n"
"{\n"
"jvm_ref_print (\n"
"sprintf (\n"
"\'\\n<field name=\"%s\" type=\"%s\" static=\"%d\" final=\"%d\" is_primitive=\"%d\" is_array=\"%d\" pltype=\"%s\" signature=\"%s\" soaptype=\"%s\" plescape=\"%d\"/>\',\n"
"fld_name, fld_type,\n"
"bit_and (modifiers, static_mask) / static_mask,\n"
"bit_and (modifiers, final_mask) / final_mask,\n"
"is_primitive,\n"
"is_array,\n"
"jvm_type_to_pl_type (fld_type, is_primitive, is_array, plescape),\n"
"jvm_type_to_signature (fld_type, is_primitive, is_array),\n"
"jvm_type_to_schema_type (fld_type, is_primitive, is_array),\n"
"plescape\n"
"), ses);\n"
"}\n"
"inx := inx + 1;\n"
"fld_type_obj := null;\n"
"jvm_field := null;\n"
"}\n"
"jvm_fields := null;\n"
"\n"
"\n"
"declare jvm_constructors any;\n"
"if (inherited <> 0)\n"
"jvm_constructors := java_call_method (\'java.lang.Class\', jvm_class,\n"
"\'getConstructors\', \'[Ljava/lang/reflect/Constructor;\');\n"
"else\n"
"jvm_constructors := java_call_method (\'java.lang.Class\', jvm_class,\n"
"\'getDeclaredConstructors\', \'[Ljava/lang/reflect/Constructor;\');\n"
"inx := 0;\n"
"while (inx < length (jvm_constructors))\n"
"{\n"
"declare jvm_constructor, const_under_class any;\n"
"const_under_class := null;\n"
"jvm_constructor := jvm_constructors[inx];\n"
"jvm_ref_describe_method (jvm_constructor, ses, \'java.lang.reflect.Constructor\', \'constructor\', const_under_class);\n"
"inx := inx + 1;\n"
"jvm_constructor := null;\n"
"}\n"
"jvm_constructors := null;\n"
"\n"
"\n"
"declare jvm_methods any;\n"
"if (inherited <> 0)\n"
"jvm_methods := java_call_method (\'java.lang.Class\', jvm_class,\n"
"\'getMethods\', \'[Ljava/lang/reflect/Method;\');\n"
"else\n"
"jvm_methods := java_call_method (\'java.lang.Class\', jvm_class,\n"
"\'getDeclaredMethods\', \'[Ljava/lang/reflect/Method;\');\n"
"inx := 0;\n"
"while (inx < length (jvm_methods))\n"
"{\n"
"declare jvm_method any;\n"
"jvm_method := jvm_methods[inx];\n"
"jvm_ref_describe_method (jvm_method, ses, \'java.lang.reflect.Method\', \'method\', under_class);\n"
"inx := inx + 1;\n"
"jvm_method := null;\n"
"}\n"
"jvm_methods := null;\n"
"jvm_class := null;\n"
"\n"
"jvm_ref_print (\'\\n</class>\', ses);\n"
"\n"
"\n"
"return string_output_string (ses);\n"
"}\n"
"--src javavm_xml.sql:211\n";

static const char *proc6 = 
"create procedure jvm_ref_archive_handler (in name varchar, in class_name varchar := null)\n"
"{\n"
"declare jar any;\n"
"\n"
"if (lower (name) like \'%jar\')\n"
"jar := java_new_object (\'java.util.jar.JarFile\', name);\n"
"else if (lower (name) like \'%zip\')\n"
"jar := java_new_object (\'java.util.zip.ZipFile\', name);\n"
"else\n"
"signal (\'xxxx\', \'unknown file type\');\n"
"\n"
"\n"
"declare entries any;\n"
"\n"
"entries := java_call_method (\'java.util.zip.ZipFile\', jar, \'entries\', \'Ljava/util/Enumeration;\');\n"
"\n"
"declare entry_name varchar;\n"
"declare entry_size integer;\n"
"\n"
"if (class_name is null)\n"
"result_names (entry_size, entry_name);\n"
"while (java_call_method (\'java.util.Enumeration\', entries, \'hasMoreElements\', \'Z\') > 0)\n"
"{\n"
"declare entry any;\n"
"entry := null;\n"
"entry := java_call_method (\'java.util.Enumeration\', entries, \'nextElement\', \'Ljava/lang/Object;\');\n"
"\n"
"entry_name := null;\n"
"entry_size := null;\n"
"\n"
"entry_name := java_call_method (\'java.util.zip.ZipEntry\', entry, \'getName\', \'Ljava/lang/String;\');\n"
"entry_size := java_call_method (\'java.util.zip.ZipEntry\', entry, \'getSize\', \'J\');\n"
"\n"
"entry_name := cast (entry_name as varchar);\n"
"\n"
"if (class_name is not null)\n"
"{\n"
"if (class_name = entry_name)\n"
"{\n"
"if (entry_size >= 1000000)\n"
"signal (\'xxxxx\', \'Max 1M can be read from the zip file\');\n"
"declare chunk_size integer;\n"
"declare bytecode_buffer varbinary;\n"
"declare bytecode varbinary;\n"
"declare readed integer;\n"
"\n"
"bytecode := \'\';\n"
"chunk_size := 0;\n"
"declare datas any;\n"
"datas := java_call_method (\'java.util.zip.ZipFile\', jar, \'getInputStream\', \'Ljava/io/InputStream;\',\n"
"vector (\'Ljava/util/zip/ZipEntry;\', entry));\n"
"readed := 0;\n"
"\n"
"while (readed < entry_size)\n"
"{\n"
"chunk_size := entry_size - readed;\n"
"bytecode_buffer := cast (repeat (\' \', chunk_size) as varbinary);\n"
"chunk_size := java_call_method (\'java.io.InputStream\', datas, \'read\', \'I\', bytecode_buffer);\n"
"if (chunk_size <> -1)\n"
"{\n"
"bytecode := concat (bytecode, left (cast (bytecode_buffer as varchar), chunk_size));\n"
"readed := readed - chunk_size;\n"
"}\n"
"else\n"
"readed := entry_size;\n"
"}\n"
"if (readed = entry_size)\n"
"return bytecode;\n"
"else\n"
"signal (\'xxxxx\', \'can\'\'t read the data from the archive\');\n"
"}\n"
"}\n"
"else\n"
"{\n"
"result (entry_size, entry_name);\n"
"}\n"
"}\n"
"if (class_name is not null)\n"
"{\n"
"return null;\n"
"}\n"
"}\n"
"--src javavm_xml.sql:363\n";

static const char *proc7 = 
"create procedure jvm_load_class (in jvm varchar)\n"
"{\n"
"declare class_loader any;\n"
"\n"
"return java_load_class (jvm);\n"
"\n"
"\n"
"\n"
"\n"
"}\n"
"--src javavm_xml.sql:447\n";

static const char *proc8 = 
"create procedure jvm_ref_import (in files any, in classes any, in unrestricted integer)\n"
"{\n"
"declare ret any;\n"
"declare add_to_classes_mask varchar;\n"
"add_to_classes_mask := \'\';\n"
"if (isstring (classes))\n"
"{\n"
"if (strstr (classes, \'*\') is not null)\n"
"{\n"
"dbg_obj_print (\'in star case\');\n"
"add_to_classes_mask := classes;\n"
"classes := vector ();\n"
"}\n"
"else\n"
"classes := vector (classes);\n"
"}\n"
"if (isstring (files))\n"
"{\n"
"files := vector (files);\n"
"}\n"
"\n"
"if (isarray (files))\n"
"{\n"
"declare files_inx integer;\n"
"files_inx := 0;\n"
"\n"
"while (files_inx < length (files))\n"
"{\n"
"declare file_name varchar;\n"
"file_name := files[files_inx];\n"
"if (lower (file_name) like \'%.class\')\n"
"{\n"
"declare class_name varchar;\n"
"class_name := replace (cast (file_name as varchar), \'.class\', \'\');\n"
"\n"
"jvm_load_class (class_name);\n"
"if (add_to_classes_mask <> \'\' and\n"
"class_name like add_to_classes_mask)\n"
"classes := vector_concat (classes, vector (class_name));\n"
"\n"
"}\n"
"else if (lower (file_name) like \'%.jar\' or lower (file_name) like \'%.zip\')\n"
"{\n"
"declare res any;\n"
"declare res_inx integer;\n"
"exec (\'jvm_ref_archive_handler (?)\', null, null, vector (file_name), 0, null, res);\n"
"res_inx := 0;\n"
"\n"
"while (res_inx < length (res))\n"
"{\n"
"declare jar_file_name varchar;\n"
"jar_file_name := res[res_inx][1];\n"
"\n"
"if (jar_file_name like \'%.class\')\n"
"{\n"
"declare ret any;\n"
"declare jar_class_name varchar;\n"
"jar_class_name := replace (cast (jar_file_name as varchar), \'.class\', \'\');\n"
"\n"
"\n"
"ret := jvm_load_class (jar_class_name);\n"
"\n"
"if (add_to_classes_mask <> \'\' and\n"
"jar_class_name like add_to_classes_mask)\n"
"classes := vector_concat (classes, vector (replace (jar_class_name, \'/\', \'.\')));\n"
"}\n"
"res_inx := res_inx + 1;\n"
"}\n"
"}\n"
"else\n"
"signal (\'xxxxx\', \'file name needs to be .class .zip or .jar\');\n"
"files_inx := files_inx + 1;\n"
"}\n"
"}\n"
"\n"
"declare ses any;\n"
"ses := string_output();\n"
"if (isarray (classes))\n"
"{\n"
"declare class_inx integer;\n"
"class_inx := 0;\n"
"\n"
"jvm_ref_print (\'<classes>\\n\', ses);\n"
"while (class_inx < length (classes))\n"
"{\n"
"declare class_name varchar;\n"
"class_name := classes[class_inx];\n"
"\n"
"declare the_xml varchar;\n"
"jvm_ref_print (jvm_ref_describe_class (class_name, classes, unrestricted), ses);\n"
"jvm_ref_print (\'\\n\', ses);\n"
"class_inx := class_inx + 1;\n"
"}\n"
"jvm_ref_print (\'</classes>\\n\', ses);\n"
"}\n"
"return string_output_string (ses);\n"
"}\n"
"--src javavm_xml.sql:460\n";

static const char *proc9 = 
"create procedure import_jar (in files any, in classes any, in unrestricted integer := 0,\n"
"in _is_return_sql integer := 0)\n"
"{\n"
"declare _xml, _xmlv any;\n"
"declare pl, all_pl varchar;\n"
"_xml := xml_tree_doc (jvm_ref_import (files, classes, unrestricted));\n"
"\n"
"_xmlv := xpath_eval (\'/classes/class\', _xml, 0);\n"
"\n"
"\n"
"if (isarray (_xmlv))\n"
"{\n"
"declare inx integer;\n"
"inx := 0;\n"
"all_pl := \'\';\n"
"\n"
"while (inx < length (_xmlv))\n"
"{\n"
"declare _xmlv_frag any;\n"
"_xmlv_frag := xml_cut (_xmlv[inx]);\n"
"pl := cast (xslt (\'http://local.virt/javavm_type\', _xmlv_frag) as varchar);\n"
"\n"
"\n"
"if (_is_return_sql)\n"
"all_pl := all_pl || pl;\n"
"else\n"
"exec (pl);\n"
"inx := inx + 1;\n"
"}\n"
"}\n"
"if (_is_return_sql)\n"
"return all_pl;\n"
"}\n"
"--src javavm_xml.sql:559\n";

static const char *proc10 = 
"create procedure unimport_jar (in files any, in classes any)\n"
"{\n"
"declare _xml, _xmlv any;\n"
"declare pl varchar;\n"
"_xml := xml_tree_doc (jvm_ref_import (files, classes, 0));\n"
"\n"
"_xmlv := xpath_eval (\'/classes/class/@pl_type\', _xml, 0);\n"
"\n"
"if (isarray (_xmlv))\n"
"{\n"
"declare inx integer;\n"
"inx := 0;\n"
"\n"
"foreach (any _xml in _xmlv) do\n"
"{\n"
"declare _children any;\n"
"_children := udt_get_info (cast (_xml as varchar), \'children\');\n"
"foreach (varchar _xml_child in _children) do\n"
"{\n"
"declare _found int;\n"
"_found := 0;\n"
"foreach (any _xml2 in _xmlv) do\n"
"{\n"
"if (cast (_xml2 as varchar) = _xml_child)\n"
"_found := 1;\n"
"}\n"
"if (not _found)\n"
"signal (\'42000\', sprintf (\n"
"\'unimport_jar is to drop an user defined type %s that is a supertype of %s. Please drop the subtype(s) first.\', _xml, _xml_child));\n"
"}\n"
"}\n"
"\n"
"while (inx < length (_xmlv))\n"
"{\n"
"pl := sprintf (\'DROP TYPE \"%I\"\', cast (_xmlv[inx] as varchar));\n"
"dbg_obj_print (pl);\n"
"exec (pl);\n"
"inx := inx + 1;\n"
"}\n"
"}\n"
"}\n"
"--src javavm_xml.sql:595\n";

static const char *proc11 = 
"create procedure import_get_types_int (in sel_name varchar)\n"
"{\n"
"declare types, ret any;\n"
"declare esc_string varchar;\n"
"declare idx integer;\n"
"\n"
"ret := vector ();\n"
"\n"
"if (strstr (sel_name, \'.class\') is not NULL)\n"
"{\n"
"declare pos integer;\n"
"sel_name := replace (sel_name, \'\\\\\', \'/\');\n"
"pos := strrchr (sel_name , \'/\');\n"
"sel_name := subseq (sel_name, pos + 1);\n"
"return vector (replace (sel_name, \'.class\', \'\'));\n"
"}\n"
"else if ((strstr (sel_name, \'.jar\') is not NULL) or\n"
"(strstr (sel_name, \'.zip\') is not NULL))\n"
"{\n"
"declare jar_list any;\n"
"\n"
"for ( select entry_name from jvm_ref_archive_handler (m) (sz integer, entry_name varchar) c where m = sel_name) do\n"
"{\n"
"if (strstr (entry_name, \'.class\') is not NULL)\n"
"ret := vector_concat (ret, vector (entry_name));\n"
"}\n"
"\n"
"return ret;\n"
"}\n"
"\n"
"return vector ();\n"
"}\n"
"--src javavm_xml.sql:639\n";

#undef isp_schema
#define isp_schema(x) isp_schema_1(x)

static int
sch_proc_def_exists (client_connection_t *cli, const char *proc_name)
{
  query_t *proc = NULL;
  char *full_name = sch_full_proc_name (isp_schema(NULL), proc_name,
	cli->cli_qualifier, CLI_OWNER (cli));
  if (full_name)
    proc = sch_proc_def (isp_schema(NULL), full_name);
  return (proc != NULL);
}

#define DEFINE_PROC(name, proc) \
   if (!sch_proc_def_exists (bootstrap_cli, (name))) \
     ddl_std_proc_1 (proc, 0x0, 1)


#define DEFINE_PUBLIC_PROC(name, proc) \
   if (!sch_proc_def_exists (bootstrap_cli, (name))) \
     ddl_std_proc_1 (proc, 0x1, 1)


#define DEFINE_OVERWRITE_PROC(name, proc) \
   ddl_std_proc_1 (proc, 0x1, 1)


void
sqls_define_javavm (client_connection_t *bootstrap_cli)
{
  /* javavm_xml.sql */

  DEFINE_PROC ("jvm_ref_print", proc0);
  DEFINE_PROC ("jvm_type_to_pl_type", proc1);
  DEFINE_PROC ("jvm_type_to_signature", proc2);
  DEFINE_PROC ("jvm_type_to_schema_type", proc3);
  DEFINE_PROC ("jvm_ref_describe_method", proc4);
  DEFINE_PROC ("jvm_ref_describe_class", proc5);
  DEFINE_PROC ("jvm_ref_archive_handler", proc6);
  DEFINE_PROC ("jvm_load_class", proc7);
  DEFINE_PROC ("jvm_ref_import", proc8);
  DEFINE_PROC ("import_jar", proc9);
  DEFINE_PROC ("unimport_jar", proc10);
  DEFINE_PROC ("import_get_types_int", proc11);
}


void
sqls_arfw_define_javavm (void)
{
}
