.\" $Xorg: xcutsel.man,v 1.4 2001/02/09 02:05:39 xorgcvs Exp $
.\" Copyright 1994, 1998  The Open Group
.\" 
.\" Permission to use, copy, modify, distribute, and sell this software and its
.\" documentation for any purpose is hereby granted without fee, provided that
.\" the above copyright notice appear in all copies and that both that
.\" copyright notice and this permission notice appear in supporting
.\" documentation.
.\" 
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE OPEN GROUP BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of The Open Group shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from The Open Group.
.\"
.\" $XFree86: xc/programs/xclipboard/xcutsel.man,v 1.7 2001/01/27 18:21:09 dawes Exp $
.\"
.TH XCUTSEL 1 __xorgversion__
.SH NAME
xcutsel - interchange between cut buffer and selection
.SH SYNOPSIS
\fBxcutsel\fP [ \fI-toolkitoption\fP ...] [-selection \fIselection\fP] [-cutbuffer \fInumber\fP]
.SH DESCRIPTION
The \fIxcutsel\fP program is used to copy the current selection into a
cut buffer and to make a selection that contains the current contents of
the cut buffer.  It acts as a bridge between applications that don't support
selections and those that do.
.PP
By default, \fIxcutsel\fP will use the selection named PRIMARY and the cut
buffer CUT_BUFFER0.  Either or both of these can be overridden by command
line arguments or by resources.
.PP
An \fIxcutsel\fP window has the following buttons:
.TP 8
.I "    quit"
When this button is pressed, \fIxcutsel\fP exits.  Any selections held by
\fIxcutsel\fP are automatically released.
.TP 8
.I "    copy PRIMARY to 0"
When this button is pressed, \fIxcutsel\fP copies the current selection into
the cut buffer.
.TP 8
.I "    copy 0 to PRIMARY"
When this button is pressed, \fIxcutsel\fP converts the current contents of
the cut buffer into the selection.
.PP
The button labels reflect the selection and cutbuffer selected by
command line options or through the resource database.
.PP
When the ``copy 0 to PRIMARY'' button is activated, the button will
remain inverted as long as \fIxcutsel\fP remains the owner of the
selection.  This serves to remind you which client owns the current
selection.  Note that the value of the selection remains constant;
if the cutbuffer is changed, you must again activate the copy button
to retrieve the new value when desired.
.SH OPTIONS
.I Xcutsel
accepts all of the standard X Toolkit command line options as well as the
following:
.TP 8
.B \-selection \fIname\fP
This option specifies the name of the selection to use.  The default is
PRIMARY.  The only supported abbreviations for this option are ``-select'',
``-sel'' and ``-s'', as the standard toolkit option ``-selectionTimeout'' has a
similar name.
.TP 8
.B \-cutbuffer \fInumber\fP
This option specifies the cut buffer to use.  The default is cut buffer 0.
.SH X DEFAULTS
This program accepts all of the standard X Toolkit resource names and classes
as well as:
.TP 8
.B "selection (\fPclass\fB Selection)"
This resource specifies the name of the selection to use.  The default is
PRIMARY.
.TP 8
.B "cutBuffer (\fPclass\fB CutBuffer)"
This resource specifies the number of the cut buffer to use.  The default is 0.
.SH WIDGET NAMES
The following instance names may be used when user configuration of the
labels in them is desired:
.TP 8
.B "sel-cut (\fPclass\fB Command)"
This is the ``copy SELECTION to BUFFER'' button.
.TP 8
.B "cut-sel (\fPclass\fB Command)"
This is the ``copy BUFFER to SELECTION'' button.
.TP 8
.B "quit (\fPclass\fB Command)"
This is the ``quit'' button.
.SH "SEE ALSO"
X(__miscmansuffix__), xclipboard(1), xterm(1), text widget documentation, individual client 
documentation for how to make a selection.
.SH BUGS
There is no way to change the name of the selection or the number of the
cut buffer while the program is running.
.SH AUTHOR
Ralph R. Swick, DEC/MIT Project Athena
