/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui.options.general;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.beaninfo.editors.HtmlBrowser;
import org.netbeans.core.ui.options.general.AdvancedProxyPanel;
import org.netbeans.core.ui.options.general.GeneralOptionsModel;
import org.netbeans.core.ui.options.general.WebBrowsersOptionsModel;
import org.netbeans.core.ui.options.general.WebBrowsersOptionsPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class GeneralOptionsPanel
extends JPanel
implements ActionListener {
    private boolean changed = false;
    private GeneralOptionsModel model;
    private HtmlBrowser.FactoryEditor editor;
    private AdvancedProxyPanel advancedPanel;
    private JButton bMoreProxy;
    private JComboBox cbWebBrowser;
    private JButton editBrowserButton;
    private JSeparator jSeparator2;
    private JLabel lProxyHost;
    private JLabel lProxyPort;
    private JLabel lWebBrowser;
    private JLabel lWebProxy;
    private JRadioButton rbHTTPProxy;
    private JRadioButton rbNoProxy;
    private JRadioButton rbUseSystemProxy;
    private JTextField tfProxyHost;
    private JTextField tfProxyPort;

    public GeneralOptionsPanel() {
        this.initComponents();
        GeneralOptionsPanel.loc(this.lWebBrowser, "Web_Browser");
        GeneralOptionsPanel.loc(this.lWebProxy, "Web_Proxy");
        GeneralOptionsPanel.loc(this.lProxyHost, "Proxy_Host");
        GeneralOptionsPanel.loc(this.lProxyPort, "Proxy_Port");
        this.cbWebBrowser.getAccessibleContext().setAccessibleName(GeneralOptionsPanel.loc("AN_Web_Browser"));
        this.cbWebBrowser.getAccessibleContext().setAccessibleDescription(GeneralOptionsPanel.loc("AD_Web_Browser"));
        this.tfProxyHost.getAccessibleContext().setAccessibleName(GeneralOptionsPanel.loc("AN_Host"));
        this.tfProxyHost.getAccessibleContext().setAccessibleDescription(GeneralOptionsPanel.loc("AD_Host"));
        this.tfProxyPort.getAccessibleContext().setAccessibleName(GeneralOptionsPanel.loc("AN_Port"));
        this.tfProxyPort.getAccessibleContext().setAccessibleDescription(GeneralOptionsPanel.loc("AD_Port"));
        this.rbNoProxy.addActionListener(this);
        this.rbUseSystemProxy.addActionListener(this);
        this.rbHTTPProxy.addActionListener(this);
        this.cbWebBrowser.addActionListener(this);
        this.tfProxyHost.addActionListener(this);
        this.tfProxyPort.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbNoProxy);
        buttonGroup.add(this.rbUseSystemProxy);
        buttonGroup.add(this.rbHTTPProxy);
        GeneralOptionsPanel.loc(this.rbNoProxy, "No_Proxy");
        GeneralOptionsPanel.loc(this.rbUseSystemProxy, "Use_System_Proxy_Settings");
        GeneralOptionsPanel.loc(this.rbHTTPProxy, "Use_HTTP_Proxy");
        if (System.getProperty("netbeans.system_http_proxy") == null) {
            this.rbUseSystemProxy.setEnabled(false);
        }
    }

    private void initComponents() {
        this.lWebBrowser = new JLabel();
        this.cbWebBrowser = new JComboBox();
        this.jSeparator2 = new JSeparator();
        this.lWebProxy = new JLabel();
        this.rbNoProxy = new JRadioButton();
        this.rbUseSystemProxy = new JRadioButton();
        this.rbHTTPProxy = new JRadioButton();
        this.lProxyHost = new JLabel();
        this.tfProxyHost = new JTextField();
        this.lProxyPort = new JLabel();
        this.tfProxyPort = new JTextField();
        this.bMoreProxy = new JButton();
        this.editBrowserButton = new JButton();
        this.lWebBrowser.setLabelFor(this.cbWebBrowser);
        Mnemonics.setLocalizedText((JLabel)this.lWebBrowser, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"GeneralOptionsPanel.lWebBrowser.text"));
        Mnemonics.setLocalizedText((JLabel)this.lWebProxy, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"LBL_GeneralOptionsPanel_lWebProxy"));
        Mnemonics.setLocalizedText((AbstractButton)this.rbNoProxy, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"GeneralOptionsPanel.rbNoProxy.text"));
        this.rbNoProxy.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.rbUseSystemProxy, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"GeneralOptionsPanel.rbUseSystemProxy.text"));
        this.rbUseSystemProxy.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.rbHTTPProxy, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"CTL_Use_HTTP_Proxy", (Object[])new Object[0]));
        this.rbHTTPProxy.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.lProxyHost.setLabelFor(this.tfProxyHost);
        Mnemonics.setLocalizedText((JLabel)this.lProxyHost, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"CTL_Proxy_Host", (Object[])new Object[0]));
        this.tfProxyHost.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                GeneralOptionsPanel.this.tfProxyHostFocusGained(focusEvent);
            }

            public void focusLost(FocusEvent focusEvent) {
                GeneralOptionsPanel.this.tfProxyHostFocusLost(focusEvent);
            }
        });
        this.lProxyPort.setLabelFor(this.tfProxyPort);
        Mnemonics.setLocalizedText((JLabel)this.lProxyPort, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"CTL_Proxy_Port", (Object[])new Object[0]));
        this.tfProxyPort.setColumns(4);
        this.tfProxyPort.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                GeneralOptionsPanel.this.tfProxyPortFocusGained(focusEvent);
            }

            public void focusLost(FocusEvent focusEvent) {
                GeneralOptionsPanel.this.tfProxyPortFocusLost(focusEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bMoreProxy, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"LBL_GeneralOptionsPanel_bMoreProxy"));
        this.bMoreProxy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GeneralOptionsPanel.this.bMoreProxyActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.editBrowserButton, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"GeneralOptionsPanel.editBrowserButton.text"));
        this.editBrowserButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GeneralOptionsPanel.this.editBrowserButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lWebBrowser).add(18, 18, 18).add((Component)this.cbWebBrowser, 0, 903, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.editBrowserButton)).add((Component)this.jSeparator2, -1, 1058, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lWebProxy).add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.rbNoProxy).add((Component)this.rbUseSystemProxy).add((Component)this.rbHTTPProxy).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(17, 17, 17).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.bMoreProxy).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lProxyHost).addPreferredGap(1).add((Component)this.tfProxyHost, -1, 795, Short.MAX_VALUE).add(12, 12, 12).add((Component)this.lProxyPort).addPreferredGap(1).add((Component)this.tfProxyPort, -2, -1, -2))))))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lWebBrowser).add((Component)this.cbWebBrowser, -2, -1, -2).add((Component)this.editBrowserButton)).add(18, 18, 18).add((Component)this.jSeparator2, -2, 10, -2).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.rbNoProxy).addPreferredGap(0).add((Component)this.rbUseSystemProxy).addPreferredGap(0).add((Component)this.rbHTTPProxy)).add((Component)this.lWebProxy)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lProxyHost).add((Component)this.tfProxyPort, -2, -1, -2).add((Component)this.tfProxyHost, -2, -1, -2).add((Component)this.lProxyPort)).addPreferredGap(0).add((Component)this.bMoreProxy).addContainerGap(161, Short.MAX_VALUE)));
    }

    private void editBrowserButtonActionPerformed(ActionEvent actionEvent) {
        WebBrowsersOptionsModel webBrowsersOptionsModel = new WebBrowsersOptionsModel();
        WebBrowsersOptionsPanel webBrowsersOptionsPanel = new WebBrowsersOptionsPanel(webBrowsersOptionsModel);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)webBrowsersOptionsPanel, GeneralOptionsPanel.loc("LBL_WebBrowsersPanel_Title"));
        DialogDisplayer.getDefault().createDialog(dialogDescriptor).setVisible(true);
        if (dialogDescriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
            webBrowsersOptionsModel.applyChanges();
            this.updateWebBrowsers();
            int n = this.cbWebBrowser.getItemCount();
            for (int i = 0; i < n; ++i) {
                Object e = this.cbWebBrowser.getItemAt(i);
                if (!e.equals(webBrowsersOptionsModel.getSelectedValue())) continue;
                this.cbWebBrowser.setSelectedItem(e);
                break;
            }
        } else {
            webBrowsersOptionsModel.discardChanges();
        }
    }

    private void bMoreProxyActionPerformed(ActionEvent actionEvent) {
        assert (this.model != null) : "Model found when AdvancedProxyPanel is created";
        if (this.advancedPanel == null) {
            this.advancedPanel = new AdvancedProxyPanel(this.model);
        }
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.advancedPanel, GeneralOptionsPanel.loc("LBL_AdvancedProxyPanel_Title"));
        this.advancedPanel.update(this.tfProxyHost.getText(), this.tfProxyPort.getText());
        DialogDisplayer.getDefault().createDialog(dialogDescriptor).setVisible(true);
        if (DialogDescriptor.OK_OPTION.equals(dialogDescriptor.getValue())) {
            this.advancedPanel.applyChanges();
            this.tfProxyHost.setText(this.model.getHttpProxyHost());
            this.tfProxyPort.setText(this.model.getHttpProxyPort());
            this.isChanged();
        }
    }

    private void tfProxyPortFocusLost(FocusEvent focusEvent) {
        this.tfProxyPort.select(0, 0);
    }

    private void tfProxyHostFocusLost(FocusEvent focusEvent) {
        this.tfProxyHost.select(0, 0);
    }

    private void tfProxyPortFocusGained(FocusEvent focusEvent) {
        this.tfProxyPort.setCaretPosition(0);
        this.tfProxyPort.selectAll();
    }

    private void tfProxyHostFocusGained(FocusEvent focusEvent) {
        this.tfProxyHost.setCaretPosition(0);
        this.tfProxyHost.selectAll();
    }

    private static String loc(String string) {
        return NbBundle.getMessage(GeneralOptionsPanel.class, (String)string);
    }

    private static void loc(Component component, String string) {
        if (!(component instanceof JLabel)) {
            component.getAccessibleContext().setAccessibleName(GeneralOptionsPanel.loc("AN_" + string));
            component.getAccessibleContext().setAccessibleDescription(GeneralOptionsPanel.loc("AD_" + string));
        }
        if (component instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)component), (String)GeneralOptionsPanel.loc("CTL_" + string));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)component), (String)GeneralOptionsPanel.loc("CTL_" + string));
        }
    }

    void update() {
        this.model = new GeneralOptionsModel();
        switch (this.model.getProxyType()) {
            case 0: {
                this.rbNoProxy.setSelected(true);
                this.tfProxyHost.setEnabled(false);
                this.tfProxyPort.setEnabled(false);
                this.bMoreProxy.setEnabled(false);
                break;
            }
            case 1: {
                this.rbUseSystemProxy.setSelected(true);
                this.tfProxyHost.setEnabled(false);
                this.tfProxyPort.setEnabled(false);
                this.bMoreProxy.setEnabled(false);
                break;
            }
            default: {
                this.rbHTTPProxy.setSelected(true);
                this.tfProxyHost.setEnabled(true);
                this.tfProxyPort.setEnabled(true);
                this.bMoreProxy.setEnabled(true);
            }
        }
        this.tfProxyHost.setText(this.model.getHttpProxyHost());
        this.tfProxyPort.setText(this.model.getHttpProxyPort());
        this.updateWebBrowsers();
        this.changed = false;
    }

    private void updateWebBrowsers() {
        if (this.editor == null) {
            this.editor = (HtmlBrowser.FactoryEditor)Lookup.getDefault().lookup(HtmlBrowser.FactoryEditor.class);
        }
        this.cbWebBrowser.removeAllItems();
        String[] stringArray = this.editor.getTags();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            this.cbWebBrowser.addItem(stringArray[i]);
        }
        this.cbWebBrowser.setSelectedItem(this.editor.getAsText());
    }

    void applyChanges() {
        if (this.model == null) {
            return;
        }
        if (this.rbNoProxy.isSelected()) {
            this.model.setProxyType(0);
        } else if (this.rbUseSystemProxy.isSelected()) {
            this.model.setProxyType(1);
        } else {
            this.model.setProxyType(2);
        }
        this.model.setHttpProxyHost(this.tfProxyHost.getText());
        this.model.setHttpProxyPort(this.tfProxyPort.getText());
        if (this.editor == null) {
            this.editor = (HtmlBrowser.FactoryEditor)Lookup.getDefault().lookup(HtmlBrowser.FactoryEditor.class);
        }
        this.editor.setAsText((String)this.cbWebBrowser.getSelectedItem());
    }

    void cancel() {
    }

    boolean dataValid() {
        return true;
    }

    boolean isChanged() {
        if (this.model == null) {
            return false;
        }
        if (!this.tfProxyHost.getText().equals(this.model.getHttpProxyHost())) {
            return true;
        }
        if (!this.tfProxyPort.getText().equals(this.model.getHttpProxyPort())) {
            return true;
        }
        return this.changed;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.changed = true;
        this.tfProxyHost.setEnabled(this.rbHTTPProxy.isSelected());
        this.tfProxyPort.setEnabled(this.rbHTTPProxy.isSelected());
        this.bMoreProxy.setEnabled(this.rbHTTPProxy.isSelected());
    }
}

