/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.threaddump.impl;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.application.jvm.Jvm;
import com.sun.tools.visualvm.application.jvm.JvmFactory;
import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasource.DataSourceRepository;
import com.sun.tools.visualvm.core.datasource.Storage;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import com.sun.tools.visualvm.core.datasupport.DataChangeEvent;
import com.sun.tools.visualvm.core.datasupport.DataChangeListener;
import com.sun.tools.visualvm.core.snapshot.Snapshot;
import com.sun.tools.visualvm.core.ui.DataSourceWindowManager;
import com.sun.tools.visualvm.coredump.CoreDump;
import com.sun.tools.visualvm.threaddump.ThreadDumpSupport;
import com.sun.tools.visualvm.threaddump.impl.ThreadDumpImpl;
import com.sun.tools.visualvm.tools.sa.SaModel;
import com.sun.tools.visualvm.tools.sa.SaModelFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ThreadDumpProvider {
    public void createThreadDump(final Application application, final boolean openView) {
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ProgressHandle pHandleF;
                Jvm jvm = JvmFactory.getJVMFor((Application)application);
                if (!jvm.isTakeThreadDumpSupported()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            NetBeansProfiler.getDefaultNB().displayError(NbBundle.getMessage(ThreadDumpProvider.class, (String)"MSG_Cannot_take_thread_dump_for_") + DataSourceDescriptorFactory.getDescriptor((DataSource)application).getName());
                        }
                    });
                    return;
                }
                ProgressHandle pHandle = null;
                try {
                    pHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ThreadDumpProvider.class, (String)"MSG_Creating_Thread_Dump"));
                    pHandle.setInitialDelay(0);
                    pHandle.start();
                    try {
                        final ThreadDumpImpl threadDump = new ThreadDumpImpl(jvm.takeThreadDump(), (DataSource)application);
                        application.getRepository().addDataSource((DataSource)threadDump);
                        if (openView) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    DataSourceWindowManager.sharedInstance().openDataSource((DataSource)threadDump);
                                }
                            });
                        }
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify((Throwable)ex);
                    }
                    pHandleF = pHandle;
                }
                catch (Throwable throwable) {
                    ProgressHandle pHandleF2 = pHandle;
                    SwingUtilities.invokeLater(new Runnable(pHandleF2){
                        final /* synthetic */ ProgressHandle val$pHandleF;
                        {
                            this.val$pHandleF = progressHandle;
                        }

                        public void run() {
                            if (this.val$pHandleF != null) {
                                this.val$pHandleF.finish();
                            }
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    public void createThreadDump(final CoreDump coreDump, final boolean openView) {
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ProgressHandle pHandleF;
                ProgressHandle pHandle = null;
                try {
                    pHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ThreadDumpProvider.class, (String)"MSG_Creating_Thread_Dump"));
                    pHandle.setInitialDelay(0);
                    pHandle.start();
                    File snapshotDir = coreDump.getStorage().getDirectory();
                    String name = ThreadDumpSupport.getInstance().getCategory().createFileName();
                    File dumpFile = new File(snapshotDir, name);
                    SaModel saAget = SaModelFactory.getSAAgentFor((DataSource)coreDump);
                    String dump = saAget.takeThreadDump();
                    if (dump != null) {
                        try {
                            FileOutputStream os = new FileOutputStream(dumpFile);
                            ((OutputStream)os).write(dump.getBytes("UTF-8"));
                            ((OutputStream)os).close();
                            final ThreadDumpImpl threadDump = new ThreadDumpImpl(dumpFile, (DataSource)coreDump);
                            coreDump.getRepository().addDataSource((DataSource)threadDump);
                            if (openView) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        DataSourceWindowManager.sharedInstance().openDataSource((DataSource)threadDump);
                                    }
                                });
                            }
                        }
                        catch (Exception ex) {
                            ErrorManager.getDefault().notify((Throwable)ex);
                        }
                    }
                    pHandleF = pHandle;
                }
                catch (Throwable throwable) {
                    ProgressHandle pHandleF2 = pHandle;
                    SwingUtilities.invokeLater(new Runnable(pHandleF2){
                        final /* synthetic */ ProgressHandle val$pHandleF;
                        {
                            this.val$pHandleF = progressHandle;
                        }

                        public void run() {
                            if (this.val$pHandleF != null) {
                                this.val$pHandleF.finish();
                            }
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    public void initialize() {
        DataSourceRepository.sharedInstance().addDataChangeListener((DataChangeListener)new SnapshotListener(), Snapshot.class);
        DataSourceRepository.sharedInstance().addDataChangeListener((DataChangeListener)new ApplicationListener(), Application.class);
    }

    private void processNewSnapshot(Snapshot snapshot) {
        if (snapshot instanceof ThreadDumpImpl) {
            return;
        }
        File snapshotFile = snapshot.getFile();
        if (snapshotFile != null && snapshotFile.isDirectory()) {
            File[] files = snapshotFile.listFiles(ThreadDumpSupport.getInstance().getCategory().getFilenameFilter());
            if (files == null) {
                return;
            }
            HashSet<ThreadDumpImpl> threadDumps = new HashSet<ThreadDumpImpl>();
            for (File file : files) {
                threadDumps.add(new ThreadDumpImpl(file, (DataSource)snapshot));
            }
            snapshot.getRepository().addDataSources(threadDumps);
        }
    }

    private void processNewApplication(Application application) {
        Storage storage = application.getStorage();
        if (storage.directoryExists()) {
            File[] files = storage.getDirectory().listFiles(ThreadDumpSupport.getInstance().getCategory().getFilenameFilter());
            if (files == null) {
                return;
            }
            HashSet<ThreadDumpImpl> threadDumps = new HashSet<ThreadDumpImpl>();
            for (File file : files) {
                threadDumps.add(new ThreadDumpImpl(file, (DataSource)application));
            }
            application.getRepository().addDataSources(threadDumps);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ApplicationListener
    implements DataChangeListener<Application> {
        private ApplicationListener() {
        }

        public void dataChanged(DataChangeEvent<Application> event) {
            final Set applications = event.getAdded();
            if (!applications.isEmpty()) {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        for (Application application : applications) {
                            ThreadDumpProvider.this.processNewApplication(application);
                        }
                    }
                });
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SnapshotListener
    implements DataChangeListener<Snapshot> {
        private SnapshotListener() {
        }

        public void dataChanged(DataChangeEvent<Snapshot> event) {
            final Set snapshots = event.getAdded();
            if (!snapshots.isEmpty()) {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        for (Snapshot snapshot : snapshots) {
                            ThreadDumpProvider.this.processNewSnapshot(snapshot);
                        }
                    }
                });
            }
        }
    }
}

