/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.SocketTimeoutException;
import java.sql.SQLException;
import org.apache.derby.impl.drda.CcsidManager;
import org.apache.derby.impl.drda.DRDAConnThread;
import org.apache.derby.impl.drda.DRDAProtocolException;
import org.apache.derby.impl.drda.DRDASocketTimeoutException;
import org.apache.derby.impl.drda.DRDAString;
import org.apache.derby.impl.drda.DecryptionManager;
import org.apache.derby.impl.drda.DssTrace;
import org.apache.derby.impl.drda.EXTDTAReaderInputStream;
import org.apache.derby.impl.drda.LayerBStreamedEXTDTAReaderInputStream;
import org.apache.derby.impl.drda.NetworkServerControlImpl;
import org.apache.derby.impl.drda.SignedBinary;
import org.apache.derby.impl.drda.StandardEXTDTAReaderInputStream;

class DDMReader {
    private static final int DEFAULT_BUFFER_SIZE = Short.MAX_VALUE;
    private static final int MAX_MARKS_NESTING = 10;
    private static final int NO_CODEPOINT = -1;
    private static final int EMPTY_STACK = -1;
    private static final boolean ADJUST_LENGTHS = true;
    private static final boolean NO_ADJUST_LENGTHS = false;
    private static final long MAX_EXTDTA_SIZE = Long.MAX_VALUE;
    private static boolean internalTrace = true;
    private static final int[][] tenRadixMagnitude = new int[][]{{1000000000}, {232830643, -1486618624}, {54210108, -1613725636, -402653184}};
    private DRDAConnThread agent;
    private CcsidManager ccsidManager;
    private byte[] buffer = new byte[Short.MAX_VALUE];
    private int pos;
    private int count;
    private int topDdmCollectionStack;
    private long[] ddmCollectionLenStack = new long[10];
    private long ddmScalarLen;
    private int dssLength;
    private boolean dssIsContinued;
    private boolean terminateChainOnErr;
    private boolean dssIsChainedWithSameID;
    private boolean dssIsChainedWithDiffID;
    private int dssCorrelationID;
    private int prevCorrelationID;
    private int svrcod;
    private DssTrace dssTrace;
    private InputStream inputStream;
    private boolean doingLayerBStreaming = false;
    volatile long totalByteCount = 0L;

    DDMReader(DRDAConnThread dRDAConnThread, DssTrace dssTrace) {
        this.initialize(dRDAConnThread, dssTrace);
    }

    DDMReader(CcsidManager ccsidManager, InputStream inputStream) {
        this.ccsidManager = ccsidManager;
        this.inputStream = inputStream;
        this.initialize(null, null);
        internalTrace = false;
    }

    protected void initialize(InputStream inputStream) {
        this.inputStream = inputStream;
        this.initialize(null, null);
    }

    protected void initialize(DRDAConnThread dRDAConnThread, DssTrace dssTrace) {
        this.agent = dRDAConnThread;
        if (dRDAConnThread != null) {
            this.ccsidManager = dRDAConnThread.ccsidManager;
            this.inputStream = dRDAConnThread.getInputStream();
        }
        this.topDdmCollectionStack = -1;
        this.svrcod = 0;
        this.pos = 0;
        this.count = 0;
        this.ddmScalarLen = 0L;
        this.dssLength = 0;
        this.prevCorrelationID = -1;
        this.dssCorrelationID = -1;
        this.dssTrace = dssTrace;
    }

    protected boolean terminateChainOnErr() {
        return this.terminateChainOnErr;
    }

    protected boolean isChainedWithSameID() {
        return this.dssIsChainedWithSameID;
    }

    protected boolean isChainedWithDiffID() {
        return this.dssIsChainedWithDiffID;
    }

    protected long getDdmLength() {
        return this.ddmScalarLen;
    }

    protected boolean moreDdmData() {
        return this.ddmScalarLen > 0L;
    }

    protected boolean moreDssData() {
        return this.dssLength > 0;
    }

    protected boolean moreData() {
        return this.pos - this.count > 0;
    }

    protected boolean isCmd() throws DRDAProtocolException, UnsupportedEncodingException {
        this.ensureALayerDataInBuffer(4);
        String string = new String(this.buffer, 0, 4, "UTF8");
        return NetworkServerControlImpl.isCmd(string);
    }

    protected int readDssHeader() throws DRDAProtocolException {
        int n;
        this.ensureALayerDataInBuffer(6);
        this.dssLength = ((this.buffer[this.pos] & 0xFF) << 8) + ((this.buffer[this.pos + 1] & 0xFF) << 0);
        this.pos += 2;
        if ((this.dssLength & 0x8000) == 32768) {
            this.dssLength = Short.MAX_VALUE;
            this.dssIsContinued = true;
        } else {
            this.dssIsContinued = false;
        }
        if (this.dssLength < 6) {
            this.agent.throwSyntaxrm(1, 0);
        }
        if ((this.buffer[this.pos++] & 0xFF) != 208) {
            this.agent.throwSyntaxrm(3, 0);
        }
        if (((n = this.buffer[this.pos++] & 0xFF) & 0xF) != 1 && (n & 0xF) != 3) {
            this.agent.throwSyntaxrm(4, 0);
        }
        if ((n & 0x40) == 64) {
            if ((n & 0x50) == 80) {
                this.dssIsChainedWithSameID = true;
                this.dssIsChainedWithDiffID = false;
            } else {
                this.dssIsChainedWithSameID = false;
                this.dssIsChainedWithDiffID = true;
            }
            this.terminateChainOnErr = (n & 0x20) != 32;
        } else {
            if ((n & 0x50) == 80) {
                this.agent.throwSyntaxrm(24, 0);
            }
            if ((n & 0x20) == 32) {
                this.agent.throwSyntaxrm(26, 0);
            }
            this.dssIsChainedWithSameID = false;
            this.dssIsChainedWithDiffID = false;
        }
        this.dssCorrelationID = ((this.buffer[this.pos] & 0xFF) << 8) + ((this.buffer[this.pos + 1] & 0xFF) << 0);
        this.pos += 2;
        if (this.prevCorrelationID != -1 && this.dssCorrelationID != this.prevCorrelationID) {
            this.agent.throwSyntaxrm(26, 0);
        }
        this.prevCorrelationID = this.dssIsChainedWithSameID ? this.dssCorrelationID : -1;
        this.dssLength -= 6;
        return this.dssCorrelationID;
    }

    protected void readReplyDss() throws DRDAProtocolException {
        int n;
        this.ensureALayerDataInBuffer(6);
        this.dssLength = ((this.buffer[this.pos++] & 0xFF) << 8) + ((this.buffer[this.pos++] & 0xFF) << 0);
        if ((this.dssLength & 0x8000) == 32768) {
            this.dssLength = Short.MAX_VALUE;
            this.dssIsContinued = true;
        } else {
            this.dssIsContinued = false;
        }
        if (this.dssLength < 6) {
            this.agent.throwSyntaxrm(1, 0);
        }
        if ((this.buffer[this.pos++] & 0xFF) != 208) {
            this.agent.throwSyntaxrm(3, 0);
        }
        if (((n = this.buffer[this.pos++] & 0xFF) & 0x40) == 64) {
            if ((n & 0x50) == 80) {
                this.dssIsChainedWithSameID = true;
                this.dssIsChainedWithDiffID = false;
            } else {
                this.dssIsChainedWithSameID = false;
                this.dssIsChainedWithDiffID = true;
            }
        } else {
            this.dssIsChainedWithSameID = false;
            this.dssIsChainedWithDiffID = false;
        }
        this.dssCorrelationID = ((this.buffer[this.pos++] & 0xFF) << 8) + ((this.buffer[this.pos++] & 0xFF) << 0);
        this.dssLength -= 6;
    }

    protected int readLengthAndCodePoint(boolean bl) throws DRDAProtocolException {
        this.ensureBLayerDataInBuffer(4, false);
        this.ddmScalarLen = this.readCodePoint();
        int n = this.readCodePoint();
        if ((this.ddmScalarLen & 0x8000L) == 32768L) {
            int n2 = (int)this.ddmScalarLen - 32768 - 4;
            int n3 = 0;
            this.ensureBLayerDataInBuffer(n2, false);
            switch (n2) {
                case 8: {
                    this.ddmScalarLen = (((long)this.buffer[this.pos++] & 0xFFL) << 56) + (((long)this.buffer[this.pos++] & 0xFFL) << 48) + (((long)this.buffer[this.pos++] & 0xFFL) << 40) + (((long)this.buffer[this.pos++] & 0xFFL) << 32) + (((long)this.buffer[this.pos++] & 0xFFL) << 24) + (((long)this.buffer[this.pos++] & 0xFFL) << 16) + (((long)this.buffer[this.pos++] & 0xFFL) << 8) + (((long)this.buffer[this.pos++] & 0xFFL) << 0);
                    n3 = 12;
                    break;
                }
                case 6: {
                    this.ddmScalarLen = (((long)this.buffer[this.pos++] & 0xFFL) << 40) + (((long)this.buffer[this.pos++] & 0xFFL) << 32) + (((long)this.buffer[this.pos++] & 0xFFL) << 24) + (((long)this.buffer[this.pos++] & 0xFFL) << 16) + (((long)this.buffer[this.pos++] & 0xFFL) << 8) + (((long)this.buffer[this.pos++] & 0xFFL) << 0);
                    n3 = 10;
                    break;
                }
                case 4: {
                    this.ddmScalarLen = (((long)this.buffer[this.pos++] & 0xFFL) << 24) + (((long)this.buffer[this.pos++] & 0xFFL) << 16) + (((long)this.buffer[this.pos++] & 0xFFL) << 8) + (((long)this.buffer[this.pos++] & 0xFFL) << 0);
                    n3 = 8;
                    break;
                }
                case 0: {
                    if (bl && (n == 5228 || n == 9243)) {
                        this.startLayerBStreaming();
                        n3 = 4;
                        break;
                    }
                    this.agent.throwSyntaxrm(12, 0);
                    break;
                }
                default: {
                    this.agent.throwSyntaxrm(12, 0);
                }
            }
            int n4 = 0;
            while (n4 <= this.topDdmCollectionStack) {
                int n5 = n4++;
                this.ddmCollectionLenStack[n5] = this.ddmCollectionLenStack[n5] - (long)n3;
            }
            this.dssLength -= n3;
        } else {
            if (this.ddmScalarLen < 4L) {
                this.agent.throwSyntaxrm(7, 0);
            }
            this.adjustLengths(4);
        }
        return n;
    }

    protected int readCodePoint() {
        return ((this.buffer[this.pos++] & 0xFF) << 8) + ((this.buffer[this.pos++] & 0xFF) << 0);
    }

    protected void markCollection() {
        this.ddmCollectionLenStack[++this.topDdmCollectionStack] = this.ddmScalarLen;
        this.ddmScalarLen = 0L;
    }

    protected int getCodePoint() throws DRDAProtocolException {
        if (this.topDdmCollectionStack == -1) {
            return -1;
        }
        if (this.ddmCollectionLenStack[this.topDdmCollectionStack] == 0L) {
            this.ddmCollectionLenStack[this.topDdmCollectionStack--] = 0L;
            return -1;
        }
        return this.readLengthAndCodePoint(false);
    }

    protected int getCodePoint(int n) throws DRDAProtocolException {
        int n2 = this.getCodePoint();
        if (n2 != n) {
            this.agent.missingCodePoint(n2);
        }
        return n2;
    }

    protected byte readByte() throws DRDAProtocolException {
        this.ensureBLayerDataInBuffer(1, true);
        return this.buffer[this.pos++];
    }

    protected int readUnsignedByte() throws DRDAProtocolException {
        this.ensureBLayerDataInBuffer(1, true);
        return this.buffer[this.pos++] & 0xFF;
    }

    protected int readNetworkShort() throws DRDAProtocolException {
        this.ensureBLayerDataInBuffer(2, true);
        return ((this.buffer[this.pos++] & 0xFF) << 8) + ((this.buffer[this.pos++] & 0xFF) << 0);
    }

    protected int readSignedNetworkShort() throws DRDAProtocolException {
        this.ensureBLayerDataInBuffer(2, true);
        return (short)(((this.buffer[this.pos++] & 0xFF) << 8) + ((this.buffer[this.pos++] & 0xFF) << 0));
    }

    protected short readShort(int n) throws DRDAProtocolException {
        this.ensureBLayerDataInBuffer(2, true);
        short s = SignedBinary.getShort(this.buffer, this.pos, n);
        this.pos += 2;
        return s;
    }

    protected int readNetworkInt() throws DRDAProtocolException {
        this.ensureBLayerDataInBuffer(4, true);
        return ((this.buffer[this.pos++] & 0xFF) << 24) + ((this.buffer[this.pos++] & 0xFF) << 16) + ((this.buffer[this.pos++] & 0xFF) << 8) + ((this.buffer[this.pos++] & 0xFF) << 0);
    }

    protected int readInt(int n) throws DRDAProtocolException {
        this.ensureBLayerDataInBuffer(4, true);
        int n2 = SignedBinary.getInt(this.buffer, this.pos, n);
        this.pos += 4;
        return n2;
    }

    protected long readNetworkLong() throws DRDAProtocolException {
        this.ensureBLayerDataInBuffer(8, true);
        return (((long)this.buffer[this.pos++] & 0xFFL) << 56) + (((long)this.buffer[this.pos++] & 0xFFL) << 48) + (((long)this.buffer[this.pos++] & 0xFFL) << 40) + (((long)this.buffer[this.pos++] & 0xFFL) << 32) + (((long)this.buffer[this.pos++] & 0xFFL) << 24) + (((long)this.buffer[this.pos++] & 0xFFL) << 16) + (((long)this.buffer[this.pos++] & 0xFFL) << 8) + (((long)this.buffer[this.pos++] & 0xFFL) << 0);
    }

    protected long readNetworkSixByteLong() throws DRDAProtocolException {
        this.ensureBLayerDataInBuffer(6, true);
        return (((long)this.buffer[this.pos++] & 0xFFL) << 40) + (((long)this.buffer[this.pos++] & 0xFFL) << 32) + (((long)this.buffer[this.pos++] & 0xFFL) << 24) + (((long)this.buffer[this.pos++] & 0xFFL) << 16) + (((long)this.buffer[this.pos++] & 0xFFL) << 8) + (((long)this.buffer[this.pos++] & 0xFFL) << 0);
    }

    protected long readLong(int n) throws DRDAProtocolException {
        this.ensureBLayerDataInBuffer(8, true);
        long l = SignedBinary.getLong(this.buffer, this.pos, n);
        this.pos += 8;
        return l;
    }

    protected float readFloat(int n) throws DRDAProtocolException {
        return Float.intBitsToFloat(this.readInt(n));
    }

    protected double readDouble(int n) throws DRDAProtocolException {
        return Double.longBitsToDouble(this.readLong(n));
    }

    protected BigDecimal readBigDecimal(int n, int n2) throws DRDAProtocolException {
        int n3 = n / 2 + 1;
        this.ensureBLayerDataInBuffer(n3, true);
        int n4 = (this.buffer[this.pos + n3 - 1] & 0xF) == 13 ? -1 : 1;
        if (n <= 9) {
            int n5 = this.packedNybblesToInt(this.buffer, this.pos, 0, n3 * 2 - 1);
            byte[] byArray = new byte[]{(byte)(n5 >>> 24), (byte)(n5 >>> 16), (byte)(n5 >>> 8), (byte)n5};
            this.pos += n3;
            return new BigDecimal(new BigInteger(n4, byArray), n2);
        }
        if (n <= 18) {
            long l = this.packedNybblesToLong(this.buffer, this.pos, 0, n3 * 2 - 1);
            byte[] byArray = new byte[]{(byte)(l >>> 56), (byte)(l >>> 48), (byte)(l >>> 40), (byte)(l >>> 32), (byte)(l >>> 24), (byte)(l >>> 16), (byte)(l >>> 8), (byte)l};
            this.pos += n3;
            return new BigDecimal(new BigInteger(n4, byArray), n2);
        }
        if (n <= 27) {
            int n6 = this.packedNybblesToInt(this.buffer, this.pos, (n3 - 5) * 2, 9);
            int n7 = this.packedNybblesToInt(this.buffer, this.pos, (n3 - 10) * 2 + 1, 9);
            int n8 = this.packedNybblesToInt(this.buffer, this.pos, 0, (n3 - 10) * 2 + 1);
            int[] nArray = this.computeMagnitude(new int[]{n8, n7, n6});
            byte[] byArray = new byte[]{(byte)(nArray[0] >>> 24), (byte)(nArray[0] >>> 16), (byte)(nArray[0] >>> 8), (byte)nArray[0], (byte)(nArray[1] >>> 24), (byte)(nArray[1] >>> 16), (byte)(nArray[1] >>> 8), (byte)nArray[1], (byte)(nArray[2] >>> 24), (byte)(nArray[2] >>> 16), (byte)(nArray[2] >>> 8), (byte)nArray[2]};
            this.pos += n3;
            return new BigDecimal(new BigInteger(n4, byArray), n2);
        }
        if (n <= 31) {
            int n9 = this.packedNybblesToInt(this.buffer, this.pos, (n3 - 5) * 2, 9);
            int n10 = this.packedNybblesToInt(this.buffer, this.pos, (n3 - 10) * 2 + 1, 9);
            int n11 = this.packedNybblesToInt(this.buffer, this.pos, (n3 - 14) * 2, 9);
            int n12 = this.packedNybblesToInt(this.buffer, this.pos, 0, (n3 - 14) * 2);
            int[] nArray = this.computeMagnitude(new int[]{n12, n11, n10, n9});
            byte[] byArray = new byte[]{(byte)(nArray[0] >>> 24), (byte)(nArray[0] >>> 16), (byte)(nArray[0] >>> 8), (byte)nArray[0], (byte)(nArray[1] >>> 24), (byte)(nArray[1] >>> 16), (byte)(nArray[1] >>> 8), (byte)nArray[1], (byte)(nArray[2] >>> 24), (byte)(nArray[2] >>> 16), (byte)(nArray[2] >>> 8), (byte)nArray[2], (byte)(nArray[3] >>> 24), (byte)(nArray[3] >>> 16), (byte)(nArray[3] >>> 8), (byte)nArray[3]};
            this.pos += n3;
            return new BigDecimal(new BigInteger(n4, byArray), n2);
        }
        this.pos += n3;
        throw new IllegalArgumentException("Decimal may only be up to 31 digits!");
    }

    byte[] getExtData(boolean bl) throws DRDAProtocolException {
        return this.getExtData(this.ddmScalarLen, bl);
    }

    EXTDTAReaderInputStream getEXTDTAReaderInputStream(boolean bl) throws DRDAProtocolException {
        if (bl && this.isEXTDTANull()) {
            return null;
        }
        if (this.doingLayerBStreaming) {
            return new LayerBStreamedEXTDTAReaderInputStream(this);
        }
        return new StandardEXTDTAReaderInputStream(this);
    }

    ByteArrayInputStream readLOBInitStream() throws DRDAProtocolException {
        return this.readLOBInitStream(0L);
    }

    ByteArrayInputStream readLOBInitStream(long l) throws DRDAProtocolException {
        return this.readLOBChunk(false, l);
    }

    ByteArrayInputStream readLOBContinuationStream() throws IOException {
        return this.readLOBContinuationStream(0L);
    }

    ByteArrayInputStream readLOBContinuationStream(long l) throws IOException {
        try {
            return this.readLOBChunk(true, l);
        }
        catch (DRDAProtocolException dRDAProtocolException) {
            dRDAProtocolException.printStackTrace(this.agent.getServer().logWriter);
            throw new IOException(dRDAProtocolException.getMessage());
        }
    }

    private ByteArrayInputStream readLOBChunk(boolean bl, long l) throws DRDAProtocolException {
        if (bl) {
            this.readDSSContinuationHeader();
        }
        int n = this.doingLayerBStreaming ? this.dssLength : (int)Math.min((long)this.dssLength, l);
        this.ensureALayerDataInBuffer(n);
        if (!this.doingLayerBStreaming) {
            this.adjustLengths(n);
        } else {
            this.dssLength -= n;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.buffer, this.pos, n);
        this.pos += n;
        if (this.doingLayerBStreaming && !this.dssIsContinued) {
            this.finishLayerBStreaming();
        }
        return byteArrayInputStream;
    }

    byte[] getExtData(long l, boolean bl) throws DRDAProtocolException {
        boolean bl2;
        ByteArrayOutputStream byteArrayOutputStream;
        boolean bl3 = false;
        if (l != -1L) {
            byteArrayOutputStream = new ByteArrayOutputStream((int)l);
        } else {
            byteArrayOutputStream = new ByteArrayOutputStream();
            l = Long.MAX_VALUE;
        }
        if (bl && this.isEXTDTANull()) {
            return null;
        }
        int n = (int)Math.min((long)this.dssLength, l);
        do {
            bl2 = this.dssIsContinued;
            this.ensureALayerDataInBuffer(n);
            this.adjustLengths(n);
            byteArrayOutputStream.write(this.buffer, this.pos, n);
            this.pos += n;
            l -= (long)n;
            if (bl2) {
                this.readDSSContinuationHeader();
            }
            n = (int)Math.min((long)this.dssLength, l);
        } while (bl2 && l > 0L);
        return byteArrayOutputStream.toByteArray();
    }

    private void readDSSContinuationHeader() throws DRDAProtocolException {
        this.ensureALayerDataInBuffer(2);
        this.dssLength = ((this.buffer[this.pos++] & 0xFF) << 8) + ((this.buffer[this.pos++] & 0xFF) << 0);
        if ((this.dssLength & 0x8000) == 32768) {
            this.dssLength = Short.MAX_VALUE;
            this.dssIsContinued = true;
        } else {
            this.dssIsContinued = false;
        }
        if (this.dssLength <= 2) {
            this.agent.throwSyntaxrm(22, 0);
        }
        this.dssLength -= 2;
    }

    private boolean isEXTDTANull() throws DRDAProtocolException {
        this.ensureALayerDataInBuffer(1);
        this.adjustLengths(1);
        byte by = this.buffer[this.pos++];
        return by != 0;
    }

    private int packedNybblesToInt(byte[] byArray, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = n2 / 2;
        if (n2 % 2 != 0) {
            n4 += byArray[n + n5] & 0xF;
            ++n5;
        }
        int n6 = n2 + n3 - 1;
        while (n5 < (n6 + 1) / 2) {
            n4 = n4 * 10 + ((byArray[n + n5] & 0xF0) >>> 4);
            n4 = n4 * 10 + (byArray[n + n5] & 0xF);
            ++n5;
        }
        if (n6 % 2 == 0) {
            n4 = n4 * 10 + ((byArray[n + n5] & 0xF0) >>> 4);
        }
        return n4;
    }

    private long packedNybblesToLong(byte[] byArray, int n, int n2, int n3) {
        long l = 0L;
        int n4 = n2 / 2;
        if (n2 % 2 != 0) {
            l += (long)(byArray[n + n4] & 0xF);
            ++n4;
        }
        int n5 = n2 + n3 - 1;
        while (n4 < (n5 + 1) / 2) {
            l = l * 10L + (long)((byArray[n + n4] & 0xF0) >>> 4);
            l = l * 10L + (long)(byArray[n + n4] & 0xF);
            ++n4;
        }
        if (n5 % 2 == 0) {
            l = l * 10L + (long)((byArray[n + n4] & 0xF0) >>> 4);
        }
        return l;
    }

    private int[] computeMagnitude(int[] nArray) {
        int n = nArray.length;
        int[] nArray2 = new int[n];
        nArray2[n - 1] = nArray[n - 1];
        for (int i = 0; i < n - 1; ++i) {
            int n2 = 0;
            int n3 = tenRadixMagnitude[i].length - 1;
            int n4 = n - 1;
            while (n3 >= 0) {
                long l = ((long)nArray[n - 2 - i] & 0xFFFFFFFFL) * ((long)tenRadixMagnitude[i][n3] & 0xFFFFFFFFL) + ((long)nArray2[n4] & 0xFFFFFFFFL) + ((long)n2 & 0xFFFFFFFFL);
                n2 = (int)(l >>> 32);
                nArray2[n4] = (int)(l & 0xFFFFFFFFL);
                --n3;
                --n4;
            }
            nArray2[n4] = n2;
        }
        return nArray2;
    }

    protected boolean readBoolean() throws DRDAProtocolException {
        this.ensureBLayerDataInBuffer(1, true);
        return this.buffer[this.pos++] != 0;
    }

    protected String readEncryptedString(DecryptionManager decryptionManager, int n, byte[] byArray, byte[] byArray2) throws DRDAProtocolException, SQLException {
        byte[] byArray3 = this.readBytes();
        byte[] byArray4 = null;
        byArray4 = decryptionManager.decryptData(byArray3, n, byArray, byArray2);
        if (byArray4 == null) {
            return null;
        }
        return this.ccsidManager.convertToUCS2(byArray4);
    }

    protected String readString(int n) throws DRDAProtocolException {
        this.ensureBLayerDataInBuffer(n, true);
        String string = this.ccsidManager.convertToUCS2(this.buffer, this.pos, n);
        this.pos += n;
        return string;
    }

    protected void readString(DRDAString dRDAString, int n, boolean bl) throws DRDAProtocolException {
        this.ensureBLayerDataInBuffer(n, true);
        int n2 = this.pos;
        this.pos += n;
        if (bl) {
            while (n > 0 && this.buffer[n2 + n - 1] == this.ccsidManager.space) {
                --n;
            }
        }
        dRDAString.setBytes(this.buffer, n2, n);
    }

    protected String readString(int n, String string) throws DRDAProtocolException {
        this.ensureBLayerDataInBuffer(n, true);
        String string2 = null;
        try {
            string2 = new String(this.buffer, this.pos, n, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.agent.agentError("UnsupportedEncodingException in readString, encoding = " + string);
            unsupportedEncodingException.printStackTrace(this.agent.getServer().logWriter);
        }
        this.pos += n;
        return string2;
    }

    protected String readStringData() throws DRDAProtocolException {
        return this.readString((int)this.ddmScalarLen, "UTF8");
    }

    protected String readStringData(int n) throws DRDAProtocolException {
        return this.readString(n, "UTF8");
    }

    protected String readLDStringData(String string) throws DRDAProtocolException {
        int n = this.readNetworkShort();
        return this.readString(n, string);
    }

    protected String readString() throws DRDAProtocolException {
        return this.readString((int)this.ddmScalarLen);
    }

    protected byte[] readBytes(int n) throws DRDAProtocolException {
        byte[] byArray;
        if (n < Short.MAX_VALUE) {
            this.ensureBLayerDataInBuffer(n, true);
            byArray = new byte[n];
            System.arraycopy(this.buffer, this.pos, byArray, 0, n);
            this.pos += n;
        } else {
            byArray = this.getExtData(n, false);
        }
        return byArray;
    }

    protected byte[] readBytes() throws DRDAProtocolException {
        return this.readBytes((int)this.ddmScalarLen);
    }

    protected void skipBytes(int n) throws DRDAProtocolException {
        this.ensureBLayerDataInBuffer(n, true);
        this.pos += n;
    }

    protected void skipBytes() throws DRDAProtocolException {
        this.skipBytes((int)this.ddmScalarLen);
    }

    protected void skipDss() throws DRDAProtocolException {
        while (this.dssIsContinued) {
            this.skipBytes(this.dssLength);
            this.readDSSContinuationHeader();
        }
        this.skipBytes(this.dssLength);
        this.topDdmCollectionStack = -1;
        this.ddmScalarLen = 0L;
        this.dssLength = 0;
    }

    protected void clearBuffer() throws DRDAProtocolException {
        this.skipBytes(Math.min(this.dssLength, this.count - this.pos));
        this.dssIsChainedWithSameID = false;
        this.dssIsChainedWithDiffID = false;
    }

    protected String convertBytes(byte[] byArray) {
        return this.ccsidManager.convertToUCS2(byArray, 0, byArray.length);
    }

    private void adjustLengths(int n) {
        this.ddmScalarLen -= (long)n;
        int n2 = 0;
        while (n2 <= this.topDdmCollectionStack) {
            int n3 = n2++;
            this.ddmCollectionLenStack[n3] = this.ddmCollectionLenStack[n3] - (long)n;
        }
        this.dssLength -= n;
    }

    protected String readCmdString(int n) throws DRDAProtocolException, UnsupportedEncodingException {
        if (n == 0) {
            return null;
        }
        this.ensureBLayerDataInBuffer(n, true);
        String string = new String(this.buffer, this.pos, n, "UTF8");
        this.pos += n;
        return string;
    }

    protected String readCmdString() throws DRDAProtocolException, UnsupportedEncodingException {
        int n = this.readNetworkShort();
        return this.readCmdString(n);
    }

    private void ensureALayerDataInBuffer(int n) throws DRDAProtocolException {
        int n2 = this.count - this.pos;
        if (n2 < n) {
            this.fill(n - n2);
        }
    }

    private void ensureBLayerDataInBuffer(int n, boolean bl) throws DRDAProtocolException {
        this.ensureALayerDataInBuffer(n);
        if (this.dssIsContinued && n > this.dssLength) {
            int n2 = (n - this.dssLength) / Short.MAX_VALUE + 1;
            this.compressBLayerData(n2);
        }
        if (bl) {
            this.adjustLengths(n);
        }
    }

    private void compressBLayerData(int n) throws DRDAProtocolException {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            if (n2 == 0) {
                n3 = this.pos + this.dssLength;
                continue;
            }
            n3 += Short.MAX_VALUE;
        }
        n2 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < n; ++i) {
            n5 = ((this.buffer[n3] & 0xFF) << 8) + ((this.buffer[n3 + 1] & 0xFF) << 0);
            if (i == 0) {
                if ((n5 & 0x8000) == 32768) {
                    n5 = Short.MAX_VALUE;
                    this.dssIsContinued = true;
                } else {
                    this.dssIsContinued = false;
                }
                n2 = 2;
            } else {
                if ((n5 & 0x8000) == 32768) {
                    n5 = Short.MAX_VALUE;
                } else {
                    this.agent.throwSyntaxrm(2, 0);
                }
                n2 += 2;
            }
            if (n5 <= 2) {
                this.agent.throwSyntaxrm(22, 0);
            }
            n6 += n5 - 2;
            n4 = i != n - 1 ? Short.MAX_VALUE : this.dssLength;
            System.arraycopy(this.buffer, (n3 -= n4 - 2) - n2, this.buffer, n3, n4);
        }
        this.pos = n3;
        this.dssLength += n6;
    }

    private void shiftBuffer(byte[] byArray) {
        int n = this.count - this.pos;
        System.arraycopy(this.buffer, this.pos, byArray, 0, n);
        this.pos = 0;
        this.count = n;
        this.buffer = byArray;
    }

    private void ensureSpaceInBufferForFill(int n) {
        int n2 = this.buffer.length - this.count + this.pos;
        if (n2 < n) {
            int n3 = n - n2 + this.buffer.length;
            int n4 = 2 * this.buffer.length;
            int n5 = n3 <= n4 ? n4 : n3;
            byte[] byArray = new byte[n5];
            this.shiftBuffer(byArray);
        } else if (this.pos != 0) {
            this.shiftBuffer(this.buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fill(int n) throws DRDAProtocolException {
        this.ensureSpaceInBufferForFill(n);
        int n2 = 0;
        int n3 = 0;
        do {
            try {
                n3 = this.inputStream.read(this.buffer, this.count, this.buffer.length - this.count);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                throw new DRDASocketTimeoutException(this.agent);
            }
            catch (IOException iOException) {
                this.agent.markCommunicationsFailure("DDMReader.fill()", "InputStream.read()", iOException.getMessage(), "*");
            }
            finally {
                if (this.dssTrace != null && this.dssTrace.isComBufferTraceOn()) {
                    this.dssTrace.writeComBufferData(this.buffer, this.count, n3, 2, "Request", "fill", 5);
                }
            }
            if (n3 == -1) continue;
            this.count += n3;
            n2 += n3;
        } while (n2 < n && n3 != -1);
        if (n3 == -1 && n2 < n) {
            this.agent.markCommunicationsFailure("DDMReader.fill()", "InputStream.read()", "insufficient data", "*");
        }
        this.totalByteCount += (long)n2;
    }

    private void trace(String string) {
        if (this.agent != null) {
            this.agent.trace(string);
        }
    }

    protected String toDebugString(String string) {
        String string2 = string + "***** DDMReader toDebugString ******\n";
        int n = 0;
        if (this.buffer != null) {
            n = this.buffer.length;
        }
        string2 = string2 + string + "Reader buffer length = " + this.buffer.length + "\n";
        return string2;
    }

    protected byte getCurrChainState() {
        if (!this.dssIsChainedWithSameID && !this.dssIsChainedWithDiffID) {
            return 0;
        }
        if (this.dssIsChainedWithSameID) {
            return 80;
        }
        return 64;
    }

    private void startLayerBStreaming() {
        this.doingLayerBStreaming = true;
    }

    private void finishLayerBStreaming() {
        this.doingLayerBStreaming = false;
    }

    boolean doingLayerBStreaming() {
        return this.doingLayerBStreaming;
    }
}

