/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.utils.formatting;

import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.utils.formatting.Formattable;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatter;
import org.netbeans.lib.profiler.utils.formatting.PlainFormattableMethodName;

public class DefaultMethodNameFormatter
implements MethodNameFormatter {
    public static final int VERBOSITY_CLASS = 1;
    public static final int VERBOSITY_METHOD = 2;
    public static final int VERBOSITY_CLASSMETHOD = 3;
    public static final int VERBOSITY_FULLMETHOD = 4;
    public static final int VERBOSITY_FULLCLASSMETHOD = 5;
    private static final int VERBOSITY_MIN = 1;
    private static final int VERBOSITY_MAX = 5;
    private static final int VERBOSITY_DEFAULT = 3;
    private int verbosity;

    public DefaultMethodNameFormatter(int verbosity) {
        this.verbosity = verbosity >= 1 && verbosity <= 5 ? verbosity : 3;
    }

    public DefaultMethodNameFormatter() {
        this.verbosity = 3;
    }

    public Formattable formatMethodName(String className, String methodName, String signature) {
        return new PlainFormattableMethodName(className, methodName, signature, this.verbosity);
    }

    public Formattable formatMethodName(ClientUtils.SourceCodeSelection method) {
        return new PlainFormattableMethodName(method.getClassName(), method.getMethodName(), method.getMethodSignature(), this.verbosity);
    }
}

