/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu.marking;

import java.util.Stack;
import org.netbeans.lib.profiler.global.TransactionalSupport;
import org.netbeans.lib.profiler.results.cpu.cct.CPUCCTVisitorAdapter;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.CategoryCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.marking.Mark;
import org.netbeans.lib.profiler.results.cpu.marking.MarkingEngine;

public class MarkBasedNodeVisitor
extends CPUCCTVisitorAdapter
implements MarkingEngine.StateObserver {
    volatile boolean resetFlag = false;
    private Mark parentMark = null;
    private Stack markStack;
    private final TransactionalSupport transaction = new TransactionalSupport();

    public MarkBasedNodeVisitor() {
        this.markStack = new Stack();
    }

    public void afterWalk() {
        this.markStack.clear();
        this.parentMark = null;
        this.transaction.endTrans();
    }

    public void beforeWalk() {
        this.transaction.beginTrans(true);
        this.parentMark = null;
        this.resetFlag = false;
    }

    public void beginTrans(boolean mutable) {
        this.transaction.beginTrans(mutable);
    }

    public void endTrans() {
        if (this.resetFlag) {
            this.markStack = new Stack();
            this.resetFlag = false;
        }
        this.transaction.endTrans();
    }

    public synchronized void onReset() {
        this.resetFlag = true;
        this.transaction.endTrans();
    }

    public void stateChanged(MarkingEngine instance) {
        this.reset();
    }

    public void visit(CategoryCPUCCTNode node) {
        this.parentMark = this.markStack.isEmpty() ? null : this.markStack.peek();
        this.markStack.push(node.getMark());
    }

    public void visitPost(CategoryCPUCCTNode node) {
        this.markStack.pop();
        this.parentMark = this.markStack.isEmpty() ? null : this.markStack.peek();
    }

    protected final Mark getCurrentMark() {
        return this.markStack.isEmpty() ? Mark.DEFAULT : this.markStack.peek();
    }

    protected final Mark getParentMark() {
        return this.parentMark != null ? this.parentMark : Mark.DEFAULT;
    }

    protected synchronized boolean isReset() {
        return this.resetFlag;
    }

    private void reset() {
        this.resetFlag = true;
    }
}

