/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.cpu.CPUCCTContainer;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;

public class PrestimeCPUCCTNodeBacked
extends PrestimeCPUCCTNode {
    protected int compactDataOfs;
    protected int nChildren;

    public PrestimeCPUCCTNodeBacked(CPUCCTContainer container, PrestimeCPUCCTNode parent, int compactDataOfs) {
        super(container, parent);
        this.compactDataOfs = compactDataOfs;
        this.container = container;
        this.nChildren = container.getNChildrenForNodeOfs(compactDataOfs);
    }

    protected PrestimeCPUCCTNodeBacked(CPUCCTContainer container, PrestimeCPUCCTNode[] children) {
        super(container, null);
        this.setThreadNode();
        this.children = children;
        this.nChildren = children.length;
        for (int i = 0; i < this.nChildren; ++i) {
            children[i].parent = this;
        }
    }

    protected PrestimeCPUCCTNodeBacked() {
    }

    public CCTNode getChild(int index) {
        this.getChildren();
        if (index < this.children.length) {
            return this.children[index];
        }
        return null;
    }

    public CCTNode[] getChildren() {
        if (this.nChildren == 0) {
            return null;
        }
        if (this.children != null) {
            return this.children;
        }
        int addChild = this.isThreadNode() ? 0 : 1;
        this.children = new PrestimeCPUCCTNode[this.nChildren + addChild];
        for (int i = 0; i < this.nChildren; ++i) {
            int dataOfs = this.container.getChildOfsForNodeOfs(this.compactDataOfs, i);
            this.children[i + addChild] = new PrestimeCPUCCTNodeBacked(this.container, this, dataOfs);
        }
        if (addChild > 0) {
            this.children[0] = this.createSelfTimeNodeForThisNode();
            ++this.nChildren;
        }
        this.sortChildren(this.container.getCPUResSnapshot().getSortBy(), this.container.getCPUResSnapshot().getSortOrder());
        return this.children;
    }

    public int getMethodId() {
        return this.container.getMethodIdForNodeOfs(this.compactDataOfs);
    }

    public int getNCalls() {
        return this.container.getNCallsForNodeOfs(this.compactDataOfs);
    }

    public int getNChildren() {
        if (this.children == null) {
            int addChild = this.nChildren > 0 ? (this.isThreadNode() ? 0 : 1) : 0;
            return this.nChildren + addChild;
        }
        return this.nChildren;
    }

    public long getSleepTime0() {
        return this.container.getSleepTime0ForNodeOfs(this.compactDataOfs);
    }

    public int getThreadId() {
        return this.container.getThreadId();
    }

    public long getTotalTime0() {
        if (!this.isSelfTimeNode()) {
            return this.container.getTotalTime0ForNodeOfs(this.compactDataOfs);
        }
        return this.container.getSelfTime0ForNodeOfs(this.compactDataOfs);
    }

    public float getTotalTime0InPerCent() {
        float result = (float)(this.container.getWholeGraphNetTime0() > 0L ? (double)this.getTotalTime0() / (double)this.container.getWholeGraphNetTime0() * 100.0 : 0.0);
        return result < 100.0f ? result : 100.0f;
    }

    public long getTotalTime1() {
        if (!this.isSelfTimeNode()) {
            return this.container.getTotalTime1ForNodeOfs(this.compactDataOfs);
        }
        return this.container.getSelfTime1ForNodeOfs(this.compactDataOfs);
    }

    public float getTotalTime1InPerCent() {
        return (float)(this.container.getWholeGraphNetTime1() > 0L ? (double)this.getTotalTime1() / (double)this.container.getWholeGraphNetTime1() * 100.0 : 0.0);
    }

    public long getWaitTime0() {
        return this.container.getWaitTime0ForNodeOfs(this.compactDataOfs);
    }

    public void sortChildren(int sortBy, boolean sortOrder) {
        this.container.getCPUResSnapshot().saveSortParams(sortBy, sortOrder);
        if (this.nChildren == 0 || this.children == null) {
            return;
        }
        this.doSortChildren(sortBy, sortOrder);
    }

    protected PrestimeCPUCCTNode createSelfTimeNodeForThisNode() {
        PrestimeCPUCCTNodeBacked selfTimeChild = new PrestimeCPUCCTNodeBacked();
        selfTimeChild.setSelfTimeNode();
        selfTimeChild.compactDataOfs = this.compactDataOfs;
        selfTimeChild.container = this.container;
        selfTimeChild.parent = this;
        return selfTimeChild;
    }
}

