/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.netbeans.lib.profiler.results.DataManagerListener;

public abstract class DataManager {
    private static Executor eventDispatcher = Executors.newCachedThreadPool();
    private final Set listeners = new HashSet();

    public void addDataListener(DataManagerListener listener) {
        this.listeners.add(listener);
    }

    public void removeDataListener(DataManagerListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDataChanged() {
        HashSet toNotify;
        if (this.listeners.isEmpty()) {
            return;
        }
        Set set = this.listeners;
        synchronized (set) {
            toNotify = new HashSet(this.listeners);
        }
        HashSet listenerSet = toNotify;
        Iterator iterator = toNotify.iterator();
        while (iterator.hasNext()) {
            final DataManagerListener listener = (DataManagerListener)iterator.next();
            eventDispatcher.execute(new Runnable(){

                public void run() {
                    listener.dataChanged();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDataReset() {
        HashSet toNotify;
        if (this.listeners.isEmpty()) {
            return;
        }
        Set set = this.listeners;
        synchronized (set) {
            toNotify = new HashSet(this.listeners);
        }
        HashSet listenerSet = toNotify;
        Iterator iterator = toNotify.iterator();
        while (iterator.hasNext()) {
            final DataManagerListener listener = (DataManagerListener)iterator.next();
            eventDispatcher.execute(new Runnable(){

                public void run() {
                    listener.dataReset();
                }
            });
        }
    }
}

