/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.results.DataFrameProcessor;
import org.netbeans.lib.profiler.results.ProfilingResultListener;

public abstract class AbstractDataFrameProcessor
implements DataFrameProcessor {
    protected static final Logger LOGGER = Logger.getLogger(DataFrameProcessor.class.getName());
    protected volatile ProfilerClient client = null;
    private final AtomicBoolean batchInProgress = new AtomicBoolean(false);
    private final Set listeners = Collections.synchronizedSet(new HashSet());

    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDataFrame(byte[] buffer) {
        try {
            this.fireBatchStart();
            this.doProcessDataFrame(buffer);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while processing data frame", e);
        }
        finally {
            this.fireBatchStop();
        }
    }

    public void removeAllListeners() {
        HashSet tmpListeners = new HashSet(this.listeners);
        Iterator iter = tmpListeners.iterator();
        while (iter.hasNext()) {
            ((ProfilingResultListener)iter.next()).shutdown();
        }
        this.listeners.clear();
    }

    public void reset() {
        this.fireReset();
    }

    public void shutdown() {
        this.fireBatchStop();
        this.fireShutdown();
    }

    public void startup(ProfilerClient client) {
        this.client = client;
    }

    protected void addListener(ProfilingResultListener listener) {
        this.listeners.add(listener);
    }

    protected abstract void doProcessDataFrame(byte[] var1);

    protected void fireProfilingPoint(final int threadId, final int ppId, final long timeStamp) {
        this.foreachListener(new ListenerFunctor(){

            public void execute(ProfilingResultListener listener) {
                listener.profilingPoint(threadId, ppId, timeStamp);
            }
        });
    }

    protected void fireReset() {
        this.foreachListener(new ListenerFunctor(){

            public void execute(ProfilingResultListener listener) {
                listener.reset();
            }
        });
    }

    protected void foreachListener(ListenerFunctor functor) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            functor.execute((ProfilingResultListener)iter.next());
        }
    }

    protected void removeListener(ProfilingResultListener listener) {
        listener.shutdown();
        this.listeners.remove(listener);
    }

    private void fireBatchStart() {
        this.batchInProgress.set(true);
        this.foreachListener(new ListenerFunctor(){

            public void execute(ProfilingResultListener listener) {
                listener.onBatchStart();
            }
        });
    }

    private void fireBatchStop() {
        if (this.batchInProgress.compareAndSet(true, false)) {
            this.foreachListener(new ListenerFunctor(){

                public void execute(ProfilingResultListener listener) {
                    listener.onBatchStop();
                }
            });
        }
    }

    private void fireShutdown() {
        this.foreachListener(new ListenerFunctor(){

            public void execute(ProfilingResultListener listener) {
                listener.shutdown();
            }
        });
    }

    protected static interface ListenerFunctor {
        public void execute(ProfilingResultListener var1);
    }
}

