/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.marker;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.netbeans.lib.profiler.marker.Marker;
import org.netbeans.lib.profiler.results.cpu.marking.MarkMapping;

public class CompositeMarker
implements Marker {
    private Set delegates = new LinkedHashSet();

    public CompositeMarker() {
    }

    public CompositeMarker(Set markerList) {
        this();
        this.delegates.addAll(markerList);
    }

    public MarkMapping[] getMarks() {
        HashSet<MarkMapping> markerMethods = new HashSet<MarkMapping>();
        Iterator iter = this.delegates.iterator();
        while (iter.hasNext()) {
            Marker delegate = (Marker)iter.next();
            MarkMapping[] mMethods = delegate.getMarks();
            markerMethods.addAll(Arrays.asList(mMethods));
        }
        return markerMethods.toArray(new MarkMapping[markerMethods.size()]);
    }

    public void addMarker(Marker marker) {
        if (marker == null) {
            return;
        }
        this.delegates.add(marker);
    }

    public void addMarkers(Collection markers) {
        if (markers == null) {
            return;
        }
        this.delegates.addAll(markers);
    }

    public void removeMarker(Marker marker) {
        if (marker == null) {
            return;
        }
        this.delegates.remove(marker);
    }

    public void removeMarkers(Collection markers) {
        if (markers == null) {
            return;
        }
        this.delegates.removeAll(markers);
    }
}

