/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.instrumentation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.netbeans.lib.profiler.classfile.BaseClassInfo;
import org.netbeans.lib.profiler.classfile.ClassInfo;
import org.netbeans.lib.profiler.classfile.ClassRepository;
import org.netbeans.lib.profiler.classfile.DynamicClassInfo;
import org.netbeans.lib.profiler.classfile.PlaceholderClassInfo;
import org.netbeans.lib.profiler.client.RuntimeProfilingPoint;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.instrumentation.JavaClassConstants;
import org.netbeans.lib.profiler.utils.MiscUtils;

public class ClassManager
implements JavaClassConstants,
CommonConstants {
    private static final RuntimeProfilingPoint[] EMPTY_PROFILEPOINT_ARRAY = new RuntimeProfilingPoint[0];
    private static Comparator ByBciComparator = new Comparator(){

        public int compare(Object aa, Object bb) {
            RuntimeProfilingPoint a = (RuntimeProfilingPoint)aa;
            RuntimeProfilingPoint b = (RuntimeProfilingPoint)bb;
            return a.getBci() - b.getBci();
        }
    };
    protected ProfilingSessionStatus status;

    protected ClassManager(ProfilingSessionStatus status) {
        this.status = status;
    }

    protected static RuntimeProfilingPoint[] getRuntimeProfilingPoints(RuntimeProfilingPoint[] points, ClassInfo classInfo) {
        ArrayList<RuntimeProfilingPoint> newPoints = null;
        String className = classInfo.getName().replace('/', '.');
        for (int i = 0; i < points.length; ++i) {
            RuntimeProfilingPoint point = points[i];
            if (!className.equals(point.getClassName()) || !point.resolve(classInfo)) continue;
            if (newPoints == null) {
                newPoints = new ArrayList<RuntimeProfilingPoint>(2);
            }
            newPoints.add(point);
        }
        if (newPoints == null) {
            return EMPTY_PROFILEPOINT_ARRAY;
        }
        return newPoints.toArray(new RuntimeProfilingPoint[newPoints.size()]);
    }

    protected static RuntimeProfilingPoint[] getRuntimeProfilingPoints(RuntimeProfilingPoint[] points, int methodIdx) {
        ArrayList<RuntimeProfilingPoint> newPoints = null;
        for (int i = 0; i < points.length; ++i) {
            RuntimeProfilingPoint point = points[i];
            if (point.getMethodIdx() != methodIdx) continue;
            if (newPoints == null) {
                newPoints = new ArrayList<RuntimeProfilingPoint>(2);
            }
            newPoints.add(point);
        }
        if (newPoints == null) {
            return EMPTY_PROFILEPOINT_ARRAY;
        }
        if (newPoints.size() > 1) {
            Collections.sort(newPoints, ByBciComparator);
        }
        return newPoints.toArray(new RuntimeProfilingPoint[newPoints.size()]);
    }

    protected static RuntimeProfilingPoint[] getRuntimeProfilingPoints(RuntimeProfilingPoint[] points, ClassInfo classInfo, int methodIdx) {
        ArrayList<RuntimeProfilingPoint> newPoints = null;
        String className = classInfo.getName().replace('/', '.');
        className = className.replace('$', '.');
        for (int i = 0; i < points.length; ++i) {
            RuntimeProfilingPoint point = points[i];
            if (!className.equals(point.getClassName()) || !point.resolve(classInfo) || point.getMethodIdx() != methodIdx) continue;
            if (newPoints == null) {
                newPoints = new ArrayList<RuntimeProfilingPoint>(2);
            }
            newPoints.add(point);
        }
        if (newPoints == null) {
            return EMPTY_PROFILEPOINT_ARRAY;
        }
        if (newPoints.size() > 1) {
            Collections.sort(newPoints, ByBciComparator);
        }
        return newPoints.toArray(new RuntimeProfilingPoint[newPoints.size()]);
    }

    protected static DynamicClassInfo javaClassForName(String className, int classLoaderId) {
        try {
            return ClassRepository.lookupClass(className, classLoaderId);
        }
        catch (IOException ex2) {
            MiscUtils.printWarningMessage("Error reading class " + className);
            MiscUtils.printWarningMessage(ex2.getMessage());
        }
        catch (ClassFormatError er) {
            MiscUtils.printWarningMessage(er.getMessage());
        }
        return null;
    }

    protected static BaseClassInfo javaClassForObjectArrayType(String elementTypeName) {
        BaseClassInfo clazz = ClassRepository.lookupSpecialClass("[" + elementTypeName);
        return clazz;
    }

    protected static BaseClassInfo javaClassForPrimitiveArrayType(int arrayTypeId) {
        BaseClassInfo clazz = ClassRepository.lookupSpecialClass(PRIMITIVE_ARRAY_TYPE_NAMES[arrayTypeId]);
        return clazz;
    }

    protected static BaseClassInfo javaClassOrPlaceholderForName(String className, int classLoaderId) {
        return ClassRepository.lookupClassOrCreatePlaceholder(className, classLoaderId);
    }

    protected static BaseClassInfo loadedJavaClassOrExistingPlaceholderForName(String className, int classLoaderId) {
        return ClassRepository.lookupLoadedClass(className, classLoaderId, true);
    }

    protected static void registerPlaceholder(PlaceholderClassInfo pci) {
        ClassRepository.addPlaceholder(pci);
    }

    protected static void resetLoadedClassData() {
        ClassRepository.clearCache();
    }

    protected static void storeClassFileBytesForCustomLoaderClasses(String[] loadedClasses, int[] loadedClassLoaderIds, byte[][] cachedClassFileBytes) {
        int nClasses = loadedClasses.length;
        for (int i = 0; i < nClasses; ++i) {
            if (cachedClassFileBytes[i] == null) continue;
            ClassRepository.addVMSuppliedClassFile(loadedClasses[i], loadedClassLoaderIds[i], cachedClassFileBytes[i]);
        }
    }
}

