/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import org.netbeans.lib.profiler.heap.ClassDump;
import org.netbeans.lib.profiler.heap.ClassDumpSegment;
import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.LoadClass;
import org.netbeans.lib.profiler.heap.TagBounds;

class LoadClassSegment
extends TagBounds {
    HprofHeap hprofHeap;
    final int classIDOffset;
    final int classSerialNumberOffset;
    final int lengthOffset;
    final int nameStringIDOffset;
    final int stackTraceSerialOffset;
    final int timeOffset;

    LoadClassSegment(HprofHeap heap, long start, long end) {
        super(2, start, end);
        int idSize = heap.dumpBuffer.getIDSize();
        this.hprofHeap = heap;
        this.timeOffset = 1;
        this.lengthOffset = this.timeOffset + 4;
        this.classSerialNumberOffset = this.lengthOffset + 4;
        this.classIDOffset = this.classSerialNumberOffset + 4;
        this.stackTraceSerialOffset = this.classIDOffset + idSize;
        this.nameStringIDOffset = this.stackTraceSerialOffset + 4;
    }

    LoadClass getClassByID(long classObjectID) {
        long[] offset = new long[]{this.startOffset};
        while (offset[0] < this.endOffset) {
            long start = offset[0];
            long classID = this.readLoadClassTag(offset);
            if (classID != classObjectID) continue;
            return new LoadClass(this, start);
        }
        return null;
    }

    void setLoadClassOffsets() {
        ClassDumpSegment classDumpSegment = this.hprofHeap.getClassDumpSegment();
        long[] offset = new long[]{this.startOffset};
        while (offset[0] < this.endOffset) {
            long start = offset[0];
            long classID = this.readLoadClassTag(offset);
            ClassDump classDump = classDumpSegment.getClassDumpByID(classID);
            if (classDump == null) continue;
            classDump.setClassLoadOffset(start);
        }
    }

    private HprofByteBuffer getDumpBuffer() {
        HprofByteBuffer dumpBuffer = this.hprofHeap.dumpBuffer;
        return dumpBuffer;
    }

    private long readLoadClassTag(long[] offset) {
        long start = offset[0];
        if (this.hprofHeap.readTag(offset) != 2) {
            return 0L;
        }
        return this.getDumpBuffer().getID(start + (long)this.classIDOffset);
    }
}

