/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.netbeans.lib.profiler.heap.HprofByteBuffer;

class HprofFileBuffer
extends HprofByteBuffer {
    private static final int MAX_bufferSizeBits = 17;
    private static final int MIN_bufferSizeBits = 7;
    private static final int MIN_bufferSize = 128;
    private static final int MIN_bufferSizeMask = 127;
    private static final int BUFFER_EXT = 8;
    private static int bufferSizeBits;
    private static int bufferSize;
    RandomAccessFile fis;
    private byte[] dumpBuffer;
    private long bufferStartOffset;

    HprofFileBuffer(File dumpFile) throws IOException {
        this.fis = new RandomAccessFile(dumpFile, "r");
        this.length = this.fis.length();
        this.bufferStartOffset = Long.MAX_VALUE;
        this.readHeader();
    }

    synchronized char getChar(long index) {
        int i = this.loadBufferIfNeeded(index);
        int ch1 = this.dumpBuffer[i++] & 0xFF;
        int ch2 = this.dumpBuffer[i] & 0xFF;
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    synchronized double getDouble(long index) {
        int i = this.loadBufferIfNeeded(index);
        return Double.longBitsToDouble(this.getLong(i));
    }

    synchronized float getFloat(long index) {
        int i = this.loadBufferIfNeeded(index);
        return Float.intBitsToFloat(this.getInt(i));
    }

    synchronized int getInt(long index) {
        int i = this.loadBufferIfNeeded(index);
        int ch1 = this.dumpBuffer[i++] & 0xFF;
        int ch2 = this.dumpBuffer[i++] & 0xFF;
        int ch3 = this.dumpBuffer[i++] & 0xFF;
        int ch4 = this.dumpBuffer[i] & 0xFF;
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    synchronized long getLong(long index) {
        return ((long)this.getInt(index) << 32) + ((long)this.getInt(index + 4L) & 0xFFFFFFFFL);
    }

    synchronized short getShort(long index) {
        int i = this.loadBufferIfNeeded(index);
        int ch1 = this.dumpBuffer[i++] & 0xFF;
        int ch2 = this.dumpBuffer[i] & 0xFF;
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    synchronized byte get(long index) {
        int i = this.loadBufferIfNeeded(index);
        return this.dumpBuffer[i];
    }

    synchronized void get(long position, byte[] chars) {
        int i = this.loadBufferIfNeeded(position);
        if (i + chars.length < this.dumpBuffer.length) {
            System.arraycopy(this.dumpBuffer, i, chars, 0, chars.length);
        } else {
            try {
                this.fis.seek(position);
                this.fis.readFully(chars);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void setBufferSize(long newBufferStart) {
        if (newBufferStart > this.bufferStartOffset && newBufferStart < this.bufferStartOffset + (long)(2 * bufferSize)) {
            if (bufferSizeBits < 17) {
                this.setBufferSize(bufferSizeBits + 1);
            }
        } else {
            this.setBufferSize(7);
        }
    }

    private void setBufferSize(int newBufferSizeBits) {
        bufferSizeBits = newBufferSizeBits;
        bufferSize = 1 << bufferSizeBits;
        this.dumpBuffer = new byte[bufferSize + 8];
    }

    private int loadBufferIfNeeded(long index) {
        if (index >= this.bufferStartOffset && index < this.bufferStartOffset + (long)bufferSize) {
            return (int)(index - this.bufferStartOffset);
        }
        long newBufferStart = index & 0xFFFFFFFFFFFFFF80L;
        this.setBufferSize(newBufferStart);
        try {
            this.fis.seek(newBufferStart);
            this.fis.readFully(this.dumpBuffer);
        }
        catch (EOFException ex) {
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.bufferStartOffset = newBufferStart;
        return (int)(index - this.bufferStartOffset);
    }
}

