/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.lib.profiler.heap.ClassDump;
import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.LongMap;
import org.netbeans.lib.profiler.heap.TagBounds;

class ClassDumpSegment
extends TagBounds {
    HprofHeap hprofHeap;
    Map arrayMap;
    final int classIDOffset;
    final int classLoaderIDOffset;
    final int constantPoolSizeOffset;
    final int fieldNameIDOffset;
    final int fieldSize;
    final int fieldTypeOffset;
    final int fieldValueOffset;
    final int instanceSizeOffset;
    final int minimumInstanceSize;
    final int protectionDomainIDOffset;
    final int reserved1;
    final int reserver2;
    final int signersID;
    final int stackTraceSerialNumberOffset;
    final int superClassIDOffset;
    ClassDump java_lang_Class;
    private List classes;
    private Map primitiveArrayMap;

    ClassDumpSegment(HprofHeap heap, long start, long end) {
        super(32, start, end);
        int idSize = heap.dumpBuffer.getIDSize();
        this.hprofHeap = heap;
        this.classIDOffset = 1;
        this.stackTraceSerialNumberOffset = this.classIDOffset + idSize;
        this.superClassIDOffset = this.stackTraceSerialNumberOffset + 4;
        this.classLoaderIDOffset = this.superClassIDOffset + idSize;
        this.signersID = this.classLoaderIDOffset + idSize;
        this.protectionDomainIDOffset = this.signersID + idSize;
        this.reserved1 = this.protectionDomainIDOffset + idSize;
        this.reserver2 = this.reserved1 + idSize;
        this.instanceSizeOffset = this.reserver2 + idSize;
        this.constantPoolSizeOffset = this.instanceSizeOffset + 4;
        this.fieldNameIDOffset = 0;
        this.fieldTypeOffset = this.fieldNameIDOffset + idSize;
        this.fieldValueOffset = this.fieldTypeOffset + 1;
        this.fieldSize = this.fieldTypeOffset + 1;
        this.minimumInstanceSize = 2 * idSize;
    }

    ClassDump getClassDumpByID(long classObjectID) {
        if (classObjectID == 0L) {
            return null;
        }
        LongMap.Entry entry = this.hprofHeap.idToOffsetMap.get(classObjectID);
        if (entry != null) {
            try {
                return (ClassDump)this.classes.get(entry.getIndex() - 1);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                return null;
            }
            catch (ClassCastException ex) {
                return null;
            }
        }
        return null;
    }

    JavaClass getJavaClassByName(String fqn) {
        Iterator classIt = this.classes.iterator();
        while (classIt.hasNext()) {
            ClassDump cls = (ClassDump)classIt.next();
            if (!fqn.equals(cls.getName())) continue;
            return cls;
        }
        return null;
    }

    int getMinimumInstanceSize() {
        return this.minimumInstanceSize;
    }

    ClassDump getPrimitiveArrayClass(byte type) {
        ClassDump primitiveArray = (ClassDump)this.primitiveArrayMap.get(type);
        if (primitiveArray == null) {
            throw new IllegalArgumentException("Invalid type " + type);
        }
        return primitiveArray;
    }

    Map getClassIdToClassMap() {
        HashMap<Long, ClassDump> map = new HashMap<Long, ClassDump>(this.classes.size() * 4 / 3);
        Iterator classIt = this.classes.iterator();
        while (classIt.hasNext()) {
            ClassDump cls = (ClassDump)classIt.next();
            map.put(new Long(cls.getJavaClassId()), cls);
        }
        return map;
    }

    void addInstanceSize(ClassDump cls, int tag, long instanceOffset) {
        if (tag == 34 || tag == 35) {
            Integer sizeInt = (Integer)this.arrayMap.get(cls);
            int size = 0;
            HprofByteBuffer dumpBuffer = this.hprofHeap.dumpBuffer;
            int idSize = dumpBuffer.getIDSize();
            long elementsOffset = instanceOffset + 1L + (long)idSize + 4L;
            if (sizeInt != null) {
                size = sizeInt;
            }
            int elements = dumpBuffer.getInt(elementsOffset);
            int elSize = tag == 35 ? this.hprofHeap.getValueSize(dumpBuffer.get(elementsOffset + 4L)) : idSize;
            this.arrayMap.put(cls, size += this.getMinimumInstanceSize() + elements * elSize);
        }
    }

    List createClassCollection() {
        if (this.classes != null) {
            return this.classes;
        }
        this.classes = new ArrayList(1000);
        long[] offset = new long[]{this.startOffset};
        while (offset[0] < this.endOffset) {
            long start = offset[0];
            int tag = this.hprofHeap.readDumpTag(offset);
            if (tag != 32) continue;
            ClassDump classDump = new ClassDump(this, start);
            long classId = classDump.getJavaClassId();
            this.classes.add(classDump);
            this.hprofHeap.idToOffsetMap.put(classId, start);
            this.hprofHeap.idToOffsetMap.get(classId).setIndex(this.classes.size());
        }
        this.hprofHeap.getLoadClassSegment().setLoadClassOffsets();
        this.arrayMap = new HashMap(this.classes.size() / 15);
        this.extractSpecialClasses();
        return this.classes;
    }

    List findStaticReferencesFor(long instanceId) {
        ArrayList refs = new ArrayList();
        Iterator classIt = this.classes.iterator();
        while (classIt.hasNext()) {
            ClassDump cls = (ClassDump)classIt.next();
            cls.findStaticReferencesFor(instanceId, refs);
        }
        return refs;
    }

    private void extractSpecialClasses() {
        this.primitiveArrayMap = new HashMap();
        Iterator classIt = this.classes.iterator();
        while (classIt.hasNext()) {
            ClassDump jcls = (ClassDump)classIt.next();
            String vmName = jcls.getLoadClass().getVMName();
            Integer typeObj = null;
            if (vmName.equals("[Z")) {
                typeObj = 4;
            } else if (vmName.equals("[C")) {
                typeObj = 5;
            } else if (vmName.equals("[F")) {
                typeObj = 6;
            } else if (vmName.equals("[D")) {
                typeObj = 7;
            } else if (vmName.equals("[B")) {
                typeObj = 8;
            } else if (vmName.equals("[S")) {
                typeObj = 9;
            } else if (vmName.equals("[I")) {
                typeObj = 10;
            } else if (vmName.equals("[J")) {
                typeObj = 11;
            } else if (vmName.equals("java/lang/Class")) {
                this.java_lang_Class = jcls;
            } else if (vmName.equals("boolean[]")) {
                typeObj = 4;
            } else if (vmName.equals("char[]")) {
                typeObj = 5;
            } else if (vmName.equals("float[]")) {
                typeObj = 6;
            } else if (vmName.equals("double[]")) {
                typeObj = 7;
            } else if (vmName.equals("byte[]")) {
                typeObj = 8;
            } else if (vmName.equals("short[]")) {
                typeObj = 9;
            } else if (vmName.equals("int[]")) {
                typeObj = 10;
            } else if (vmName.equals("long[]")) {
                typeObj = 11;
            } else if (vmName.equals("java.lang.Class")) {
                this.java_lang_Class = jcls;
            }
            if (typeObj == null) continue;
            this.primitiveArrayMap.put(typeObj, jcls);
        }
    }
}

