/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.util.Collections;
import java.util.List;
import org.netbeans.lib.profiler.heap.ClassDump;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;

class ClassDumpInstance
implements Instance {
    ClassDump classDump;

    ClassDumpInstance(ClassDump cls) {
        this.classDump = cls;
    }

    public List getFieldValues() {
        return Collections.EMPTY_LIST;
    }

    public boolean isGCRoot() {
        return this.classDump.getHprof().getGCRoot(this) != null;
    }

    public long getInstanceId() {
        return this.classDump.getJavaClassId();
    }

    public int getInstanceNumber() {
        return this.classDump.getHprof().idToOffsetMap.get(this.getInstanceId()).getIndex();
    }

    public JavaClass getJavaClass() {
        return this.classDump.classDumpSegment.java_lang_Class;
    }

    public Instance getNearestGCRootPointer() {
        return this.classDump.getHprof().nearestGCRoot.getNearestGCRootPointer(this);
    }

    public int getReachableSize() {
        return 0;
    }

    public List getReferences() {
        return this.classDump.getReferences();
    }

    public int getRetainedSize() {
        return 0;
    }

    public int getSize() {
        return this.getJavaClass().getInstanceSize();
    }

    public List getStaticFieldValues() {
        return this.getJavaClass().getStaticFieldValues();
    }

    public Object getValueOfField(String name) {
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClassDumpInstance) {
            return this.classDump.equals(((ClassDumpInstance)obj).classDump);
        }
        return false;
    }

    public int hashCode() {
        return this.classDump.hashCode();
    }
}

