/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.heapdump.impl;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptor;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import com.sun.tools.visualvm.core.ui.DataSourceView;
import com.sun.tools.visualvm.core.ui.components.DataViewComponent;
import com.sun.tools.visualvm.core.ui.components.ScrollableContainer;
import com.sun.tools.visualvm.heapdump.HeapDump;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.profiler.heapwalk.HeapWalker;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

class HeapDumpView
extends DataSourceView {
    private static final Logger LOGGER = Logger.getLogger(HeapDumpView.class.getName());

    public HeapDumpView(HeapDump heapDump) {
        this(heapDump, DataSourceDescriptorFactory.getDescriptor((DataSource)heapDump));
    }

    private HeapDumpView(HeapDump heapDump, DataSourceDescriptor descriptor) {
        super((DataSource)heapDump, descriptor.getName(), descriptor.getIcon(), 0, true);
    }

    protected DataViewComponent createComponent() {
        HeapDump heapDump = (HeapDump)this.getDataSource();
        DataViewComponent dvc = new DataViewComponent(new MasterViewSupport(heapDump).getMasterView(), new DataViewComponent.MasterViewConfiguration(true));
        return dvc;
    }

    private static class MasterViewSupport
    extends JPanel {
        private JLabel progressLabel;
        private JPanel contentsPanel;

        public MasterViewSupport(HeapDump heapDump) {
            this.initComponents();
            this.loadHeap(heapDump.getFile());
        }

        public DataViewComponent.MasterView getMasterView() {
            return new DataViewComponent.MasterView(NbBundle.getMessage(HeapDumpView.class, (String)"LBL_Heap_Dump"), null, (JComponent)new ScrollableContainer((JComponent)this));
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.progressLabel = new JLabel(NbBundle.getMessage(HeapDumpView.class, (String)"LBL_Loading_Heap_Dump"), 0);
            this.contentsPanel = new JPanel(new BorderLayout());
            this.contentsPanel.add((Component)this.progressLabel, "Center");
            this.contentsPanel.setBackground(Color.WHITE);
            this.add((Component)this.contentsPanel, "Center");
        }

        private void loadHeap(final File file) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    try {
                        final HeapWalker hw = new HeapWalker(file);
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                MasterViewSupport.this.contentsPanel.remove(MasterViewSupport.this.progressLabel);
                                TopComponent hwView = hw.getTopComponent();
                                hwView.setPreferredSize(new Dimension(1, 1));
                                MasterViewSupport.this.contentsPanel.add((Component)hwView, "Center");
                                MasterViewSupport.this.contentsPanel.revalidate();
                                MasterViewSupport.this.contentsPanel.repaint();
                            }
                        });
                    }
                    catch (FileNotFoundException ex) {
                        LOGGER.throwing(HeapDumpView.class.getName(), "loadHeap", ex);
                    }
                    catch (IOException ex) {
                        LOGGER.throwing(HeapDumpView.class.getName(), "loadHeap", ex);
                    }
                }
            });
        }
    }
}

