/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.monitor;

import java.awt.Color;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.lib.profiler.results.DataManagerListener;
import org.netbeans.lib.profiler.results.monitor.VMTelemetryDataManager;
import org.netbeans.lib.profiler.ui.charts.AbstractSynchronousXYChartModel;
import org.netbeans.lib.profiler.ui.monitor.VMTelemetryXYChartModelDataResetListener;

public abstract class VMTelemetryXYChartModel
extends AbstractSynchronousXYChartModel
implements DataManagerListener {
    protected VMTelemetryDataManager vmTelemetryDataManager;
    protected long[] maxYValues;
    protected long[] minYValues;
    protected Color[] seriesColors;
    protected String[] seriesNames;
    protected int itemCount = 0;
    protected int seriesCount = 0;
    protected long maxXValue = 0L;
    protected long minXValue = 0L;
    private final Set dataResetListeners = new HashSet();
    private long lastXValue = Long.MIN_VALUE;

    public VMTelemetryXYChartModel(VMTelemetryDataManager vmTelemetryDataManager) {
        this.vmTelemetryDataManager = vmTelemetryDataManager;
        vmTelemetryDataManager.addDataListener((DataManagerListener)this);
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public long getMaxDisplayYValue(int seriesIndex) {
        return this.getMaxYValue(seriesIndex);
    }

    public long getMaxXValue() {
        return this.maxXValue;
    }

    public long getMaxYValue(int seriesIndex) {
        return this.maxYValues[seriesIndex];
    }

    public long getMinDisplayYValue(int seriesIndex) {
        return 0L;
    }

    public long getMinXValue() {
        return this.minXValue;
    }

    public long getMinYValue(int seriesIndex) {
        return this.minYValues[seriesIndex];
    }

    public Color getSeriesColor(int seriesIndex) {
        return this.seriesColors[seriesIndex];
    }

    public int getSeriesCount() {
        return this.seriesCount;
    }

    public String getSeriesName(int seriesIndex) {
        return this.seriesNames[seriesIndex];
    }

    public long getXValue(int itemIndex) {
        return this.vmTelemetryDataManager.timeStamps[itemIndex];
    }

    public long getYValue(int itemIndex, int seriesIndex) {
        return this.getYValues(seriesIndex)[itemIndex];
    }

    public void addDataResetListener(VMTelemetryXYChartModelDataResetListener listener) {
        this.dataResetListeners.add(listener);
    }

    public void dataChanged() {
        int newItemCount = this.vmTelemetryDataManager.getItemCount();
        if (this.itemCount == 0) {
            if (newItemCount > 0) {
                this.minXValue = this.vmTelemetryDataManager.timeStamps[0];
                this.maxXValue = this.vmTelemetryDataManager.timeStamps[0];
                for (int seriesIndex = 0; seriesIndex < this.seriesCount; ++seriesIndex) {
                    this.minYValues[seriesIndex] = this.getYValues(seriesIndex)[0];
                    this.maxYValues[seriesIndex] = this.getYValues(seriesIndex)[0];
                }
                if (newItemCount > 1) {
                    this.processNewData(1, newItemCount - 1);
                }
            }
        } else if (newItemCount > this.itemCount) {
            this.processNewData(this.itemCount, newItemCount - 1);
        }
        this.itemCount = newItemCount;
        this.fireChartDataChanged();
    }

    public void dataReset() {
        this.itemCount = 0;
        this.minXValue = 0L;
        this.maxXValue = 0L;
        this.minYValues = new long[this.seriesCount];
        this.maxYValues = new long[this.seriesCount];
        this.lastXValue = Long.MIN_VALUE;
        this.fireChartDataReset();
    }

    public void removeDataResetListener(VMTelemetryXYChartModelDataResetListener listener) {
        this.dataResetListeners.remove(listener);
    }

    public void setupModel(String[] seriesNames, Color[] seriesColors) {
        this.seriesNames = seriesNames;
        this.seriesColors = seriesColors;
        if (seriesNames.length != seriesColors.length) {
            this.seriesCount = 0;
            throw new RuntimeException("Counts of series names and series colors don't match.");
        }
        this.seriesCount = seriesNames.length;
        this.itemCount = 0;
        this.minXValue = 0L;
        this.maxXValue = 0L;
        this.minYValues = new long[this.seriesCount];
        this.maxYValues = new long[this.seriesCount];
    }

    protected abstract long[] getYValues(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChartDataReset() {
        HashSet toNotify;
        if (this.dataResetListeners == null) {
            return;
        }
        Set set = this.dataResetListeners;
        synchronized (set) {
            toNotify = new HashSet(this.dataResetListeners);
        }
        Iterator iterator = toNotify.iterator();
        while (iterator.hasNext()) {
            ((VMTelemetryXYChartModelDataResetListener)iterator.next()).chartDataReset();
        }
    }

    private void processNewData(int startIndex, int endIndex) {
        for (int itemIndex = startIndex; itemIndex <= endIndex; ++itemIndex) {
            long newXValue = this.vmTelemetryDataManager.timeStamps[itemIndex];
            if (this.lastXValue >= newXValue) {
                System.err.println("Profiler Graphs Warning: New x-value not greater than previous x-value. Graphs may not be displayed correctly.");
            } else {
                this.maxXValue = newXValue;
            }
            this.lastXValue = newXValue;
            for (int seriesIndex = 0; seriesIndex < this.seriesCount; ++seriesIndex) {
                long newYValue = this.getYValues(seriesIndex)[itemIndex];
                this.minYValues[seriesIndex] = Math.min(this.minYValues[seriesIndex], newYValue);
                this.maxYValues[seriesIndex] = Math.max(this.maxYValues[seriesIndex], newYValue);
            }
        }
    }
}

