/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.memory;

import java.awt.AWTKeyStroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.JExtendedTable;
import org.netbeans.lib.profiler.ui.components.table.ClassNameTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.CustomBarCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.ExtendedTableModel;
import org.netbeans.lib.profiler.ui.components.table.LabelBracketTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.LabelTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.SortableTableModel;
import org.netbeans.lib.profiler.ui.memory.MemoryResUserActionsHandler;
import org.netbeans.lib.profiler.ui.memory.MemoryResultsPanel;
import org.netbeans.lib.profiler.utils.StringUtils;

public abstract class LivenessResultsPanel
extends MemoryResultsPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.memory.Bundle");
    private static final String FILTER_MENU_ITEM_NAME = messages.getString("LivenessResultsPanel_FilterMenuItemName");
    private static final String CLASS_COLUMN_NAME = messages.getString("LivenessResultsPanel_ClassColumnName");
    private static final String LIVE_BYTES_REL_COLUMN_NAME = messages.getString("LivenessResultsPanel_LiveBytesRelColumnName");
    private static final String LIVE_BYTES_COLUMN_NAME = messages.getString("LivenessResultsPanel_LiveBytesColumnName");
    private static final String LIVE_OBJECTS_COLUMN_NAME = messages.getString("LivenessResultsPanel_LiveObjectsColumnName");
    private static final String ALLOC_OBJECTS_COLUMN_NAME = messages.getString("LivenessResultsPanel_AllocObjectsColumnName");
    private static final String AVG_AGE_COLUMN_NAME = messages.getString("LivenessResultsPanel_AvgAgeColumnName");
    private static final String SURVGEN_COLUMN_NAME = messages.getString("LivenessResultsPanel_SurvGenColumnName");
    private static final String TOTAL_ALLOC_OBJECTS_COLUMN_NAME = messages.getString("LivenessResultsPanel_TotalAllocObjectsColumnName");
    private static final String CLASS_COLUMN_TOOLTIP = messages.getString("LivenessResultsPanel_ClassColumnToolTip");
    private static final String LIVE_BYTES_REL_COLUMN_TOOLTIP = messages.getString("LivenessResultsPanel_LiveBytesRelColumnToolTip");
    private static final String LIVE_BYTES_COLUMN_TOOLTIP = messages.getString("LivenessResultsPanel_LiveBytesColumnToolTip");
    private static final String LIVE_OBJECTS_COLUMN_TOOLTIP = messages.getString("LivenessResultsPanel_LiveObjectsColumnToolTip");
    private static final String ALLOC_OBJECTS_COLUMN_TOOLTIP = messages.getString("LivenessResultsPanel_AllocObjectsColumnToolTip");
    private static final String AVG_AGE_COLUMN_TOOLTIP = messages.getString("LivenessResultsPanel_AvgAgeColumnToolTip");
    private static final String SURVGEN_COLUMN_TOOLTIP = messages.getString("LivenessResultsPanel_SurvGenColumnToolTip");
    private static final String TOTAL_ALLOC_OBJECTS_COLUMN_TOOLTIP = messages.getString("LivenessResultsPanel_TotalAllocObjectsColumnToolTip");
    private static final String TABLE_ACCESS_NAME = messages.getString("LivenessResultsPanel_TableAccessName");
    protected float[] avgObjectAge;
    protected int[] maxSurvGen;
    protected int[] nTotalAllocObjects;
    protected long[] nTrackedAllocObjects;
    protected int[] nTrackedLiveObjects;
    protected long[] trackedLiveObjectsSize;
    protected int nInstrClasses;
    protected int trackedAllocObjects;
    protected int trackedLiveObjects;
    protected long nTotalTracked;
    protected long nTotalTrackedBytes;
    private int initialSortingColumn;
    private int minNamesColumnWidth;

    public LivenessResultsPanel(MemoryResUserActionsHandler actionsHandler) {
        super(actionsHandler);
        this.setDefaultSorting();
    }

    public void setDefaultSorting() {
        this.setSorting(1, false);
    }

    public void setSorting(int sColumn, boolean sOrder) {
        if (sColumn == -1) {
            this.setDefaultSorting();
        } else {
            this.initialSortingColumn = sColumn;
            this.sortBy = this.getSortBy(this.initialSortingColumn);
            this.sortOrder = sOrder;
        }
    }

    public int getSortingColumn() {
        if (this.resTableModel == null) {
            return -1;
        }
        return this.resTableModel.getRealColumn(this.resTableModel.getSortingColumn());
    }

    public boolean getSortingOrder() {
        if (this.resTableModel == null) {
            return false;
        }
        return this.resTableModel.getSortingOrder();
    }

    protected CustomBarCellRenderer getBarCellRenderer() {
        return new CustomBarCellRenderer(0L, this.maxValue);
    }

    protected void getResultsSortedByAllocObj() {
        this.getResultsSortedByClassName(true);
        int visibleLines = this.nInfoLines;
        this.nInfoLines = this.sortResults(this.nTrackedAllocObjects, (int[][])new int[][]{this.nTotalAllocObjects, this.nTrackedLiveObjects, this.maxSurvGen}, (long[][])new long[][]{this.trackedLiveObjectsSize}, (float[][])new float[][]{this.avgObjectAge}, 0, visibleLines, false);
        this.totalAllocations = 0L;
        this.trackedAllocObjects = 0;
        this.trackedLiveObjects = 0;
        for (int i = 0; i < this.nInfoLines; ++i) {
            this.trackedLiveObjects += this.nTrackedLiveObjects[i];
            this.trackedAllocObjects = (int)((long)this.trackedAllocObjects + this.nTrackedAllocObjects[i]);
            this.totalAllocations += (long)this.nTotalAllocObjects[i];
        }
    }

    protected void getResultsSortedByAvgAge() {
        this.getResultsSortedByClassName(true);
        int visibleLines = this.nInfoLines;
        this.nInfoLines = this.sortResults(this.avgObjectAge, new int[][]{this.nTotalAllocObjects, this.nTrackedLiveObjects, this.maxSurvGen}, new long[][]{this.trackedLiveObjectsSize, this.nTrackedAllocObjects}, 0, visibleLines, false);
        this.totalAllocations = 0L;
        this.trackedAllocObjects = 0;
        this.trackedLiveObjects = 0;
        for (int i = 0; i < this.nInfoLines; ++i) {
            this.trackedLiveObjects += this.nTrackedLiveObjects[i];
            this.trackedAllocObjects = (int)((long)this.trackedAllocObjects + this.nTrackedAllocObjects[i]);
            this.totalAllocations += (long)this.nTotalAllocObjects[i];
        }
    }

    protected void getResultsSortedByClassName(boolean presortOnly) {
        this.nInfoLines = this.sortResultsByClassName(new int[][]{this.nTotalAllocObjects, this.nTrackedLiveObjects, this.maxSurvGen}, new long[][]{this.trackedLiveObjectsSize, this.nTrackedAllocObjects}, new float[][]{this.avgObjectAge}, this.nTrackedItems, this.truncateZeroItems());
        if (!presortOnly) {
            this.totalAllocations = 0L;
            this.trackedAllocObjects = 0;
            this.trackedLiveObjects = 0;
            for (int i = 0; i < this.nInfoLines; ++i) {
                this.trackedLiveObjects += this.nTrackedLiveObjects[i];
                this.trackedAllocObjects = (int)((long)this.trackedAllocObjects + this.nTrackedAllocObjects[i]);
                this.totalAllocations += (long)this.nTotalAllocObjects[i];
            }
        }
    }

    protected void getResultsSortedByLiveObjNumber() {
        this.getResultsSortedByClassName(true);
        int visibleLines = this.nInfoLines;
        this.nInfoLines = this.sortResults(this.nTrackedLiveObjects, (int[][])new int[][]{this.nTotalAllocObjects, this.maxSurvGen}, (long[][])new long[][]{this.trackedLiveObjectsSize, this.nTrackedAllocObjects}, (float[][])new float[][]{this.avgObjectAge}, 0, visibleLines, false);
        this.totalAllocations = 0L;
        this.trackedAllocObjects = 0;
        this.trackedLiveObjects = 0;
        for (int i = 0; i < this.nInfoLines; ++i) {
            this.trackedLiveObjects += this.nTrackedLiveObjects[i];
            this.trackedAllocObjects = (int)((long)this.trackedAllocObjects + this.nTrackedAllocObjects[i]);
            this.totalAllocations += (long)this.nTotalAllocObjects[i];
        }
    }

    protected void getResultsSortedByLiveObjSize() {
        this.getResultsSortedByClassName(true);
        int visibleLines = this.nInfoLines;
        this.nInfoLines = this.sortResults(this.trackedLiveObjectsSize, (int[][])new int[][]{this.nTotalAllocObjects, this.nTrackedLiveObjects, this.maxSurvGen}, (long[][])new long[][]{this.nTrackedAllocObjects}, (float[][])new float[][]{this.avgObjectAge}, 0, visibleLines, false);
        this.totalAllocations = 0L;
        this.trackedAllocObjects = 0;
        this.trackedLiveObjects = 0;
        for (int i = 0; i < this.nInfoLines; ++i) {
            this.trackedLiveObjects += this.nTrackedLiveObjects[i];
            this.trackedAllocObjects = (int)((long)this.trackedAllocObjects + this.nTrackedAllocObjects[i]);
            this.totalAllocations += (long)this.nTotalAllocObjects[i];
        }
    }

    protected void getResultsSortedBySurvGen() {
        this.getResultsSortedByClassName(true);
        int visibleLines = this.nInfoLines;
        this.nInfoLines = this.sortResults(this.maxSurvGen, (int[][])new int[][]{this.nTotalAllocObjects, this.nTrackedLiveObjects}, (long[][])new long[][]{this.trackedLiveObjectsSize, this.nTrackedAllocObjects}, (float[][])new float[][]{this.avgObjectAge}, 0, visibleLines, false);
        int curSurvGen = this.maxSurvGen[0];
        int top = 0;
        while (curSurvGen > 0) {
            int bottom;
            for (bottom = top; this.maxSurvGen[bottom] == curSurvGen && bottom < this.nInfoLines; ++bottom) {
            }
            if (bottom <= top) continue;
            this.sortResults(this.trackedLiveObjectsSize, (int[][])new int[][]{this.nTrackedLiveObjects, this.nTotalAllocObjects, this.maxSurvGen}, (long[][])new long[][]{this.nTrackedAllocObjects}, (float[][])new float[][]{this.avgObjectAge}, top, bottom - top, false);
            top = bottom;
            curSurvGen = this.maxSurvGen[bottom];
        }
        this.totalAllocations = 0L;
        this.trackedAllocObjects = 0;
        this.trackedLiveObjects = 0;
        for (int i = 0; i < this.nInfoLines; ++i) {
            this.trackedLiveObjects += this.nTrackedLiveObjects[i];
            this.trackedAllocObjects = (int)((long)this.trackedAllocObjects + this.nTrackedAllocObjects[i]);
            this.totalAllocations += (long)this.nTotalAllocObjects[i];
        }
    }

    protected void getResultsSortedByTotalAllocObj() {
        this.getResultsSortedByClassName(true);
        int visibleLines = this.nInfoLines;
        this.nInfoLines = this.sortResults(this.nTotalAllocObjects, (int[][])new int[][]{this.nTrackedLiveObjects, this.maxSurvGen}, (long[][])new long[][]{this.trackedLiveObjectsSize, this.nTrackedAllocObjects}, (float[][])new float[][]{this.avgObjectAge}, 0, visibleLines, false);
        this.totalAllocations = 0L;
        this.trackedAllocObjects = 0;
        this.trackedLiveObjects = 0;
        for (int i = 0; i < this.nInfoLines; ++i) {
            this.trackedLiveObjects += this.nTrackedLiveObjects[i];
            this.trackedAllocObjects = (int)((long)this.trackedAllocObjects + this.nTrackedAllocObjects[i]);
            this.totalAllocations += (long)this.nTotalAllocObjects[i];
        }
    }

    protected JExtendedTable getResultsTable() {
        this.trackedAllocObjects = 0;
        this.trackedLiveObjects = 0;
        this.totalAllocations = 0L;
        this.sortResults();
        if (this.resTable == null) {
            this.resTableModel = new ExtendedTableModel(new SortableTableModel(){

                public String getColumnName(int col) {
                    return LivenessResultsPanel.this.columnNames[col];
                }

                public int getRowCount() {
                    return LivenessResultsPanel.this.nDisplayedItems;
                }

                public int getColumnCount() {
                    return LivenessResultsPanel.this.columnNames.length;
                }

                public Class getColumnClass(int col) {
                    return LivenessResultsPanel.this.columnTypes[col];
                }

                public Object getValueAt(int row, int col) {
                    return LivenessResultsPanel.this.computeValueAt(row, col);
                }

                public String getColumnToolTipText(int col) {
                    return LivenessResultsPanel.this.columnToolTips[col];
                }

                public void sortByColumn(int column, boolean order) {
                    LivenessResultsPanel.this.sortBy = LivenessResultsPanel.this.getSortBy(column);
                    LivenessResultsPanel.this.sortOrder = order;
                    int selectedRow = LivenessResultsPanel.this.resTable.getSelectedRow();
                    String selectedRowContents = null;
                    if (selectedRow != -1) {
                        selectedRowContents = (String)LivenessResultsPanel.this.resTable.getValueAt(selectedRow, 0);
                    }
                    LivenessResultsPanel.this.prepareResults();
                    if (selectedRowContents != null) {
                        LivenessResultsPanel.this.resTable.selectRowByContents(selectedRowContents, 0, true);
                    }
                }

                public boolean getInitialSorting(int column) {
                    switch (column) {
                        case 0: {
                            return true;
                        }
                    }
                    return false;
                }
            });
            this.resTableModel.setRealColumnVisibility(7, false);
            this.resTableModel.setRealColumnVisibility(4, false);
            this.resTableModel.setRealColumnVisibility(5, false);
            this.resTable = new JExtendedTable(this.resTableModel){

                public void doLayout() {
                    int columnsWidthsSum = 0;
                    int realFirstColumn = -1;
                    for (int i = 0; i < LivenessResultsPanel.this.resTableModel.getColumnCount(); ++i) {
                        int index = LivenessResultsPanel.this.resTableModel.getRealColumn(i);
                        if (index == 0) {
                            realFirstColumn = i;
                            continue;
                        }
                        columnsWidthsSum += this.getColumnModel().getColumn(i).getPreferredWidth();
                    }
                    if (realFirstColumn != -1) {
                        this.getColumnModel().getColumn(realFirstColumn).setPreferredWidth(Math.max(this.getWidth() - columnsWidthsSum, LivenessResultsPanel.this.minNamesColumnWidth));
                    }
                    super.doLayout();
                }
            };
            this.resTable.getAccessibleContext().setAccessibleName(TABLE_ACCESS_NAME);
            this.resTableModel.setTable(this.resTable);
            this.resTableModel.setInitialSorting(this.initialSortingColumn, this.sortOrder);
            this.resTable.setRowSelectionAllowed(true);
            this.resTable.setSelectionMode(0);
            this.resTable.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
            this.resTable.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
            this.resTable.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
            this.resTable.setShowHorizontalLines(false);
            this.resTable.setShowVerticalLines(true);
            this.resTable.setRowMargin(0);
            this.resTable.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
            HashSet<AWTKeyStroke> keys = new HashSet<AWTKeyStroke>(this.resTable.getFocusTraversalKeys(0));
            keys.add(KeyStroke.getKeyStroke(9, 0));
            this.resTable.setFocusTraversalKeys(0, keys);
            keys = new HashSet<AWTKeyStroke>(this.resTable.getFocusTraversalKeys(1));
            keys.add(KeyStroke.getKeyStroke(9, 1));
            this.resTable.setFocusTraversalKeys(1, keys);
            this.setColumnsData();
        }
        return this.resTable;
    }

    protected Object computeValueAt(int row, int col) {
        int index = (Integer)this.filteredToFullIndexes.get(row);
        switch (col) {
            case 0: {
                return this.sortedClassNames[index];
            }
            case 1: {
                return new Long(this.trackedLiveObjectsSize[index]);
            }
            case 2: {
                return this.intFormat.format(this.trackedLiveObjectsSize[index]) + " B (" + (this.nTotalTrackedBytes == 0L ? "-%" : this.percentFormat.format((float)this.trackedLiveObjectsSize[index] / (float)this.nTotalTrackedBytes)) + ")";
            }
            case 3: {
                return this.intFormat.format(this.nTrackedLiveObjects[index]) + " (" + (this.nTotalTracked == 0L ? "-%" : this.percentFormat.format((float)this.nTrackedLiveObjects[index] / (float)this.nTotalTracked)) + ")";
            }
            case 4: {
                return this.intFormat.format(this.nTrackedAllocObjects[index]);
            }
            case 5: {
                return StringUtils.floatPerCentToString((float)this.avgObjectAge[index]);
            }
            case 6: {
                return this.intFormat.format(this.maxSurvGen[index]);
            }
            case 7: {
                return this.intFormat.format(this.nTotalAllocObjects[index]);
            }
        }
        return null;
    }

    protected void initColumnSelectorItems() {
        this.headerPopup.removeAll();
        for (int i = 0; i < this.columnNames.length; ++i) {
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(this.columnNames[i]);
            menuItem.setActionCommand(new Integer(i).toString());
            this.addMenuItemListener(menuItem);
            if (this.resTable != null) {
                menuItem.setState(this.resTableModel.isRealColumnVisible(i));
                if (i == 0) {
                    menuItem.setEnabled(false);
                }
            } else {
                menuItem.setState(true);
            }
            this.headerPopup.add(menuItem);
        }
        this.headerPopup.addSeparator();
        JCheckBoxMenuItem filterMenuItem = new JCheckBoxMenuItem(FILTER_MENU_ITEM_NAME);
        filterMenuItem.setActionCommand("Filter");
        this.addMenuItemListener(filterMenuItem);
        if (this.filterComponent == null) {
            filterMenuItem.setState(true);
        } else {
            filterMenuItem.setState(this.filterComponent.isVisible());
        }
        this.headerPopup.add(filterMenuItem);
        this.headerPopup.pack();
    }

    protected void initColumnsData() {
        int maxWidth = this.getFontMetrics(this.getFont()).charWidth('W') * 10;
        this.minNamesColumnWidth = this.getFontMetrics(this.getFont()).charWidth('W') * 30;
        ClassNameTableCellRenderer classNameTableCellRenderer = new ClassNameTableCellRenderer();
        LabelTableCellRenderer labelTableCellRenderer = new LabelTableCellRenderer(11);
        LabelBracketTableCellRenderer labelBracketTableCellRenderer = new LabelBracketTableCellRenderer(11);
        this.columnNames = new String[]{CLASS_COLUMN_NAME, LIVE_BYTES_REL_COLUMN_NAME, LIVE_BYTES_COLUMN_NAME, LIVE_OBJECTS_COLUMN_NAME, ALLOC_OBJECTS_COLUMN_NAME, AVG_AGE_COLUMN_NAME, SURVGEN_COLUMN_NAME, TOTAL_ALLOC_OBJECTS_COLUMN_NAME};
        this.columnToolTips = new String[]{CLASS_COLUMN_TOOLTIP, LIVE_BYTES_REL_COLUMN_TOOLTIP, LIVE_BYTES_COLUMN_TOOLTIP, LIVE_OBJECTS_COLUMN_TOOLTIP, ALLOC_OBJECTS_COLUMN_TOOLTIP, AVG_AGE_COLUMN_TOOLTIP, SURVGEN_COLUMN_TOOLTIP, TOTAL_ALLOC_OBJECTS_COLUMN_TOOLTIP};
        this.columnTypes = new Class[]{String.class, Number.class, String.class, String.class, String.class, Number.class, Number.class, String.class};
        this.columnRenderers = new TableCellRenderer[]{classNameTableCellRenderer, null, labelBracketTableCellRenderer, labelBracketTableCellRenderer, labelTableCellRenderer, labelTableCellRenderer, labelTableCellRenderer, labelTableCellRenderer};
        this.columnWidths = new int[]{maxWidth, maxWidth, maxWidth, maxWidth, maxWidth, maxWidth, maxWidth, maxWidth};
    }

    protected boolean passesValueFilter(int i) {
        return (double)this.trackedLiveObjectsSize[i] / (double)this.nTotalTrackedBytes * 100.0 >= this.valueFilterValue;
    }

    private void setColumnsData() {
        this.barRenderer = this.getBarCellRenderer();
        TableColumnModel colModel = this.resTable.getColumnModel();
        colModel.getColumn(0).setPreferredWidth(this.minNamesColumnWidth);
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            int index = this.resTableModel.getRealColumn(i);
            if (index == 0) {
                colModel.getColumn(i).setPreferredWidth(this.minNamesColumnWidth);
            } else {
                colModel.getColumn(i).setPreferredWidth(this.columnWidths[index - 1]);
            }
            if (index == 1) {
                colModel.getColumn(i).setCellRenderer(this.barRenderer);
                continue;
            }
            colModel.getColumn(i).setCellRenderer(this.columnRenderers[index]);
        }
    }

    private int getSortBy(int column) {
        switch (column) {
            case 0: {
                return 6;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 5;
            }
            case 7: {
                return 7;
            }
        }
        return 1;
    }

    private void addMenuItemListener(JCheckBoxMenuItem menuItem) {
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("Filter")) {
                    LivenessResultsPanel.this.filterComponent.setVisible(!LivenessResultsPanel.this.filterComponent.isVisible());
                    return;
                }
                LivenessResultsPanel.this.saveColumnsData();
                boolean sortResults = false;
                int column = Integer.parseInt(e.getActionCommand());
                int sortingColumn = LivenessResultsPanel.this.resTableModel.getSortingColumn();
                int realSortingColumn = LivenessResultsPanel.this.resTableModel.getRealColumn(sortingColumn);
                boolean isColumnVisible = LivenessResultsPanel.this.resTableModel.isRealColumnVisible(column);
                if (isColumnVisible && column == realSortingColumn) {
                    sortingColumn = sortingColumn + 1 == LivenessResultsPanel.this.resTableModel.getColumnCount() ? sortingColumn - 1 : sortingColumn + 1;
                    realSortingColumn = LivenessResultsPanel.this.resTableModel.getRealColumn(sortingColumn);
                    sortResults = true;
                }
                LivenessResultsPanel.this.resTableModel.setRealColumnVisibility(column, !isColumnVisible);
                LivenessResultsPanel.this.resTable.createDefaultColumnsFromModel();
                LivenessResultsPanel.this.resTableModel.setTable(LivenessResultsPanel.this.resTable);
                sortingColumn = LivenessResultsPanel.this.resTableModel.getVirtualColumn(realSortingColumn);
                if (sortResults) {
                    LivenessResultsPanel.this.sortOrder = LivenessResultsPanel.this.resTableModel.getInitialSorting(sortingColumn);
                    LivenessResultsPanel.this.sortBy = LivenessResultsPanel.this.getSortBy(realSortingColumn);
                    LivenessResultsPanel.this.sortResults();
                    LivenessResultsPanel.this.resTable.repaint();
                }
                LivenessResultsPanel.this.resTableModel.setInitialSorting(sortingColumn, LivenessResultsPanel.this.sortOrder);
                LivenessResultsPanel.this.resTable.getTableHeader().repaint();
                LivenessResultsPanel.this.setColumnsData();
            }
        });
    }

    private void saveColumnsData() {
        TableColumnModel colModel = this.resTable.getColumnModel();
        for (int i = 0; i < this.resTableModel.getColumnCount(); ++i) {
            int index = this.resTableModel.getRealColumn(i);
            if (index == 0) continue;
            this.columnWidths[index - 1] = colModel.getColumn(i).getPreferredWidth();
        }
    }

    private void sortResults() {
        switch (this.sortBy) {
            case 6: {
                this.getResultsSortedByClassName(false);
                break;
            }
            case 1: {
                this.getResultsSortedByLiveObjSize();
                break;
            }
            case 2: {
                this.getResultsSortedByLiveObjNumber();
                break;
            }
            case 3: {
                this.getResultsSortedByAllocObj();
                break;
            }
            case 4: {
                this.getResultsSortedByAvgAge();
                break;
            }
            case 5: {
                this.getResultsSortedBySurvGen();
                break;
            }
            case 7: {
                this.getResultsSortedByTotalAllocObj();
            }
        }
        this.createFilteredIndexes();
    }
}

