/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.memory;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.instrumentation.InstrumentationException;
import org.netbeans.lib.profiler.results.memory.MemoryCCTProvider;
import org.netbeans.lib.profiler.ui.LiveResultsPanel;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.memory.ActionsHandler;
import org.netbeans.lib.profiler.ui.memory.LivenessResultsPanel;
import org.netbeans.lib.profiler.ui.memory.MemoryResUserActionsHandler;

public class LiveLivenessResultsPanel
extends LivenessResultsPanel
implements LiveResultsPanel,
ActionListener {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.memory.Bundle");
    private static final String GO_SOURCE_POPUP_ITEM_NAME = messages.getString("LiveLivenessResultsPanel_GoSourcePopupItemName");
    private static final String SHOW_STACK_TRACES_POPUP_ITEM_NAME = messages.getString("AllocResultsPanel_LiveShowStackTracesPopupItemName");
    private static final String STOP_CLASS_POPUP_ITEM_NAME = messages.getString("LiveLivenessResultsPanel_StopClassPopupItemName");
    private static final String STOP_BELOW_LINE_POPUP_ITEM_NAME = messages.getString("LiveLivenessResultsPanel_StopBelowLinePopupItemName");
    private static final String STOP_CLASS_SPEC_POPUP_ITEM_NAME = messages.getString("LiveLivenessResultsPanel_StopClassSpecPopupItemName");
    private static final String STOP_BELOW_LINE_SPEC_POPUP_ITEM_NAME = messages.getString("LiveLivenessResultsPanel_StopBelowLineSpecPopupItemName");
    private static final String LOG_CLASS_HISTORY = messages.getString("LiveResultsPanel_LogClassHistory");
    protected TargetAppRunner runner;
    ActionsHandler handler;
    private JMenuItem popupRemoveProfForClass;
    private JMenuItem popupRemoveProfForClassesBelow;
    private JMenuItem popupShowStacks;
    private JMenuItem startHisto;
    private JPopupMenu popup;
    private ProfilingSessionStatus status;
    private boolean updateResultsInProgress = false;
    private boolean updateResultsPending = false;

    public LiveLivenessResultsPanel(TargetAppRunner runner, MemoryResUserActionsHandler actionsHandler) {
        this(runner, actionsHandler, null);
    }

    public LiveLivenessResultsPanel(TargetAppRunner runner, MemoryResUserActionsHandler actionsHandler, ActionsHandler handler) {
        super(actionsHandler);
        this.runner = runner;
        this.status = runner.getProfilerClient().getStatus();
        this.initColumnsData();
        this.handler = handler;
    }

    public BufferedImage getViewImage(boolean onlyVisibleArea) {
        if (onlyVisibleArea) {
            return UIUtils.createScreenshot(this.jScrollPane);
        }
        return UIUtils.createScreenshot(this.resTable);
    }

    public String getViewName() {
        return "memory-liveness-live";
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.popupRemoveProfForClass) {
            MemoryCCTProvider olcgb = this.runner.getProfilerClient().getMemoryCCTProvider();
            boolean[] newlyUnprofiledClasses = new boolean[this.sortedClassIds.length];
            int line = (Integer)this.filteredToFullIndexes.get(this.clickedLine);
            if (!olcgb.classMarkedUnprofiled(this.sortedClassIds[line])) {
                olcgb.markClassUnprofiled(this.sortedClassIds[line]);
                newlyUnprofiledClasses[this.sortedClassIds[line]] = true;
                if (line < this.nTrackedAllocObjects.length) {
                    this.nTrackedAllocObjects[line] = 0L;
                    this.nTrackedLiveObjects[line] = 0;
                    this.trackedLiveObjectsSize[line] = 0L;
                    this.avgObjectAge[line] = 0.0f;
                    this.maxSurvGen[line] = 0;
                }
                this.nTotalAllocObjects[line] = 0;
                this.deinstrumentMemoryProfiledClasses(newlyUnprofiledClasses);
            }
            this.prepareResults();
        } else if (source == this.popupRemoveProfForClassesBelow) {
            int line = this.clickedLine;
            MemoryCCTProvider olcgb = this.runner.getProfilerClient().getMemoryCCTProvider();
            boolean[] newlyUnprofiledClasses = new boolean[this.sortedClassIds.length];
            int nClasses = this.filteredToFullIndexes.size();
            for (int i = line + 1; i < nClasses; ++i) {
                int index = (Integer)this.filteredToFullIndexes.get(i);
                if (olcgb.classMarkedUnprofiled(this.sortedClassIds[index])) continue;
                olcgb.markClassUnprofiled(this.sortedClassIds[index]);
                newlyUnprofiledClasses[this.sortedClassIds[index]] = true;
                this.nTrackedAllocObjects[index] = 0L;
                this.nTrackedLiveObjects[index] = 0;
                this.trackedLiveObjectsSize[index] = 0L;
                this.avgObjectAge[index] = 0.0f;
                this.maxSurvGen[index] = 0;
                this.nTotalAllocObjects[index] = 0;
            }
            this.deinstrumentMemoryProfiledClasses(newlyUnprofiledClasses);
            this.prepareResults();
        } else if (source == this.popupShowStacks) {
            this.actionsHandler.showStacksForClass(this.selectedClassId, this.getSortingColumn(), this.getSortingOrder());
        } else if (e.getSource() == this.startHisto && this.handler != null) {
            this.handler.performAction("history logging", new Object[]{new Integer(this.selectedClassId), this.getClassName(this.selectedClassId), Boolean.TRUE});
        }
    }

    public void fetchResultsFromTargetApp() throws ClientUtils.TargetAppOrVMTerminated {
        int i;
        MemoryCCTProvider olcgb = this.runner.getProfilerClient().getMemoryCCTProvider();
        if (olcgb == null) {
            throw new ClientUtils.TargetAppOrVMTerminated(1);
        }
        MemoryCCTProvider.ObjectNumbersContainer onc = olcgb.getLivenessObjectNumbers();
        this.nTrackedAllocObjects = onc.nTrackedAllocObjects;
        this.nTrackedLiveObjects = onc.nTrackedLiveObjects;
        this.trackedLiveObjectsSize = onc.trackedLiveObjectsSize;
        this.avgObjectAge = onc.avgObjectAge;
        this.maxSurvGen = onc.maxSurvGen;
        this.nInstrClasses = onc.nInstrClasses;
        if (this.nTrackedLiveObjects == null && this.nTrackedAllocObjects == null || this.avgObjectAge == null || this.maxSurvGen == null) {
            return;
        }
        this.nTotalAllocObjects = this.runner.getProfilerClient().getAllocatedObjectsCountResults();
        this.nTrackedItems = Math.min(this.nTrackedAllocObjects.length, this.nTrackedLiveObjects.length);
        this.nTrackedItems = Math.min(this.nTrackedItems, this.trackedLiveObjectsSize.length);
        this.nTrackedItems = Math.min(this.nTrackedItems, this.avgObjectAge.length);
        this.nTrackedItems = Math.min(this.nTrackedItems, this.maxSurvGen.length);
        this.nTrackedItems = Math.min(this.nTrackedItems, this.nInstrClasses);
        this.nTrackedItems = Math.min(this.nTrackedItems, this.nTotalAllocObjects.length);
        for (i = 0; i < this.nTrackedItems; ++i) {
            if (this.nTrackedAllocObjects[i] != -1L) continue;
            this.nTotalAllocObjects[i] = 0;
        }
        this.maxValue = 0L;
        this.nTotalTrackedBytes = 0L;
        this.nTotalTracked = 0L;
        for (i = 0; i < this.nTrackedItems; ++i) {
            if (this.maxValue < this.trackedLiveObjectsSize[i]) {
                this.maxValue = this.trackedLiveObjectsSize[i];
            }
            this.nTotalTrackedBytes += this.trackedLiveObjectsSize[i];
            this.nTotalTracked += (long)this.nTrackedLiveObjects[i];
        }
        if (this.handler != null) {
            this.handler.performAction("history update", new Object[]{this.nTrackedLiveObjects, this.nTotalAllocObjects});
        }
        this.initDataUponResultsFetch();
    }

    public boolean fitsVisibleArea() {
        return !this.jScrollPane.getVerticalScrollBar().isEnabled();
    }

    public void handleRemove() {
    }

    public void handleShutdown() {
        if (this.popup != null && this.popup.isVisible()) {
            this.updateResultsPending = false;
            this.popup.setVisible(false);
        }
    }

    public boolean hasView() {
        return this.resTable != null;
    }

    public boolean supports(int instrumentationType) {
        return instrumentationType == 5;
    }

    public void updateLiveResults() {
        if (this.popup != null && this.popup.isVisible()) {
            this.updateResultsPending = true;
            return;
        }
        if (this.updateResultsInProgress) {
            return;
        }
        this.updateResultsInProgress = true;
        String selectedRowString = null;
        if (this.resTable != null) {
            int selectedRowIndex = this.resTable.getSelectedRow();
            if (selectedRowIndex >= this.resTable.getRowCount()) {
                selectedRowIndex = -1;
                this.resTable.clearSelection();
            }
            if (selectedRowIndex != -1) {
                selectedRowString = this.resTable.getValueAt(selectedRowIndex, 0).toString();
            }
        }
        try {
            if (this.runner.getProfilingSessionStatus().targetAppRunning) {
                this.reset();
                this.fetchResultsFromTargetApp();
            }
            this.prepareResults();
            if (selectedRowString != null) {
                this.resTable.selectRowByContents(selectedRowString, 0, false);
            }
            if (this.resTable != null && this.resTable.isFocusOwner()) {
                this.resTable.requestFocusInWindow();
            }
        }
        catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
            targetAppOrVMTerminated.printStackTrace(System.err);
        }
        this.updateResultsInProgress = false;
    }

    protected String getClassName(int classId) {
        return this.status.getClassNames()[classId];
    }

    protected String[] getClassNames() {
        return this.status.getClassNames();
    }

    protected int getPercentsTracked() {
        return 100 / this.runner.getProfilerEngineSettings().getAllocTrackEvery();
    }

    protected JPopupMenu getPopupMenu() {
        if (this.popup == null) {
            this.popup = new JPopupMenu();
            Font boldfont = this.popup.getFont().deriveFont(1);
            this.popupRemoveProfForClass = new JMenuItem();
            this.popupRemoveProfForClassesBelow = new JMenuItem();
            this.popupRemoveProfForClass.setText(STOP_CLASS_POPUP_ITEM_NAME);
            this.popupRemoveProfForClassesBelow.setText(STOP_BELOW_LINE_POPUP_ITEM_NAME);
            if (this.runner.getProfilerEngineSettings().getAllocStackTraceLimit() != 0) {
                this.popup.addSeparator();
                this.popupShowStacks = new JMenuItem();
                this.popupShowStacks.setText(SHOW_STACK_TRACES_POPUP_ITEM_NAME);
                this.popup.add(this.popupShowStacks);
                this.popupShowStacks.addActionListener(this);
            }
            this.popup.addSeparator();
            this.popup.add(this.popupRemoveProfForClass);
            this.popup.add(this.popupRemoveProfForClassesBelow);
            this.popupRemoveProfForClass.addActionListener(this);
            this.popupRemoveProfForClassesBelow.addActionListener(this);
            this.popup.addSeparator();
            this.startHisto = new JMenuItem();
            this.startHisto.setText(LOG_CLASS_HISTORY);
            this.popup.add(this.startHisto);
            this.startHisto.addActionListener(this);
            this.popup.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuCanceled(PopupMenuEvent e) {
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (LiveLivenessResultsPanel.this.updateResultsPending) {
                                LiveLivenessResultsPanel.this.updateLiveResults();
                                LiveLivenessResultsPanel.this.updateResultsPending = false;
                            }
                        }
                    });
                }
            });
        }
        return this.popup;
    }

    protected void adjustFramePopupMenuTextIfNecessary() {
        String name = this.sortedClassNames[this.clickedLine];
        this.popupRemoveProfForClass.setText(MessageFormat.format(STOP_CLASS_SPEC_POPUP_ITEM_NAME, name));
        this.popupRemoveProfForClassesBelow.setText(MessageFormat.format(STOP_BELOW_LINE_SPEC_POPUP_ITEM_NAME, name));
    }

    protected void performDefaultAction(int classId) {
    }

    private void deinstrumentMemoryProfiledClasses(boolean[] newlyUnprofiledClasses) {
        try {
            this.runner.getProfilerClient().deinstrumentMemoryProfiledClasses(newlyUnprofiledClasses);
        }
        catch (InstrumentationException ex1) {
            this.runner.getAppStatusHandler().displayError(ex1.getMessage());
        }
        catch (ClientUtils.TargetAppOrVMTerminated ex2) {
            this.runner.getAppStatusHandler().displayError(ex2.getMessage());
        }
    }
}

