/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.graphs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.charts.ChartModelListener;
import org.netbeans.lib.profiler.ui.charts.SynchronousXYChart;
import org.netbeans.lib.profiler.ui.components.ColorIcon;
import org.netbeans.lib.profiler.ui.graphs.GraphPanel;
import org.netbeans.lib.profiler.ui.monitor.VMTelemetryXYChartModel;
import org.netbeans.lib.profiler.ui.monitor.VMTelemetryXYChartModelDataResetListener;

public class ThreadsGraphPanel
extends GraphPanel
implements ChartModelListener,
VMTelemetryXYChartModelDataResetListener {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.graphs.Bundle");
    private static final String THREADS_CURRENT_STRING = messages.getString("ThreadsGraphPanel_ThreadsCurrentString");
    private static final String THREADS_MAXIMUM_STRING = messages.getString("ThreadsGraphPanel_ThreadsMaximumString");
    private static final String TIME_AT_CURSOR_STRING = messages.getString("ThreadsGraphPanel_TimeAtCursorString");
    private static final String THREADS_AT_CURSOR_STRING = messages.getString("ThreadsGraphPanel_ThreadsAtCursorString");
    private static final String CLASSES_CURRENT_STRING = messages.getString("ThreadsGraphPanel_ClassesCurrentString");
    private static final String CLASSES_MAXIMUM_STRING = messages.getString("ThreadsGraphPanel_ClassesMaximumString");
    private static final String CLASSES_AT_CURSOR_STRING = messages.getString("ThreadsGraphPanel_ClassesAtCursorString");
    private static final String CHART_ACCESS_NAME = messages.getString("ThreadsGraphPanel_ChartAccessName");
    private JPanel bigLegendPanel;
    private JPanel smallLegendPanel;
    private SynchronousXYChart xyChart;
    private VMTelemetryXYChartModel threadsXYChartModel;
    private volatile boolean completeFunctionality;
    private int chartTimeLength = 180000;

    public ThreadsGraphPanel(VMTelemetryXYChartModel threadsXYChartModel, Action detailsAction) {
        this(false, null, threadsXYChartModel, null);
    }

    public ThreadsGraphPanel(boolean completeFunctionality, Color backgroundPaint, VMTelemetryXYChartModel threadsXYChartModel, final Action detailsAction) {
        this.completeFunctionality = completeFunctionality;
        this.threadsXYChartModel = threadsXYChartModel;
        threadsXYChartModel.addDataResetListener(this);
        this.setLayout(new BorderLayout());
        JLabel userThreadsBig = new JLabel(threadsXYChartModel.getSeriesName(0), new ColorIcon(threadsXYChartModel.getSeriesColor(0), Color.BLACK, 18, 9), 10);
        userThreadsBig.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        JLabel loadedClassesBig = new JLabel(threadsXYChartModel.getSeriesName(1), new ColorIcon(threadsXYChartModel.getSeriesColor(1), Color.BLACK, 18, 9), 10);
        loadedClassesBig.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.bigLegendPanel = new JPanel();
        this.bigLegendPanel.add(userThreadsBig);
        this.bigLegendPanel.add(loadedClassesBig);
        JLabel userThreadsSmall = new JLabel(threadsXYChartModel.getSeriesName(0), new ColorIcon(threadsXYChartModel.getSeriesColor(0), null, 8, 8), 10);
        userThreadsSmall.setFont(this.getFont().deriveFont((float)this.getFont().getSize() - 1.0f));
        userThreadsSmall.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        JLabel loadedClassesSmall = new JLabel(threadsXYChartModel.getSeriesName(1), new ColorIcon(threadsXYChartModel.getSeriesColor(1), null, 8, 8), 10);
        loadedClassesSmall.setFont(this.getFont().deriveFont((float)this.getFont().getSize() - 1.0f));
        loadedClassesSmall.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.smallLegendPanel = new JPanel();
        this.smallLegendPanel.setLayout(new FlowLayout(1, 0, 1));
        this.smallLegendPanel.setBackground(Color.WHITE);
        this.smallLegendPanel.setBorder(new LineBorder(new Color(235, 235, 235), 1));
        this.smallLegendPanel.add(userThreadsSmall);
        this.smallLegendPanel.add(loadedClassesSmall);
        this.xyChart = new SynchronousXYChart(1, 51, 0.01){

            public String getToolTipText(MouseEvent event) {
                return ThreadsGraphPanel.this.getChartToolTipText(event);
            }
        };
        this.xyChart.setUseSecondaryVerticalAxis(true);
        if (completeFunctionality) {
            this.xyChart.setTopChartMargin(50);
            this.xyChart.allowSelection();
            this.xyChart.setMinimumVerticalMarksDistance(50);
        } else {
            this.xyChart.setTopChartMargin(20);
            this.xyChart.denySelection();
            this.xyChart.setMinimumVerticalMarksDistance(UIManager.getFont("Panel.font").getSize() + 8);
        }
        this.chartDataReset();
        if (backgroundPaint != null) {
            this.setOpaque(true);
            this.setBackground(backgroundPaint);
            this.xyChart.setBackgroundPaint(backgroundPaint);
        }
        this.xyChart.setModel(threadsXYChartModel);
        if (!completeFunctionality) {
            threadsXYChartModel.addChartModelListener(this);
        }
        long time = System.currentTimeMillis();
        this.xyChart.setupInitialAppearance(time, time + 1200L, 0L, 2L);
        this.getAccessibleContext().setAccessibleName(CHART_ACCESS_NAME);
        this.xyChart.setAccessibleContext(this.getAccessibleContext());
        this.add(this.xyChart);
        this.xyChart.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getModifiers() == 16 && e.getClickCount() == 2 && detailsAction != null) {
                    detailsAction.actionPerformed(null);
                }
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this.xyChart);
    }

    public JPanel getBigLegendPanel() {
        return this.bigLegendPanel;
    }

    public SynchronousXYChart getChart() {
        return this.xyChart;
    }

    public String getChartToolTipText(MouseEvent event) {
        if (this.threadsXYChartModel.getItemCount() < 2) {
            return null;
        }
        StringBuffer toolTipBuffer = new StringBuffer();
        toolTipBuffer.append("<html>");
        if (!this.completeFunctionality || !this.xyChart.hasValidDataForPosition(event.getX(), event.getY())) {
            ThreadsGraphPanel.appendToolTipItem(toolTipBuffer, THREADS_CURRENT_STRING, this.intFormat.format(this.threadsXYChartModel.getYValue(this.threadsXYChartModel.getItemCount() - 1, 0)), false);
            ThreadsGraphPanel.appendToolTipItem(toolTipBuffer, THREADS_MAXIMUM_STRING, this.intFormat.format(this.threadsXYChartModel.getMaxYValue(0)), false);
            ThreadsGraphPanel.appendToolTipItem(toolTipBuffer, CLASSES_CURRENT_STRING, this.intFormat.format(this.threadsXYChartModel.getYValue(this.threadsXYChartModel.getItemCount() - 1, 1)), false);
            ThreadsGraphPanel.appendToolTipItem(toolTipBuffer, CLASSES_MAXIMUM_STRING, this.intFormat.format(this.threadsXYChartModel.getMaxYValue(1)), true);
        } else {
            ThreadsGraphPanel.appendToolTipItem(toolTipBuffer, THREADS_CURRENT_STRING, this.intFormat.format(this.threadsXYChartModel.getYValue(this.threadsXYChartModel.getItemCount() - 1, 0)), false);
            ThreadsGraphPanel.appendToolTipItem(toolTipBuffer, THREADS_MAXIMUM_STRING, this.intFormat.format(this.threadsXYChartModel.getMaxYValue(0)), false);
            ThreadsGraphPanel.appendToolTipItem(toolTipBuffer, CLASSES_CURRENT_STRING, this.intFormat.format(this.threadsXYChartModel.getYValue(this.threadsXYChartModel.getItemCount() - 1, 1)), false);
            ThreadsGraphPanel.appendToolTipItem(toolTipBuffer, CLASSES_MAXIMUM_STRING, this.intFormat.format(this.threadsXYChartModel.getMaxYValue(1)), false);
            toolTipBuffer.append("<br>");
            ThreadsGraphPanel.appendToolTipItem(toolTipBuffer, TIME_AT_CURSOR_STRING, this.xyChart.getTimeAtPosition(event.getX()), false);
            ThreadsGraphPanel.appendToolTipItem(toolTipBuffer, THREADS_AT_CURSOR_STRING, this.intFormat.format(this.xyChart.getYValueAtPosition(event.getX(), 0)), false);
            ThreadsGraphPanel.appendToolTipItem(toolTipBuffer, CLASSES_AT_CURSOR_STRING, this.intFormat.format(this.xyChart.getYValueAtPosition(event.getX(), 1)), true);
        }
        toolTipBuffer.append("</html>");
        return toolTipBuffer.toString();
    }

    public JPanel getSmallLegendPanel() {
        return this.smallLegendPanel;
    }

    public void chartDataChanged() {
        if (!this.completeFunctionality && this.xyChart.isFitToWindow() && this.threadsXYChartModel.getMaxXValue() - this.threadsXYChartModel.getMinXValue() >= (long)this.chartTimeLength) {
            UIUtils.runInEventDispatchThread(new Runnable(){

                public void run() {
                    ThreadsGraphPanel.this.xyChart.setTrackingEnd();
                }
            });
        }
    }

    public void chartDataReset() {
        UIUtils.runInEventDispatchThread(new Runnable(){

            public void run() {
                ThreadsGraphPanel.this.xyChart.resetChart();
                if (ThreadsGraphPanel.this.completeFunctionality) {
                    ThreadsGraphPanel.this.xyChart.resetTrackingEnd();
                    ThreadsGraphPanel.this.xyChart.resetFitToWindow();
                } else {
                    ThreadsGraphPanel.this.xyChart.setFitToWindow();
                }
            }
        });
    }

    private static void appendToolTipItem(StringBuffer toolTipBuffer, String itemName, String itemValue, boolean lastItem) {
        toolTipBuffer.append("&nbsp;<b>");
        toolTipBuffer.append(itemName);
        toolTipBuffer.append("</b>: ");
        toolTipBuffer.append(itemValue);
        toolTipBuffer.append("&nbsp;");
        if (!lastItem) {
            toolTipBuffer.append("<br>");
        }
    }
}

