/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.profiler.ui.UIUtils;

public class FilterComponent
extends JPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.components.Bundle");
    private static final String DEFAULT_TEXTFIELD_STRING = messages.getString("FilterComponent_DefaultTextFieldString");
    private static final String INVALID_REGEXP_STRING = messages.getString("FilterComponent_InvalidRegExpString");
    private static final String FILTER_TYPE_TOOLTIP = messages.getString("FilterComponent_FilterTypeToolTip");
    private static final String FILTER_VALUE_TOOLTIP = messages.getString("FilterComponent_FilterValueToolTip");
    private static final String SET_FILTER_BUTTON_TOOLTIP = messages.getString("FilterComponent_SetFilterButtonToolTip");
    private static final String CLEAR_FILTER_BUTTON_TOOLTIP = messages.getString("FilterComponent_ClearFilterButtonToolTip");
    private static final String FILTER_STRING_COMBO_ACCESS_NAME = messages.getString("FilterComponent_FilterStringComboAccessName");
    private static final String FILTER_STRING_COMBO_ACCESS_DESCR = messages.getString("FilterComponent_FilterStringComboAccessDescr");
    private static final String ACCESS_NAME = messages.getString("FilterComponent_AccessName");
    private static final String ACCESS_DESCR = messages.getString("FilterComponent_AccessDescr");
    private static final Color DEFAULT_TEXTFIELD_FOREGROUND = Color.GRAY;
    private static final String EMPTY_STRING = "";
    private final ImageIcon setFilterIcon = new ImageIcon(this.getClass().getResource("/org/netbeans/lib/profiler/ui/resources/setFilter.png"));
    private final Icon setFilterRolloverIcon = new ButtonBorderIcon(this.setFilterIcon);
    private final ImageIcon clearFilterIcon = new ImageIcon(this.getClass().getResource("/org/netbeans/lib/profiler/ui/resources/clearFilter.png"));
    private final Icon clearFilterRolloverIcon = new ButtonBorderIcon(this.clearFilterIcon);
    private Color textFieldForeground;
    private JButton clearFilterButton;
    private JButton filterTypeButton;
    private JButton setFilterButton;
    private JFilterStringCombo filterStringCombo;
    private JLabel incorrectRegExpLabel;
    private JMenuItem activeFilterItem;
    private JPanel setClearFilterButtonsPanel;
    private JPanel textFieldRegExpWarningPanel;
    private JPopupMenu filterTypePopup;
    private PopupItemsListener popupItemsListener;
    private String filterString = "";
    private String textFieldEmptyText = DEFAULT_TEXTFIELD_STRING;
    private Vector filterNames;
    private Vector filterStringsBuffer;
    private Vector filterTypes;
    private Vector listeners = new Vector();
    private Vector rolloverIcons;
    private Vector standardIcons;
    private boolean internalChange = false;
    private boolean textFieldEmptyFlag = true;
    private boolean validRegExpFlag = true;
    private int defaultFilterType = 20;
    private int filterType = 0;
    private int lastFilterType = -1;
    private int nOwnComboItems = 0;

    public FilterComponent() {
        this.popupItemsListener = new PopupItemsListener();
        this.standardIcons = new Vector();
        this.rolloverIcons = new Vector();
        this.filterNames = new Vector();
        this.filterTypes = new Vector();
        this.filterStringsBuffer = new Vector();
        this.initComponents();
        this.checkRegExp();
        this.updateSetClearButtons();
    }

    public int getDefaultFilterType() {
        return this.defaultFilterType;
    }

    public void setEmptyFilterText(String text) {
        if (text.length() == 0) {
            return;
        }
        String oldTextFieldEmptyText = this.textFieldEmptyText;
        this.textFieldEmptyText = text;
        if (this.filterStringCombo.getText().equals(oldTextFieldEmptyText)) {
            this.filterStringCombo.setText(this.textFieldEmptyText);
        }
    }

    public void setFilterString(String string) {
        this.setFilterString(string, true);
    }

    public String getFilterString() {
        return this.filterString;
    }

    public String[] getFilterStrings() {
        return FilterComponent.getFilterStrings(this.filterString);
    }

    public static String[] getFilterStrings(String string) {
        if (string == null) {
            return null;
        }
        return string.trim().split(" +");
    }

    public void setDefaultFilterType(int type) {
        this.defaultFilterType = type;
    }

    public void setFilterType(int type) {
        this.setFilterType(type, false);
    }

    public int getFilterType() {
        return this.filterType;
    }

    public void setFilterValues(String string, int type) {
        this.setFilterString(string, false);
        this.setFilterType(type, false);
        this.fireFilterChanged();
        this.updateSetClearButtons();
    }

    public JMenuItem addFilterItem(ImageIcon icon, String filterName, int filterType) {
        ImageIcon standardIcon = icon;
        ButtonBorderIcon rolloverIcon = new ButtonBorderIcon(icon);
        this.standardIcons.add(standardIcon);
        this.rolloverIcons.add(rolloverIcon);
        this.filterNames.add(filterName);
        this.filterTypes.add(new Integer(filterType));
        JMenuItem menuItem = new JMenuItem();
        menuItem.setText(filterName);
        menuItem.setIcon(standardIcon);
        menuItem.setBackground(UIUtils.getProfilerResultsBackground());
        menuItem.addActionListener(this.popupItemsListener);
        this.filterTypePopup.add(menuItem);
        this.filterTypePopup.pack();
        this.setFilterTypePopupItemActive(menuItem, false);
        return menuItem;
    }

    public void addFilterListener(FilterListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public JSeparator addSeparatorItem() {
        this.standardIcons.add(null);
        this.rolloverIcons.add(null);
        this.filterNames.add(null);
        this.filterTypes.add(null);
        JPopupMenu.Separator separator = new JPopupMenu.Separator();
        separator.setForeground(Color.BLACK);
        separator.setBackground(Color.WHITE);
        this.filterTypePopup.add(separator);
        this.filterTypePopup.pack();
        return separator;
    }

    public void removeFilterListener(FilterListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    private JMenuItem getFilterMenuItemByIndex(int index) {
        if (index < this.filterTypePopup.getComponentCount()) {
            return (JMenuItem)this.filterTypePopup.getComponent(index);
        }
        return null;
    }

    private void setFilterString(String string, boolean fireChange) {
        if (string == null) {
            return;
        }
        if (!this.filterString.equals(string = string.trim())) {
            this.filterString = string;
            this.filterStringCombo.setText(this.filterString);
            this.internalChange = true;
            this.addComboBoxItem(this.filterString);
            this.internalChange = false;
            if (fireChange) {
                boolean textFieldEmptyFlagBkp = this.textFieldEmptyFlag;
                this.textFieldEmptyFlag = false;
                this.fireFilterChanged();
                this.checkRegExp();
                this.updateSetClearButtons();
                this.textFieldEmptyFlag = textFieldEmptyFlagBkp;
            }
            if (this.filterString.length() > 0) {
                this.doFocusGained();
            } else {
                this.doFocusLost();
            }
        }
    }

    private void setFilterType(int type, boolean fireChange) {
        if (this.filterType != type) {
            for (int i = 0; i < this.filterTypes.size(); ++i) {
                Integer int_index = (Integer)this.filterTypes.get(i);
                if (int_index == null || int_index != type) continue;
                this.setFilterTypePopupItemActive(i, fireChange);
                return;
            }
        }
    }

    private void setFilterTypePopupItemActive(JMenuItem menuItem, boolean fireChange) {
        int index = this.filterTypePopup.getComponentIndex(menuItem);
        if (index != -1) {
            this.setFilterTypePopupItemActive(index, fireChange);
        }
    }

    private void setFilterTypePopupItemActive(int index, boolean fireChange) {
        int newFilterType = (Integer)this.filterTypes.get(index);
        if (newFilterType != this.filterType) {
            this.activeFilterItem = this.getFilterMenuItemByIndex(index);
            this.filterType = newFilterType;
            ArrowSignIcon standardIcon = new ArrowSignIcon((ImageIcon)this.standardIcons.get(index));
            ButtonBorderIcon rolloverIcon = new ButtonBorderIcon(standardIcon);
            String filterName = (String)this.filterNames.get(index);
            this.filterTypeButton.setIcon(standardIcon);
            this.filterTypeButton.setRolloverIcon(rolloverIcon);
            this.filterTypeButton.setToolTipText(MessageFormat.format(FILTER_TYPE_TOOLTIP, filterName));
            this.checkRegExp();
            if (fireChange) {
                this.fireFilterChanged();
            }
            this.updateSetClearButtons();
            this.updateComboItems();
        }
    }

    private int getIndexByCurrentFilterType() {
        return this.getIndexByFilterType(this.filterType);
    }

    private int getIndexByFilterType(int type) {
        for (int i = 0; i < this.filterTypes.size(); ++i) {
            Integer int_index = (Integer)this.filterTypes.get(i);
            if (int_index == null || int_index != type) continue;
            return i;
        }
        return -1;
    }

    private void addComboBoxItem(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (this.filterStringsBuffer.contains(string)) {
            this.filterStringsBuffer.remove(string);
        }
        this.filterStringsBuffer.add(string);
        this.updateComboItems();
    }

    private void checkRegExp() {
        if (this.filterType != 50 || this.textFieldEmptyFlag) {
            this.validRegExpFlag = true;
        } else {
            try {
                String[] filters;
                for (String filter : filters = FilterComponent.getFilterStrings(this.filterStringCombo.getText())) {
                    EMPTY_STRING.matches(filter);
                }
                this.validRegExpFlag = true;
            }
            catch (PatternSyntaxException e) {
                this.validRegExpFlag = false;
            }
        }
    }

    private void doFocusGained() {
        this.textFieldEmptyFlag = false;
        this.filterStringCombo.comboEditor.setForeground(this.textFieldForeground);
        if (this.filterStringCombo.getText().equals(this.textFieldEmptyText)) {
            this.filterStringCombo.setText(EMPTY_STRING);
        }
    }

    private void doFocusLost() {
        if (this.filterStringCombo.getText().length() == 0 && this.filterString.length() == 0) {
            this.textFieldEmptyFlag = true;
            this.filterStringCombo.setText(this.textFieldEmptyText);
            this.filterStringCombo.comboEditor.setForeground(DEFAULT_TEXTFIELD_FOREGROUND);
        }
    }

    private void fireFilterChanged() {
        if (this.validRegExpFlag) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((FilterListener)this.listeners.elementAt(i)).filterChanged();
            }
        }
        this.lastFilterType = this.filterType;
    }

    private void initComponents() {
        SetClearButtonsActionListener setClearButtonsActionListner = new SetClearButtonsActionListener();
        this.filterStringCombo = UIUtils.isMetalLookAndFeel() ? new JFilterStringCombo(){

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, this.comboEditor.getPreferredSize().height);
            }

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, this.comboEditor.getPreferredSize().height);
            }

            public Dimension getMinimumSize() {
                return new Dimension(super.getMinimumSize().width, this.comboEditor.getPreferredSize().height);
            }
        } : new JFilterStringCombo();
        this.filterStringCombo.setEditable(true);
        Border textFieldBorder = this.filterStringCombo.getBorder();
        this.filterStringCombo.setBorder(BorderFactory.createEmptyBorder(1, 5, 1, 0));
        this.filterStringCombo.setMaximumRowCount(7);
        this.filterStringCombo.addActionListener(new FilterStringComboActionListener());
        this.filterStringCombo.getAccessibleContext().setAccessibleName(FILTER_STRING_COMBO_ACCESS_NAME);
        this.filterStringCombo.getAccessibleContext().setAccessibleDescription(FILTER_STRING_COMBO_ACCESS_DESCR);
        this.filterStringCombo.setToolTipText(FILTER_VALUE_TOOLTIP);
        JTextComponent filterStringComboEditor = this.filterStringCombo.comboEditor;
        Color textFieldBackground = filterStringComboEditor.getBackground();
        this.textFieldForeground = filterStringComboEditor.getForeground();
        this.filterStringCombo.setBackground(textFieldBackground);
        filterStringComboEditor.setForeground(DEFAULT_TEXTFIELD_FOREGROUND);
        filterStringComboEditor.setText(this.textFieldEmptyText);
        filterStringComboEditor.getDocument().addDocumentListener(new FilterTextFieldDocumentListener());
        filterStringComboEditor.addKeyListener(new FilterTextFieldKeyListener());
        filterStringComboEditor.addFocusListener(new FilterTextFieldFocusListener());
        this.filterTypeButton = new JButton(EMPTY_STRING);
        this.filterTypeButton.setFocusable(false);
        this.filterTypeButton.setBorder(BorderFactory.createEmptyBorder());
        this.filterTypeButton.setBackground(textFieldBackground);
        this.filterTypeButton.setContentAreaFilled(false);
        this.filterTypeButton.addMouseListener(new FilterTypeButtonMouseListener());
        this.incorrectRegExpLabel = new JLabel(INVALID_REGEXP_STRING);
        this.incorrectRegExpLabel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        this.incorrectRegExpLabel.setBackground(textFieldBackground);
        this.incorrectRegExpLabel.setForeground(Color.RED);
        this.textFieldRegExpWarningPanel = new JPanel(new BorderLayout(0, 0));
        this.textFieldRegExpWarningPanel.setBackground(textFieldBackground);
        this.textFieldRegExpWarningPanel.add((Component)this.filterStringCombo, "Center");
        this.textFieldRegExpWarningPanel.add((Component)this.incorrectRegExpLabel, "East");
        this.setFilterButton = new JButton(EMPTY_STRING);
        this.setFilterButton.setIcon(this.setFilterIcon);
        this.setFilterButton.setRolloverIcon(this.setFilterRolloverIcon);
        this.setFilterButton.setFocusable(false);
        this.setFilterButton.setBorder(BorderFactory.createEmptyBorder());
        this.setFilterButton.setBackground(textFieldBackground);
        this.setFilterButton.setContentAreaFilled(false);
        this.setFilterButton.addActionListener(setClearButtonsActionListner);
        this.setFilterButton.setToolTipText(SET_FILTER_BUTTON_TOOLTIP);
        this.clearFilterButton = new JButton(EMPTY_STRING);
        this.clearFilterButton.setIcon(this.clearFilterIcon);
        this.clearFilterButton.setRolloverIcon(this.clearFilterRolloverIcon);
        this.clearFilterButton.setFocusable(false);
        this.clearFilterButton.setBorder(BorderFactory.createEmptyBorder());
        this.clearFilterButton.setBackground(textFieldBackground);
        this.clearFilterButton.setContentAreaFilled(false);
        this.clearFilterButton.addActionListener(setClearButtonsActionListner);
        this.clearFilterButton.setToolTipText(CLEAR_FILTER_BUTTON_TOOLTIP);
        this.setClearFilterButtonsPanel = new JPanel(new BorderLayout(0, 0));
        this.setClearFilterButtonsPanel.setBackground(textFieldBackground);
        this.setClearFilterButtonsPanel.add((Component)this.setFilterButton, "West");
        this.setClearFilterButtonsPanel.add((Component)this.clearFilterButton, "East");
        this.filterTypePopup = new JPopupMenu(){

            public void setVisible(boolean visible) {
                super.setVisible(visible);
                if (visible) {
                    MenuElement[] me = FilterComponent.this.activeFilterItem != null ? new MenuElement[]{this, FilterComponent.this.activeFilterItem} : new MenuElement[]{this};
                    MenuSelectionManager.defaultManager().setSelectedPath(me);
                }
            }
        };
        this.filterTypePopup.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.filterTypePopup.setBackground(UIUtils.getProfilerResultsBackground());
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createCompoundBorder(textFieldBorder, BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.setBackground(textFieldBackground);
        this.add((Component)this.filterTypeButton, "West");
        this.add((Component)this.textFieldRegExpWarningPanel, "Center");
        this.add((Component)this.setClearFilterButtonsPanel, "East");
        this.getAccessibleContext().setAccessibleName(ACCESS_NAME);
        this.getAccessibleContext().setAccessibleDescription(ACCESS_DESCR);
    }

    private void performClearFilterButtonAction() {
        this.filterString = EMPTY_STRING;
        this.filterStringCombo.setText(this.filterString);
        this.setFilterType(this.defaultFilterType, false);
        this.fireFilterChanged();
        this.updateSetClearButtons();
    }

    private void performSetFilterButtonAction() {
        this.filterStringCombo.setText(this.filterStringCombo.getText().trim());
        String newFilterString = this.filterStringCombo.getText();
        if (!newFilterString.equals(this.filterString) || this.lastFilterType != this.filterType) {
            this.filterString = newFilterString;
            this.addComboBoxItem(this.filterString);
            this.fireFilterChanged();
            this.updateSetClearButtons();
        }
    }

    private void updateComboItems() {
        String currentFilterString = this.filterStringCombo.getText();
        this.filterStringCombo.removeAllItems();
        for (int i = this.filterStringsBuffer.size() - 1; i >= 0; --i) {
            this.filterStringCombo.addItem(this.filterStringsBuffer.get(i));
        }
        this.filterStringCombo.setText(currentFilterString);
    }

    private void updateSetClearButtons() {
        if (this.validRegExpFlag) {
            if (this.incorrectRegExpLabel.isVisible()) {
                this.incorrectRegExpLabel.setVisible(false);
            }
        } else {
            if (!this.incorrectRegExpLabel.isVisible()) {
                this.incorrectRegExpLabel.setVisible(true);
            }
            if (this.clearFilterButton.isVisible()) {
                this.clearFilterButton.setVisible(false);
            }
            if (this.setFilterButton.isVisible()) {
                this.setFilterButton.setVisible(false);
            }
            this.updateSetClearFilterButtonsPanelBorder();
            return;
        }
        if (this.textFieldEmptyFlag) {
            if (this.clearFilterButton.isVisible()) {
                this.clearFilterButton.setVisible(false);
            }
            if (this.setFilterButton.isVisible()) {
                this.setFilterButton.setVisible(false);
            }
            this.updateSetClearFilterButtonsPanelBorder();
            return;
        }
        if (this.filterString.length() == 0) {
            if (this.clearFilterButton.isVisible()) {
                this.clearFilterButton.setVisible(false);
            }
        } else if (!this.clearFilterButton.isVisible()) {
            this.clearFilterButton.setVisible(true);
        }
        if (this.filterStringCombo.getText().equals(this.filterString) && this.lastFilterType == this.filterType || this.filterStringCombo.getText().length() == 0) {
            if (this.setFilterButton.isVisible()) {
                this.setFilterButton.setVisible(false);
            }
        } else if (!this.setFilterButton.isVisible()) {
            if (this.clearFilterButton.isVisible()) {
                ((BorderLayout)this.setClearFilterButtonsPanel.getLayout()).setHgap(1);
            } else {
                ((BorderLayout)this.setClearFilterButtonsPanel.getLayout()).setHgap(0);
            }
            this.setFilterButton.setVisible(true);
        }
        this.updateSetClearFilterButtonsPanelBorder();
    }

    private void updateSetClearFilterButtonsPanelBorder() {
        if (this.clearFilterButton.isVisible() || this.setFilterButton.isVisible()) {
            this.setClearFilterButtonsPanel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        } else {
            this.setClearFilterButtonsPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }
    }

    private class SetClearButtonsActionListener
    implements ActionListener {
        private SetClearButtonsActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == FilterComponent.this.setFilterButton) {
                FilterComponent.this.performSetFilterButtonAction();
                FilterComponent.this.filterStringCombo.requestFocus();
                return;
            }
            if (e.getSource() == FilterComponent.this.clearFilterButton) {
                FilterComponent.this.performClearFilterButtonAction();
                FilterComponent.this.filterStringCombo.requestFocus();
                return;
            }
        }
    }

    private class PopupItemsListener
    implements ActionListener {
        private PopupItemsListener() {
        }

        public void actionPerformed(ActionEvent e) {
            FilterComponent.this.setFilterTypePopupItemActive((JMenuItem)e.getSource(), false);
            FilterComponent.this.filterStringCombo.requestFocus();
        }
    }

    private class JFilterStringCombo
    extends JComboBox {
        public JTextComponent comboEditor = (JTextComponent)this.getEditor().getEditorComponent();
        public boolean comboPopupActionFlag = false;
        public boolean comboPopupKeyFlag = false;

        public JFilterStringCombo() {
            this.setRenderer(new FilterStringComboRenderer());
            this.addPopupMenuListener(new FilterStringComboPopupMenuListener());
        }

        public void setText(String text) {
            this.comboEditor.setText(text);
        }

        public String getText() {
            return this.comboEditor.getText();
        }

        public void clearSelection() {
            this.comboEditor.setSelectionStart(this.comboEditor.getCaretPosition());
            this.comboEditor.setSelectionEnd(this.comboEditor.getCaretPosition());
        }
    }

    private class FilterTypeButtonMouseListener
    extends MouseAdapter {
        private FilterTypeButtonMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            FilterComponent.this.filterTypePopup.show(FilterComponent.this, 1, FilterComponent.this.getHeight() - 2);
        }
    }

    private class FilterTextFieldKeyListener
    extends KeyAdapter {
        private FilterTextFieldKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            ((FilterComponent)FilterComponent.this).filterStringCombo.comboPopupKeyFlag = true;
            if (e.getKeyCode() == 10) {
                FilterComponent.this.performSetFilterButtonAction();
                FilterComponent.this.filterStringCombo.clearSelection();
                return;
            }
            if (e.getKeyCode() == 27) {
                FilterComponent.this.filterStringCombo.setText(FilterComponent.this.filterString);
                FilterComponent.this.updateSetClearButtons();
                return;
            }
            if (e.getModifiers() == 1 && (e.getKeyCode() == 38 || e.getKeyCode() == 40)) {
                FilterComponent.this.filterTypePopup.show(FilterComponent.this, 1, FilterComponent.this.getHeight() - 2);
                return;
            }
        }

        public void keyReleased(KeyEvent e) {
            ((FilterComponent)FilterComponent.this).filterStringCombo.comboPopupKeyFlag = false;
        }
    }

    private class FilterTextFieldFocusListener
    implements FocusListener {
        private FilterTextFieldFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            FilterComponent.this.doFocusGained();
        }

        public void focusLost(FocusEvent e) {
            FilterComponent.this.doFocusLost();
        }
    }

    private class FilterTextFieldDocumentListener
    implements DocumentListener {
        private FilterTextFieldDocumentListener() {
        }

        public void changedUpdate(DocumentEvent e) {
            if (((FilterComponent)FilterComponent.this).filterStringCombo.comboPopupActionFlag) {
                return;
            }
            FilterComponent.this.checkRegExp();
            FilterComponent.this.updateSetClearButtons();
        }

        public void insertUpdate(DocumentEvent e) {
            if (((FilterComponent)FilterComponent.this).filterStringCombo.comboPopupActionFlag) {
                return;
            }
            FilterComponent.this.checkRegExp();
            FilterComponent.this.updateSetClearButtons();
        }

        public void removeUpdate(DocumentEvent e) {
            if (((FilterComponent)FilterComponent.this).filterStringCombo.comboPopupActionFlag) {
                return;
            }
            FilterComponent.this.checkRegExp();
            FilterComponent.this.updateSetClearButtons();
        }
    }

    private class FilterStringComboRenderer
    extends DefaultListCellRenderer {
        private JSeparator separator = new JSeparator();

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JComponent renderer = (JComponent)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            renderer.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0), renderer.getBorder()));
            return renderer;
        }
    }

    private class FilterStringComboPopupMenuListener
    implements PopupMenuListener {
        private FilterStringComboPopupMenuListener() {
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
            ((FilterComponent)FilterComponent.this).filterStringCombo.comboPopupActionFlag = false;
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            ((FilterComponent)FilterComponent.this).filterStringCombo.comboPopupActionFlag = false;
            FilterComponent.this.filterStringCombo.clearSelection();
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            ((FilterComponent)FilterComponent.this).filterStringCombo.comboPopupActionFlag = true;
        }
    }

    private class FilterStringComboActionListener
    implements ActionListener {
        private FilterStringComboActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (FilterComponent.this.internalChange) {
                return;
            }
            String string = (String)FilterComponent.this.filterStringCombo.getSelectedItem();
            if (string == null || string.equals(FilterComponent.EMPTY_STRING)) {
                return;
            }
            if (((FilterComponent)FilterComponent.this).filterStringCombo.comboPopupKeyFlag || !((FilterComponent)FilterComponent.this).filterStringCombo.comboPopupActionFlag) {
                return;
            }
            FilterComponent.this.setFilterString(string);
            FilterComponent.this.updateSetClearButtons();
        }
    }

    private static class ButtonBorderIcon
    implements Icon {
        private Color BUTTON_BORDER_DARK = new Color(115, 115, 115);
        private Color BUTTON_BORDER_LIGHT = new Color(204, 204, 204);
        private Icon icon;

        public ButtonBorderIcon(Icon icon) {
            this.icon = icon;
        }

        public int getIconHeight() {
            return this.icon.getIconHeight();
        }

        public int getIconWidth() {
            return this.icon.getIconWidth();
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.icon.paintIcon(c, g, x, y);
            g.setColor(this.BUTTON_BORDER_DARK);
            g.drawLine(x + this.icon.getIconWidth() - 1, y, x + this.icon.getIconWidth() - 1, y + this.icon.getIconHeight() - 1);
            g.drawLine(x, y + this.icon.getIconHeight() - 1, x + this.icon.getIconWidth() - 1, y + this.icon.getIconHeight() - 1);
            g.setColor(this.BUTTON_BORDER_LIGHT);
            g.drawLine(x, y, x + this.icon.getIconWidth() - 1, y);
            g.drawLine(x, y, x, y + this.icon.getIconHeight() - 1);
        }
    }

    private class ArrowSignIcon
    implements Icon {
        private final ImageIcon popupArrowIcon = new ImageIcon(this.getClass().getResource("/org/netbeans/lib/profiler/ui/resources/popupArrow.png"));
        private Icon icon;

        public ArrowSignIcon(Icon icon) {
            this.icon = icon;
        }

        public int getIconHeight() {
            return this.icon.getIconHeight();
        }

        public int getIconWidth() {
            return this.icon.getIconWidth();
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.icon.paintIcon(c, g, x, y);
            this.popupArrowIcon.paintIcon(c, g, x + this.icon.getIconWidth() - this.popupArrowIcon.getIconWidth(), y + this.icon.getIconHeight() - this.popupArrowIcon.getIconHeight());
        }
    }

    public static interface FilterListener {
        public void filterChanged();
    }
}

