/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.ui.UIUtils;

public abstract class SwingWorker {
    private static ExecutorService warmupService;
    private static ExecutorService taskService;
    private final Object warmupLock = new Object();
    private boolean useEQ;
    private boolean workerRunning;
    private Runnable warmupTimer = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = SwingWorker.this.warmupLock;
            synchronized (object) {
                try {
                    if (SwingWorker.this.workerRunning) {
                        SwingWorker.this.warmupLock.wait(SwingWorker.this.getWarmup());
                    }
                    if (SwingWorker.this.workerRunning) {
                        SwingWorker.this.nonResponding();
                    }
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        }
    };

    public SwingWorker(boolean forceEQ) {
        SwingWorker.sinit();
        this.useEQ = forceEQ;
    }

    public SwingWorker() {
        this(true);
    }

    public void execute() {
        this.postRunnable(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = SwingWorker.this.warmupLock;
                synchronized (object) {
                    SwingWorker.this.workerRunning = true;
                }
                warmupService.submit(SwingWorker.this.warmupTimer);
                try {
                    SwingWorker.this.doInBackground();
                }
                catch (Throwable throwable) {
                    Object object2 = SwingWorker.this.warmupLock;
                    synchronized (object2) {
                        SwingWorker.this.workerRunning = false;
                        SwingWorker.this.warmupLock.notify();
                    }
                    if (SwingWorker.this.useEQ) {
                        SwingWorker.runInEventDispatchThread(new Runnable(){

                            public void run() {
                                SwingWorker.this.done();
                            }
                        });
                    } else {
                        SwingWorker.this.done();
                    }
                    throw throwable;
                }
                object = SwingWorker.this.warmupLock;
                synchronized (object) {
                    SwingWorker.this.workerRunning = false;
                    SwingWorker.this.warmupLock.notify();
                }
                if (SwingWorker.this.useEQ) {
                    SwingWorker.runInEventDispatchThread(new /* invalid duplicate definition of identical inner class */);
                } else {
                    SwingWorker.this.done();
                }
            }
        });
    }

    protected int getWarmup() {
        return 500;
    }

    protected abstract void doInBackground();

    protected void done() {
    }

    protected void nonResponding() {
    }

    protected void postRunnable(Runnable runnable) {
        taskService.submit(runnable);
    }

    static synchronized void sinit() {
        if (warmupService == null) {
            UIUtils.runInEventDispatchThreadAndWait(new Runnable(){

                public void run() {
                    warmupService = Executors.newCachedThreadPool();
                    taskService = Executors.newCachedThreadPool();
                }
            });
        }
    }

    private static void runInEventDispatchThread(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    private static void runInEventDispatchThreadAndWait(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }
}

