/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.stp;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.ui.HyperlinkTextArea;
import org.netbeans.modules.profiler.ui.stp.ProfilingSettingsManager;
import org.netbeans.modules.profiler.ui.stp.SelectProfilingTask;
import org.netbeans.modules.profiler.ui.stp.TaskChooser;
import org.netbeans.modules.profiler.ui.stp.Utils;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskPresenter
implements TaskChooser.Item {
    private static final String CREATE_CUSTOM_STRING = NbBundle.getMessage(TaskPresenter.class, (String)"TaskPresenter_CreateCustomString");
    private static final String RENAME_ITEM_TEXT = NbBundle.getMessage(TaskPresenter.class, (String)"TaskPresenter_RenameItemText");
    private static final String DUPLICATE_ITEM_TEXT = NbBundle.getMessage(TaskPresenter.class, (String)"TaskPresenter_DuplicateItemText");
    private static final String DELETE_ITEM_TEXT = NbBundle.getMessage(TaskPresenter.class, (String)"TaskPresenter_DeleteItemText");
    private static final String MOVE_UP_ITEM_TEXT = NbBundle.getMessage(TaskPresenter.class, (String)"TaskPresenter_MoveUpItemText");
    private static final String MOVE_DOWN_ITEM_TEXT = NbBundle.getMessage(TaskPresenter.class, (String)"TaskPresenter_MoveDownItemText");
    private static final String CREATE_CUSTOM_TOOLTIP = NbBundle.getMessage(TaskPresenter.class, (String)"TaskPresenter_CreateCustomToolTip");
    private Context context;
    private Icon icon;
    private LargeTaskPresenter largeTaskPresenter;
    private SmallTaskPresenter smallTaskPresenter;
    private String name;

    public TaskPresenter(String name, Icon icon, Context context) {
        this.name = name;
        this.icon = icon;
        this.context = context;
    }

    @Override
    public JComponent getLargeComponent() {
        if (this.largeTaskPresenter == null) {
            this.largeTaskPresenter = new LargeTaskPresenter(this.name, this.icon, this.context);
        }
        return this.largeTaskPresenter;
    }

    public void setProfilingSettings(ArrayList<ProfilingSettings> profilingSettingsArr) {
        this.largeTaskPresenter.setProfilingSettings(profilingSettingsArr);
    }

    public ArrayList<ProfilingSettings> getProfilingSettings() {
        return this.largeTaskPresenter.getProfilingSettings();
    }

    public ProfilingSettings getSelectedProfilingSettings() {
        return this.largeTaskPresenter.getSelectedProfilingSettings();
    }

    @Override
    public JComponent getSmallComponent() {
        if (this.smallTaskPresenter == null) {
            this.smallTaskPresenter = new SmallTaskPresenter(this.name, this.icon);
        }
        return this.smallTaskPresenter;
    }

    public void resetProfilingSettings() {
        this.largeTaskPresenter.resetProfilingSettings();
    }

    public void selectProfilingSettings(ProfilingSettings profilingSettings) {
        this.largeTaskPresenter.selectSettings(profilingSettings);
    }

    private static class TPHyperlinkTextArea
    extends HyperlinkTextArea {
        public TPHyperlinkTextArea(String text) {
            super(text);
            this.setForeground(SelectProfilingTask.DARKLINK_COLOR_INACTIVE);
            this.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    JComponent parent = (JComponent)TPHyperlinkTextArea.this.getParent();
                    if (parent != null) {
                        parent.scrollRectToVisible(TPHyperlinkTextArea.this.getBounds());
                    }
                }
            });
            KeyStroke ks = KeyStroke.getKeyStroke(10, 0);
            this.getInputMap().put(ks, "");
        }

        protected Color getHighlightColor() {
            return SelectProfilingTask.DARKLINK_COLOR;
        }

        protected String getHighlightText(String originalText) {
            return "<u>" + originalText + "</u>";
        }

        protected Color getNormalColor() {
            return SelectProfilingTask.DARKLINK_COLOR_INACTIVE;
        }

        protected String getNormalText(String originalText) {
            return originalText;
        }
    }

    private static class SmallTaskPresenter
    extends JPanel {
        public SmallTaskPresenter(String title, Icon icon) {
            this.initComponents(title, icon);
        }

        private void initComponents(String title, Icon icon) {
            this.setLayout(new BorderLayout());
            this.setOpaque(true);
            this.setBackground(SelectProfilingTask.BACKGROUND_COLOR_INACTIVE);
            JLabel label = new JLabel();
            label.setFont(label.getFont().deriveFont(1, label.getFont().getSize2D() + 3.0f));
            label.setForeground(new Color(80, 80, 80));
            label.setIcon(icon);
            label.setText(title);
            label.setIconTextGap(10);
            label.setBorder(BorderFactory.createEmptyBorder(5, 12, 5, 12));
            this.add((Component)label, "North");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LargeTaskPresenter
    extends JPanel {
        private static final int MAX_VISIBLE_ROWS = 4;
        private static final int CONFIGURATION_HEIGHT = new HTMLTextArea((String)"H").getPreferredSize().height;
        private ArrayList<ProfilingSettings> profilingSettings = new ArrayList();
        private Context context;
        private JMenuItem deleteItem;
        private JMenuItem duplicateItem;
        private JMenuItem moveDownItem;
        private JMenuItem moveUpItem;
        private JMenuItem renameItem;
        private JPanel configurationsContainer;
        private JPopupMenu presetPopupMenu;
        private JScrollPane configurationsScrollPane;
        private TPHyperlinkTextArea createCustom;
        private int activeSettingsIndex = -1;
        private int selectedSettingsIndex = 0;

        public LargeTaskPresenter(String title, Icon icon, Context context) {
            this.context = context;
            this.initComponents(title, icon);
        }

        public void setProfilingSettings(ArrayList<ProfilingSettings> profilingSettings) {
            this.resetProfilingSettings();
            this.profilingSettings.addAll(profilingSettings);
            this.updateItems();
        }

        public ArrayList<ProfilingSettings> getProfilingSettings() {
            return this.profilingSettings;
        }

        public ProfilingSettings getSelectedProfilingSettings() {
            if (this.selectedSettingsIndex == -1) {
                return null;
            }
            return this.profilingSettings.get(this.selectedSettingsIndex);
        }

        public void resetProfilingSettings() {
            this.selectedSettingsIndex = 0;
            this.profilingSettings.clear();
        }

        public void selectSettings(ProfilingSettings settings) {
            this.selectSettings(settings, true);
        }

        private TPHyperlinkTextArea getPresenter(ProfilingSettings settings) {
            if (settings == null || this.profilingSettings.indexOf(settings) == -1) {
                return null;
            }
            return (TPHyperlinkTextArea)((Object)this.configurationsContainer.getComponent(this.profilingSettings.indexOf(settings) * 2 + 1));
        }

        private void createCustomSettings() {
            SelectProfilingTask.getDefault().synchronizeCurrentSettings();
            ProfilingSettings newSettings = ProfilingSettingsManager.getDefault().createNewSettings(this.profilingSettings.get(0).getProfilingType(), this.profilingSettings.toArray(new ProfilingSettings[this.profilingSettings.size()]));
            if (newSettings != null) {
                ProfilingSettings selectedSettings = this.profilingSettings.get(this.selectedSettingsIndex);
                this.profilingSettings.add(newSettings);
                this.updateItems();
                this.selectedSettingsIndex = this.profilingSettings.indexOf(selectedSettings);
                this.context.selectSettings(newSettings);
            }
        }

        private void initComponents(String title, Icon icon) {
            this.setLayout(new GridBagLayout());
            this.setOpaque(true);
            this.setBackground(SelectProfilingTask.BACKGROUND_COLOR);
            JLabel label = new JLabel();
            label.setFont(label.getFont().deriveFont(1, label.getFont().getSize2D() + 3.0f));
            label.setForeground(new Color(198, 129, 0));
            label.setIcon(icon);
            label.setText(title);
            label.setIconTextGap(10);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(5, 12, 5, 12);
            this.add((Component)label, gridBagConstraints);
            JSeparator separator = Utils.createHorizontalSeparator();
            separator.setBackground(this.getBackground());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 10, 7, 10);
            this.add((Component)separator, gridBagConstraints);
            this.configurationsContainer = new ConfigurationsContainer();
            this.configurationsContainer.setLayout(new GridBagLayout());
            this.configurationsContainer.setOpaque(true);
            this.configurationsContainer.setBackground(SelectProfilingTask.BACKGROUND_COLOR);
            this.configurationsContainer.addHierarchyListener(new HierarchyListener(){

                public void hierarchyChanged(HierarchyEvent e) {
                    if ((e.getChangeFlags() & 4L) != 0L && LargeTaskPresenter.this.configurationsContainer.isShowing() && LargeTaskPresenter.this.selectedSettingsIndex != -1) {
                        ProfilingSettings selectedSettings = (ProfilingSettings)LargeTaskPresenter.this.profilingSettings.get(LargeTaskPresenter.this.selectedSettingsIndex);
                        TPHyperlinkTextArea selectedPresenter = LargeTaskPresenter.this.getPresenter(selectedSettings);
                        selectedPresenter.requestFocusInWindow();
                    }
                }
            });
            this.configurationsScrollPane = new JScrollPane(20, 31){

                public Dimension getPreferredSize() {
                    return new Dimension(super.getPreferredSize().width, Math.min(((LargeTaskPresenter)LargeTaskPresenter.this).configurationsContainer.getPreferredSize().height, CONFIGURATION_HEIGHT * 4));
                }
            };
            this.configurationsScrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.configurationsScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            this.configurationsScrollPane.setViewportView(this.configurationsContainer);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(0, 0, 0, 10);
            this.add((Component)this.configurationsScrollPane, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(0, 0, 10, 0);
            this.add((Component)Utils.createFillerPanel(), gridBagConstraints);
            this.createCustom = new TPHyperlinkTextArea(CREATE_CUSTOM_STRING);
            this.createCustom.setToolTipText(CREATE_CUSTOM_TOOLTIP);
            this.createCustom.setName(CREATE_CUSTOM_STRING);
            this.createCustom.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1) {
                        this.mouseExited(e);
                        LargeTaskPresenter.this.createCustomSettings();
                    }
                }
            });
            this.createCustom.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 32) {
                        LargeTaskPresenter.this.createCustomSettings();
                    }
                }
            });
            this.renameItem = new JMenuItem(RENAME_ITEM_TEXT);
            this.renameItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProfilingSettings activeSettings = (ProfilingSettings)LargeTaskPresenter.this.profilingSettings.get(LargeTaskPresenter.this.activeSettingsIndex);
                    ProfilingSettings newSettings = ProfilingSettingsManager.getDefault().renameSettings(activeSettings, LargeTaskPresenter.this.profilingSettings.toArray(new ProfilingSettings[LargeTaskPresenter.this.profilingSettings.size()]));
                    if (newSettings != null) {
                        ProfilingSettings selectedSettings = (ProfilingSettings)LargeTaskPresenter.this.profilingSettings.get(LargeTaskPresenter.this.selectedSettingsIndex);
                        LargeTaskPresenter.this.profilingSettings.add(LargeTaskPresenter.this.profilingSettings.indexOf(activeSettings), newSettings);
                        LargeTaskPresenter.this.profilingSettings.remove(activeSettings);
                        LargeTaskPresenter.this.updateItems();
                        if (LargeTaskPresenter.this.activeSettingsIndex != LargeTaskPresenter.this.selectedSettingsIndex) {
                            LargeTaskPresenter.this.selectSettings(selectedSettings, false);
                        } else {
                            LargeTaskPresenter.this.context.selectSettings(newSettings);
                        }
                    }
                }
            });
            this.duplicateItem = new JMenuItem(DUPLICATE_ITEM_TEXT);
            this.duplicateItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SelectProfilingTask.getDefault().synchronizeCurrentSettings();
                    ProfilingSettings activeSettings = (ProfilingSettings)LargeTaskPresenter.this.profilingSettings.get(LargeTaskPresenter.this.activeSettingsIndex);
                    ProfilingSettings newSettings = ProfilingSettingsManager.getDefault().createDuplicateSettings(activeSettings, LargeTaskPresenter.this.profilingSettings.toArray(new ProfilingSettings[LargeTaskPresenter.this.profilingSettings.size()]));
                    if (newSettings != null) {
                        ProfilingSettings selectedSettings = (ProfilingSettings)LargeTaskPresenter.this.profilingSettings.get(LargeTaskPresenter.this.selectedSettingsIndex);
                        LargeTaskPresenter.this.profilingSettings.add(newSettings);
                        LargeTaskPresenter.this.updateItems();
                        LargeTaskPresenter.this.selectedSettingsIndex = LargeTaskPresenter.this.profilingSettings.indexOf(selectedSettings);
                        LargeTaskPresenter.this.context.selectSettings(newSettings);
                    }
                }
            });
            this.deleteItem = new JMenuItem(DELETE_ITEM_TEXT);
            this.deleteItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProfilingSettings selectedSettings = (ProfilingSettings)LargeTaskPresenter.this.profilingSettings.get(LargeTaskPresenter.this.selectedSettingsIndex);
                    LargeTaskPresenter.this.profilingSettings.remove(LargeTaskPresenter.this.activeSettingsIndex);
                    LargeTaskPresenter.this.updateItems();
                    LargeTaskPresenter.this.selectedSettingsIndex = LargeTaskPresenter.this.profilingSettings.indexOf(selectedSettings);
                    if (LargeTaskPresenter.this.selectedSettingsIndex == -1) {
                        LargeTaskPresenter.this.context.selectSettings((ProfilingSettings)LargeTaskPresenter.this.profilingSettings.get(Math.max(LargeTaskPresenter.this.activeSettingsIndex - 1, 0)));
                    } else {
                        LargeTaskPresenter.this.selectSettings(selectedSettings, false);
                    }
                }
            });
            this.moveUpItem = new JMenuItem(MOVE_UP_ITEM_TEXT);
            this.moveUpItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProfilingSettings selectedSettings = (ProfilingSettings)LargeTaskPresenter.this.profilingSettings.get(LargeTaskPresenter.this.selectedSettingsIndex);
                    ProfilingSettings activeSettings = (ProfilingSettings)LargeTaskPresenter.this.profilingSettings.get(LargeTaskPresenter.this.activeSettingsIndex);
                    LargeTaskPresenter.this.profilingSettings.remove(activeSettings);
                    LargeTaskPresenter.this.profilingSettings.add(LargeTaskPresenter.this.activeSettingsIndex - 1, activeSettings);
                    LargeTaskPresenter.this.updateItems();
                    LargeTaskPresenter.this.selectSettings(selectedSettings, false);
                }
            });
            this.moveDownItem = new JMenuItem(MOVE_DOWN_ITEM_TEXT);
            this.moveDownItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProfilingSettings selectedSettings = (ProfilingSettings)LargeTaskPresenter.this.profilingSettings.get(LargeTaskPresenter.this.selectedSettingsIndex);
                    ProfilingSettings activeSettings = (ProfilingSettings)LargeTaskPresenter.this.profilingSettings.get(LargeTaskPresenter.this.activeSettingsIndex);
                    LargeTaskPresenter.this.profilingSettings.remove(activeSettings);
                    LargeTaskPresenter.this.profilingSettings.add(LargeTaskPresenter.this.activeSettingsIndex + 1, activeSettings);
                    LargeTaskPresenter.this.updateItems();
                    LargeTaskPresenter.this.selectSettings(selectedSettings, false);
                }
            });
            this.presetPopupMenu = new JPopupMenu();
            this.presetPopupMenu.add(this.renameItem);
            this.presetPopupMenu.add(this.duplicateItem);
            this.presetPopupMenu.add(this.deleteItem);
            this.presetPopupMenu.addSeparator();
            this.presetPopupMenu.add(this.moveUpItem);
            this.presetPopupMenu.add(this.moveDownItem);
        }

        private void selectSettings(ProfilingSettings settings, final boolean scrollToVisible) {
            if (this.selectedSettingsIndex != -1 && this.profilingSettings.get(this.selectedSettingsIndex) != settings) {
                ProfilingSettings selectedSettings = this.profilingSettings.get(this.selectedSettingsIndex);
                TPHyperlinkTextArea selectedPresenter = this.getPresenter(selectedSettings);
                selectedPresenter.setSelected(false);
            }
            this.selectedSettingsIndex = this.profilingSettings.indexOf(settings);
            this.setCursor(Cursor.getDefaultCursor());
            final TPHyperlinkTextArea presenter = this.getPresenter(settings);
            presenter.setSelected(true);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    presenter.requestFocusInWindow();
                    if (scrollToVisible) {
                        LargeTaskPresenter.this.configurationsContainer.scrollRectToVisible(presenter.getBounds());
                    }
                }
            });
        }

        private void showPopupMenu(ProfilingSettings settings, int x, int y) {
            this.activeSettingsIndex = this.profilingSettings.indexOf(settings);
            this.renameItem.setEnabled(!settings.isPreset());
            this.deleteItem.setEnabled(!settings.isPreset());
            this.moveUpItem.setEnabled(this.activeSettingsIndex > 0);
            this.moveDownItem.setEnabled(this.activeSettingsIndex < this.profilingSettings.size() - 1);
            this.presetPopupMenu.show((Component)((Object)this.getPresenter(settings)), x, y);
        }

        private void updateItems() {
            GridBagConstraints gridBagConstraints;
            this.configurationsContainer.removeAll();
            int i = 0;
            while (i < this.profilingSettings.size()) {
                final ProfilingSettings settings = this.profilingSettings.get(i);
                String settingsName = settings.getSettingsName();
                JLabel dot = new JLabel("\u00b7");
                dot.setOpaque(false);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = i;
                gridBagConstraints.fill = 0;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.insets = new Insets(3, 25, 0, 2);
                this.configurationsContainer.add((Component)dot, gridBagConstraints);
                final TPHyperlinkTextArea presenter = new TPHyperlinkTextArea(settingsName);
                presenter.getAccessibleContext().setAccessibleName(settingsName);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = i++;
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.insets = new Insets(0, 0, 0, 4);
                this.configurationsContainer.add((Component)((Object)presenter), gridBagConstraints);
                presenter.addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent e) {
                        if (e.getButton() == 1) {
                            if (LargeTaskPresenter.this.selectedSettingsIndex != -1 && settings != LargeTaskPresenter.this.profilingSettings.get(LargeTaskPresenter.this.selectedSettingsIndex)) {
                                LargeTaskPresenter.this.context.selectSettings(settings);
                            }
                        } else if (e.getButton() == 3) {
                            LargeTaskPresenter.this.showPopupMenu(settings, e.getX(), e.getY());
                        }
                    }
                });
                presenter.addKeyListener(new KeyAdapter(){

                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyCode() == 32 && LargeTaskPresenter.this.selectedSettingsIndex != -1 && settings != LargeTaskPresenter.this.profilingSettings.get(LargeTaskPresenter.this.selectedSettingsIndex)) {
                            LargeTaskPresenter.this.context.selectSettings(settings);
                        } else if (e.getKeyCode() == 525 || e.getKeyCode() == 121 && e.getModifiers() == 1) {
                            Dimension size = presenter.getSize();
                            LargeTaskPresenter.this.showPopupMenu(settings, size.width / 2, size.height / 2);
                        }
                    }
                });
            }
            int lastItemIndex = this.profilingSettings.size();
            JLabel dot = new JLabel("\u00b7");
            dot.setOpaque(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = lastItemIndex;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(3, 25, 0, 2);
            this.configurationsContainer.add((Component)dot, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = lastItemIndex;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(0, 0, 0, 4);
            this.configurationsContainer.add((Component)((Object)this.createCustom), gridBagConstraints);
            this.context.refreshLayout();
        }
    }

    private static class ConfigurationsContainer
    extends JPanel
    implements Scrollable {
        private ConfigurationsContainer() {
        }

        public Dimension getPreferredScrollableViewportSize() {
            return null;
        }

        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            Container parent = this.getParent();
            if (parent == null || !(parent instanceof JViewport)) {
                return 50;
            }
            return (int)((float)((JViewport)parent).getHeight() * 0.95f);
        }

        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 20;
        }
    }

    public static interface Context {
        public void refreshLayout();

        public void selectSettings(ProfilingSettings var1);
    }
}

