/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.stp;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.filters.SimpleFilter;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.ImagePanel;
import org.netbeans.lib.profiler.ui.components.VerticalLayout;
import org.netbeans.lib.profiler.ui.components.XPStyleBorder;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.ui.stp.AttachSettingsPanel;
import org.netbeans.modules.profiler.ui.stp.DefaultSettingsConfigurator;
import org.netbeans.modules.profiler.ui.stp.ProfilingSettingsManager;
import org.netbeans.modules.profiler.ui.stp.SettingsContainerPanel;
import org.netbeans.modules.profiler.ui.stp.TaskChooser;
import org.netbeans.modules.profiler.ui.stp.TaskPresenter;
import org.netbeans.modules.profiler.ui.stp.Utils;
import org.netbeans.modules.profiler.ui.stp.WelcomePanel;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.DialogDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectProfilingTask
extends JPanel
implements TaskChooser.Listener,
HelpCtx.Provider {
    private static final String SELECT_PROJECT_TO_ATTACH_STRING = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_SelectProjectToAttachString");
    public static final String EXTERNAL_APPLICATION_STRING = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_ExternalApplicationString");
    private static final String PROFILE_DIALOG_CAPTION = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_ProfileDialogCaption");
    private static final String ATTACH_DIALOG_CAPTION = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_AttachDialogCaption");
    private static final String MODIFY_DIALOG_CAPTION = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_ModifyDialogCaption");
    private static final String MONITOR_STRING = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_MonitorString");
    private static final String CPU_STRING = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_CpuString");
    private static final String MEMORY_STRING = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_MemoryString");
    private static final String ATTACH_LABEL_TEXT = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_AttachLabelText");
    private static final String RUN_BUTTON_TEXT = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_RunButtonText");
    private static final String ATTACH_BUTTON_TEXT = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_AttachButtonText");
    private static final String OK_BUTTON_TEXT = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_OkButtonText");
    private static final String CANCEL_BUTTON_TEXT = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_CancelButtonText");
    private static final String INIT_SESSION_STRING = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_InitSessionString");
    private static final String CHOOSER_COMBO_ACCESS_DESCR = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_ChooserComboAccessDescr");
    private static final String WORKDIR_INVALID_MSG = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_WorkDirInvalidMsg");
    public static Color BACKGROUND_COLOR;
    public static Color BACKGROUND_COLOR_INACTIVE;
    public static Color DARKLINK_COLOR;
    public static Color DARKLINK_COLOR_INACTIVE;
    private static SelectProfilingTask defaultInstance;
    private static final Image BACKGROUND_IMAGE;
    private static final Icon MONITOR_ICON;
    private static final Icon CPU_ICON;
    private static final Icon MEMORY_ICON;
    private static final Icon RUN_ICON;
    private static final Icon ATTACH_ICON;
    private AttachSettingsPanel attachSettingsPanel;
    private DialogDescriptor dd;
    private FileObject profiledFile;
    private ImagePanel taskChooserPanel;
    private JButton attachButton;
    private JButton cancelButton;
    private JButton modifyButton;
    private JButton runButton;
    private JButton submitButton;
    private JComboBox projectsChooserCombo;
    private JLabel projectsChooserLabel;
    private JPanel attachSettingsPanelContainer;
    private JPanel contentsPanel;
    private JPanel customSettingsPanelContainer;
    private JPanel extraSettingsPanel;
    private JPanel projectsChooserComboContainer;
    private JPanel projectsChooserPanel;
    private JSeparator attachSettingsPanelSeparator;
    private JSeparator customSettingsPanelSeparator;
    private JSeparator extraSettingsPanelSeparator;
    private JSeparator projectsChooserSeparator;
    private List<SimpleFilter> predefinedInstrFilterKeys;
    private Object lastAttachProject;
    private SettingsConfigurator configurator;
    private SettingsContainerPanel settingsContainerPanel;
    private TaskChooser taskChooser;
    private TaskPresenter selectedTask;
    private TaskPresenter taskCPU;
    private TaskPresenter taskMemory;
    private TaskPresenter taskMonitor;
    private WeakReference<WelcomePanel> welcomePanelReference;
    private SimpleFilter[] predefinedInstrFilters;
    private String[][] projectPackages;
    private boolean enableOverride;
    private boolean internalComboChange = false;
    private boolean isAttach;
    private boolean isModify;

    private SelectProfilingTask() {
        this.initComponents();
        this.initTasks();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SelectProfilingTask.this.initTaskChooserSize();
                SelectProfilingTask.this.initPreferredSize();
            }
        });
    }

    private static void initColors() {
        boolean textInverse;
        boolean inverseColors;
        Color systemBackgroundColor = UIUtils.getProfilerResultsBackground();
        int backgroundRed = systemBackgroundColor.getRed();
        int backgroundGreen = systemBackgroundColor.getGreen();
        int backgroundBlue = systemBackgroundColor.getBlue();
        boolean bl = inverseColors = backgroundRed < 18 || backgroundGreen < 18 || backgroundBlue < 18;
        if (inverseColors) {
            BACKGROUND_COLOR = UIUtils.getSafeColor((int)(backgroundRed + 11), (int)(backgroundGreen + 11), (int)(backgroundBlue + 11));
            BACKGROUND_COLOR_INACTIVE = UIUtils.getSafeColor((int)(backgroundRed + 18), (int)(backgroundGreen + 18), (int)(backgroundBlue + 18));
        } else {
            BACKGROUND_COLOR = UIUtils.getSafeColor((int)(backgroundRed - 11), (int)(backgroundGreen - 11), (int)(backgroundBlue - 11));
            BACKGROUND_COLOR_INACTIVE = UIUtils.getSafeColor((int)(backgroundRed - 18), (int)(backgroundGreen - 18), (int)(backgroundBlue - 18));
        }
        boolean bl2 = textInverse = BACKGROUND_COLOR_INACTIVE.getRed() - Color.DARK_GRAY.getRed() < 50;
        if (textInverse) {
            int darklinkExtent = Color.DARK_GRAY.getRed() - Color.BLACK.getRed();
            int darklinkInverse = Color.WHITE.getRed() - darklinkExtent;
            DARKLINK_COLOR = Color.WHITE;
            DARKLINK_COLOR_INACTIVE = UIUtils.getSafeColor((int)darklinkInverse, (int)darklinkInverse, (int)darklinkInverse);
        } else {
            DARKLINK_COLOR = Color.BLACK;
            DARKLINK_COLOR_INACTIVE = Color.DARK_GRAY;
        }
    }

    public static Configuration selectAttachProfilerTask() {
        SelectProfilingTask spt = SelectProfilingTask.getDefault();
        spt.setSubmitButton(spt.attachButton);
        spt.setupAttachProfiler();
        spt.dd = new DialogDescriptor((Object)spt, ATTACH_DIALOG_CAPTION, true, new Object[]{spt.attachButton, spt.cancelButton}, (Object)spt.attachButton, 0, null, null);
        Dialog d = ProfilerDialogs.createDialog(spt.dd);
        d.pack();
        d.setVisible(true);
        Configuration result = null;
        if (spt.dd.getValue() == spt.attachButton) {
            result = new Configuration(spt.createFinalSettings(), spt.getAttachSettings());
        }
        spt.cleanup();
        return result;
    }

    public static Configuration selectModifyProfilingTask(FileObject profiledFile, boolean isAttach) {
        SelectProfilingTask spt = SelectProfilingTask.getDefault();
        spt.setSubmitButton(spt.modifyButton);
        spt.setupModifyProfiling(profiledFile, isAttach);
        spt.dd = new DialogDescriptor((Object)spt, MessageFormat.format(MODIFY_DIALOG_CAPTION, Utils.getProjectName()), true, new Object[]{spt.modifyButton, spt.cancelButton}, (Object)spt.modifyButton, 0, null, null);
        Dialog d = ProfilerDialogs.createDialog(spt.dd);
        d.pack();
        d.setVisible(true);
        Configuration result = null;
        if (spt.dd.getValue() == spt.modifyButton) {
            result = new Configuration(spt.createFinalSettings(), null);
        }
        spt.cleanup();
        return result;
    }

    public static Configuration selectProfileProjectTask(FileObject profiledFile, boolean enableOverride) {
        SelectProfilingTask spt = SelectProfilingTask.getDefault();
        spt.setSubmitButton(spt.runButton);
        spt.setupProfileProject(profiledFile, enableOverride);
        String targetName = Utils.getProjectName() + (profiledFile == null ? "" : ": " + profiledFile.getNameExt());
        spt.dd = new DialogDescriptor((Object)spt, MessageFormat.format(PROFILE_DIALOG_CAPTION, targetName), true, new Object[]{spt.runButton, spt.cancelButton}, (Object)spt.runButton, 0, null, null);
        Dialog d = ProfilerDialogs.createDialog(spt.dd);
        d.pack();
        d.setVisible(true);
        Configuration result = null;
        if (spt.dd.getValue() == spt.runButton) {
            String workDir;
            ProfilingSettings settings = spt.createFinalSettings();
            if (settings.getOverrideGlobalSettings() && (workDir = settings.getWorkingDir().trim()).length() != 0 && !new File(workDir).exists()) {
                settings.setWorkingDir("");
                NetBeansProfiler.getDefaultNB().displayWarning(WORKDIR_INVALID_MSG);
            }
            result = new Configuration(settings, null);
        }
        spt.cleanup();
        return result;
    }

    public HelpCtx getHelpCtx() {
        return this.settingsContainerPanel.getHelpCtx();
    }

    @Override
    public void itemCollapsed(TaskChooser.Item item) {
    }

    @Override
    public void itemExpanded(TaskChooser.Item item) {
        this.selectedTask.selectProfilingSettings(((TaskPresenter)item).getSelectedProfilingSettings());
    }

    @Override
    public void itemWillCollapse(TaskChooser.Item item) {
    }

    @Override
    public void itemWillExpand(TaskChooser.Item item) {
        this.selectProfilingSettings(((TaskPresenter)item).getSelectedProfilingSettings());
    }

    static SelectProfilingTask getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new SelectProfilingTask();
        }
        return defaultInstance;
    }

    List<SimpleFilter> getPredefinedInstrFilterKeys() {
        return this.predefinedInstrFilterKeys;
    }

    SimpleFilter getResolvedPredefinedFilter(SimpleFilter key) {
        return null;
    }

    void setSubmitButton(JButton submitButton) {
        this.submitButton = submitButton;
    }

    void disableSubmitButton() {
        if (this.submitButton != null) {
            this.submitButton.setEnabled(false);
        }
    }

    void enableSubmitButton() {
        if (this.submitButton != null) {
            this.submitButton.setEnabled(true);
        }
    }

    void synchronizeCurrentSettings() {
        if (this.configurator != null && this.configurator.getSettings() != null) {
            this.configurator.synchronizeSettings();
        }
    }

    void updateHelpCtx() {
        if (this.dd != null) {
            this.dd.setHelpCtx(this.getHelpCtx());
        }
    }

    private AttachSettings getAttachSettings() {
        return this.attachSettingsPanel.getSettings();
    }

    private TaskPresenter getTaskPresenter(ProfilingSettings profilingSettings) {
        if (profilingSettings == null) {
            return null;
        }
        if (Utils.isMonitorSettings(profilingSettings)) {
            return this.taskMonitor;
        }
        if (Utils.isCPUSettings(profilingSettings)) {
            return this.taskCPU;
        }
        if (Utils.isMemorySettings(profilingSettings)) {
            return this.taskMemory;
        }
        return null;
    }

    private WelcomePanel getWelcomePanel() {
        WelcomePanel welcomePanel;
        if (this.welcomePanelReference == null || this.welcomePanelReference.get() == null) {
            welcomePanel = new WelcomePanel();
            this.welcomePanelReference = new WeakReference<WelcomePanel>(welcomePanel);
        } else {
            welcomePanel = (WelcomePanel)this.welcomePanelReference.get();
        }
        return welcomePanel;
    }

    private void cleanup() {
        if (!this.projectsChooserPanel.isVisible() || this.projectsChooserCombo.getSelectedItem() != SELECT_PROJECT_TO_ATTACH_STRING) {
            this.storeCurrentSettings();
        }
        this.projectCleanup();
        this.profiledFile = null;
        this.enableOverride = false;
        this.isAttach = false;
        this.isModify = false;
        this.contentsPanel.removeAll();
        this.customSettingsPanelContainer.removeAll();
        this.internalComboChange = true;
        this.projectsChooserCombo.removeAllItems();
        this.internalComboChange = false;
        this.submitButton = null;
        this.projectPackages = null;
        this.predefinedInstrFilters = null;
        this.predefinedInstrFilterKeys = null;
        this.dd = null;
        this.contentsPanel.setPreferredSize(this.contentsPanel.getSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProfilingSettings createFinalSettings() {
        if (this.configurator != null) {
            ProfilingSettings profilingSettings;
            this.synchronizeCurrentSettings();
            ProfilingSettings settings = this.configurator.createFinalSettings();
            ProgressHandle pHandle = ProgressHandleFactory.createHandle((String)INIT_SESSION_STRING);
            pHandle.setInitialDelay(0);
            pHandle.start();
            try {
                profilingSettings = settings;
            }
            catch (Throwable throwable) {
                SwingUtilities.invokeLater(new Runnable(pHandle){
                    final /* synthetic */ ProgressHandle val$pHandle;
                    {
                        this.val$pHandle = progressHandle;
                    }

                    public void run() {
                        this.val$pHandle.finish();
                    }
                });
                throw throwable;
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            return profilingSettings;
        }
        return null;
    }

    private void initComponents() {
        this.projectsChooserLabel = new JLabel(ATTACH_LABEL_TEXT);
        this.projectsChooserLabel.setBorder(BorderFactory.createEmptyBorder(6, 15, 6, 0));
        this.projectsChooserLabel.setOpaque(false);
        this.projectsChooserCombo = new JComboBox();
        this.projectsChooserLabel.setLabelFor(this.projectsChooserCombo);
        this.projectsChooserCombo.getAccessibleContext().setAccessibleDescription(CHOOSER_COMBO_ACCESS_DESCR);
        this.projectsChooserComboContainer = new JPanel(new BorderLayout());
        this.projectsChooserComboContainer.setBorder(BorderFactory.createEmptyBorder(6, 10, 6, 10));
        this.projectsChooserComboContainer.setOpaque(false);
        this.projectsChooserComboContainer.add((Component)this.projectsChooserCombo, "Center");
        this.projectsChooserSeparator = Utils.createHorizontalSeparator();
        this.projectsChooserPanel = new JPanel(new BorderLayout());
        this.projectsChooserPanel.add((Component)this.projectsChooserLabel, "West");
        this.projectsChooserPanel.add((Component)this.projectsChooserComboContainer, "Center");
        this.projectsChooserPanel.add((Component)this.projectsChooserSeparator, "South");
        this.taskChooser = new TaskChooser();
        this.taskChooser.addItemListener(this);
        this.taskChooserPanel = new ImagePanel(BACKGROUND_IMAGE, 3);
        this.taskChooserPanel.setLayout((LayoutManager)new BorderLayout());
        this.taskChooserPanel.add((Component)this.taskChooser, (Object)"North");
        this.settingsContainerPanel = new SettingsContainerPanel();
        this.contentsPanel = new JPanel(new BorderLayout());
        this.customSettingsPanelSeparator = Utils.createHorizontalSeparator();
        this.customSettingsPanelContainer = new JPanel(new BorderLayout());
        this.attachSettingsPanel = new AttachSettingsPanel();
        this.attachSettingsPanelSeparator = Utils.createHorizontalSeparator();
        this.attachSettingsPanelContainer = new JPanel(new BorderLayout());
        this.attachSettingsPanelContainer.add((Component)this.attachSettingsPanel, "Center");
        this.attachSettingsPanelContainer.add((Component)this.attachSettingsPanelSeparator, "South");
        this.extraSettingsPanelSeparator = Utils.createHorizontalSeparator();
        this.extraSettingsPanel = new JPanel(new BorderLayout());
        this.extraSettingsPanel.add((Component)this.extraSettingsPanelSeparator, "North");
        this.extraSettingsPanel.add((Component)this.customSettingsPanelContainer, "Center");
        this.extraSettingsPanel.add((Component)this.attachSettingsPanelContainer, "South");
        this.runButton = new JButton(RUN_BUTTON_TEXT, RUN_ICON);
        this.attachButton = new JButton(ATTACH_BUTTON_TEXT, ATTACH_ICON){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, ((SelectProfilingTask)SelectProfilingTask.this).runButton.getPreferredSize().height);
            }
        };
        this.modifyButton = new JButton(OK_BUTTON_TEXT){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, ((SelectProfilingTask)SelectProfilingTask.this).runButton.getPreferredSize().height);
            }
        };
        this.cancelButton = new JButton(CANCEL_BUTTON_TEXT){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, ((SelectProfilingTask)SelectProfilingTask.this).runButton.getPreferredSize().height);
            }
        };
        this.setLayout(new BorderLayout());
        this.add((Component)this.projectsChooserPanel, "North");
        this.add((Component)this.taskChooserPanel, "West");
        this.add((Component)this.contentsPanel, "Center");
        this.add((Component)this.extraSettingsPanel, "South");
        this.projectsChooserPanel.setOpaque(true);
        this.projectsChooserPanel.setBackground(this.taskChooserPanel.getBackground());
        this.projectsChooserCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (SelectProfilingTask.this.internalComboChange) {
                    return;
                }
                Object comboSelection = SelectProfilingTask.this.projectsChooserCombo.getSelectedItem();
                if (SelectProfilingTask.this.lastAttachProject != null) {
                    SelectProfilingTask.this.storeSettings();
                }
                if (comboSelection == null || comboSelection == SELECT_PROJECT_TO_ATTACH_STRING) {
                    return;
                }
                if (comboSelection != SELECT_PROJECT_TO_ATTACH_STRING && SelectProfilingTask.this.projectsChooserCombo.getItemAt(0) == SELECT_PROJECT_TO_ATTACH_STRING) {
                    SelectProfilingTask.this.projectsChooserCombo.removeItemAt(0);
                }
                if (comboSelection == EXTERNAL_APPLICATION_STRING) {
                    SelectProfilingTask.this.updateProject();
                    SelectProfilingTask.this.lastAttachProject = EXTERNAL_APPLICATION_STRING;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SelectProfilingTask.this.projectsChooserCombo.requestFocusInWindow();
                    }
                });
            }
        });
    }

    private void initPreferredSize() {
        Dimension preferredContentsSize = new Dimension(360, 215);
        Dimension monitorSettingsSize = DefaultSettingsConfigurator.SHARED_INSTANCE.getMonitorConfigurator().getBasicSettingsPanel().getPreferredSize();
        Dimension cpuSettingsSize = DefaultSettingsConfigurator.SHARED_INSTANCE.getCPUConfigurator().getBasicSettingsPanel().getPreferredSize();
        Dimension memorySettingsSize = DefaultSettingsConfigurator.SHARED_INSTANCE.getMemoryConfigurator().getBasicSettingsPanel().getPreferredSize();
        preferredContentsSize.setSize(Math.max(preferredContentsSize.width, monitorSettingsSize.width), Math.max(preferredContentsSize.height, monitorSettingsSize.height));
        preferredContentsSize.setSize(Math.max(preferredContentsSize.width, cpuSettingsSize.width), Math.max(preferredContentsSize.height, cpuSettingsSize.height));
        preferredContentsSize.setSize(Math.max(preferredContentsSize.width, memorySettingsSize.width), Math.max(preferredContentsSize.height, memorySettingsSize.height));
        this.settingsContainerPanel.setPreferredContentsSize(preferredContentsSize);
        Dimension finalSize = this.settingsContainerPanel.getPreferredSize();
        this.contentsPanel.setPreferredSize(finalSize);
    }

    private void initTaskChooserSize() {
        Dimension preferredTaskChooserSize = new Dimension(200, this.taskChooserPanel.getPreferredSize().height);
        int vgap = ((VerticalLayout)this.taskChooser.getLayout()).getVGap() * 2;
        int insets = XPStyleBorder.getBorderInsets().left + XPStyleBorder.getBorderInsets().right;
        Dimension monitorSettingsSize = this.taskMonitor.getSmallComponent().getPreferredSize();
        Dimension cpuSettingsSize = this.taskCPU.getSmallComponent().getPreferredSize();
        Dimension memorySettingsSize = this.taskMemory.getSmallComponent().getPreferredSize();
        preferredTaskChooserSize.setSize(Math.max(preferredTaskChooserSize.width, monitorSettingsSize.width + vgap + insets), preferredTaskChooserSize.height);
        preferredTaskChooserSize.setSize(Math.max(preferredTaskChooserSize.width, cpuSettingsSize.width + vgap + insets), preferredTaskChooserSize.height);
        preferredTaskChooserSize.setSize(Math.max(preferredTaskChooserSize.width, memorySettingsSize.width + vgap + insets), preferredTaskChooserSize.height);
        this.taskChooserPanel.setPreferredSize(preferredTaskChooserSize);
    }

    private void initTasks() {
        TaskPresenter.Context context = new TaskPresenter.Context(){

            public void selectSettings(ProfilingSettings settings) {
                SelectProfilingTask.this.selectProfilingSettings(settings);
            }

            public void refreshLayout() {
                SelectProfilingTask.this.taskChooser.refreshLayout();
            }
        };
        this.taskMonitor = new TaskPresenter(MONITOR_STRING, MONITOR_ICON, context);
        this.taskCPU = new TaskPresenter(CPU_STRING, CPU_ICON, context);
        this.taskMemory = new TaskPresenter(MEMORY_STRING, MEMORY_ICON, context);
        this.taskChooser.add(this.taskMonitor);
        this.taskChooser.add(this.taskCPU);
        this.taskChooser.add(this.taskMemory);
    }

    private void projectCleanup() {
        this.taskChooser.reset();
        this.taskMonitor.resetProfilingSettings();
        this.taskCPU.resetProfilingSettings();
        this.taskMemory.resetProfilingSettings();
        this.attachSettingsPanel.resetSettings();
        this.selectedTask = null;
        if (this.configurator != null) {
            this.configurator.reset();
        }
        this.configurator = null;
    }

    private void selectProfilingSettings(ProfilingSettings profilingSettings) {
        this.synchronizeCurrentSettings();
        TaskPresenter newSelectedTask = this.getTaskPresenter(profilingSettings);
        if (newSelectedTask == null || newSelectedTask != this.selectedTask) {
            JPanel newContentsPanel = null;
            if (newSelectedTask == null) {
                WelcomePanel welcomePanel;
                newContentsPanel = welcomePanel = this.getWelcomePanel();
            } else {
                if (newSelectedTask == this.taskMonitor) {
                    this.settingsContainerPanel.setContents(this.configurator.getMonitorConfigurator());
                } else if (newSelectedTask == this.taskCPU) {
                    this.settingsContainerPanel.setContents(this.configurator.getCPUConfigurator());
                } else if (newSelectedTask == this.taskMemory) {
                    this.settingsContainerPanel.setContents(this.configurator.getMemoryConfigurator());
                }
                newContentsPanel = this.settingsContainerPanel;
            }
            this.contentsPanel.removeAll();
            this.contentsPanel.add((Component)newContentsPanel, "Center");
            this.contentsPanel.doLayout();
            this.contentsPanel.repaint();
            this.selectedTask = newSelectedTask;
        }
        if (profilingSettings != null) {
            this.settingsContainerPanel.setShowingPreset(profilingSettings.isPreset());
            this.settingsContainerPanel.switchToBasicSettings();
            this.settingsContainerPanel.setCaption(profilingSettings.getSettingsName());
            this.selectedTask.selectProfilingSettings(profilingSettings);
            this.configurator.setSettings(profilingSettings);
        }
    }

    private void setupAttachProfiler() {
        this.profiledFile = null;
        this.enableOverride = false;
        this.isAttach = true;
        this.isModify = false;
        this.projectsChooserLabel.setEnabled(true);
        this.projectsChooserCombo.setEnabled(true);
        this.projectsChooserPanel.setVisible(true);
        this.attachSettingsPanel.setEnabled(true);
        this.attachSettingsPanelContainer.setVisible(true);
        if (this.lastAttachProject == null) {
            this.lastAttachProject = EXTERNAL_APPLICATION_STRING;
        }
        this.updateProjectsCombo(EXTERNAL_APPLICATION_STRING);
        this.updateProject();
    }

    private void setupModifyProfiling(FileObject profiledFile, boolean isAttach) {
        this.profiledFile = profiledFile;
        this.enableOverride = false;
        this.isAttach = isAttach;
        this.isModify = true;
        this.projectsChooserLabel.setEnabled(false);
        this.projectsChooserCombo.setEnabled(false);
        this.projectsChooserPanel.setVisible(isAttach);
        this.attachSettingsPanel.setEnabled(false);
        this.attachSettingsPanelContainer.setVisible(isAttach);
        if (isAttach) {
            this.updateProjectsCombo(EXTERNAL_APPLICATION_STRING);
        }
        this.updateProject();
    }

    private void setupProfileProject(FileObject profiledFile, boolean enableOverride) {
        this.enableOverride = enableOverride;
        this.isAttach = false;
        this.isModify = false;
        this.projectsChooserPanel.setVisible(false);
        this.attachSettingsPanelContainer.setVisible(false);
        this.updateProject();
    }

    private void storeCurrentSettings() {
        this.storeSettings();
    }

    private void storeSettings() {
        this.synchronizeCurrentSettings();
        final ArrayList<ProfilingSettings> profilingSettings = new ArrayList<ProfilingSettings>();
        profilingSettings.addAll(this.taskMonitor.getProfilingSettings());
        profilingSettings.addAll(this.taskCPU.getProfilingSettings());
        profilingSettings.addAll(this.taskMemory.getProfilingSettings());
        final ProfilingSettings selectedProfilingSettings = this.selectedTask == null ? null : this.selectedTask.getSelectedProfilingSettings();
        IDEUtils.runInProfilerRequestProcessor(new Runnable(){

            public void run() {
                ProfilingSettingsManager.getDefault().storeProfilingSettings(profilingSettings.toArray(new ProfilingSettings[profilingSettings.size()]), selectedProfilingSettings);
            }
        });
    }

    private void updateProject() {
        this.projectCleanup();
        this.projectPackages = null;
        this.predefinedInstrFilters = null;
        this.predefinedInstrFilterKeys = null;
        if (this.projectsChooserPanel.isVisible() && this.projectsChooserCombo.getSelectedItem() == SELECT_PROJECT_TO_ATTACH_STRING) {
            this.taskChooser.setEnabled(false);
            this.contentsPanel.removeAll();
            this.contentsPanel.add((Component)this.getWelcomePanel(), "Center");
            this.contentsPanel.doLayout();
            this.contentsPanel.repaint();
        } else {
            TaskPresenter taskPresenter;
            this.configurator = Utils.getSettingsConfigurator();
            this.configurator.setContext(this.profiledFile, this.isAttach, this.isModify, this.enableOverride);
            JPanel customSettings = this.configurator.getCustomSettingsPanel();
            if (customSettings != null) {
                this.customSettingsPanelContainer.removeAll();
                this.customSettingsPanelContainer.add((Component)customSettings, "North");
                this.customSettingsPanelContainer.add((Component)this.customSettingsPanelSeparator, "South");
                this.customSettingsPanelContainer.setVisible(true);
            } else {
                this.customSettingsPanelContainer.removeAll();
                this.customSettingsPanelContainer.setVisible(false);
            }
            this.taskChooser.setEnabled(true);
            ProfilingSettings[] profilingSettings = new ProfilingSettings[]{};
            ProfilingSettings lastSelectedSettings = null;
            ProfilingSettingsManager.ProfilingSettingsDescriptor profilingSettingsDescriptor = ProfilingSettingsManager.getDefault().getProfilingSettings();
            profilingSettings = profilingSettingsDescriptor.getProfilingSettings();
            lastSelectedSettings = profilingSettingsDescriptor.getLastSelectedProfilingSettings();
            ArrayList<ProfilingSettings> monitorSettings = new ArrayList<ProfilingSettings>();
            ArrayList<ProfilingSettings> cpuSettings = new ArrayList<ProfilingSettings>();
            ArrayList<ProfilingSettings> memorySettings = new ArrayList<ProfilingSettings>();
            for (ProfilingSettings settings : profilingSettings) {
                if (Utils.isMonitorSettings(settings)) {
                    monitorSettings.add(settings);
                    continue;
                }
                if (Utils.isCPUSettings(settings)) {
                    cpuSettings.add(settings);
                    continue;
                }
                if (!Utils.isMemorySettings(settings)) continue;
                memorySettings.add(settings);
            }
            this.taskMonitor.setProfilingSettings(monitorSettings);
            this.taskCPU.setProfilingSettings(cpuSettings);
            this.taskMemory.setProfilingSettings(memorySettings);
            if (lastSelectedSettings == null) {
                for (ProfilingSettings cpuSettingsPreset : cpuSettings) {
                    if (!cpuSettingsPreset.isPreset()) continue;
                    lastSelectedSettings = cpuSettingsPreset;
                }
            }
            if (lastSelectedSettings != null && (taskPresenter = this.getTaskPresenter(lastSelectedSettings)) != null) {
                this.taskChooser.expandImmediately(taskPresenter);
            }
            this.selectProfilingSettings(lastSelectedSettings);
        }
        if (this.attachSettingsPanelContainer.isVisible()) {
            this.attachSettingsPanel.setSettings(this.projectsChooserCombo.getSelectedItem() != SELECT_PROJECT_TO_ATTACH_STRING);
        }
    }

    private void updateProjectsCombo(Object projectToSelect) {
        this.internalComboChange = true;
        if (projectToSelect == null) {
            this.projectsChooserCombo.addItem(SELECT_PROJECT_TO_ATTACH_STRING);
        }
        this.projectsChooserCombo.addItem(EXTERNAL_APPLICATION_STRING);
        if (projectToSelect == null) {
            this.projectsChooserCombo.setSelectedIndex(0);
        } else {
            this.projectsChooserCombo.setSelectedItem(projectToSelect);
        }
        this.internalComboChange = false;
    }

    static {
        SelectProfilingTask.initColors();
        BACKGROUND_IMAGE = Utilities.loadImage((String)"org/netbeans/modules/profiler/ui/stp/resources/sptBar.png");
        MONITOR_ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/ui/resources/monitoring.png"));
        CPU_ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/ui/resources/cpu.png"));
        MEMORY_ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/ui/resources/memory.png"));
        RUN_ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/actions/resources/runButton.gif"));
        ATTACH_ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/actions/resources/attachButton.gif"));
    }

    public static class Configuration {
        private AttachSettings attachSettings;
        private ProfilingSettings profilingSettings;

        Configuration(ProfilingSettings profilingSettings, AttachSettings attachSettings) {
            this.profilingSettings = profilingSettings;
            this.attachSettings = attachSettings;
        }

        public AttachSettings getAttachSettings() {
            return this.attachSettings;
        }

        public ProfilingSettings getProfilingSettings() {
            return this.profilingSettings;
        }
    }

    public static interface SettingsConfigurator {
        public SettingsContainerPanel.Contents getCPUConfigurator();

        public void setContext(FileObject var1, boolean var2, boolean var3, boolean var4);

        public JPanel getCustomSettingsPanel();

        public SettingsContainerPanel.Contents getMemoryConfigurator();

        public SettingsContainerPanel.Contents getMonitorConfigurator();

        public void setSettings(ProfilingSettings var1);

        public ProfilingSettings getSettings();

        public ProfilingSettings createFinalSettings();

        public void loadCustomSettings(Properties var1);

        public void reset();

        public void storeCustomSettings(Properties var1);

        public void synchronizeSettings();
    }
}

