/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.stp;

import java.util.Properties;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.ProfilingSettingsPresets;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.modules.profiler.ui.stp.CPUSettingsAdvancedPanel;
import org.netbeans.modules.profiler.ui.stp.CPUSettingsBasicPanel;
import org.netbeans.modules.profiler.ui.stp.MemorySettingsAdvancedPanel;
import org.netbeans.modules.profiler.ui.stp.MemorySettingsBasicPanel;
import org.netbeans.modules.profiler.ui.stp.MonitorSettingsAdvancedPanel;
import org.netbeans.modules.profiler.ui.stp.MonitorSettingsBasicPanel;
import org.netbeans.modules.profiler.ui.stp.SelectProfilingTask;
import org.netbeans.modules.profiler.ui.stp.SettingsContainerPanel;
import org.netbeans.modules.profiler.ui.stp.Utils;
import org.openide.filesystems.FileObject;

public class DefaultSettingsConfigurator
implements SelectProfilingTask.SettingsConfigurator {
    public static final DefaultSettingsConfigurator SHARED_INSTANCE = new DefaultSettingsConfigurator();
    private CPUContents cpuContents = new CPUContents();
    private FileObject profiledFile;
    private MemoryContents memoryContents = new MemoryContents();
    private MonitorContents monitorContents = new MonitorContents();
    private ProfilingSettings settings;
    private boolean enableOverride;
    private boolean isAttach;
    private boolean isModify;
    private boolean isPreset;

    public SettingsContainerPanel.Contents getCPUConfigurator() {
        return this.cpuContents;
    }

    public void setContext(FileObject profiledFile, boolean isAttach, boolean isModify, boolean enableOverride) {
        this.profiledFile = profiledFile;
        this.enableOverride = enableOverride;
        this.isAttach = isAttach;
        this.isModify = isModify;
        this.monitorContents.setContext(profiledFile, isAttach, isModify, enableOverride);
        this.cpuContents.setContext(profiledFile, isAttach, isModify, enableOverride);
        this.memoryContents.setContext(profiledFile, isAttach, isModify, enableOverride);
    }

    public JPanel getCustomSettingsPanel() {
        return null;
    }

    public SettingsContainerPanel.Contents getMemoryConfigurator() {
        return this.memoryContents;
    }

    public SettingsContainerPanel.Contents getMonitorConfigurator() {
        return this.monitorContents;
    }

    public void setSettings(ProfilingSettings settings) {
        this.settings = settings;
        this.isPreset = settings.isPreset();
        if (Utils.isMonitorSettings(settings)) {
            this.monitorContents.setSettings(settings);
        } else if (Utils.isCPUSettings(settings)) {
            this.cpuContents.setSettings(settings);
        } else if (Utils.isMemorySettings(settings)) {
            this.memoryContents.setSettings(settings);
        }
    }

    public ProfilingSettings getSettings() {
        return this.settings;
    }

    public ProfilingSettings createFinalSettings() {
        if (Utils.isMonitorSettings(this.settings)) {
            return this.monitorContents.createFinalSettings();
        }
        if (Utils.isCPUSettings(this.settings)) {
            return this.cpuContents.createFinalSettings();
        }
        if (Utils.isMemorySettings(this.settings)) {
            return this.memoryContents.createFinalSettings();
        }
        return null;
    }

    public void loadCustomSettings(Properties properties) {
    }

    public void reset() {
        this.settings = null;
        this.profiledFile = null;
        this.enableOverride = false;
        this.isAttach = false;
        this.isModify = false;
        this.isPreset = false;
        this.monitorContents.reset();
        this.cpuContents.reset();
        this.memoryContents.reset();
    }

    public void storeCustomSettings(Properties properties) {
    }

    public void synchronizeSettings() {
        if (Utils.isMonitorSettings(this.settings)) {
            this.monitorContents.synchronizeSettings();
        } else if (Utils.isCPUSettings(this.settings)) {
            this.cpuContents.synchronizeSettings();
        } else if (Utils.isMemorySettings(this.settings)) {
            this.memoryContents.synchronizeSettings();
        }
    }

    protected boolean isAttach() {
        return this.isAttach;
    }

    protected boolean isModify() {
        return this.isModify;
    }

    protected boolean isPreset() {
        return this.isPreset;
    }

    protected FileObject getProfiledFile() {
        return this.profiledFile;
    }

    protected boolean enableOverride() {
        return this.enableOverride;
    }

    public static class MonitorContents
    implements SettingsContainerPanel.Contents,
    ChangeListener {
        private FileObject profiledFile;
        private MonitorSettingsAdvancedPanel advancedSettingsPanel;
        private MonitorSettingsBasicPanel basicSettingsPanel;
        private ProfilingSettings settings;
        private Vector<ChangeListener> changeListeners = new Vector();
        private boolean enableOverride;
        private boolean internalChange = false;
        private boolean isAttach;
        private boolean isModify;
        private boolean isPreset;

        public MonitorContents() {
            this.basicSettingsPanel = new MonitorSettingsBasicPanel();
            this.advancedSettingsPanel = new MonitorSettingsAdvancedPanel();
            this.basicSettingsPanel.addChangeListener(this);
            this.advancedSettingsPanel.addChangeListener(this);
        }

        public JPanel getAdvancedSettingsPanel() {
            return this.advancedSettingsPanel;
        }

        public JPanel getBasicSettingsPanel() {
            return this.basicSettingsPanel;
        }

        public void setContext(FileObject profiledFile, boolean isAttach, boolean isModify, boolean enableOverride) {
            this.profiledFile = profiledFile;
            this.enableOverride = enableOverride;
            this.isAttach = isAttach;
            this.isModify = isModify;
        }

        public float getProfilingOverhead() {
            if (this.settings == null) {
                return 0.0f;
            }
            this.synchronizeBasicAdvancedPanels();
            return 0.0f;
        }

        public void setSettings(ProfilingSettings settings) {
            this.settings = settings;
            this.isPreset = settings.isPreset();
            this.internalChange = true;
            SelectProfilingTask.getDefault().enableSubmitButton();
            this.basicSettingsPanel.setThreadsMonitoring(settings.getThreadsMonitoringEnabled());
            if (!settings.isPreset()) {
                this.advancedSettingsPanel.enableAll();
            }
            this.advancedSettingsPanel.setOverrideAvailable(this.enableOverride);
            this.advancedSettingsPanel.setOverrideSettings(settings.getOverrideGlobalSettings());
            this.advancedSettingsPanel.setWorkingDirectory(settings.getWorkingDir());
            this.advancedSettingsPanel.setJavaPlatformName(settings.getJavaPlatformName());
            this.advancedSettingsPanel.setVMArguments(settings.getJVMArgs());
            if (settings.isPreset()) {
                this.advancedSettingsPanel.disableAll();
            }
            this.internalChange = false;
            this.fireSettingsChanged();
        }

        public void addChangeListener(ChangeListener listener) {
            if (!this.changeListeners.contains(listener)) {
                this.changeListeners.add(listener);
            }
        }

        public ProfilingSettings createFinalSettings() {
            ProfilingSettings finalSettings = ProfilingSettingsPresets.createMonitorPreset();
            finalSettings.setIsPreset(this.settings.isPreset());
            finalSettings.setSettingsName(this.settings.getSettingsName());
            finalSettings.setThreadsMonitoringEnabled(this.basicSettingsPanel.getThreadsMonitoring());
            finalSettings.setOverrideGlobalSettings(this.advancedSettingsPanel.getOverrideSettings());
            finalSettings.setWorkingDir(this.advancedSettingsPanel.getWorkingDirectory());
            finalSettings.setJavaPlatformName(this.advancedSettingsPanel.getJavaPlatformName());
            finalSettings.setJVMArgs(this.advancedSettingsPanel.getVMArguments());
            return finalSettings;
        }

        public void removeChangeListener(ChangeListener listener) {
            this.changeListeners.remove(listener);
        }

        public void reset() {
            this.settings = null;
            this.profiledFile = null;
            this.enableOverride = false;
            this.isAttach = false;
            this.isModify = false;
            this.isPreset = false;
        }

        public void stateChanged(ChangeEvent e) {
            this.fireSettingsChanged();
        }

        public void synchronizeBasicAdvancedPanels() {
        }

        public void synchronizeSettings() {
            this.synchronizeBasicAdvancedPanels();
            this.settings.setThreadsMonitoringEnabled(this.basicSettingsPanel.getThreadsMonitoring());
            this.settings.setOverrideGlobalSettings(this.advancedSettingsPanel.getOverrideSettings());
            this.settings.setWorkingDir(this.advancedSettingsPanel.getWorkingDirectory());
            this.settings.setJavaPlatformName(this.advancedSettingsPanel.getJavaPlatformName());
            this.settings.setJVMArgs(this.advancedSettingsPanel.getVMArguments());
        }

        private void fireSettingsChanged() {
            if (!this.internalChange) {
                for (ChangeListener listener : this.changeListeners) {
                    listener.stateChanged(new ChangeEvent(this));
                }
            }
        }
    }

    public static class MemoryContents
    implements SettingsContainerPanel.Contents,
    ChangeListener {
        private FileObject profiledFile;
        private MemorySettingsAdvancedPanel advancedSettingsPanel = new MemorySettingsAdvancedPanel();
        private MemorySettingsBasicPanel basicSettingsPanel = new MemorySettingsBasicPanel();
        private ProfilingSettings settings;
        private Vector<ChangeListener> changeListeners = new Vector();
        private boolean enableOverride;
        private boolean internalChange = false;
        private boolean isAttach;
        private boolean isModify;
        private boolean isPreset;

        public MemoryContents() {
            this.basicSettingsPanel = new MemorySettingsBasicPanel();
            this.advancedSettingsPanel = new MemorySettingsAdvancedPanel();
            this.basicSettingsPanel.addChangeListener(this);
            this.advancedSettingsPanel.addChangeListener(this);
        }

        public JPanel getAdvancedSettingsPanel() {
            return this.advancedSettingsPanel;
        }

        public JPanel getBasicSettingsPanel() {
            return this.basicSettingsPanel;
        }

        public void setContext(FileObject profiledFile, boolean isAttach, boolean isModify, boolean enableOverride) {
            this.profiledFile = profiledFile;
            this.enableOverride = enableOverride;
            this.isAttach = isAttach;
            this.isModify = isModify;
        }

        public float getProfilingOverhead() {
            if (this.settings == null) {
                return 0.0f;
            }
            this.synchronizeBasicAdvancedPanels();
            return 0.0f;
        }

        public void setSettings(ProfilingSettings settings) {
            this.settings = settings;
            this.isPreset = settings.isPreset();
            this.internalChange = true;
            SelectProfilingTask.getDefault().enableSubmitButton();
            this.basicSettingsPanel.setContext(new Runnable(){

                public void run() {
                    MemoryContents.this.synchronizeSettings();
                }
            });
            this.basicSettingsPanel.setProfilingType(settings.getProfilingType());
            this.basicSettingsPanel.setTrackEvery(settings.getAllocTrackEvery());
            this.basicSettingsPanel.setRecordStackTrace(settings.getAllocStackTraceLimit() != 0);
            this.basicSettingsPanel.setUseProfilingPoints(false);
            if (!settings.isPreset()) {
                this.advancedSettingsPanel.enableAll();
            }
            this.advancedSettingsPanel.setAllocStackTraceLimit(settings.getAllocStackTraceLimit());
            this.advancedSettingsPanel.setRunGC(settings.getRunGCOnGetResultsInMemoryProfiling());
            this.advancedSettingsPanel.setThreadsMonitoring(settings.getThreadsMonitoringEnabled());
            this.advancedSettingsPanel.setOverrideAvailable(this.enableOverride);
            this.advancedSettingsPanel.setOverrideSettings(settings.getOverrideGlobalSettings());
            this.advancedSettingsPanel.setWorkingDirectory(settings.getWorkingDir());
            this.advancedSettingsPanel.setJavaPlatformName(settings.getJavaPlatformName());
            this.advancedSettingsPanel.setVMArguments(settings.getJVMArgs());
            if (settings.isPreset()) {
                this.advancedSettingsPanel.disableAll();
            }
            this.internalChange = false;
            this.fireSettingsChanged();
        }

        public void addChangeListener(ChangeListener listener) {
            if (!this.changeListeners.contains(listener)) {
                this.changeListeners.add(listener);
            }
        }

        public ProfilingSettings createFinalSettings() {
            ProfilingSettings finalSettings = ProfilingSettingsPresets.createMemoryPreset();
            finalSettings.setIsPreset(this.settings.isPreset());
            finalSettings.setSettingsName(this.settings.getSettingsName());
            finalSettings.setProfilingType(this.basicSettingsPanel.getProfilingType());
            finalSettings.setAllocTrackEvery(this.basicSettingsPanel.getTrackEvery());
            finalSettings.setUseProfilingPoints(this.basicSettingsPanel.getUseProfilingPoints());
            finalSettings.setAllocStackTraceLimit(this.basicSettingsPanel.getRecordStackTrace() ? this.advancedSettingsPanel.getAllocStackTraceLimit() : 0);
            finalSettings.setRunGCOnGetResultsInMemoryProfiling(this.advancedSettingsPanel.getRunGC());
            finalSettings.setThreadsMonitoringEnabled(this.advancedSettingsPanel.getThreadsMonitoring());
            finalSettings.setOverrideGlobalSettings(this.advancedSettingsPanel.getOverrideSettings());
            finalSettings.setWorkingDir(this.advancedSettingsPanel.getWorkingDirectory());
            finalSettings.setJavaPlatformName(this.advancedSettingsPanel.getJavaPlatformName());
            finalSettings.setJVMArgs(this.advancedSettingsPanel.getVMArguments());
            return finalSettings;
        }

        public void removeChangeListener(ChangeListener listener) {
            this.changeListeners.remove(listener);
        }

        public void reset() {
            this.settings = null;
            this.profiledFile = null;
            this.enableOverride = false;
            this.isAttach = false;
            this.isModify = false;
            this.isPreset = false;
        }

        public void stateChanged(ChangeEvent e) {
            this.fireSettingsChanged();
        }

        public void synchronizeBasicAdvancedPanels() {
            this.advancedSettingsPanel.setRecordStackTrace(this.basicSettingsPanel.getRecordStackTrace());
        }

        public void synchronizeSettings() {
            this.synchronizeBasicAdvancedPanels();
            this.settings.setProfilingType(this.basicSettingsPanel.getProfilingType());
            this.settings.setAllocTrackEvery(this.basicSettingsPanel.getTrackEvery());
            this.settings.setUseProfilingPoints(this.basicSettingsPanel.getUseProfilingPoints());
            this.settings.setAllocStackTraceLimit(this.basicSettingsPanel.getRecordStackTrace() ? this.advancedSettingsPanel.getAllocStackTraceLimit() : 0);
            this.settings.setRunGCOnGetResultsInMemoryProfiling(this.advancedSettingsPanel.getRunGC());
            this.settings.setThreadsMonitoringEnabled(this.advancedSettingsPanel.getThreadsMonitoring());
            this.settings.setOverrideGlobalSettings(this.advancedSettingsPanel.getOverrideSettings());
            this.settings.setWorkingDir(this.advancedSettingsPanel.getWorkingDirectory());
            this.settings.setJavaPlatformName(this.advancedSettingsPanel.getJavaPlatformName());
            this.settings.setJVMArgs(this.advancedSettingsPanel.getVMArguments());
        }

        private void fireSettingsChanged() {
            if (!this.internalChange) {
                for (ChangeListener listener : this.changeListeners) {
                    listener.stateChanged(new ChangeEvent(this));
                }
            }
        }
    }

    public static class CPUContents
    implements SettingsContainerPanel.Contents,
    ChangeListener {
        private static final boolean ENABLE_THREAD_CPU_TIMER = Boolean.getBoolean("org.netbeans.lib.profiler.enableThreadCPUTimer");
        private CPUSettingsAdvancedPanel advancedSettingsPanel;
        private CPUSettingsBasicPanel basicSettingsPanel;
        private FileObject profiledFile;
        private ProfilingSettings settings;
        private Vector<ChangeListener> changeListeners = new Vector();
        private boolean enableOverride;
        private boolean internalChange = false;
        private boolean isAttach;
        private boolean isModify;
        private boolean isPreset;
        private boolean useCPUTimer;

        public CPUContents() {
            this.basicSettingsPanel = new CPUSettingsBasicPanel();
            this.advancedSettingsPanel = new CPUSettingsAdvancedPanel();
            this.basicSettingsPanel.addChangeListener(this);
            this.advancedSettingsPanel.addChangeListener(this);
        }

        public JPanel getAdvancedSettingsPanel() {
            return this.advancedSettingsPanel;
        }

        public JPanel getBasicSettingsPanel() {
            return this.basicSettingsPanel;
        }

        public void setContext(FileObject profiledFile, boolean isAttach, boolean isModify, boolean enableOverride) {
            this.profiledFile = profiledFile;
            this.enableOverride = enableOverride;
            this.isAttach = isAttach;
            this.isModify = isModify;
            this.useCPUTimer = ENABLE_THREAD_CPU_TIMER || isAttach || Platform.isSolaris();
        }

        public float getProfilingOverhead() {
            if (this.settings == null) {
                return 0.0f;
            }
            this.synchronizeBasicAdvancedPanels();
            return 0.0f;
        }

        public void setSettings(ProfilingSettings settings) {
            this.settings = settings;
            this.isPreset = settings.isPreset();
            this.internalChange = true;
            this.basicSettingsPanel.setContext(SelectProfilingTask.getDefault().getPredefinedInstrFilterKeys(), new Runnable(){

                public void run() {
                    CPUContents.this.synchronizeSettings();
                }
            });
            this.basicSettingsPanel.setProfilingType(settings.getProfilingType());
            this.basicSettingsPanel.setRootMethods(settings.getInstrumentationRootMethods());
            this.basicSettingsPanel.setQuickFilter(settings.getQuickFilter());
            this.basicSettingsPanel.setInstrumentationFilter(settings.getSelectedInstrumentationFilter());
            this.basicSettingsPanel.setUseProfilingPoints(false);
            if (!settings.isPreset()) {
                this.advancedSettingsPanel.enableAll();
            }
            this.advancedSettingsPanel.setCPUProfilingType(settings.getCPUProfilingType());
            this.advancedSettingsPanel.setSamplingInterval(settings.getSamplingInterval());
            this.advancedSettingsPanel.setExcludeThreadTime(settings.getExcludeWaitTime());
            this.advancedSettingsPanel.setProfileSpawnedThreads(settings.getInstrumentSpawnedThreads());
            this.advancedSettingsPanel.setUseCPUTimer(settings.getThreadCPUTimerOn(), this.useCPUTimer);
            this.advancedSettingsPanel.setInstrumentMethodInvoke(settings.getInstrumentMethodInvoke());
            this.advancedSettingsPanel.setInstrumentGettersSetters(settings.getInstrumentGetterSetterMethods());
            this.advancedSettingsPanel.setInstrumentEmptyMethods(settings.getInstrumentEmptyMethods());
            this.advancedSettingsPanel.setInstrumentationScheme(settings.getInstrScheme());
            this.advancedSettingsPanel.setProfiledThreadsLimit(settings.getNProfiledThreadsLimit());
            this.advancedSettingsPanel.setProfileFramework(settings.getProfileUnderlyingFramework());
            this.advancedSettingsPanel.setThreadsMonitoring(settings.getThreadsMonitoringEnabled());
            this.advancedSettingsPanel.setOverrideAvailable(this.enableOverride);
            this.advancedSettingsPanel.setOverrideSettings(settings.getOverrideGlobalSettings());
            this.advancedSettingsPanel.setWorkingDirectory(settings.getWorkingDir());
            this.advancedSettingsPanel.setJavaPlatformName(settings.getJavaPlatformName());
            this.advancedSettingsPanel.setVMArguments(settings.getJVMArgs());
            if (settings.isPreset()) {
                this.advancedSettingsPanel.disableAll();
            }
            this.internalChange = false;
            this.fireSettingsChanged();
        }

        public void addChangeListener(ChangeListener listener) {
            if (!this.changeListeners.contains(listener)) {
                this.changeListeners.add(listener);
            }
        }

        public ProfilingSettings createFinalSettings() {
            ProfilingSettings finalSettings = ProfilingSettingsPresets.createCPUPreset((int)this.settings.getProfilingType());
            finalSettings.setIsPreset(this.settings.isPreset());
            finalSettings.setSettingsName(this.settings.getSettingsName());
            finalSettings.setProfilingType(this.basicSettingsPanel.getProfilingType());
            finalSettings.setSelectedInstrumentationFilter(this.basicSettingsPanel.getInstrumentationFilter());
            finalSettings.setUseProfilingPoints(this.basicSettingsPanel.getUseProfilingPoints());
            finalSettings.setCPUProfilingType(this.advancedSettingsPanel.getCPUProfilingType());
            finalSettings.setSamplingInterval(this.advancedSettingsPanel.getSamplingInterval());
            finalSettings.setExcludeWaitTime(this.advancedSettingsPanel.getExcludeThreadTime());
            finalSettings.setProfileUnderlyingFramework(this.advancedSettingsPanel.getProfileFramework());
            finalSettings.setInstrumentSpawnedThreads(this.advancedSettingsPanel.getProfileSpawnedThreads());
            finalSettings.setThreadCPUTimerOn(this.useCPUTimer && this.advancedSettingsPanel.getUseCPUTimer());
            finalSettings.setInstrumentMethodInvoke(this.advancedSettingsPanel.getInstrumentMethodInvoke());
            finalSettings.setInstrumentGetterSetterMethods(this.advancedSettingsPanel.getInstrumentGettersSetters());
            finalSettings.setInstrumentEmptyMethods(this.advancedSettingsPanel.getInstrumentEmptyMethods());
            finalSettings.setInstrScheme(this.advancedSettingsPanel.getInstrumentationScheme());
            finalSettings.setNProfiledThreadsLimit(this.advancedSettingsPanel.getProfiledThreadsLimit());
            finalSettings.setThreadsMonitoringEnabled(this.advancedSettingsPanel.getThreadsMonitoring());
            finalSettings.setOverrideGlobalSettings(this.advancedSettingsPanel.getOverrideSettings());
            finalSettings.setWorkingDir(this.advancedSettingsPanel.getWorkingDirectory());
            finalSettings.setJavaPlatformName(this.advancedSettingsPanel.getJavaPlatformName());
            finalSettings.setJVMArgs(this.advancedSettingsPanel.getVMArguments());
            if (finalSettings.getProfilingType() == 8) {
                finalSettings.setInstrumentationRootMethods(new ClientUtils.SourceCodeSelection[0]);
                finalSettings.instrRootMethodsPending = true;
            } else {
                finalSettings.setInstrumentationRootMethods(this.basicSettingsPanel.getRootMethods());
            }
            return finalSettings;
        }

        public void removeChangeListener(ChangeListener listener) {
            this.changeListeners.remove(listener);
        }

        public void reset() {
            this.settings = null;
            this.profiledFile = null;
            this.enableOverride = false;
            this.isAttach = false;
            this.isModify = false;
            this.isPreset = false;
            this.useCPUTimer = false;
        }

        public void stateChanged(ChangeEvent e) {
            this.fireSettingsChanged();
        }

        public void synchronizeBasicAdvancedPanels() {
            if (this.basicSettingsPanel.getProfilingType() == 8) {
                this.advancedSettingsPanel.setEntireAppDefaults(this.isPreset);
            } else {
                this.advancedSettingsPanel.setPartOfAppDefaults(this.isPreset);
            }
        }

        public void synchronizeSettings() {
            this.synchronizeBasicAdvancedPanels();
            this.settings.setProfilingType(this.basicSettingsPanel.getProfilingType());
            this.settings.setInstrumentationRootMethods(this.basicSettingsPanel.getRootMethods());
            this.settings.setQuickFilter(this.basicSettingsPanel.getQuickFilter());
            this.settings.setSelectedInstrumentationFilter(this.basicSettingsPanel.getInstrumentationFilter());
            this.settings.setUseProfilingPoints(this.basicSettingsPanel.getUseProfilingPoints());
            this.settings.setCPUProfilingType(this.advancedSettingsPanel.getCPUProfilingType());
            this.settings.setSamplingInterval(this.advancedSettingsPanel.getSamplingInterval());
            this.settings.setExcludeWaitTime(this.advancedSettingsPanel.getExcludeThreadTime());
            this.settings.setProfileUnderlyingFramework(this.advancedSettingsPanel.getProfileFramework());
            this.settings.setInstrumentSpawnedThreads(this.advancedSettingsPanel.getProfileSpawnedThreads());
            this.settings.setThreadCPUTimerOn(this.advancedSettingsPanel.getUseCPUTimer());
            this.settings.setInstrumentMethodInvoke(this.advancedSettingsPanel.getInstrumentMethodInvoke());
            this.settings.setInstrumentGetterSetterMethods(this.advancedSettingsPanel.getInstrumentGettersSetters());
            this.settings.setInstrumentEmptyMethods(this.advancedSettingsPanel.getInstrumentEmptyMethods());
            this.settings.setInstrScheme(this.advancedSettingsPanel.getInstrumentationScheme());
            this.settings.setNProfiledThreadsLimit(this.advancedSettingsPanel.getProfiledThreadsLimit());
            this.settings.setThreadsMonitoringEnabled(this.advancedSettingsPanel.getThreadsMonitoring());
            this.settings.setOverrideGlobalSettings(this.advancedSettingsPanel.getOverrideSettings());
            this.settings.setWorkingDir(this.advancedSettingsPanel.getWorkingDirectory());
            this.settings.setJavaPlatformName(this.advancedSettingsPanel.getJavaPlatformName());
            this.settings.setJVMArgs(this.advancedSettingsPanel.getVMArguments());
        }

        private void fireSettingsChanged() {
            if (!this.internalChange) {
                for (ChangeListener listener : this.changeListeners) {
                    listener.stateChanged(new ChangeEvent(this));
                }
            }
        }
    }
}

