/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.model;

import java.text.MessageFormat;
import javax.swing.ImageIcon;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.heapwalk.model.AbstractHeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.model.ChildrenComputer;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerInstanceNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.RootNode;
import org.openide.util.NbBundle;

public abstract class InstanceNode
extends AbstractHeapWalkerNode
implements HeapWalkerInstanceNode {
    private static final String LOOP_TO_STRING = NbBundle.getMessage(InstanceNode.class, (String)"InstanceNode_LoopToString");
    HeapWalkerNode loopTo;
    private Instance instance;
    private String name;

    public InstanceNode(Instance instance, String name, HeapWalkerNode parent) {
        this(instance, name, parent, parent == null ? 1 : parent.getMode());
    }

    public InstanceNode(Instance instance, String name, HeapWalkerNode parent, int mode) {
        super(parent, mode);
        this.instance = instance;
        this.name = name;
        this.loopTo = this.computeLoopTo();
    }

    public abstract boolean isArray();

    public Instance getInstance() {
        return this.instance;
    }

    public boolean isLeaf() {
        return !this.hasInstance() || this.isLoop();
    }

    public boolean isLoop() {
        return this.getLoopTo() != null;
    }

    public HeapWalkerNode getLoopTo() {
        return this.loopTo;
    }

    public boolean hasInstance() {
        return this.instance != null;
    }

    protected abstract ChildrenComputer getChildrenComputer();

    protected HeapWalkerNode[] computeChildren() {
        return BrowserUtils.lazilyCreateChildren(this, this.getChildrenComputer());
    }

    protected HeapWalkerNode computeLoopTo() {
        if (this.hasInstance()) {
            for (HeapWalkerNode parent = this.getParent(); parent != null && parent instanceof HeapWalkerInstanceNode; parent = parent.getParent()) {
                if (!((HeapWalkerInstanceNode)parent).getInstance().equals(this.instance)) continue;
                return parent;
            }
        }
        return null;
    }

    protected String computeName() {
        if (this.isLoop()) {
            return this.name + " " + MessageFormat.format(LOOP_TO_STRING, BrowserUtils.getFullNodeName(this.getLoopTo()));
        }
        return this.name;
    }

    protected String computeType() {
        if (!this.hasInstance()) {
            return "<object>";
        }
        return this.instance.getJavaClass().getName();
    }

    protected String computeValue() {
        JavaClass javaClass;
        HeapWalkerNode root;
        if (!this.hasInstance()) {
            return "null";
        }
        if ("java.lang.Class".equals(this.instance.getJavaClass().getName()) && (root = BrowserUtils.getRoot(this)) instanceof RootNode && (javaClass = ((RootNode)((Object)root)).getJavaClassByID(this.instance.getInstanceId())) != null) {
            return "#" + this.instance.getInstanceNumber() + " (" + BrowserUtils.getSimpleType(javaClass.getName()) + ")";
        }
        return "#" + this.instance.getInstanceNumber();
    }

    protected ImageIcon processLoopIcon(ImageIcon icon) {
        if (!this.isLoop()) {
            return icon;
        }
        return BrowserUtils.createLoopIcon(icon);
    }
}

