/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.memorylint.rules;

import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.heapwalk.memorylint.Histogram;
import org.netbeans.modules.profiler.heapwalk.memorylint.IteratingRule;
import org.netbeans.modules.profiler.heapwalk.memorylint.MemoryLint;
import org.netbeans.modules.profiler.heapwalk.memorylint.StringHelper;
import org.netbeans.modules.profiler.heapwalk.memorylint.Utils;
import org.openide.util.NbBundle;

public class TooManyBooleans
extends IteratingRule {
    Histogram<Histogram.Entry> booleans = new Histogram();
    private Heap heap;
    private Instance FALSE;
    private Instance TRUE;
    private StringHelper helper;
    private int count;
    private int total;

    public TooManyBooleans() {
        super(NbBundle.getMessage(TooManyBooleans.class, (String)"LBL_TMB_Name"), NbBundle.getMessage(TooManyBooleans.class, (String)"LBL_TMB_Desc"), "java.lang.Boolean");
    }

    public String getHTMLDescription() {
        return NbBundle.getMessage(TooManyBooleans.class, (String)"LBL_TMB_LongDesc");
    }

    protected void perform(Instance in) {
        if (in.equals(this.TRUE) || in.equals(this.FALSE)) {
            return;
        }
        ++this.count;
        this.booleans.add(Utils.printClass(this.getContext(), this.getContext().getRootIncommingString(in)), new Histogram.Entry(in.getSize()));
    }

    protected void prepareRule(MemoryLint context) {
        this.heap = context.getHeap();
        this.helper = context.getStringHelper();
        JavaClass booleanClass = this.heap.getJavaClassByName("java.lang.Boolean");
        this.TRUE = (Instance)booleanClass.getValueOfStaticField("TRUE");
        this.FALSE = (Instance)booleanClass.getValueOfStaticField("FALSE");
    }

    protected void summary() {
        if (this.count > 0) {
            this.getContext().appendResults(NbBundle.getMessage(TooManyBooleans.class, (String)"FMT_TMB_Result", (Object)(this.count + 2), (Object)(this.count * this.TRUE.getSize())));
            this.getContext().appendResults(this.booleans.toString(0));
        } else {
            this.getContext().appendResults(NbBundle.getMessage(TooManyBooleans.class, (String)"FMT_TMB_ResultOK"));
        }
    }
}

