/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.memorylint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.profiler.heapwalk.memorylint.Rule;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RuleRegistry {
    private RuleRegistry() {
    }

    public static Collection<Rule> getRegisteredRules() {
        List<Rule> al = RuleRegistry.instantiateRules();
        Collections.sort(al, new Comparator<Rule>(){

            @Override
            public int compare(Rule o1, Rule o2) {
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        });
        return al;
    }

    private static List<Rule> instantiateRules() {
        Lookup.Template template = new Lookup.Template(Rule.class);
        Lookup.Result result = Lookup.getDefault().lookup(template);
        Set classes = result.allClasses();
        ArrayList<Rule> list = new ArrayList<Rule>(classes.size());
        for (Class cls : classes) {
            try {
                list.add((Rule)cls.newInstance());
            }
            catch (Exception any) {}
        }
        return list;
    }
}

