/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.heapwalk.AbstractController;
import org.netbeans.modules.profiler.heapwalk.ClassesController;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.ui.ClassesListControllerUI;
import org.openide.util.NbBundle;

public class ClassesListController
extends AbstractController {
    private static final String ANALYZING_CLASSES_MSG = NbBundle.getMessage(ClassesListController.class, (String)"ClassesListController_AnalyzingClassesMsg");
    public static final int FILTER_SUBCLASS = 1001;
    private ClassesController classesController;
    private JavaClass selectedClass;

    public ClassesListController(ClassesController classesController) {
        this.classesController = classesController;
    }

    public ClassesController getClassesController() {
        return this.classesController;
    }

    public void setColumnVisibility(int column, boolean isColumnVisible) {
        ((ClassesListControllerUI)((Object)this.getPanel())).setColumnVisibility(column, isColumnVisible);
    }

    public List getFilteredSortedClasses(String[] filterStrings, int filterType, boolean showZeroInstances, boolean showZeroSize, int sortingColumn, boolean sortingOrder) {
        HeapFragmentWalker fragmentWalker = this.classesController.getHeapFragmentWalker();
        Heap heap = fragmentWalker.getHeapFragment();
        List filteredClasses = filterType == 1001 && filterStrings != null && !filterStrings[0].equals("") ? ClassesListController.getFilteredClasses(ClassesListController.getSubclasses(heap, filterStrings), null, 0, showZeroInstances, showZeroSize) : ClassesListController.getFilteredClasses(heap.getAllClasses(), filterStrings, filterType, showZeroInstances, showZeroSize);
        return ClassesListController.getSortedClasses(filteredClasses, sortingColumn, sortingOrder);
    }

    public JavaClass getSelectedClass() {
        return this.selectedClass;
    }

    public void classSelected(JavaClass javaClass) {
        if (this.selectedClass == javaClass) {
            return;
        }
        this.selectedClass = javaClass;
        this.classesController.classSelected();
    }

    public static boolean matchesFilter(JavaClass jClass, String[] filterStrings, int filterType, boolean showZeroInstances, boolean showZeroSize) {
        int instancesCount = jClass.getInstancesCount();
        int instanceSize = jClass.getInstanceSize();
        if (!showZeroInstances && instancesCount == 0) {
            return false;
        }
        if (!(showZeroSize || instancesCount != 0 && instanceSize != 0)) {
            return false;
        }
        if (filterType == 0 || filterStrings == null || filterStrings[0].equals("")) {
            return true;
        }
        return ClassesListController.passesFilters(jClass.getName(), filterStrings, filterType);
    }

    public void selectClass(JavaClass javaClass) {
        ((ClassesListControllerUI)((Object)this.getPanel())).ensureWillBeVisible(javaClass);
        ((ClassesListControllerUI)((Object)this.getPanel())).selectClass(javaClass);
    }

    public void updateData() {
        ((ClassesListControllerUI)((Object)this.getPanel())).updateData();
    }

    protected AbstractButton createControllerPresenter() {
        return ((ClassesListControllerUI)((Object)this.getPanel())).getPresenter();
    }

    protected JPanel createControllerUI() {
        return new ClassesListControllerUI(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection getContextSubclasses(Heap heap, String className) {
        ProgressHandle pHandle = null;
        try {
            pHandle = ProgressHandleFactory.createHandle((String)ANALYZING_CLASSES_MSG);
            pHandle.setInitialDelay(0);
            pHandle.start();
            HashSet<JavaClass> subclasses = new HashSet<JavaClass>();
            String[] subclassesNames = new String[]{className};
            for (int i = 0; i < subclassesNames.length; ++i) {
                JavaClass jClass = heap.getJavaClassByName(subclassesNames[i]);
                if (jClass == null || !subclasses.add(jClass)) continue;
                subclasses.addAll(jClass.getSubClasses());
            }
            HashSet<JavaClass> hashSet = subclasses;
            return hashSet;
        }
        finally {
            if (pHandle != null) {
                pHandle.finish();
            }
        }
    }

    private static List getFilteredClasses(List classes, String[] filterStrings, int filterType, boolean showZeroInstances, boolean showZeroSize) {
        ArrayList<JavaClass> filteredClasses = new ArrayList<JavaClass>();
        for (JavaClass jClass : classes) {
            if (!ClassesListController.matchesFilter(jClass, filterStrings, filterType, showZeroInstances, showZeroSize)) continue;
            filteredClasses.add(jClass);
        }
        return filteredClasses;
    }

    private static List getSortedClasses(List filteredClasses, int sortingColumn, boolean sortingOrder) {
        Collections.sort(filteredClasses, new ClassesComparator(sortingColumn, sortingOrder));
        return filteredClasses;
    }

    private static List getSubclasses(Heap heap, String[] filterStrings) {
        HashSet<JavaClass> subclasses = new HashSet<JavaClass>();
        for (int i = 0; i < filterStrings.length; ++i) {
            JavaClass jClass = heap.getJavaClassByName(filterStrings[i]);
            if (jClass == null) continue;
            Collection subclassesCol = jClass.getSubClasses();
            subclasses.add(jClass);
            if (subclassesCol.size() <= 0) continue;
            subclasses.addAll(subclassesCol);
        }
        return new ArrayList(subclasses);
    }

    private static boolean passesFilter(String value, String filter, int type) {
        switch (type) {
            case 10: {
                return value.regionMatches(true, 0, filter, 0, filter.length());
            }
            case 20: {
                return value.toLowerCase().indexOf(filter.toLowerCase()) != -1;
            }
            case 30: {
                return value.regionMatches(true, value.length() - filter.length(), filter, 0, filter.length());
            }
            case 40: {
                return value.equalsIgnoreCase(filter);
            }
            case 50: {
                try {
                    return value.matches(filter);
                }
                catch (PatternSyntaxException e) {
                    return false;
                }
            }
        }
        return false;
    }

    private static boolean passesFilters(String value, String[] filters, int type) {
        for (int i = 0; i < filters.length; ++i) {
            if (!ClassesListController.passesFilter(value, filters[i], type)) continue;
            return true;
        }
        return false;
    }

    private static class ClassesComparator
    implements Comparator {
        private boolean sortingOrder;
        private int sortingColumn;

        public ClassesComparator(int sortingColumn, boolean sortingOrder) {
            this.sortingColumn = sortingColumn;
            this.sortingOrder = sortingOrder;
        }

        public int compare(Object o1, Object o2) {
            JavaClass jClass1 = this.sortingOrder ? (JavaClass)o1 : (JavaClass)o2;
            JavaClass jClass2 = this.sortingOrder ? (JavaClass)o2 : (JavaClass)o1;
            switch (this.sortingColumn) {
                case 0: {
                    return jClass1.getName().compareTo(jClass2.getName());
                }
                case 1: 
                case 2: {
                    return new Integer(jClass1.getInstancesCount()).compareTo(new Integer(jClass2.getInstancesCount()));
                }
                case 3: {
                    return new Integer(jClass1.getAllInstancesSize()).compareTo(jClass2.getAllInstancesSize());
                }
            }
            throw new RuntimeException("Unsupported compare operation for " + o1 + ", " + o2);
        }
    }
}

