/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.MemoryDiffPanel;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.openide.actions.FindAction;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public final class SnapshotsDiffWindow
extends TopComponent {
    private static final String ALLOC_CAPTION = NbBundle.getMessage(SnapshotResultsWindow.class, (String)"SnapshotDiffWindow_AllocCaption");
    private static final String LIVENESS_CAPTION = NbBundle.getMessage(SnapshotResultsWindow.class, (String)"SnapshotDiffWindow_LivenessCaption");
    private static final String ALLOC_ACCESS_DESCR = NbBundle.getMessage(SnapshotResultsWindow.class, (String)"SnapshotDiffWindow_AllocAccessDescr");
    private static final String LIVENESS_ACCESS_DESCR = NbBundle.getMessage(SnapshotResultsWindow.class, (String)"SnapshotDiffWindow_LivenessAccessDescr");
    private static final Image WINDOW_ICON_MEMORY = Utilities.loadImage((String)"org/netbeans/modules/profiler/actions/resources/compareSnapshots.png");
    private Component lastFocusOwner;

    public SnapshotsDiffWindow() {
        throw new InternalError("This constructor should never be called");
    }

    public SnapshotsDiffWindow(ResultsSnapshot ls, LoadedSnapshot snapshot1, LoadedSnapshot snapshot2, int sortingColumn, boolean sortingOrder) {
        this.setLayout(new BorderLayout());
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        if (ls instanceof AllocMemoryResultsDiff) {
            this.getAccessibleContext().setAccessibleDescription(ALLOC_ACCESS_DESCR);
            this.displayMemoryAllocDiff((MemoryResultsSnapshot)((AllocMemoryResultsDiff)ls), snapshot1, snapshot2, sortingColumn, sortingOrder);
        } else if (ls instanceof LivenessMemoryResultsDiff) {
            this.getAccessibleContext().setAccessibleDescription(LIVENESS_ACCESS_DESCR);
            this.displayMemoryLivenessDiff((MemoryResultsSnapshot)((LivenessMemoryResultsDiff)ls), snapshot1, snapshot2, sortingColumn, sortingOrder);
        }
    }

    public static synchronized SnapshotsDiffWindow get(ResultsSnapshot ls, LoadedSnapshot snapshot1, LoadedSnapshot snapshot2) {
        return SnapshotsDiffWindow.get(ls, snapshot1, snapshot2, -1, false);
    }

    public static synchronized SnapshotsDiffWindow get(ResultsSnapshot ls, LoadedSnapshot snapshot1, LoadedSnapshot snapshot2, int sortingColumn, boolean sortingOrder) {
        return new SnapshotsDiffWindow(ls, snapshot1, snapshot2, sortingColumn, sortingOrder);
    }

    public int getPersistenceType() {
        return 2;
    }

    public void componentActivated() {
        if (this.lastFocusOwner != null) {
            this.lastFocusOwner.requestFocus();
        }
    }

    public void componentDeactivated() {
        this.lastFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
    }

    protected String preferredID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private void displayMemoryAllocDiff(MemoryResultsSnapshot diff, LoadedSnapshot snapshot1, LoadedSnapshot snapshot2, int sortingColumn, boolean sortingOrder) {
        MemoryDiffPanel allocDiffPanel = new MemoryDiffPanel(diff, snapshot1, snapshot2, sortingColumn, sortingOrder);
        this.updateFind(true, allocDiffPanel);
        this.add(allocDiffPanel, "Center");
        this.setName(ALLOC_CAPTION);
        this.setIcon(WINDOW_ICON_MEMORY);
    }

    private void displayMemoryLivenessDiff(MemoryResultsSnapshot diff, LoadedSnapshot snapshot1, LoadedSnapshot snapshot2, int sortingColumn, boolean sortingOrder) {
        MemoryDiffPanel livenessDiffPanel = new MemoryDiffPanel(diff, snapshot1, snapshot2, sortingColumn, sortingOrder);
        this.updateFind(true, livenessDiffPanel);
        this.add(livenessDiffPanel, "Center");
        this.setName(LIVENESS_CAPTION);
        this.setIcon(WINDOW_ICON_MEMORY);
    }

    private void updateFind(boolean enabled, final SnapshotResultsWindow.FindPerformer performer) {
        CallbackSystemAction globalFindAction = (CallbackSystemAction)SystemAction.get(FindAction.class);
        Object findActionKey = globalFindAction.getActionMapKey();
        if (enabled) {
            this.getActionMap().put(findActionKey, new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    performer.performFind();
                }
            });
        } else {
            this.getActionMap().remove(findActionKey);
        }
    }
}

