/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLLabel;
import org.netbeans.lib.profiler.ui.memory.DiffAllocResultsPanel;
import org.netbeans.lib.profiler.ui.memory.DiffLivenessResultsPanel;
import org.netbeans.lib.profiler.ui.memory.MemoryResUserActionsHandler;
import org.netbeans.lib.profiler.ui.memory.MemoryResultsPanel;
import org.netbeans.lib.profiler.ui.memory.SnapshotLivenessResultsPanel;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.SaveViewAction;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.netbeans.modules.profiler.actions.FindNextAction;
import org.netbeans.modules.profiler.actions.FindPreviousAction;
import org.netbeans.modules.profiler.ui.FindDialog;
import org.netbeans.modules.profiler.ui.Utils;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public class MemoryDiffPanel
extends JPanel
implements SnapshotResultsWindow.FindPerformer,
SaveViewAction.ViewProvider {
    private static final String PANEL_TITLE = NbBundle.getMessage(MemoryDiffPanel.class, (String)"MemoryDiffPanel_PanelTitle");
    private static final String SNAPSHOTS_COMPARISON_STRING = NbBundle.getMessage(MemoryDiffPanel.class, (String)"MemoryDiffPanel_SnapshotsComparisonString");
    private static final String SNAPSHOT_NOT_AVAILABLE_MSG = NbBundle.getMessage(MemoryDiffPanel.class, (String)"MemoryDiffPanel_SnapshotNotAvailableMsg");
    private static final String STRING_NOT_FOUND_MSG = NbBundle.getMessage(MemoryDiffPanel.class, (String)"MemorySnapshotPanel_StringNotFoundMsg");
    private static final String FIND_ACTION_TOOLTIP = NbBundle.getMessage(MemoryDiffPanel.class, (String)"MemorySnapshotPanel_FindActionTooltip");
    private static final ImageIcon MEMORY_RESULTS_TAB_ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/resources/memoryResultsTab.png"));
    private static final ImageIcon INFO_TAB_ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/resources/infoTab.png"));
    private static final ImageIcon STACK_TRACES_TAB_ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/resources/stackTracesTab.png"));
    private JButton findActionPresenter;
    private JButton findNextPresenter;
    private JButton findPreviousPresenter;
    private MemoryResultsPanel memoryPanel;

    public MemoryDiffPanel(MemoryResultsSnapshot snapshot, LoadedSnapshot snapshot1, LoadedSnapshot snapshot2, int sortingColumn, boolean sortingOrder) {
        String s2File;
        this.setLayout(new BorderLayout());
        DiffActionsHandler memoryActionsHandler = new DiffActionsHandler();
        if (snapshot instanceof AllocMemoryResultsDiff) {
            this.memoryPanel = new DiffAllocResultsPanel((AllocMemoryResultsSnapshot)((AllocMemoryResultsDiff)snapshot), (MemoryResUserActionsHandler)memoryActionsHandler);
            DiffAllocResultsPanel amemoryPanel = (DiffAllocResultsPanel)this.memoryPanel;
            amemoryPanel.setSorting(sortingColumn, sortingOrder);
            amemoryPanel.prepareResults();
        } else if (snapshot instanceof LivenessMemoryResultsDiff) {
            this.memoryPanel = new DiffLivenessResultsPanel((LivenessMemoryResultsSnapshot)((LivenessMemoryResultsDiff)snapshot), (MemoryResUserActionsHandler)memoryActionsHandler, 1);
            SnapshotLivenessResultsPanel lmemoryPanel = (SnapshotLivenessResultsPanel)this.memoryPanel;
            lmemoryPanel.setSorting(sortingColumn, sortingOrder);
            lmemoryPanel.prepareResults();
        }
        this.add((Component)this.memoryPanel, "Center");
        JToolBar toolBar = new JToolBar(){

            public Component add(Component comp) {
                if (comp instanceof JButton) {
                    UIUtils.fixButtonUI((AbstractButton)((JButton)comp));
                }
                return super.add(comp);
            }
        };
        toolBar.setFloatable(false);
        toolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        toolBar.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0));
        toolBar.add(new SaveViewAction(this));
        toolBar.addSeparator();
        this.findActionPresenter = toolBar.add((Action)SystemAction.get(FindAction.class));
        this.findPreviousPresenter = toolBar.add(new FindPreviousAction(this));
        this.findNextPresenter = toolBar.add(new FindNextAction(this));
        if (this.findActionPresenter instanceof AbstractButton) {
            JButton ab = this.findActionPresenter;
            ab.setIcon(Utils.FIND_ACTION_ICON);
            ab.setText("");
            ab.setToolTipText(FIND_ACTION_TOOLTIP);
        }
        this.findActionPresenter.setEnabled(true);
        this.findPreviousPresenter.setEnabled(true);
        this.findNextPresenter.setEnabled(true);
        JPanel toolBarFiller = new JPanel(new FlowLayout(3, 0, 0));
        toolBarFiller.setOpaque(false);
        toolBar.add(toolBarFiller);
        final WeakReference[] loadedSnapshots = new WeakReference[2];
        final String s1File = snapshot1.getFile() == null ? null : snapshot1.getFile().getAbsolutePath();
        String string = s2File = snapshot2.getFile() == null ? null : snapshot2.getFile().getAbsolutePath();
        if (s1File == null) {
            loadedSnapshots[0] = new WeakReference<LoadedSnapshot>(snapshot1);
        }
        if (s2File == null) {
            loadedSnapshots[1] = new WeakReference<LoadedSnapshot>(snapshot2);
        }
        String SNAPSHOT_1_MASK = "file:/1";
        String SNAPSHOT_2_MASK = "file:/2";
        String SNAPSHOT_1_LINK = "<a href='file:/1'>" + StringUtils.formatUserDate((Date)new Date(snapshot1.getSnapshot().getTimeTaken())) + "</a>";
        String SNAPSHOT_2_LINK = "<a href='file:/2'>" + StringUtils.formatUserDate((Date)new Date(snapshot2.getSnapshot().getTimeTaken())) + "</a>";
        HTMLLabel descriptionLabel = new HTMLLabel(MessageFormat.format(SNAPSHOTS_COMPARISON_STRING, SNAPSHOT_1_LINK, SNAPSHOT_2_LINK)){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            protected void showURL(URL url) {
                File f;
                LoadedSnapshot ls = null;
                if ("file:/1".equals(url.toString())) {
                    if (s1File != null) {
                        f = new File(s1File);
                        if (f.exists()) {
                            ls = ResultsManager.getDefault().loadSnapshot(FileUtil.toFileObject((File)f));
                        }
                    } else {
                        ls = (LoadedSnapshot)loadedSnapshots[0].get();
                    }
                } else if ("file:/2".equals(url.toString())) {
                    if (s2File != null) {
                        f = new File(s2File);
                        if (f.exists()) {
                            ls = ResultsManager.getDefault().loadSnapshot(FileUtil.toFileObject((File)f));
                        }
                    } else {
                        ls = (LoadedSnapshot)loadedSnapshots[1].get();
                    }
                }
                if (ls != null) {
                    SnapshotResultsWindow srw = SnapshotResultsWindow.get(ls);
                    srw.open();
                    srw.requestActive();
                } else {
                    NetBeansProfiler.getDefaultNB().displayWarning(SNAPSHOT_NOT_AVAILABLE_MSG);
                }
            }
        };
        descriptionLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        toolBar.add((Component)descriptionLabel);
        this.add((Component)toolBar, "North");
        this.getInputMap(2).put(KeyStroke.getKeyStroke(114, 1), "FIND_PREVIOUS");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(114, 1), "FIND_PREVIOUS");
        this.getActionMap().put("FIND_PREVIOUS", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                MemoryDiffPanel.this.performFindPrevious();
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(114, 0), "FIND_NEXT");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(114, 0), "FIND_NEXT");
        this.getActionMap().put("FIND_NEXT", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                MemoryDiffPanel.this.performFindNext();
            }
        });
    }

    public String getTitle() {
        return PANEL_TITLE;
    }

    public BufferedImage getViewImage(boolean onlyVisibleArea) {
        return this.memoryPanel.getCurrentViewScreenshot(onlyVisibleArea);
    }

    public String getViewName() {
        return "memory_diff";
    }

    public boolean fitsVisibleArea() {
        return this.memoryPanel.fitsVisibleArea();
    }

    public boolean hasView() {
        return true;
    }

    public void performFind() {
        String findString = FindDialog.getFindString();
        if (findString == null) {
            return;
        }
        this.memoryPanel.setFindString(findString);
        if (!this.memoryPanel.findFirst()) {
            NetBeansProfiler.getDefaultNB().displayInfoAndWait(STRING_NOT_FOUND_MSG);
        }
    }

    public void performFindNext() {
        if (!this.memoryPanel.isFindStringDefined()) {
            String findString = FindDialog.getFindString();
            if (findString == null) {
                return;
            }
            this.memoryPanel.setFindString(findString);
        }
        if (!this.memoryPanel.findNext()) {
            NetBeansProfiler.getDefaultNB().displayInfoAndWait(STRING_NOT_FOUND_MSG);
        }
    }

    public void performFindPrevious() {
        if (!this.memoryPanel.isFindStringDefined()) {
            String findString = FindDialog.getFindString();
            if (findString == null) {
                return;
            }
            this.memoryPanel.setFindString(findString);
        }
        if (!this.memoryPanel.findPrevious()) {
            NetBeansProfiler.getDefaultNB().displayInfoAndWait(STRING_NOT_FOUND_MSG);
        }
    }

    public void requestFocus() {
        this.memoryPanel.requestFocus();
    }

    private class DiffActionsHandler
    implements MemoryResUserActionsHandler {
        public static final String BOOLEAN_CODE = "boolean";
        public static final String CHAR_CODE = "char";
        public static final String BYTE_CODE = "byte";
        public static final String SHORT_CODE = "short";
        public static final String INT_CODE = "int";
        public static final String LONG_CODE = "long";
        public static final String FLOAT_CODE = "float";
        public static final String DOUBLE_CODE = "double";

        private DiffActionsHandler() {
        }

        public void showSourceForMethod(String className, String methodName, String methodSig) {
            if (BOOLEAN_CODE.equals(className) || CHAR_CODE.equals(className) || BYTE_CODE.equals(className) || SHORT_CODE.equals(className) || INT_CODE.equals(className) || LONG_CODE.equals(className) || FLOAT_CODE.equals(className) || DOUBLE_CODE.equals(className)) {
                Profiler.getDefault().displayWarning(CANNOT_SHOW_PRIMITIVE_SRC_MSG);
                return;
            }
            NetBeansProfiler.getDefaultNB().openJavaSource(className, methodName, methodSig);
        }

        public void showStacksForClass(int selectedClassId, int sortingColumn, boolean sortingOrder) {
        }
    }
}

