/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs;

import java.util.Iterator;
import org.netbeans.modules.masterfs.filebasedfs.FileBasedFileSystem;
import org.netbeans.modules.masterfs.filebasedfs.naming.NamingFactory;

public final class Statistics {
    public static final TimeConsumer REFRESH_FOLDER = new TimeConsumer("Folder refresh");
    public static final TimeConsumer REFRESH_FILE = new TimeConsumer("File refresh");
    public static final TimeConsumer REFRESH_FS = new TimeConsumer("FileSystem refresh");
    public static final TimeConsumer LISTENERS_CALLS = new TimeConsumer("Invocation of FileChangeListeners");
    static /* synthetic */ Class class$org$netbeans$modules$masterfs$filebasedfs$Statistics;

    private Statistics() {
    }

    public static StopWatch getStopWatch(TimeConsumer timeConsumer) {
        return new StopWatch(timeConsumer);
    }

    public static int fileSystems() {
        return FileBasedFileSystem.getSize();
    }

    public static int fileNamings() {
        return NamingFactory.getSize();
    }

    public static int fileObjects() {
        int n = 0;
        Iterator iterator = FileBasedFileSystem.getInstances().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            FileBasedFileSystem fileBasedFileSystem = (FileBasedFileSystem)((Object)iterator.next());
            n += Statistics.fileObjectsPerFileSystem(fileBasedFileSystem);
            ++n2;
        }
        return n;
    }

    public static int fileObjectsPerFileSystem(FileBasedFileSystem fileBasedFileSystem) {
        return fileBasedFileSystem.getFactory().getSize();
    }

    public static final class StopWatch {
        private long startTime = 0L;
        private final TimeConsumer activity;
        static final /* synthetic */ boolean $assertionsDisabled;

        private StopWatch(TimeConsumer timeConsumer) {
            this.activity = timeConsumer;
        }

        public void start() {
            this.startTime = System.currentTimeMillis();
        }

        public void stop() {
            if (!$assertionsDisabled && this.startTime == 0L) {
                throw new AssertionError();
            }
            this.activity.elapsedTime = (int)((long)this.activity.elapsedTime + (System.currentTimeMillis() - this.startTime));
            this.activity.incrementNumerOfCalls();
            this.startTime = 0L;
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$masterfs$filebasedfs$Statistics == null ? (class$org$netbeans$modules$masterfs$filebasedfs$Statistics = Statistics.class$("org.netbeans.modules.masterfs.filebasedfs.Statistics")) : class$org$netbeans$modules$masterfs$filebasedfs$Statistics).desiredAssertionStatus();
        }
    }

    public static final class TimeConsumer {
        private int elapsedTime;
        private int numberOfCalls;
        private final String description;

        private TimeConsumer(String string) {
            this.description = string;
        }

        public int getConsumedTime() {
            return this.elapsedTime;
        }

        public int getNumberOfCalls() {
            return this.numberOfCalls;
        }

        public void reset() {
            this.elapsedTime = 0;
            this.numberOfCalls = 0;
        }

        public String toString() {
            return this.description + ": " + this.numberOfCalls + " calls in " + this.elapsedTime + "ms";
        }

        private void incrementNumerOfCalls() {
            ++this.numberOfCalls;
        }
    }
}

