/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.profiler;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptor;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import com.sun.tools.visualvm.core.ui.DataSourceView;
import com.sun.tools.visualvm.core.ui.components.DataViewComponent;
import com.sun.tools.visualvm.profiler.ProfilerSnapshot;
import java.awt.Dimension;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.util.NbBundle;

class ProfilerSnapshotView
extends DataSourceView {
    private static final Logger LOGGER = Logger.getLogger(ProfilerSnapshotView.class.getName());
    private LoadedSnapshot loadedSnapshot = null;
    private SnapshotResultsWindow srw = null;

    public ProfilerSnapshotView(ProfilerSnapshot snapshot) {
        this(snapshot, DataSourceDescriptorFactory.getDescriptor((DataSource)snapshot));
    }

    private ProfilerSnapshotView(ProfilerSnapshot snapshot, DataSourceDescriptor descriptor) {
        super((DataSource)snapshot, descriptor.getName(), descriptor.getIcon(), 0x7FFFFFFE, true);
        this.loadedSnapshot = snapshot.getLoadedSnapshot();
    }

    protected void removed() {
        if (this.srw != null) {
            IDEUtils.runInEventDispatchThread((Runnable)new Runnable(){

                public void run() {
                    try {
                        Method method = ProfilerSnapshotView.this.srw.getClass().getDeclaredMethod("componentClosed", new Class[0]);
                        if (method != null) {
                            method.setAccessible(true);
                            method.invoke((Object)ProfilerSnapshotView.this.srw, new Object[0]);
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        LOGGER.throwing(ProfilerSnapshotView.class.getName(), "removed", noSuchMethodException);
                    }
                    catch (SecurityException securityException) {
                        LOGGER.throwing(ProfilerSnapshotView.class.getName(), "removed", securityException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        LOGGER.throwing(ProfilerSnapshotView.class.getName(), "removed", illegalAccessException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        LOGGER.throwing(ProfilerSnapshotView.class.getName(), "removed", illegalArgumentException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        LOGGER.throwing(ProfilerSnapshotView.class.getName(), "removed", invocationTargetException);
                    }
                    ProfilerSnapshotView.this.srw = null;
                }
            });
        }
        this.loadedSnapshot = null;
    }

    protected DataViewComponent createComponent() {
        this.srw = SnapshotResultsWindow.get((LoadedSnapshot)this.loadedSnapshot, (int)-1, (boolean)false);
        DataViewComponent dvc = new DataViewComponent(new MasterViewSupport().getMasterView(), new DataViewComponent.MasterViewConfiguration(true));
        return dvc;
    }

    private class MasterViewSupport
    extends JPanel {
        private MasterViewSupport() {
        }

        public DataViewComponent.MasterView getMasterView() {
            ProfilerSnapshotView.this.srw.setPreferredSize(new Dimension(1, 1));
            return new DataViewComponent.MasterView(NbBundle.getMessage(ProfilerSnapshotView.class, (String)"DESCR_Profiler_Snapshot"), null, (JComponent)ProfilerSnapshotView.this.srw);
        }
    }
}

