/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.ui;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptor;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import com.sun.tools.visualvm.core.ui.DataSourceCaption;
import com.sun.tools.visualvm.core.ui.DataSourceView;
import com.sun.tools.visualvm.core.ui.DataSourceWindowManager;
import com.sun.tools.visualvm.core.ui.DataSourceWindowTabbedPane;
import java.awt.BorderLayout;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataSourceWindow
extends TopComponent
implements PropertyChangeListener {
    private static final Logger LOGGER = Logger.getLogger(DataSourceWindow.class.getName());
    private int viewsCount = 0;
    private DataSource dataSource;
    private DataSourceDescriptor dataSourceDescriptor;
    private DataSourceWindowTabbedPane.ViewContainer singleViewContainer;
    private DataSourceWindowTabbedPane tabbedContainer;

    public DataSourceWindow(DataSource dataSource) {
        this.dataSource = dataSource;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    DataSourceWindow.this.initAppearance();
                    DataSourceWindow.this.initComponents();
                }
            });
        }
        catch (Exception e) {
            LOGGER.severe("Failed to create window for " + dataSource);
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void addView(DataSourceView view) {
        if (this.viewsCount == 0) {
            this.singleViewContainer = new DataSourceWindowTabbedPane.ViewContainer(new DataSourceCaption<DataSource>(this.dataSource), view);
            this.add(this.singleViewContainer, "Center");
            this.doLayout();
        } else if (this.viewsCount == 1) {
            this.remove(this.singleViewContainer);
            this.add(this.tabbedContainer, "Center");
            this.tabbedContainer.addViewTab(this.dataSource, this.singleViewContainer.getView());
            this.tabbedContainer.addViewTab(this.dataSource, view);
            this.doLayout();
            this.singleViewContainer.getCaption().finish();
            this.singleViewContainer = null;
        } else {
            this.tabbedContainer.addViewTab(this.dataSource, view);
        }
        ++this.viewsCount;
    }

    public void selectView(DataSourceView view) {
        if (this.viewsCount > 1) {
            int viewIndex = this.indexOf(view);
            if (viewIndex == -1) {
                throw new RuntimeException("View " + view + " not present in DataSourceWindow " + this);
            }
            this.tabbedContainer.setSelectedIndex(viewIndex);
        }
    }

    public void removeView(final DataSourceView view) {
        if (this.viewsCount == 1) {
            if (view != this.singleViewContainer.getView()) {
                throw new RuntimeException("View " + view + " not present in DataSourceWindow " + this);
            }
            this.remove(this.singleViewContainer);
            this.singleViewContainer.getCaption().finish();
            this.singleViewContainer = null;
        } else {
            int viewIndex = this.indexOf(view);
            if (viewIndex == -1) {
                throw new RuntimeException("View " + view + " not present in DataSourceWindow " + this);
            }
            this.tabbedContainer.removeTabAt(viewIndex);
            if (this.viewsCount == 2) {
                this.singleViewContainer = new DataSourceWindowTabbedPane.ViewContainer(new DataSourceCaption<DataSource>(this.dataSource), this.tabbedContainer.getViews().iterator().next());
                this.remove(this.tabbedContainer);
                this.tabbedContainer.removeTabAt(0);
                this.add(this.singleViewContainer, "Center");
                this.doLayout();
            }
        }
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                view.viewRemoved();
            }
        });
        DataSourceWindowManager.sharedInstance().unregisterClosedView(view);
        --this.viewsCount;
        if (this.viewsCount == 0 && this.isOpened()) {
            this.close();
        }
    }

    public void removeAllViews() {
        Set<DataSourceView> views = this.getViews();
        for (DataSourceView view : views) {
            this.removeView(view);
        }
    }

    public Set<DataSourceView> getViews() {
        if (this.viewsCount == 1) {
            return Collections.singleton(this.singleViewContainer.getView());
        }
        return this.tabbedContainer.getViews();
    }

    public boolean containsView(DataSourceView view) {
        return this.indexOf(view) != -1;
    }

    private int indexOf(DataSourceView view) {
        if (this.viewsCount == 1) {
            return view == this.singleViewContainer.getView() ? 0 : -1;
        }
        return this.tabbedContainer.indexOfView(view);
    }

    protected final void componentClosed() {
        this.dataSourceDescriptor.removePropertyChangeListener(this);
        this.removeAllViews();
        DataSourceWindowManager.sharedInstance().unregisterClosedWindow(this);
    }

    @Override
    public void propertyChange(final PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("prop_name".equals(propertyName)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DataSourceWindow.this.setName((String)evt.getNewValue());
                }
            });
        } else if ("prop_icon".equals(propertyName)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DataSourceWindow.this.setIcon((Image)evt.getNewValue());
                }
            });
        } else if ("close".equals(propertyName)) {
            this.removeView(this.tabbedContainer.getDataSourceView((DataSourceWindowTabbedPane.ViewContainer)evt.getNewValue()));
        }
    }

    private void initAppearance() {
        this.dataSourceDescriptor = DataSourceDescriptorFactory.getDescriptor(this.dataSource);
        this.dataSourceDescriptor.addPropertyChangeListener(this);
        this.setName(this.dataSourceDescriptor.getName());
        this.setIcon(this.dataSourceDescriptor.getIcon());
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.tabbedContainer = new DataSourceWindowTabbedPane();
        this.tabbedContainer.addPropertyChangeListener("close", this);
        this.add(this.tabbedContainer, "Center");
    }

    public int getPersistenceType() {
        return 2;
    }

    protected String preferredID() {
        return this.getClass().getName();
    }
}

