/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.snapshot;

import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import com.sun.tools.visualvm.core.datasupport.Utils;
import com.sun.tools.visualvm.core.snapshot.Snapshot;
import java.awt.Image;
import java.io.File;
import java.util.Date;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public final class SnapshotsSupport {
    private static final Image SNAPSHOT_BADGE = Utilities.loadImage((String)"com/sun/tools/visualvm/core/ui/resources/snapshotBadge.png", (boolean)true);
    private static SnapshotsSupport instance;

    public static synchronized SnapshotsSupport getInstance() {
        if (instance == null) {
            instance = new SnapshotsSupport();
        }
        return instance;
    }

    public void saveAs(final Snapshot snapshot, String dialogTitle) {
        final File file = snapshot.getFile();
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(dialogTitle);
        chooser.setSelectedFile(new File(snapshot.getFile().getName()));
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(snapshot.getCategory().getFileFilter());
        if (chooser.showSaveDialog(WindowManager.getDefault().getMainWindow()) == 0) {
            final File copy = chooser.getSelectedFile();
            RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    ProgressHandle pHandleF;
                    ProgressHandle pHandle = null;
                    try {
                        pHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(SnapshotsSupport.class, (String)"LBL_Saving", (Object)DataSourceDescriptorFactory.getDescriptor(snapshot).getName()));
                        pHandle.setInitialDelay(0);
                        pHandle.start();
                        Utils.copyFile(file, copy);
                        pHandleF = pHandle;
                    }
                    catch (Throwable throwable) {
                        ProgressHandle pHandleF2 = pHandle;
                        SwingUtilities.invokeLater(new Runnable(pHandleF2){
                            final /* synthetic */ ProgressHandle val$pHandleF;
                            {
                                this.val$pHandleF = progressHandle;
                            }

                            public void run() {
                                if (this.val$pHandleF != null) {
                                    this.val$pHandleF.finish();
                                }
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            });
        }
    }

    public String getTimeStamp(long time) {
        return StringUtils.formatUserDate((Date)new Date(time));
    }

    public Image createSnapshotIcon(Image icon) {
        return Utilities.mergeImages((Image)icon, (Image)SNAPSHOT_BADGE, (int)0, (int)0);
    }

    private SnapshotsSupport() {
    }
}

